/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc.editor;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.ObservatorySite;
import alma.obsprep.bo.enumerations.Polarization;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.services.etc.BeamsizeNotSpecifiedException;
import alma.obsprep.services.etc.ExposureTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.ReceiverTemperature;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Length;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.util.Optional;

public class SensitivityCalculatorParams {
    public final ArrayParameters array12m;
    public final ArrayParameters array7m;
    public final ArrayParameters arrayTp;
    private final Frequency observingFrequency = Frequency.createFrequencyGHZ(345.0);
    private final UserFrequency bandwidth = UserFrequency.createUserFrequency();
    private final SkyCoordinates raDec = SkyCoordinates.createAbsoluteCoordinates();
    private Polarization polarization = Polarization.DUAL;
    private String waterVapourChoiceType = "Automatic Choice";
    private String waterVapourColumnDensity = null;
    private ObservatorySite observatorySite = ObservatorySite.SITE_CHAJNANTOR;

    public SensitivityCalculatorParams() {
        this.bandwidth.setObservingFrequency(this.observingFrequency);
        this.array12m = new ArrayParameters12m();
        this.array7m = new ArrayParameters7m();
        this.arrayTp = new ArrayParametersTP();
    }

    public Frequency getObservingFrequency() {
        return this.observingFrequency;
    }

    public UserFrequency getBandwidth() {
        return this.bandwidth;
    }

    public SkyCoordinates getRaDec() {
        return this.raDec;
    }

    public Frequency getEffectiveBandwidth() {
        return (Frequency)this.bandwidth.multiply(this.polarization.count);
    }

    public Polarization getPolarization() {
        return this.polarization;
    }

    public void setPolarization(Polarization polarization) {
        this.polarization = polarization;
    }

    public String getWaterVapourChoiceType() {
        return this.waterVapourChoiceType;
    }

    public void setWaterVapourChoiceType(String string) {
        this.waterVapourChoiceType = string;
    }

    public boolean isWaterVapourAutoChoice() {
        return "Automatic Choice".equals(this.waterVapourChoiceType);
    }

    public String gettrueWaterVapourColumnDensity() {
        return this.waterVapourColumnDensity;
    }

    public String getWaterVapourColumnDensity() {
        if (this.isWaterVapourAutoChoice()) {
            this.waterVapourColumnDensity = WaterVaporColumns.getWVIndexLabel(this.getWvIndex());
        }
        return this.waterVapourColumnDensity;
    }

    public void setWaterVapourColumnDensity(String string) {
        this.waterVapourColumnDensity = string;
    }

    public ObservatorySite getObservatorySite() {
        return ObservatorySite.SITE_CHAJNANTOR;
    }

    public void setObservatorySite(String string) {
        String string2 = "ObservatorySite is no longer allowed to change. " + (Object)((Object)ObservatorySite.SITE_CHAJNANTOR) + "is the only allowed choice.";
        throw new RuntimeException(string2);
    }

    private Latitude getObservatoryLatitude() {
        return this.observatorySite.getObservatoryLatitude();
    }

    protected int getWvIndex() {
        if (this.isWaterVapourAutoChoice()) {
            int n = WaterVaporColumns.wvindexSelector(this.observingFrequency, this.raDec.getJ2000SkyCoordinates().getLatitude(), Optional.empty());
            this.setWaterVapourColumnDensity(WaterVaporColumns.getWVIndexLabel(n));
            return n;
        }
        return WaterVaporColumns.wvindexSelector(this.gettrueWaterVapourColumnDensity());
    }

    public Temperature getTsys() {
        try {
            return ExposureTimeCalculator.getTsys(this.raDec, this.getObservatoryLatitude(), this.observingFrequency, this.getWvIndex(), Double.NaN, Optional.empty());
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
            return null;
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            return null;
        }
    }

    public Temperature getTrx() {
        try {
            return ReceiverTemperature.getReceiverTemperature(this.observingFrequency);
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            return null;
        }
    }

    public AtmosphereTable.Data getAtmData() {
        AtmosphereTable atmosphereTable = AtmosphereTable.getInstance();
        float f = (float)this.observingFrequency.getContentInGHz();
        AtmosphereTable.Data data = atmosphereTable.lookup(f, this.getWvIndex());
        return data;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("f=" + (Object)((Object)this.observingFrequency)).append(", ");
        stringBuilder.append("w=" + this.bandwidth).append(", ");
        stringBuilder.append("coords=" + this.raDec).append(", ");
        stringBuilder.append("poln=" + (Object)((Object)this.polarization)).append(", ");
        stringBuilder.append("wvchoice=" + this.waterVapourChoiceType).append(", ");
        stringBuilder.append("wv=" + this.waterVapourColumnDensity).append(", ");
        stringBuilder.append("site=" + (Object)((Object)this.observatorySite)).append("\n");
        stringBuilder.append(this.array12m.toString()).append("\n");
        stringBuilder.append(this.array7m.toString()).append("\n");
        stringBuilder.append(this.arrayTp.toString());
        return stringBuilder.toString();
    }

    public class ArrayParametersTP
    extends ArrayParameters {
        ArrayParametersTP() {
            super(Array.ARRAY_TP);
        }

        @Override
        public UserAngle getBeamsize() {
            Angle angle = this.array.antenna.getBeamSize(SensitivityCalculatorParams.this.observingFrequency);
            this.beamsize.setContentAndUnit((ValueUnitPair)angle);
            return this.beamsize;
        }
    }

    public class ArrayParameters7m
    extends ArrayParameters {
        ArrayParameters7m() {
            super(Array.ARRAY_7M);
        }

        @Override
        public UserAngle getBeamsize() {
            Length length = Length.createLength((double)30.0, (String)Length.UNIT_M);
            UserAngle userAngle = Array.syntheticBeamsize(SensitivityCalculatorParams.this.observingFrequency, length);
            userAngle.convertToUnit(Angle.UNIT_ARCSEC);
            this.beamsize.setContentAndUnit(userAngle);
            return this.beamsize;
        }
    }

    public class ArrayParameters12m
    extends ArrayParameters {
        ArrayParameters12m() {
            super(Array.ARRAY_12M);
        }

        @Override
        public UserAngle getBeamsize() {
            return this.beamsize;
        }
    }

    public abstract class ArrayParameters {
        protected final Array array;
        protected int numberAntennas;
        protected double corrEfficiency = 0.88;
        protected final UserAngle beamsize = UserAngle.createUserAngle(0.0, UserAngle.UNIT_ARCSEC);
        protected final Time integrationTime = Time.createTime();
        protected final UserSensitivity sensitivity;

        ArrayParameters(Array array) {
            this.array = array;
            this.numberAntennas = array.getNominalNumberOfAntennas();
            this.sensitivity = UserSensitivity.createUserSensitivity();
            this.sensitivity.setArrayType(array.type);
            this.sensitivity.setObservingFrequency(SensitivityCalculatorParams.this.observingFrequency);
            this.sensitivity.setBeamsize((Angle)((Object)this.beamsize));
            this.beamsize.setUserUnitList(UserAngle.units_SmallAngle);
            this.beamsize.setObservingFrequency(SensitivityCalculatorParams.this.observingFrequency);
        }

        public Sensitivity calcSensitivity() throws InvalidFrequencyException, SourceNeverVisibleException, BeamsizeNotSpecifiedException {
            if (!this.sensitivity.inModelUnit() && this.sensitivity.getBeamsize().getContent() <= 0.0) {
                this.sensitivity.setContent(0.0);
                String string = "Beamsize must be greater than 0.0 to specify sensitivity in one of the Temperature units";
                throw new BeamsizeNotSpecifiedException(string);
            }
            Sensitivity sensitivity = ExposureTimeCalculator.pointSourceSensitivity(this.integrationTime, SensitivityCalculatorParams.this.observingFrequency, SensitivityCalculatorParams.this.getEffectiveBandwidth(), this.getCorrEfficiency(), SensitivityCalculatorParams.this.raDec, this.numberAntennas, this.array, SensitivityCalculatorParams.this.getObservatoryLatitude(), SensitivityCalculatorParams.this.getWvIndex(), Double.NaN, 1.0, Optional.empty());
            String string = this.sensitivity.getUnit();
            this.sensitivity.setContentAndUnit(sensitivity.getContent(), sensitivity.getUnit());
            this.sensitivity.convertToUnit(string);
            return this.sensitivity;
        }

        public Time calcIntegrationTime() throws InvalidFrequencyException, SourceNeverVisibleException, BeamsizeNotSpecifiedException {
            if (!this.sensitivity.inModelUnit() && this.sensitivity.getBeamsize().getContent() <= 0.0) {
                this.integrationTime.setContent(0.0);
                String string = "Beamsize must be greater than 0.0 to specify sensitivity in one of the Temperature units";
                throw new BeamsizeNotSpecifiedException(string);
            }
            Time time = ExposureTimeCalculator.pointSourceExposureTime((Sensitivity)((Object)this.sensitivity), SensitivityCalculatorParams.this.observingFrequency, SensitivityCalculatorParams.this.getEffectiveBandwidth(), this.getCorrEfficiency(), SensitivityCalculatorParams.this.raDec, this.numberAntennas, this.array, SensitivityCalculatorParams.this.getObservatoryLatitude(), SensitivityCalculatorParams.this.getWvIndex(), Double.NaN, 1.0, Optional.empty());
            time.convertToFriendlyUnit();
            this.integrationTime.setContentAndUnit(time.getContent(), time.getUnit());
            return this.integrationTime;
        }

        public int getNAntennas() {
            return this.numberAntennas;
        }

        public void setNAntennas(int n) {
            this.numberAntennas = n;
        }

        public double getCorrEfficiency() {
            return this.corrEfficiency * 0.96;
        }

        public void setCorrEfficiency(double d) {
            this.corrEfficiency = d;
        }

        public abstract UserAngle getBeamsize();

        public Time getIntegrationTime() {
            return this.integrationTime;
        }

        public UserSensitivity getSensitivity() {
            return this.sensitivity;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("type=" + (Object)((Object)this.array)).append(", ");
            stringBuilder.append("nAnt=" + this.numberAntennas).append(", ");
            stringBuilder.append("corrEff=" + this.corrEfficiency).append(", ");
            stringBuilder.append("beam=" + this.beamsize).append(", ");
            stringBuilder.append("time=" + this.integrationTime).append(", ");
            stringBuilder.append("goal=" + this.sensitivity);
            return stringBuilder.toString();
        }
    }
}

