/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Frequency;
import alma.valuetypes.Temperature;
import java.util.HashMap;
import java.util.Map;

public class ReceiverTemperature {
    private static Map<ReceiverBand, ReceiverTemperature> map = new HashMap<ReceiverBand, ReceiverTemperature>();
    private double baseTemperatureK;

    private ReceiverTemperature(double d, double d2) {
        this.baseTemperatureK = d;
    }

    private ReceiverTemperature(double d) {
        this(d, 0.0);
    }

    private double getReceiverTemperatureK() {
        return this.baseTemperatureK;
    }

    public static double getReceiverTemperature(double d) throws InvalidFrequencyException {
        try {
            ReceiverBand receiverBand = ReceiverBand.getReceiverBand(d);
            ReceiverTemperature receiverTemperature = map.get(receiverBand);
            return receiverTemperature.getReceiverTemperatureK();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidFrequencyException(d);
        }
    }

    public static double getReceiverTemperatureForReceiverBand(ReceiverBand receiverBand) {
        if (receiverBand == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: receiverBand");
        }
        ReceiverTemperature receiverTemperature = map.get(receiverBand);
        return receiverTemperature.getReceiverTemperatureK();
    }

    public static Temperature getReceiverTemperature(ReceiverBand receiverBand) throws InvalidFrequencyException {
        if (receiverBand == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: receiverBand");
        }
        ReceiverTemperature receiverTemperature = map.get(receiverBand);
        return Temperature.createTemperature((double)receiverTemperature.getReceiverTemperatureK(), (String)Temperature.UNIT_K);
    }

    public static Temperature getReceiverTemperature(Frequency frequency) throws InvalidFrequencyException {
        double d = ReceiverTemperature.getReceiverTemperature(frequency.getContentInGHz());
        return Temperature.createTemperature((double)d, (String)Temperature.UNIT_K);
    }

    static {
        map.put(ReceiverBand.getReceiverBand(1), new ReceiverTemperature(25.0));
        map.put(ReceiverBand.getReceiverBand(2), new ReceiverTemperature(30.0));
        map.put(ReceiverBand.getReceiverBand(3), new ReceiverTemperature(45.0));
        map.put(ReceiverBand.getReceiverBand(4), new ReceiverTemperature(51.0));
        map.put(ReceiverBand.getReceiverBand(5), new ReceiverTemperature(55.0));
        map.put(ReceiverBand.getReceiverBand(6), new ReceiverTemperature(55.0));
        map.put(ReceiverBand.getReceiverBand(7), new ReceiverTemperature(75.0));
        map.put(ReceiverBand.getReceiverBand(8), new ReceiverTemperature(150.0));
        map.put(ReceiverBand.getReceiverBand(9), new ReceiverTemperature(110.0));
        map.put(ReceiverBand.getReceiverBand(10), new ReceiverTemperature(230.0));
    }
}

