/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.util.MinimumBoundingRectangle;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.UserSensitivity;
import com.google.common.collect.Sets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class SchedBlockExpert {
    private static CacheAccess<Integer, Rectangle> boundingRectangleCache = JCS.getInstance((String)"boundingRectangleCache");
    private ScienceGoal scienceGoal;
    private ObservingTimeCalculator timeCalculator;
    public static final double LOW_ELEVATION = 35.0;
    public static final double HIGH_RESOLUTION = 0.1;
    public static final double HOUR_ANGLE_STEP = 12.0;
    public static final Time NOMINAL_SB_LENGTH = AlmaPolicies.getInstance().getNominalSbLength();
    public static final double NOMINAL_TOTAL_TO_SCIENCE_RATIO = AlmaPolicies.getInstance().getNominalTotalToScienceRatio();
    public static final double NOMINAL_TOTAL_TO_SCIENCE_MULTIPLE_TUNINGS_RATIO = AlmaPolicies.getInstance().getNominalTotalToScienceMultipleTuningsRatio();
    public static final double NOMINAL_TOTAL_TO_SCIENCE_ACA_7M_RATIO = AlmaPolicies.getInstance().getNominalTotalToScienceACA7MRatio();
    public static final double NOMINAL_TOTAL_TO_POLARIZATION_RATIO = AlmaPolicies.getInstance().getNominalTotalToSciencePolarizationRatio();
    public static final Time TP_NOMINAL_SB_LENGTH = AlmaPolicies.getInstance().getTPNominalSbLength();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchedBlockExpert getInstance(ScienceGoal scienceGoal) {
        SchedBlockExpert schedBlockExpert = (SchedBlockExpert)scienceGoal.getSchedBlockExpert();
        if (schedBlockExpert != null) return schedBlockExpert;
        Class<SchedBlockExpert> clazz = SchedBlockExpert.class;
        synchronized (SchedBlockExpert.class) {
            if (schedBlockExpert != null) return schedBlockExpert;
            schedBlockExpert = new SchedBlockExpert(scienceGoal);
            scienceGoal.setSchedBlockExpert(schedBlockExpert);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return schedBlockExpert;
        }
    }

    private SchedBlockExpert(ScienceGoal scienceGoal) {
        this.scienceGoal = scienceGoal;
        this.timeCalculator = new ObservingTimeCalculator(scienceGoal);
    }

    public int hourAngleRangeCount() {
        int n;
        TargetParameters targetParameters = this.scienceGoal.getSoleTargetParameters();
        if (targetParameters == null) {
            return 1;
        }
        Latitude latitude = SiteCharacteristics.getInstance().getObsLatitude();
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
        double d = 90.0 - Math.abs(latitude.getContentInUnits(Latitude.UNIT_DEG) - skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_DEG));
        if (d > 35.0) {
            n = 1;
        } else {
            PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
            double d2 = performanceParameters.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
            if (d2 > 0.1) {
                n = 1;
            } else {
                double d3 = 0.0;
                double d4 = 360.0;
                double d5 = 180.0;
                n = (int)Math.ceil((d4 - d3) / d5);
            }
        }
        return n;
    }

    public List<Range> calcHourAngleRange() {
        return Arrays.asList(new Range(0.0, 360.0));
    }

    @Deprecated
    public ArrayList<Range> calcBLResolutionRange() throws InvalidObsProgramParametersException {
        if (!Telescope.getTelescopeSelection().equals((Object)Telescope.ALMA)) {
            ArrayList<Range> arrayList = new ArrayList<Range>();
            arrayList.add(new Range(0.0, 0.0));
            return arrayList;
        }
        double d = 0.5;
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        double d2 = performanceParameters.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
        double d3 = performanceParameters.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC);
        double d4 = 50.0;
        ArrayList<Range> arrayList = new ArrayList<Range>();
        arrayList.add(new Range(d2 * (1.0 - d), d2 * (1.0 + d)));
        while (d2 * d4 < d3) {
            double d5 = d2 * d4 * 0.9;
            if (d2 >= d5) {
                throw new InvalidObsProgramParametersException("Invalid AngularResolution");
            }
            d2 = d5;
            arrayList.add(new Range(d2 * (1.0 - d), d2 * (1.0 + d)));
        }
        return arrayList;
    }

    public ArrayList<Range> calcACAResolutionRange() {
        ArrayList<Range> arrayList = new ArrayList<Range>();
        arrayList.add(new Range(0.0, 0.0));
        return arrayList;
    }

    public static int calcExecutionCount(Time time, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        Time time2 = (Time)time.multiply(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet));
        return (int)Math.ceil(time2.getContentInUnits(Time.UNIT_MIN) / NOMINAL_SB_LENGTH.getContentInUnits(Time.UNIT_MIN));
    }

    public int calcExecutionCountForAllSources(boolean bl, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws InvalidFrequencyException, SourceNeverVisibleException, UnableToFindSolutionException {
        Time time = this.calcExecutionTimeForAllSources(bl, enumSet);
        Time time2 = this.getNominalObsLengthPolicy();
        return (int)Math.ceil(time.getContentInDefaultUnits() / time2.getContentInDefaultUnits());
    }

    public Time calcExecutionTime(boolean bl, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws InvalidFrequencyException, SourceNeverVisibleException {
        Array array = this.scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
        Integer n = this.scienceGoal.getSoleTargetParameters().getNumberOfPointings(array);
        if (bl) {
            return this.timeCalculateACA();
        }
        return (Time)((Time)this.timeCalculate().multiply(n.intValue())).multiply(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet));
    }

    public Time calcExecutionTimeForAllSources(Boolean bl, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws InvalidFrequencyException, SourceNeverVisibleException, UnableToFindSolutionException {
        Time time = Time.createTime((double)0.0, (String)Time.UNIT_S);
        if (bl.booleanValue()) {
            return this.timeCalculateACA();
        }
        RequestedArray requestedArray = this.scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
        for (TargetParameters targetParameters : this.scienceGoal.getTargetParameters()) {
            Integer n = targetParameters.getNumberOfPointings(requestedArray.getArray());
            Time time2 = (Time)this.timeCalculate(targetParameters, requestedArray).multiply(n.intValue());
            time.aggregate(time2);
        }
        return (Time)time.multiply(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet));
    }

    public Sensitivity calcAllocatedSensitivity() {
        UserSensitivity userSensitivity;
        try {
            userSensitivity = this.scienceGoal.getPerformanceParameters().getSensitivityForFinestAR();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(SchedBlockExpert.class).warning("Unable to calculate allocated sensitivity " + invalidObsProgramParametersException.getMessage());
            return Sensitivity.createSensitivity();
        }
        int n = this.calcHourAngleRange().size();
        double d = Math.sqrt(n) * userSensitivity.getContentInUnits(Sensitivity.UNIT_MJY);
        return Sensitivity.createSensitivity((double)d, (String)Sensitivity.UNIT_MJY);
    }

    public Time timeCalculate() throws InvalidFrequencyException, SourceNeverVisibleException {
        Sensitivity sensitivity = this.calcAllocatedSensitivity();
        TargetParameters targetParameters = this.scienceGoal.getSoleTargetParameters();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Array array = this.scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
        Time time = this.timeCalculator.singlePointOnSourceTime(array, sensitivity, targetParameters, performanceParameters.getSensitivityFrequencyWidth(), true);
        return time;
    }

    public Time timeCalculate(TargetParameters targetParameters, RequestedArray requestedArray) throws InvalidFrequencyException, SourceNeverVisibleException {
        Sensitivity sensitivity = this.calcAllocatedSensitivity();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Time time = this.timeCalculator.singlePointOnSourceTime(requestedArray.getArray(), sensitivity, targetParameters, performanceParameters.getSensitivityFrequencyWidth(), false);
        return time;
    }

    public Time timeCalculateACA() throws InvalidFrequencyException, SourceNeverVisibleException {
        Sensitivity sensitivity = this.calcAllocatedSensitivity();
        TargetParameters targetParameters = this.scienceGoal.getSoleTargetParameters();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Time time = this.timeCalculator.singlePointOnSourceTime(Array.ARRAY_TP, sensitivity, targetParameters, performanceParameters.getSensitivityFrequencyWidth(), true);
        Time time2 = this.timeCalculator.singlePointOnSourceTime(Array.ARRAY_7M, sensitivity, targetParameters, performanceParameters.getSensitivityFrequencyWidth(), true);
        Time time3 = time.getContentInDefaultUnits() > time2.getContentInDefaultUnits() ? time : time2;
        return time3;
    }

    public Time getNominalSBLengthPolicy() {
        return NOMINAL_SB_LENGTH;
    }

    public Time getNominalSBLengthPolicy(RequestedArray requestedArray) {
        if (requestedArray == null) {
            throw new IllegalArgumentException("array is null");
        }
        return RequestedArray.TP.equals((Object)requestedArray) ? TP_NOMINAL_SB_LENGTH : NOMINAL_SB_LENGTH;
    }

    public Time getNominalObsLengthPolicy() {
        double d = this.getNominalSBLengthPolicy().getContentInUnits(Time.UNIT_MIN);
        double d2 = Math.max(d * 0.0, 0.0);
        return Time.createTime((double)(d - d2), (String)Time.UNIT_MIN);
    }

    public boolean getUseTPArray() {
        return SchedBlockExpert.determineIfTPArrayIsToBeUsed(this.scienceGoal.getPerformanceParameters().getUseACA(), this.scienceGoal);
    }

    public static boolean determineIfTPArrayIsToBeUsed(Boolean bl, ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: goal");
        }
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        boolean bl2 = false;
        if (!bl.booleanValue()) {
            return false;
        }
        boolean bl3 = false;
        try {
            bl3 = scienceGoal.isSolarScienceGoal();
            if (bl3) {
                return true;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new IllegalArgumentException("Cannot determine if science goal is solar");
        }
        if (almaCapabilities.getNumAntennas(Array.ARRAY_TP, scienceGoal.getSpectralSetupParameters()) > 0 && scienceGoal.getSpectralSetupParameters().getType() == SpectralSetupParameters.TYPE_FULL) {
            Object object;
            bl2 = true;
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            if (!performanceParameters.getDesiredLargestScale().isZero()) {
                object = performanceParameters.getDesiredLargestScale();
                assert (object != null);
                double d = scienceGoal.getRepresentativeFrequencyInSky().getContentInGHz();
                TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
                List<Configuration> list = null;
                Double d2 = null;
                try {
                    list = Configuration.getKnownConfigurations(RequestedArray.SEVEN_M);
                    assert (list != null && list.size() > 0);
                    d2 = list.get(0).getRecoverableScale(d, targetParametersArray, RequestedArray.SEVEN_M);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    Log.logger(SchedBlockExpert.class).warning("Unable to determine ACA 7m configuration: " + invalidConfigurationParametersException.getMessage());
                    return true;
                }
                assert (d2 != null && d2 > 0.0);
                Log.logger(SchedBlockExpert.class).finer(String.format("ACA 7m recoverable scale : %.5g (arcsec) Desired angular scale : %.5g (arcsec)", d2, object.getContentInUnits(Angle.UNIT_ARCSEC)));
                if (object.getContentInUnits(Angle.UNIT_ARCSEC) < d2) {
                    Log.logger(SchedBlockExpert.class).finer("LAS requested can be recovered with the ACA 7m alone: TP omitted");
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            if (scienceGoal.getSpectralSetupParameters().getScienceSpectralWindowCount() > 0) {
                object = scienceGoal.getSpectralSetupParameters().getScienceSpectralWindow(0).getCenterFrequencySky();
                try {
                    if (ReceiverBand.getReceiverBand((Frequency)((Object)object)).getType().equals("DSB")) {
                        Log.logger(SchedBlockExpert.class).fine("DSB receiver being used: TP not scheduled");
                        bl2 = false;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.logger(SchedBlockExpert.class).warning("Unable to determine whether we should use TP: " + illegalArgumentException.getMessage());
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    public static IntTimeSource getTotalExecutionTimeForSB(SchedBlock schedBlock, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        return (IntTimeSource)SchedBlockExpert.getTotalTOSForSB(schedBlock).multiply(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet));
    }

    public static double getNominalExecutionTimeToTOSRatio(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sbGenerationSchemas");
        }
        double d = NOMINAL_TOTAL_TO_SCIENCE_RATIO;
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.ACA_7M)) {
            d = NOMINAL_TOTAL_TO_SCIENCE_ACA_7M_RATIO;
        } else if (Sets.intersection(EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING, SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB, SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN), enumSet).size() > 0) {
            d = NOMINAL_TOTAL_TO_SCIENCE_MULTIPLE_TUNINGS_RATIO;
        } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.POLARISATION)) {
            d = NOMINAL_TOTAL_TO_POLARIZATION_RATIO;
        }
        return d;
    }

    public static IntTimeSource getTotalTOSForSB(SchedBlock schedBlock) {
        IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource((double)0.0, (String)IntTimeSource.UNIT_S);
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                intTimeSource = (IntTimeSource)intTimeSource.plus((AbstractDoubleWithUnit)scienceParameters.getIntegrationTime());
            }
        }
        return intTimeSource;
    }

    public static RequiredConfigurations getRecommended12mConfigurations(ScienceGoal scienceGoal, Frequency frequency) throws InvalidConfigurationParametersException {
        boolean bl;
        Object object;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Angle angle = performanceParameters.getDesiredLargestScale();
        RequiredConfigurations requiredConfigurations = new RequiredConfigurations();
        requiredConfigurations.set12mCompactConfigurationRecommended(false);
        try {
            object = scienceGoal.getObsProposal();
            if (object != null && ((ObsProposal)((Object)object)).isVLBI()) {
                requiredConfigurations.setBest12mExtConfig(Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M));
                return requiredConfigurations;
            }
            if (angle.isLessThan((AbstractDoubleWithUnit)Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCMIN))) {
                throw new InvalidConfigurationParametersException("Desired LAS has not been defined");
            }
        }
        catch (UnknownEntityException | Configuration.UnableToDetermineConfigurationException throwable) {
            throw new InvalidConfigurationParametersException("Unable to determine ObsProposal" + throwable);
        }
        Configuration configuration = Configuration.getBestConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal);
        requiredConfigurations.setBest12mExtConfig(configuration);
        object = null;
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidConfigurationParametersException();
        }
        if (bl && !Configuration.getSolarConfigurations().contains(configuration)) {
            String string = "Cannot determine a 12-m configuration for the desired angular resolution of " + performanceParameters.getDesiredAngularResolution() + " with a rep. freq of " + (Object)((Object)frequency) + " when configured for solar";
            Log.logger(Configuration.class).fine(string);
            throw new InvalidConfigurationParametersException(string);
        }
        if (!bl && angle.isGreaterThan((AbstractDoubleWithUnit)Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC)) && Configuration.getIsSecondConfigurationRequired(configuration, angle.getContentInUnits(Angle.UNIT_ARCSEC), frequency.getContentInGHz(), scienceGoal, RequestedArray.TWELVE_M, false)) {
            requiredConfigurations.set12mCompactConfigurationRecommended(true);
            try {
                object = Configuration.getSecondCompactConfiguration(configuration);
                requiredConfigurations.setTwelveMetreCompactConfig((Configuration)object);
                Log.logger(SchedBlockExpert.class).fine("Second 12m configuration required: " + ((Configuration)object).getName());
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                Log.logger(SchedBlockExpert.class).fine("Unable to determine the 12m compact configuration when one is required: " + invalidConfigurationParametersException.getMessage());
                requiredConfigurations.setTwelveMetreCompactConfig(null);
            }
        }
        return requiredConfigurations;
    }

    public static Rectangle getBoundingRectangle(SkyCoordinates skyCoordinates, SkyCoordinates[] skyCoordinatesArray) throws IllegalArgumentException {
        ArrayList<SkyCoordinates> arrayList = new ArrayList<SkyCoordinates>();
        Rectangle rectangle = Rectangle.createRectangle();
        try {
            Log.logger(SchedBlockExpert.class).fine(String.format("Rectangle origin: RA %s Dec %s ", skyCoordinates.getLongitude().toHHMMSS(), skyCoordinates.getLatitude().toDDMMSS()));
        }
        catch (InvalidCoordException | OutOfRangeException exception) {
            // empty catch block
        }
        for (SkyCoordinates object : skyCoordinatesArray) {
            SkyCoordinates skyCoordinates2 = object.isOffsetCoordinates() ? object.deepCopy() : object.getOffsetCoordinates(skyCoordinates);
            boolean bl = false;
            for (SkyCoordinates skyCoordinates3 : arrayList) {
                if (!skyCoordinates3.getLongitude().isEqual((AbstractDoubleWithUnit)skyCoordinates2.getLongitude()) || !skyCoordinates3.getLatitude().isEqual((AbstractDoubleWithUnit)skyCoordinates2.getLatitude())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(skyCoordinates2);
        }
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("Illegal argument: offsetSkyCoords.size() (" + arrayList.size() + ") " + "did not pass the test: offsetSkyCoords.size() == 0");
        }
        Line line = SchedBlockExpert.determineMaximumSeparationBetweenPointings(arrayList);
        assert (line != null);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            MinimumBoundingRectangle minimumBoundingRectangle = new MinimumBoundingRectangle();
            MinimumBoundingRectangle.BoundedRectangle boundedRectangle = minimumBoundingRectangle.determineMinimumBoundRectangleForCoordinates(arrayList);
            assert (boundedRectangle != null);
            Log.logger(SchedBlockExpert.class).fine("boundedRectangle (without 7m beam width included) : " + boundedRectangle);
            rectangle.setLong(Angle.createAngle((double)boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.LONGEST).getSideLength(), (String)Angle.UNIT_ARCSEC));
            rectangle.setShort(Angle.createAngle((double)boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.SHORTEST).getSideLength(), (String)Angle.UNIT_ARCSEC));
            double d = boundedRectangle.getRotationAngle();
            Log.logger(SchedBlockExpert.class).fine("Adjusted rotation angle (degs) : " + d);
            rectangle.setRotationAngle(Angle.createAngle((double)d, (String)Angle.UNIT_DEG));
            rectangle.clearTPVertices();
            stringBuffer.setLength(0);
            for (Point2D.Double double_ : boundedRectangle.getRectangle()) {
                Angle angle = Angle.createAngle((double)double_.getX(), (String)Angle.UNIT_ARCSEC);
                Angle angle2 = Angle.createAngle((double)double_.getY(), (String)Angle.UNIT_ARCSEC);
                rectangle.addTPVertex(angle, angle2);
                stringBuffer.append(angle.getContentInUnits(Angle.UNIT_ARCSEC) + "," + angle2.getContentInUnits(Angle.UNIT_ARCSEC) + ",");
            }
            try {
                rectangle.setCentre(rectangle.getTPRectangleCentralCoordinate().getAbsoluteCoordinates(skyCoordinates));
            }
            catch (Rectangle.UnableToDetermineCentralCoordinateException unableToDetermineCentralCoordinateException) {
                throw new IllegalArgumentException("Unable to determine TP rectangle central coordinate");
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            double_.setRect(rectangle.getLongitudeLength().getContentInUnits(Angle.UNIT_ARCSEC), rectangle.getLatitudeLength().getContentInUnits(Angle.UNIT_ARCSEC), boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.LONGEST).getSideLength(), boundedRectangle.getSide(MinimumBoundingRectangle.BoundedRectangle.SideType.SHORTEST).getSideLength());
        }
        catch (MinimumBoundingRectangle.PointsAreAllCollinearException | MinimumBoundingRectangle.UnableToDetermineMinimumBoundingBoxException exception) {
            Log.logger(SchedBlockExpert.class).fine("Points are collinear or there are less than 3 pointings");
            if (arrayList.size() < 2) {
                rectangle.setRotationAngle(Angle.createAngle((double)0.0, (String)Angle.UNIT_DEG));
            } else {
                rectangle.setRotationAngle(Angle.createAngle((double)line.getAngleOfLine(), (String)Angle.UNIT_DEG));
            }
            if (arrayList.size() == 1) {
                rectangle.setCentre(((SkyCoordinates)arrayList.get(0)).getAbsoluteCoordinates(skyCoordinates));
            } else {
                rectangle.setCentre(line.getRectangleCentre().getAbsoluteCoordinates(skyCoordinates));
            }
            rectangle.setLong(Angle.createAngle((double)line.getLength(), (String)Angle.UNIT_ARCSEC));
            rectangle.setShort(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
        }
        if (Log.logger(SchedBlockExpert.class).fine()) {
            stringBuffer.setLength(0);
            for (SkyCoordinates skyCoordinates4 : arrayList) {
                stringBuffer.append(skyCoordinates4.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC) + "," + skyCoordinates4.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC) + ",");
            }
        }
        Log.logger(SchedBlockExpert.class).fine(String.format("Sky offset pointing coords (arcsec) : %s", stringBuffer.toString()));
        Log.logger(SchedBlockExpert.class).fine("Rectangle dimensions (arcsec) : Long " + rectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC) + " short " + rectangle.getShort().getContentInUnits(Angle.UNIT_ARCSEC));
        assert (rectangle != null);
        return rectangle;
    }

    private static Line determineMaximumSeparationBetweenPointings(List<SkyCoordinates> list) throws IllegalArgumentException {
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: offsetSkyCoords");
        }
        if (list.size() < 1) {
            throw new IllegalArgumentException("Illegal argument: offsetCoords.size (" + list.size() + ") " + " did not pass the test: offsetCoords.size < 1");
        }
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        if (list.size() == 1) {
            return new Line(0.0, double_, double_2);
        }
        double d = 0.0;
        boolean bl = false;
        for (SkyCoordinates skyCoordinates : list) {
            for (SkyCoordinates skyCoordinates2 : list) {
                if (skyCoordinates2 == skyCoordinates) continue;
                double d2 = skyCoordinates.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d3 = skyCoordinates.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d4 = skyCoordinates2.getLongitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d5 = skyCoordinates2.getLatitude().getContentInUnits(Angle.UNIT_ARCSEC);
                double d6 = d2 - d4;
                double d7 = d3 - d5;
                double d8 = Math.abs(Math.sqrt(d6 * d6 + d7 * d7));
                if (!bl) {
                    bl = true;
                    d = d8;
                    double_.setLocation(d2, d3);
                    double_2.setLocation(d4, d5);
                    continue;
                }
                if (!(d8 > d)) continue;
                double_.setLocation(d2, d3);
                double_2.setLocation(d4, d5);
                d = d8;
            }
        }
        Log.logger(SchedBlockExpert.class).fine("maxDistance: " + d);
        return new Line(d, double_, double_2);
    }

    public static Rectangle getBoundingRectangle(TargetParameters targetParameters) {
        TargetParameters targetParameters2 = TargetParameters.getPointingSourceInICRS(targetParameters);
        Rectangle rectangle = SchedBlockExpert.getBoundingRectangle(targetParameters2.getFieldCenterCoordinates(), targetParameters2.getPointingPattern().getPhaseCenterCoordinates());
        rectangle.setTargetParameters(targetParameters2);
        return rectangle;
    }

    public static class RequiredConfigurations {
        boolean twelveMCompactConfigurationRecommended = false;
        private Configuration best12mExtConfig = null;
        private Configuration twelveMetreCompactConfig = null;

        public RequiredConfigurations(Configuration configuration, Configuration configuration2) {
            this.best12mExtConfig = configuration;
            this.twelveMetreCompactConfig = configuration2;
        }

        public RequiredConfigurations() {
        }

        public boolean has12mCompactConfiguration() {
            return this.twelveMetreCompactConfig != null;
        }

        public final Configuration getBest12mExtConfig() {
            return this.best12mExtConfig;
        }

        public final Configuration getTwelveMetreCompactConfig() throws UnableToDetermine12mCompactConfiguration {
            if (this.twelveMCompactConfigurationRecommended && this.twelveMetreCompactConfig == null) {
                throw new UnableToDetermine12mCompactConfiguration();
            }
            return this.twelveMetreCompactConfig;
        }

        public final void setBest12mExtConfig(Configuration configuration) {
            this.best12mExtConfig = configuration;
        }

        public final void setTwelveMetreCompactConfig(Configuration configuration) {
            this.twelveMetreCompactConfig = configuration;
        }

        public final boolean is12mCompactConfigurationRecommended() {
            return this.twelveMCompactConfigurationRecommended;
        }

        public final void set12mCompactConfigurationRecommended(boolean bl) {
            this.twelveMCompactConfigurationRecommended = bl;
        }
    }

    public static class UnableToDetermine12mCompactConfiguration
    extends Exception {
    }

    public static class Line {
        private double length;
        private Point2D.Double p1;
        private Point2D.Double p2;

        public Line(double d, Point2D.Double double_, Point2D.Double double_2) {
            this.length = d;
            this.p1 = double_;
            this.p2 = double_2;
        }

        final double getLength() {
            return this.length;
        }

        final void setLength(double d) {
            if (d < 0.0) {
                throw new IllegalArgumentException("Illegal argument: length (" + d + ") " + "did not pass the test: length < 0");
            }
            this.length = d;
        }

        final SkyCoordinates getRectangleCentre() {
            if (this.p1 == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: p1");
            }
            if (this.p2 == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: p2");
            }
            SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
            double d = (this.p1.getX() + this.p2.getX()) / 2.0;
            double d2 = (this.p1.getY() + this.p2.getY()) / 2.0;
            skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
            skyCoordinates.setLatitude(Latitude.createLatitude((double)d2, (String)Latitude.UNIT_ARCSEC));
            skyCoordinates.setLongitude(Longitude.createLongitude((double)d, (String)Latitude.UNIT_ARCSEC));
            return skyCoordinates;
        }

        final double getAngleOfLine() {
            if (this.p1 == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: p1");
            }
            if (this.p2 == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: p2");
            }
            if (this.length == 0.0) {
                return 0.0;
            }
            double d = Math.abs(this.p1.getY() - this.p2.getY());
            double d2 = Math.toDegrees(Math.asin(Math.abs(d / this.length)));
            double d3 = (this.p1.getY() - this.p2.getY()) / (this.p1.getX() - this.p2.getX());
            if (d3 < 0.0) {
                d2 *= -1.0;
            }
            Log.logger(Line.class).fine("Angle of the line degrees : " + d2);
            return d2;
        }

        final double getSlope() {
            Log.logger(Line.class).fine("p2: " + this.p2);
            Log.logger(Line.class).fine("p1: " + this.p1);
            return (this.p1.getY() - this.p2.getY()) / (this.p1.getX() - this.p2.getX());
        }
    }
}

