/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline;

import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.services.experts.spectralline.SpectralLineComparators;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public final class SpectralLine
implements Comparable<SpectralLine>,
Cloneable {
    public static final String DEFAULT_NAME = "...Enter Name Here...";
    private static Collection<String> badSpecies = new ArrayList<String>();
    private static Collection<String> badTransition = new ArrayList<String>();
    private Type type = Type.UNKNOWN;
    private Integer lineId = null;
    private String species = "";
    private Frequency frequency;
    private String transition = "";
    private String description = "";
    private String title = "";
    private Double sMu = null;
    private String provenance = "";
    private Double upperStateEnergy = null;
    private Double observedIntensity = null;
    private UUID uuid = null;
    private CorrConfigMode corrConfigMode = null;
    private final EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
    private boolean isLineOutsideOfSPWRange = false;

    public void addFlag(Flag flag) {
        this.flags.add(flag);
    }

    public void removeFlag(Flag flag) {
        this.flags.remove((Object)flag);
    }

    public void setFlags(Collection<Flag> collection) {
        this.flags.clear();
        this.flags.addAll(collection);
    }

    public Collection<Flag> getFlags() {
        return this.flags;
    }

    public SpectralLine() {
    }

    public SpectralLine(SpectralLine spectralLine) {
        this.setLineId(spectralLine.lineId);
        this.setSpecies(spectralLine.species);
        this.setFrequency(spectralLine.frequency.deepCopy());
        this.setTransition(spectralLine.transition);
        this.setDescription(spectralLine.description);
        this.setSmu(spectralLine.sMu);
        this.setUpperStateEnergy(spectralLine.upperStateEnergy);
        this.setObservedIntensity(spectralLine.observedIntensity);
        this.setType(spectralLine.type);
        this.setFlags(spectralLine.flags);
        this.setTitle(spectralLine.title);
        this.setProvenance(spectralLine.provenance);
        this.setScienceSpectralWindowUUID(spectralLine.uuid);
        this.setCorrConfigMode(spectralLine.corrConfigMode);
    }

    private void resetTitle() {
        for (String string : badSpecies) {
            if (!this.species.contains(string)) continue;
            this.title = this.transition;
            return;
        }
        this.title = StringUtils.trim((String)(this.getSpecies().trim() + " " + this.getTransition()));
    }

    public CorrConfigMode getCorrConfigMode() {
        return this.corrConfigMode;
    }

    public void setCorrConfigMode(CorrConfigMode corrConfigMode) {
        this.corrConfigMode = corrConfigMode;
    }

    public UUID getScienceSpectralWindowUUID() {
        return this.uuid;
    }

    public void setScienceSpectralWindowUUID(UUID uUID) {
        this.uuid = uUID;
    }

    public Integer getLineId() {
        return this.lineId;
    }

    public void setLineId(Integer n) {
        this.lineId = n;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public double getFrequencyInGHz() {
        if (this.frequency == null) {
            return Double.NaN;
        }
        return this.frequency.getContentInGHz();
    }

    public void setFrequency(Frequency frequency) {
        if (frequency != null) {
            this.frequency = frequency.deepCopy();
        }
    }

    public void setFrequency(double d) {
        if (d != 0.0) {
            this.frequency = Frequency.createFrequency((double)d, (String)Frequency.UNIT_HZ);
        }
    }

    public double getWavelength() {
        return 2.99792458E8 / this.getFrequency().getContentInUnits(Frequency.UNIT_HZ);
    }

    public void setWavelength(double d) {
        if (d == 0.0) {
            this.frequency = null;
        } else {
            this.setFrequency(2.99792458E8 / d);
        }
    }

    public String getTransition() {
        return this.transition;
    }

    public void setTransition(String string) {
        string = string.trim();
        string = string.replaceAll("\\s+", " ");
        string = string.replaceAll("</?(sub|sup|i)>", "");
        string = string.replaceAll("&(Sigma|Omega);*", "$1");
        string = string.replaceAll("Sigma", "\u03a3");
        string = string.replaceAll("Omega", "\u03a9");
        string = string.replaceAll("alpha", "\u03b1");
        string = string.replaceAll("beta", "\u03b2");
        string = string.replaceAll("delta", "\u03b4");
        string = string.replaceAll("epsilon", "\u03b5");
        string = string.replaceAll("gamma", "\u03b3");
        string = string.replaceAll("zeta", "\u03b6");
        string = string.replaceAll("\\(\\s+", "\\(");
        string = string.replaceAll("\\s+(,|\\))", "$1");
        string = string.replaceAll("(?<=[\\d\\)=])\\s+?-\\s+?(?=\\d)", "-");
        string = string.replaceAll("(?<=[=-])\\s+(?=\\d)", "");
        string = string.replaceAll("(?<=\\d),\\s+(\\d)", ",$1");
        string = string.replaceAll(",(?![\\d*\\s])", ", ");
        this.transition = string = string.replaceAll("(?<=[+-])\\s+(?=[+-])", "");
        this.resetTitle();
    }

    public Type getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        string = string.trim();
        this.description = string = string.replaceAll("\\s+", " ");
    }

    public String getProvenance() {
        return this.provenance;
    }

    public void setProvenance(String string) {
        this.provenance = string;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String string) {
        string = string.trim();
        string = string.replaceAll("\\s+", " ");
        string = string.replaceAll("&(Sigma|Omega);", "$1");
        string = string.replaceAll("Sigma", "\u03a3");
        string = string.replaceAll("Omega", "\u03a9");
        string = string.replaceAll("(\\D{1}=\\d+)", " $1");
        this.species = string = string.replaceAll("\\s+", " ");
        this.resetTitle();
    }

    public Double getSmu() {
        return this.sMu;
    }

    public void setSmu(Double d) {
        this.sMu = d;
    }

    public Double getObservedIntensity() {
        return this.observedIntensity;
    }

    public void setObservedIntensity(Double d) {
        this.observedIntensity = d;
    }

    public Double getUpperStateEnergy() {
        return this.upperStateEnergy;
    }

    public void setUpperStateEnergy(Double d) {
        this.upperStateEnergy = d;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return "<SpectralLine(" + this.title + ", " + (Object)((Object)this.frequency) + ")>";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SpectralLine)) {
            return false;
        }
        SpectralLine spectralLine = (SpectralLine)object;
        boolean bl = false;
        if (this.frequency != null && spectralLine.frequency != null) {
            bl = spectralLine.frequency.equals((Object)this.frequency);
        }
        boolean bl2 = false;
        if (this.sMu == null && spectralLine.sMu == null) {
            bl2 = true;
        } else if (this.sMu != null && spectralLine.sMu != null) {
            bl2 = spectralLine.sMu.equals(this.sMu);
        }
        boolean bl3 = false;
        if (this.upperStateEnergy == null && spectralLine.upperStateEnergy == null) {
            bl3 = true;
        } else if (this.upperStateEnergy != null && spectralLine.upperStateEnergy != null) {
            bl3 = spectralLine.upperStateEnergy.equals(this.upperStateEnergy);
        }
        boolean bl4 = false;
        if (this.observedIntensity == null && spectralLine.observedIntensity == null) {
            bl4 = true;
        } else if (this.observedIntensity != null && spectralLine.observedIntensity != null) {
            bl4 = spectralLine.observedIntensity.equals(this.observedIntensity);
        }
        return bl && bl2 && bl3 && bl4 && spectralLine.description.equals(this.description) && spectralLine.species.equals(this.species) && spectralLine.title.equals(this.title) && spectralLine.transition.equals(this.transition) && spectralLine.type.equals((Object)this.type) && spectralLine.flags.equals(this.flags) && spectralLine.provenance.equals(this.provenance);
    }

    public int hashCode() {
        int n = 17;
        for (Object object : new Object[]{this.frequency, this.sMu, this.upperStateEnergy, this.observedIntensity}) {
            if (object == null) continue;
            n = 31 * n + object.hashCode();
        }
        n = 31 * n + this.species.hashCode();
        n = 31 * n + this.title.hashCode();
        n = 31 * n + this.transition.hashCode();
        n = 31 * n + this.description.hashCode();
        n = 31 * n + this.flags.hashCode();
        n = 31 * n + this.type.hashCode();
        n = 31 * n + this.provenance.hashCode();
        return n;
    }

    @Override
    public int compareTo(SpectralLine spectralLine) {
        if (this.equals(spectralLine)) {
            return 0;
        }
        return SpectralLineComparators.TITLE_COMPARATOR.compare(this, spectralLine);
    }

    public void setLineOutsideOfSPWRange(boolean bl) {
        this.isLineOutsideOfSPWRange = bl;
    }

    public boolean isLineOutsideOfSPWRange() {
        return this.isLineOutsideOfSPWRange;
    }

    static {
        badSpecies.add("alpha");
        badSpecies.add("beta");
        badSpecies.add("delta");
        badSpecies.add("epsilon");
        badSpecies.add("gamma");
        badSpecies.add("zeta");
        badSpecies.add("UnidentifiedTransition");
        badSpecies.add("u-line");
        badTransition.add("alpha");
    }

    public static enum Type {
        UNKNOWN,
        OFFLINE,
        ONLINE,
        CONTINUUM,
        LINE;

        public static final EnumSet<Type> ALL_TYPES;
        public static final EnumSet<Type> OBSERVED_TYPES;

        static {
            ALL_TYPES = EnumSet.allOf(Type.class);
            OBSERVED_TYPES = EnumSet.of(CONTINUUM, LINE);
        }
    }

    public static enum Flag {
        PLANET,
        ISM_HOTCORE,
        ISM_DIFFUSECLOUD,
        COMET,
        ISM_DARK_CLOUD,
        EXTRAGALACTIC,
        AGB_PPN_PN,
        COMMON;

        public static final EnumSet<Flag> ALL_FLAGS;

        static {
            ALL_FLAGS = EnumSet.allOf(Flag.class);
        }
    }
}

