/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.widgets.IndeterminateProgressMonitor;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.SpectralLineComparators;
import alma.obsprep.services.experts.spectralline.SpectralLineCsvEntry;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.UniqueList;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseBool;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.StrReplace;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.StrMinMax;
import org.supercsv.cellprocessor.constraint.StrNotNullOrEmpty;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.prefs.CsvPreference;

public class SpectralLineCatalogue {
    final CsvPreference csvPrefs = new CsvPreference('\"', 58, "\r\n");
    private final String[] header = new String[]{"line_id", "species_id", "s_name_noparens", "chemical_name", "orderedfreq", "resolved_QNs", "sijmu2", "lovas_int", "E_up_K", "planet", "ism_hotcore", "ism_diffusecloud", "comet", "ism_darkcloud", "extragalactic", "agb_ppn_pn", "top20"};
    private final CellProcessor[] userProcessors = new CellProcessor[]{new ParseInt(), new ParseInt(), new StrNotNullOrEmpty(), new StrNotNullOrEmpty(), new Optional((CellProcessor)new ParseDouble()), new NotNull(), new StrReplace("NULL", "-1", (StringCellProcessor)new ParseDouble()), new Optional((CellProcessor)new StrMinMax(0L, Integer.MAX_VALUE)), new StrReplace("NULL", "-1", (StringCellProcessor)new ParseDouble()), new ParseBool(), new ParseBool(), new ParseBool(), new ParseBool(), new ParseBool(), new ParseBool(), new ParseBool(), new Optional((CellProcessor)new ParseInt())};
    private final BasicEventList<SpectralLine> root = new BasicEventList(94000);
    private final UniqueList<SpectralLine> allLines = new UniqueList(this.root);
    private SortedList<SpectralLine> linesByFrequency = new SortedList(this.allLines, SpectralLineComparators.FREQUENCY_COMPARATOR);
    public static SpectralLineCatalogue INSTANCE = null;
    private static IndeterminateProgressMonitor progressMonitor;
    private Object monitor = new Object();

    public static final SpectralLineCatalogue getInstance() {
        return SpectralLineCatalogue.getInstance(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SpectralLineCatalogue getInstance(boolean bl) {
        if (INSTANCE != null) return INSTANCE;
        Class<SpectralLineCatalogue> clazz = SpectralLineCatalogue.class;
        synchronized (SpectralLineCatalogue.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SpectralLineCatalogue(bl);
            assert (INSTANCE != null);
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpectralLineCatalogue(boolean bl) {
        if (!Boolean.getBoolean("userSLC")) {
            File file = new File(System.getProperty("otData.dir"));
            URL uRL = MiscUtils.findResource(file, "splatalogue.csv");
            if (bl) {
                SwingWorker<List<SpectralLine>, Void> swingWorker = this.getLoader(uRL);
                swingWorker.execute();
                while (!swingWorker.isDone()) {
                    Object object = this.monitor;
                    synchronized (object) {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            } else {
                this.loadCatalogue(uRL);
            }
        }
    }

    private static void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static IndeterminateProgressMonitor makeProgressMonitor(final Component component, final Object object, final String string, final Dialog.ModalityType modalityType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SpectralLineCatalogue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    progressMonitor = SpectralLineCatalogue.makeProgressMonitor(component, object, string, modalityType);
                }
            });
            return progressMonitor;
        }
        progressMonitor = new IndeterminateProgressMonitor(component, object, string, modalityType);
        progressMonitor.setMillisToPopup(0);
        return progressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCatalogue(URL uRL) {
        try {
            SpectralLineCsvEntry spectralLineCsvEntry;
            InputStream inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            CsvBeanReader csvBeanReader = new CsvBeanReader((Reader)inputStreamReader, this.csvPrefs);
            ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>(32000);
            while ((spectralLineCsvEntry = (SpectralLineCsvEntry)csvBeanReader.read(SpectralLineCsvEntry.class, this.header, this.userProcessors)) != null) {
                arrayList.add(spectralLineCsvEntry.toSpectralLine());
            }
            csvBeanReader.close();
            this.allLines.getReadWriteLock().writeLock().lock();
            try {
                this.allLines.clear();
                this.allLines.addAll(arrayList);
            }
            finally {
                this.allLines.getReadWriteLock().writeLock().unlock();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Log.logger((Object)this).log(Level.WARNING, "User interrupted spectral line catalogue initialisation");
        }
        catch (IOException iOException) {
            Log.logger((Object)this).log(Level.WARNING, "Cannot read line catalogue: " + iOException.getMessage(), (Throwable)iOException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private SwingWorker<List<SpectralLine>, Void> getLoader(final URL uRL) {
        return new SwingWorker<List<SpectralLine>, Void>(){
            final List<SpectralLine> loaded = new ArrayList<SpectralLine>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SpectralLine> doInBackground() {
                IndeterminateProgressMonitor indeterminateProgressMonitor = SpectralLineCatalogue.makeProgressMonitor(null, "Loading Spectral Line Catalogue", "Loading offline database from disk...", Dialog.ModalityType.DOCUMENT_MODAL);
                this.addPropertyChangeListener(indeterminateProgressMonitor);
                try {
                    SpectralLineCsvEntry spectralLineCsvEntry;
                    InputStream inputStream = uRL.openStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    CsvBeanReader csvBeanReader = new CsvBeanReader((Reader)inputStreamReader, SpectralLineCatalogue.this.csvPrefs);
                    ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>(93000);
                    while ((spectralLineCsvEntry = (SpectralLineCsvEntry)csvBeanReader.read(SpectralLineCsvEntry.class, SpectralLineCatalogue.this.header, SpectralLineCatalogue.this.userProcessors)) != null) {
                        arrayList.add(spectralLineCsvEntry.toSpectralLine());
                    }
                    csvBeanReader.close();
                    SpectralLineCatalogue.invokeAndWait(() -> indeterminateProgressMonitor.setNote("Adding lines to pool."));
                    SpectralLineCatalogue.this.allLines.getReadWriteLock().writeLock().lock();
                    try {
                        SpectralLineCatalogue.this.allLines.clear();
                        SpectralLineCatalogue.this.allLines.addAll(arrayList);
                    }
                    finally {
                        SpectralLineCatalogue.this.allLines.getReadWriteLock().writeLock().unlock();
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    Log.logger((Object)this).log(Level.WARNING, "User interrupted spectral line catalogue initialisation");
                    GUIUtilities.error(null, "User interrupted spectral line catalogue initialisation");
                }
                catch (IOException iOException) {
                    Log.logger((Object)this).log(Level.WARNING, "Cannot read line catalogue: " + iOException.getMessage(), (Throwable)iOException);
                    GUIUtilities.error(null, "Cannot read line catalogue: " + iOException.getMessage(), iOException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    GUIUtilities.error(null, "Problem loading catalogue: " + exception.getMessage(), exception);
                }
                return this.loaded;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done() {
                Object object = SpectralLineCatalogue.this.monitor;
                synchronized (object) {
                    SpectralLineCatalogue.this.monitor.notifyAll();
                }
            }
        };
    }

    public EventList<SpectralLine> getRootCatalogue() {
        return this.allLines;
    }

    public Collection<SpectralLine> getLinesByFrequency() {
        return this.linesByFrequency;
    }

    public void load(final URL uRL) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingWorker swingWorker = SpectralLineCatalogue.this.getLoader(uRL);
                swingWorker.execute();
            }
        });
    }

    public static void setInstance(SpectralLineCatalogue spectralLineCatalogue) {
        INSTANCE = spectralLineCatalogue;
    }
}

