/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.spectralline.gui.Band;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.beansbinding.Converter;

abstract class FrequencyConverter
extends Converter<Double, Integer> {
    static final List<Band> bands = new ArrayList<Band>();
    static final int MIN_BAND = 1;
    static final int MAX_BAND = 10;
    static final double MIN_FREQUENCY = 31.3;
    static final double MAX_FREQUENCY = 950.0;

    FrequencyConverter() {
    }

    public Integer convertForward(Double d) {
        double d2 = d;
        double d3 = Double.MAX_VALUE;
        int n = 0;
        for (Band band : bands) {
            if (band.contains(d2)) {
                return band.getBand();
            }
            double d4 = d2 - band.getMaxFrequency();
            if (!(d4 > 0.0) || !(d4 < d3)) continue;
            d3 = d4;
            n = band.getBand();
        }
        if (d2 < 31.3) {
            return 1;
        }
        if (d2 > 950.0) {
            return 10;
        }
        return n;
    }

    static {
        for (ReceiverBand receiverBand : ReceiverBand.getFullReceiverBands()) {
            bands.add(new Band(receiverBand));
        }
    }
}

