/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.gui.AvailableLinesTableFormat;
import alma.obsprep.services.experts.spectralline.gui.FilteredCatalogue;
import alma.obsprep.services.experts.spectralline.gui.FilteredCatalogueControlPanel;
import alma.obsprep.services.experts.spectralline.gui.LineSelectorDialog;
import alma.obsprep.services.experts.spectralline.gui.TableCellRendererFactory;
import alma.obsprep.services.experts.spectralline.gui.TableColumnResizer;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class SingleLineSelectorDialog
extends LineSelectorDialog {
    private final FilteredCatalogue catalogue;
    private final Velocity velocity;
    private JLabel availableLabel;
    private FilteredCatalogueControlPanel filterControlPanel;
    private JScrollPane scrollPane;
    private JTable table;
    private JButton selectButton;
    private JButton cancelButton;

    public SingleLineSelectorDialog(Frame frame, EventList<SpectralLine> eventList, Velocity velocity) {
        super(frame);
        this.catalogue = new FilteredCatalogue(eventList);
        this.velocity = velocity;
        this.initComponents();
        this.filterControlPanel.setVelocity(velocity);
        this.filterControlPanel.clearHideObservableLineFilters();
        TableColumn tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.table.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.TEMPERATURE));
        tableColumn = this.table.getColumnModel().getColumn(6);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.DEBYE_SQUARED));
        this.filterControlPanel.controlCatalogue(this.catalogue);
        SortedList<SpectralLine> sortedList = this.catalogue.getSorted();
        TableComparatorChooser tableComparatorChooser = TableComparatorChooser.install((JTable)this.table, sortedList, (Object)TableComparatorChooser.MULTIPLE_COLUMN_MOUSE_WITH_UNDO, (TableFormat)new AvailableLinesTableFormat(velocity));
        tableComparatorChooser.fromString("column 2, column 0");
        TableColumnResizer.resize(this.table);
    }

    private void initComponents() {
        this.filterControlPanel = FilteredCatalogueControlPanel.getInstance();
        this.filterControlPanel.setSpectralLinePicker(this);
        this.scrollPane = new ScrollWhenFocusedPane();
        this.table = new JTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.availableLabel = new JLabel();
        this.selectButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Choose Spectral Line");
        this.setModal(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SingleLineSelectorDialog.this.formWindowClosing(windowEvent);
            }
        });
        this.table.setModel(this.catalogue.getTableModel(this.velocity));
        this.table.setSelectionModel((ListSelectionModel)this.catalogue.getSelectionModel());
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SingleLineSelectorDialog.this.tableMouseClicked(mouseEvent);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new SelectButtonEnabler());
        this.scrollPane.setViewportView(this.table);
        this.availableLabel.setFont(this.availableLabel.getFont().deriveFont(this.availableLabel.getFont().getStyle() | 1));
        this.availableLabel.setText("Transitions matching your filter settings");
        this.selectButton.setText("Select");
        this.selectButton.setEnabled(false);
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleLineSelectorDialog.this.selectButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingleLineSelectorDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.getContentPane().add(jScrollPane);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.filterControlPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.availableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(groupLayout.createSequentialGroup().addComponent(this.scrollPane, -1, -2, Short.MAX_VALUE).addContainerGap())).addGroup(groupLayout.createSequentialGroup().addComponent(this.selectButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.availableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 353, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectButton).addComponent(this.cancelButton)).addContainerGap()).addComponent(this.filterControlPanel, -2, -1, -2))));
        this.pack();
        this.availableLabel.setName("SingleLineSelectorDialog.availableLabel");
        this.cancelButton.setName("SingleLineSelectorDialog.cancelButton");
        this.filterControlPanel.setName("SingleLineSelectorDialog.filterControlPanel");
        this.scrollPane.setName("SingleLineSelectorDialog.scrollPane");
        this.selectButton.setName("SingleLineSelectorDialog.selectButton");
        this.table.setName("SingleLineSelectorDialog.table");
    }

    private void tableMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.selectButtonActionPerformed(null);
        }
    }

    private void selectButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
        if (this.publisher != null) {
            ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
            arrayList.add(this.catalogue.get(this.table.getSelectedRow()));
            this.publisher.publish(arrayList);
            this.publisher.complete();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
        if (this.publisher != null) {
            this.publisher.complete();
        }
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        if (this.publisher != null) {
            this.publisher.complete();
        }
    }

    public void setLOFrequencies(Frequency frequency, Frequency frequency2, boolean bl) {
        this.filterControlPanel.setLo1(frequency);
        this.filterControlPanel.setLo2(frequency2, bl);
        this.filterControlPanel.enableHideNonObservableLinesCheckBox(frequency != null);
    }

    private class SelectButtonEnabler
    implements ListSelectionListener {
        private SelectButtonEnabler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                SingleLineSelectorDialog.this.selectButton.setEnabled(false);
            } else {
                SingleLineSelectorDialog.this.selectButton.setEnabled(true);
            }
        }
    }
}

