/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Collection;

public class AvailableReceiverFilter
implements Matcher<SpectralLine> {
    final Collection<FrequencyRange> receiverBandRanges = new ArrayList<FrequencyRange>();

    public AvailableReceiverFilter(Velocity velocity) {
        for (ReceiverBand object : ReceiverBand.getKnownReceiverBands()) {
            this.receiverBandRanges.add(object.getRFRange());
        }
        for (FrequencyRange frequencyRange : this.receiverBandRanges) {
            FrequencyRange frequencyRange2 = FrequencyRange.centredOn((Frequency)((Object)frequencyRange.mid()), (Frequency)((Object)frequencyRange.range()));
            frequencyRange.setMin(velocity.reverseShift((Frequency)((Object)frequencyRange2.min())));
            frequencyRange.setMax(velocity.reverseShift((Frequency)((Object)frequencyRange2.max())));
        }
    }

    public boolean matches(SpectralLine spectralLine) {
        Frequency frequency = spectralLine.getFrequency();
        for (FrequencyRange frequencyRange : this.receiverBandRanges) {
            if (!frequencyRange.contains(frequency)) continue;
            return true;
        }
        return false;
    }
}

