/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.obsprep.services.experts.spectralline.SpectralLine;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MinimumUpperStateEnergyMatcherEditor
extends AbstractMatcherEditor<SpectralLine>
implements ChangeListener {
    private final JSpinner spinner;

    public MinimumUpperStateEnergyMatcherEditor(JSpinner jSpinner) {
        this.spinner = jSpinner;
        this.spinner.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Double d = (Double)this.spinner.getValue();
        if (d == null) {
            this.fireMatchAll();
        } else {
            this.fireChanged(new MinimumUpperStateEnergyMatcher(d));
        }
    }

    private static class MinimumUpperStateEnergyMatcher
    implements Matcher<SpectralLine> {
        private final Double threshold;

        public MinimumUpperStateEnergyMatcher(Double d) {
            this.threshold = d;
        }

        public boolean matches(SpectralLine spectralLine) {
            Double d = spectralLine.getUpperStateEnergy();
            return d >= this.threshold;
        }
    }
}

