/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui.filters;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.gui.NonObservableLinesFilterMethodInterface;
import alma.obsprep.services.experts.spectralline.gui.filters.AvailableReceiverFilter;
import alma.obsprep.services.experts.spectralline.gui.filters.BasebandMatcher;
import alma.obsprep.services.experts.spectralline.gui.filters.DoubleSidebandMatcher;
import alma.obsprep.services.experts.spectralline.gui.filters.LinesWithinSSPSpectralWindowsFilter;
import alma.obsprep.services.experts.spectralline.gui.filters.Lo1SidebandMatcher;
import alma.obsprep.services.experts.spectralline.gui.filters.Lo2BasebandMatcher;
import alma.obsprep.services.experts.spectralline.gui.filters.SingleSidebandMatcher;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.TreeSet;

public class SidebandMatcherEditor
extends AbstractMatcherEditor<SpectralLine> {
    public static final Frequency MIN_BANDWIDTH;
    private Velocity velocity;
    private boolean active = false;
    protected boolean enabled = false;
    protected final Collection<Matcher<SpectralLine>> matchers = new ArrayList<Matcher<SpectralLine>>();
    private FrequencyRangeMatcher currentMatcher;
    private Lo1SidebandMatcher lo1Matcher = null;
    private Lo2BasebandMatcher lo2Matcher = null;
    private final Collection<SpectralLine> linesInOtherBasebands = new ArrayList<SpectralLine>();
    private final Collection<SpectralLine> linesInThisBaseband = new ArrayList<SpectralLine>();
    private NonObservableLinesFilterMethodInterface nonObservableFilteringAlgorithmDecider;

    public SidebandMatcherEditor(Velocity velocity, NonObservableLinesFilterMethodInterface nonObservableLinesFilterMethodInterface) {
        assert (nonObservableLinesFilterMethodInterface != null);
        this.velocity = velocity;
        this.nonObservableFilteringAlgorithmDecider = nonObservableLinesFilterMethodInterface;
    }

    public boolean isActive() {
        for (Matcher<SpectralLine> matcher : this.matchers) {
            if (matcher instanceof AvailableReceiverFilter) continue;
            return true;
        }
        return false;
    }

    public void setLo1(Frequency frequency) {
        if (frequency == null) {
            this.lo1Matcher = null;
        } else {
            double d = frequency.getContentInGHz();
            for (ReceiverBand receiverBand : ReceiverBand.getFullReceiverBands()) {
                double d2 = receiverBand.getLOMin();
                double d3 = receiverBand.getLOMax();
                if (!(d >= d2) || !(d3 >= d)) continue;
                this.lo1Matcher = new Lo1SidebandMatcher(frequency, receiverBand, this.velocity);
            }
        }
        Matcher<SpectralLine> iterator = null;
        for (Matcher<SpectralLine> matcher : this.matchers) {
            if (!(matcher instanceof Lo1SidebandMatcher)) continue;
            iterator = matcher;
        }
        this.matchers.remove(iterator);
        if (this.lo1Matcher != null) {
            this.matchers.add(this.lo1Matcher);
        }
        boolean bl = this.active = this.matchers.size() > 0;
        if (this.enabled) {
            this.currentMatcher = new FrequencyRangeMatcher(this.matchers);
            this.fireChanged(this.currentMatcher);
        }
    }

    public void setLo2(Frequency frequency, boolean bl) {
        if (this.lo1Matcher == null || frequency == null) {
            this.lo2Matcher = null;
        } else {
            Frequency frequency2 = this.lo1Matcher.getLo1();
            this.lo2Matcher = new Lo2BasebandMatcher(frequency2, frequency, this.velocity, bl);
        }
        for (Matcher matcher : this.matchers) {
            if (!(matcher instanceof Lo2BasebandMatcher)) continue;
            this.matchers.remove(matcher);
        }
        if (this.lo2Matcher != null) {
            this.matchers.add(this.lo2Matcher);
        }
        boolean bl2 = this.active = this.matchers.size() > 0;
        if (this.enabled) {
            this.currentMatcher = new FrequencyRangeMatcher(this.matchers);
            this.fireChanged(this.currentMatcher);
        }
    }

    private Collection<Matcher<SpectralLine>> getMatchersForLines(Collection<SpectralLine> collection, Frequency frequency, boolean bl) {
        ArrayList<Matcher<SpectralLine>> arrayList = new ArrayList<Matcher<SpectralLine>>();
        arrayList.add(new AvailableReceiverFilter(this.velocity));
        Frequency frequency2 = null;
        if (collection != null && this.lo1Matcher == null) {
            if (bl) {
                frequency2 = this.getMaxWindowWidth(collection);
            }
            for (SpectralLine spectralLine : collection) {
                Frequency frequency3 = spectralLine.getFrequency();
                Frequency frequency4 = this.velocity.dopplerShift(frequency3);
                for (ReceiverBand receiverBand : ReceiverBand.getFullReceiverBands()) {
                    if (!receiverBand.getRFRange().contains(frequency4)) continue;
                    ReceiverType receiverType = receiverBand.getReceiverType();
                    if (ReceiverType.SSB.equals((Object)receiverType)) {
                        arrayList.add(new SingleSidebandMatcher(frequency4, receiverBand, this.velocity, frequency));
                        continue;
                    }
                    arrayList.add(new DoubleSidebandMatcher(frequency4, receiverBand, this.velocity, frequency));
                }
                if (!bl) continue;
                arrayList.add(new BasebandMatcher(frequency4, this.velocity, frequency2));
            }
        }
        return arrayList;
    }

    public void setLinesInOtherBasebands(Collection<SpectralLine> collection) {
        this.linesInOtherBasebands.clear();
        if (collection != null) {
            this.linesInOtherBasebands.addAll(collection);
        }
        this.setLines(this.linesInThisBaseband);
    }

    public Frequency getMaxWindowWidth(Collection<SpectralLine> collection) {
        Frequency frequency = MIN_BANDWIDTH.deepCopy();
        this.getMaxWindowWidth(frequency, collection);
        return frequency;
    }

    private void getMaxWindowWidth(Frequency frequency, Collection<SpectralLine> collection) {
        if (collection != null) {
            for (SpectralLine spectralLine : collection) {
                Frequency frequency2;
                CorrConfigMode corrConfigMode = spectralLine.getCorrConfigMode();
                if (corrConfigMode == null || !(frequency2 = corrConfigMode.getNominalBandwidth()).isGreaterThan((AbstractDoubleWithUnit)frequency)) continue;
                frequency.setContentAndUnit((ValueUnitPair)frequency2);
            }
        }
    }

    public void setLines(Collection<SpectralLine> collection) {
        ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
        if (collection != null) {
            arrayList.addAll(collection);
        }
        this.linesInThisBaseband.clear();
        if (collection != null) {
            this.linesInThisBaseband.addAll(arrayList);
        }
        Frequency frequency = MIN_BANDWIDTH.deepCopy();
        Frequency frequency2 = this.getMaxWindowWidth(this.linesInOtherBasebands);
        Frequency frequency3 = (Frequency)((Frequency)frequency2.plus((AbstractDoubleWithUnit)frequency)).half();
        Collection<Matcher<SpectralLine>> collection2 = null;
        switch (this.nonObservableFilteringAlgorithmDecider.getFilterType()) {
            case RESTFREQUENCIES: {
                collection2 = this.getMatchersForRestFrequencies(this.linesInThisBaseband, this.nonObservableFilteringAlgorithmDecider.getSSP());
                break;
            }
            case SPW: {
                collection2 = this.getMatchersForLines(this.linesInThisBaseband, frequency3, true);
                collection2.addAll(this.getMatchersForLines(this.linesInOtherBasebands, frequency3, false));
                break;
            }
            case OVERLAY: {
                collection2 = this.getMatchersForLines(new ArrayList<SpectralLine>(), frequency3, false);
                break;
            }
            default: {
                throw new RuntimeException("Unable to determine the non-observable line algorithm");
            }
        }
        assert (collection2 != null);
        ArrayList<Matcher<SpectralLine>> arrayList2 = new ArrayList<Matcher<SpectralLine>>();
        for (Matcher<SpectralLine> matcher : this.matchers) {
            if (matcher instanceof SingleSidebandMatcher) {
                arrayList2.add(matcher);
            }
            if (matcher instanceof DoubleSidebandMatcher) {
                arrayList2.add(matcher);
            }
            if (matcher instanceof BasebandMatcher) {
                arrayList2.add(matcher);
            }
            if (!(matcher instanceof AvailableReceiverFilter)) continue;
            arrayList2.add(matcher);
        }
        this.matchers.removeAll(arrayList2);
        this.matchers.addAll(collection2);
        this.active = this.isActive();
        if (this.enabled) {
            this.currentMatcher = new FrequencyRangeMatcher(this.matchers);
            this.fireChanged(this.currentMatcher);
        }
    }

    private Collection<Matcher<SpectralLine>> getMatchersForRestFrequencies(Collection<SpectralLine> collection, Optional<SpectralSetupParameters> optional) {
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("Illegal argument: !ssp.isPresent() (" + !optional.isPresent() + ") " + "did not pass the test: !ssp.isPresent() ");
        }
        ArrayList<Matcher<SpectralLine>> arrayList = new ArrayList<Matcher<SpectralLine>>();
        arrayList.add(new LinesWithinSSPSpectralWindowsFilter(optional.get()));
        return arrayList;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            this.currentMatcher = new FrequencyRangeMatcher(this.matchers);
            this.fireChanged(this.currentMatcher);
        } else {
            this.fireMatchAll();
        }
    }

    public Frequency getMinFrequency() {
        Collection<FrequencyRange> collection = this.getWindows();
        Frequency frequency = Frequency.createFrequencyGHZ(Double.MAX_VALUE);
        for (FrequencyRange frequencyRange : collection) {
            if (!((Frequency)((Object)frequencyRange.min())).isLessThan((AbstractDoubleWithUnit)frequency)) continue;
            frequency = (Frequency)((Object)frequencyRange.min());
        }
        return frequency;
    }

    public Frequency getMaxFrequency() {
        Collection<FrequencyRange> collection = this.getWindows();
        Frequency frequency = Frequency.createFrequencyGHZ(-1.7976931348623157E308);
        for (FrequencyRange frequencyRange : collection) {
            if (!((Frequency)((Object)frequencyRange.max())).isGreaterThan((AbstractDoubleWithUnit)frequency)) continue;
            frequency = (Frequency)((Object)frequencyRange.max());
        }
        return frequency;
    }

    public void clearFilters() {
        this.matchers.clear();
        this.setLines(null);
        this.setLinesInOtherBasebands(null);
        this.setLo1(null);
        this.setLo2(null, true);
    }

    private Collection<FrequencyRange> getWindows() {
        Comparator<Frequency> comparator = new Comparator<Frequency>(){

            @Override
            public int compare(Frequency frequency, Frequency frequency2) {
                if (frequency.isEqual((AbstractDoubleWithUnit)frequency2)) {
                    return 0;
                }
                return frequency.isLessThan((AbstractDoubleWithUnit)frequency2) ? -1 : 1;
            }
        };
        ArrayList<FrequencyRange> arrayList = new ArrayList<FrequencyRange>();
        for (Matcher<SpectralLine> object2 : this.matchers) {
            if (object2 instanceof SingleSidebandMatcher) {
                arrayList.add(((SingleSidebandMatcher)object2).sideband);
            }
            if (object2 instanceof DoubleSidebandMatcher) {
                arrayList.addAll(((DoubleSidebandMatcher)object2).sidebands);
            }
            if (object2 instanceof Lo1SidebandMatcher) {
                arrayList.addAll(((Lo1SidebandMatcher)object2).sidebands);
            }
            if (object2 instanceof BasebandMatcher) {
                arrayList.add(((BasebandMatcher)object2).baseband);
            }
            if (!(object2 instanceof AvailableReceiverFilter)) continue;
            arrayList.addAll(((AvailableReceiverFilter)object2).receiverBandRanges);
        }
        TreeSet<Frequency> treeSet = new TreeSet<Frequency>(comparator);
        TreeSet<Frequency> treeSet2 = new TreeSet<Frequency>(comparator);
        for (FrequencyRange frequencyRange : arrayList) {
            if (this.currentMatcher.matches((Frequency)((Object)frequencyRange.min()))) {
                treeSet.add((Frequency)((Object)frequencyRange.min()));
            }
            if (!this.currentMatcher.matches((Frequency)((Object)frequencyRange.max()))) continue;
            treeSet2.add((Frequency)((Object)frequencyRange.max()));
        }
        ArrayList arrayList2 = new ArrayList();
        Frequency[] frequencyArray = treeSet2.toArray(new Frequency[treeSet2.size()]);
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Frequency frequency = (Frequency)((Object)iterator.next());
            Frequency frequency2 = frequencyArray[n++];
            arrayList2.add(new FrequencyRange(frequency, frequency2));
        }
        return arrayList2;
    }

    static {
        Frequency frequency = Frequency.createFrequencyGHZ(1.0E9);
        for (CorrConfigMode corrConfigMode : OTConfigModeDecoder.getInstance().getKnownModesSet()) {
            Frequency frequency2 = corrConfigMode.getNominalBandwidth();
            if (!frequency2.isLessThan((AbstractDoubleWithUnit)frequency)) continue;
            frequency.setContentAndUnit((ValueUnitPair)frequency2);
        }
        MIN_BANDWIDTH = frequency;
    }

    private static class FrequencyRangeMatcher
    implements Matcher<SpectralLine> {
        private final Collection<Matcher<SpectralLine>> frequencyRangeMatcher = new ArrayList<Matcher<SpectralLine>>();

        public FrequencyRangeMatcher(Collection<Matcher<SpectralLine>> collection) {
            if (collection != null) {
                this.frequencyRangeMatcher.addAll(collection);
            }
        }

        public boolean matches(SpectralLine spectralLine) {
            for (Matcher<SpectralLine> matcher : this.frequencyRangeMatcher) {
                if (matcher.matches((Object)spectralLine)) continue;
                return false;
            }
            return true;
        }

        public boolean matches(Frequency frequency) {
            SpectralLine spectralLine = new SpectralLine();
            spectralLine.setFrequency(frequency);
            return this.matches(spectralLine);
        }
    }
}

