/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.ReceiverExpert;
import alma.obsprep.services.experts.SingleContinuumExpert;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.Range;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BaseBandDeployer {
    private Log.Logger logger = Log.logger((Object)this);
    protected BaseBandList basebands;
    protected SpectralSetupParameters ssp;
    private static final String DEFAULTERRORMESSAGE = "Can not allocate these spectral windows in one receiver band.";
    public static final Frequency BASEBANDWIDTH = Frequency.createFrequencyGHZ(2.0);
    public static final double HALFBASEBANDWITHGHZ = ((Frequency)BASEBANDWIDTH.half(true)).getContentInGHz();
    public static final Frequency FREQ_OFFSET = Frequency.createFrequencyGHZ(1.0E-10);
    protected static final boolean EFFECTIVE = true;
    protected static final boolean NOMINAL = false;
    protected Integer spectralScanTuningIndex = 0;
    public static final Frequency dummyFrequency = Frequency.createFrequencyGHZ(-1.0);
    private static Frequency ZERO_GHZ = Frequency.createFrequencyGHZ(0.0);

    public BaseBandDeployer(SpectralSetupParameters spectralSetupParameters, Integer n) throws BaseBandNotDeployableException {
        this.ssp = spectralSetupParameters;
        this.spectralScanTuningIndex = n;
        if (!spectralSetupParameters.isSpectralScan()) {
            throw new BaseBandNotDeployableException("Spectral setup should be a spectral scan");
        }
        Velocity velocity = Velocity.createVelocity();
        velocity.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
        this.basebands = new BaseBandList(velocity);
        SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
        SpectralScan.SpectralScanTunings spectralScanTunings = null;
        try {
            spectralScanTunings = spectralScan.getTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            throw new BaseBandNotDeployableException(unableToFindSolutionException);
        }
        if (n > spectralScanTunings.getNumberOfTunings()) {
            throw new BaseBandNotDeployableException("Tuning index in the spectral scan is out of range");
        }
        try {
            for (Frequency frequency : spectralScanTunings.getTuning(n)) {
                BaseBand baseBand = new BaseBand();
                Frequency frequency2 = frequency;
                UserFrequency userFrequency = spectralScan.getBandWidth();
                baseBand.addSpectralWindow(new SpectralWindow(frequency2, (Frequency)((Object)userFrequency), velocity));
                if (((Frequency)((Object)baseBand.getRange(true).range())).isGreaterThan((AbstractDoubleWithUnit)BASEBANDWIDTH)) {
                    String string = "The spectral window range exceeds the baseband width : " + baseBand.getRange(true).range();
                    throw new BaseBandNotDeployableException(string);
                }
                baseBand.setCenter();
                this.basebands.add(baseBand);
            }
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            throw new BaseBandNotDeployableException(spectralScanTuningException);
        }
    }

    public BaseBandDeployer(SpectralSetupParameters spectralSetupParameters) throws BaseBandNotDeployableException {
        Object object;
        ScienceSpectralWindow[] scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindow();
        this.ssp = spectralSetupParameters;
        Velocity velocity = Velocity.createVelocity();
        velocity.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
        try {
            if (!(spectralSetupParameters.getSSPDerivedFromSpectralScanSetup().booleanValue() || spectralSetupParameters.getType() == SpectralSetupParameters.TYPE_CONTINUUM && spectralSetupParameters.getScienceSpectralWindow(0).getIsSkyFrequency())) {
                velocity = spectralSetupParameters.getSourceVelocity();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new BaseBandNotDeployableException();
        }
        if (spectralSetupParameters.getScienceSpectralWindowCount() == 0) {
            throw new BaseBandNotDeployableException();
        }
        if (!spectralSetupParameters.getScienceSpectralWindow(0).getIsSkyFrequency()) {
            velocity = spectralSetupParameters.getSourceVelocity();
        }
        this.basebands = new BaseBandList(velocity);
        boolean bl = false;
        try {
            if (spectralSetupParameters.getScienceGoal() != null) {
                object = spectralSetupParameters.getScienceGoal().getObsProposal();
                if (object == null) {
                    throw new BaseBandNotDeployableException("Unable to determine if this is a VLBI project");
                }
                bl = object.isVLBI();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new BaseBandNotDeployableException("Unable to determine if this is a VLBI project");
        }
        if (spectralSetupParameters.isSingleContinuum() && !bl) {
            object = spectralSetupParameters.getScienceSpectralWindow(0);
            Frequency frequency = Frequency.createFrequencyGHZ(2.0);
            if (object == null) {
                throw new BaseBandNotDeployableException("At least 1 spectral window is needed.");
            }
            Frequency frequency2 = spectralSetupParameters.getSingleContinuumFrequency();
            Frequency frequency3 = object.getIsSkyFrequency() ? frequency2 : velocity.dopplerShift(frequency2);
            SingleContinuumExpert singleContinuumExpert = new SingleContinuumExpert(frequency3);
            Range<Frequency>[] rangeArray = null;
            try {
                rangeArray = singleContinuumExpert.singleContinuumBasebands(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BaseBandNotDeployableException(illegalArgumentException);
            }
            for (Range<Frequency> range : rangeArray) {
                BaseBand baseBand = new BaseBand();
                Frequency frequency4 = range.mid();
                baseBand.setCenterRest(frequency4);
                baseBand.addNewSpectralWindow(frequency4, frequency);
                this.basebands.add(baseBand);
            }
            return;
        }
        try {
            object = spectralSetupParameters.getGroupIndexSet();
        }
        catch (InvalidGroupIndexException invalidGroupIndexException) {
            invalidGroupIndexException.printStackTrace();
            throw new BaseBandNotDeployableException(invalidGroupIndexException);
        }
        if (object.size() == 0) {
            throw new BaseBandNotDeployableException("At least 1 spectral window is needed.");
        }
        if (object.contains(-1) && object.size() > 1) {
            String string = "ScienceSpectralWindow has an invalid group index : -1";
            throw new BaseBandNotDeployableException(string);
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object object2;
            BaseBand baseBand = new BaseBand();
            int n = (Integer)iterator.next();
            for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
                if (scienceSpectralWindow.getGroupIndex() != n) continue;
                Frequency frequency = scienceSpectralWindow.getCenterFrequency();
                object2 = scienceSpectralWindow.getBandWidth();
                baseBand.addSpectralWindow(new SpectralWindow(frequency, (Frequency)((Object)object2), velocity));
            }
            FrequencyRange frequencyRange = baseBand.getRange(true);
            BigDecimal bigDecimal = new BigDecimal(((Frequency)((Object)frequencyRange.min())).getContentInGHz());
            BigDecimal bigDecimal2 = new BigDecimal(((Frequency)((Object)frequencyRange.max())).getContentInGHz());
            double d = bigDecimal2.subtract(bigDecimal, new MathContext(14)).doubleValue();
            if (d > BASEBANDWIDTH.getContentInGHz()) {
                object2 = "The spectral window range exceeds the baseband width : " + frequencyRange.range();
                throw new BaseBandNotDeployableException((String)object2);
            }
            baseBand.setCenter();
            this.basebands.add(baseBand);
        }
    }

    BaseBandList createBaseBandList(Velocity velocity) {
        return new BaseBandList(velocity);
    }

    public boolean isDeployable(boolean bl) throws BaseBandNotDeployableException {
        Set<ReceiverBand> set = this.getSuitableReceiverSet();
        for (ReceiverBand receiverBand : set) {
            if (!this.isDeployable(receiverBand, bl)) continue;
            return true;
        }
        return false;
    }

    private boolean isDeployable(ReceiverBand receiverBand, boolean bl) {
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax() * 2.0);
        Frequency frequency3 = Frequency.createFrequencyGHZ(receiverBand.getIFMin() * 2.0);
        FrequencyRange frequencyRange = this.basebands.getWholeRange(bl);
        Frequency frequency4 = (Frequency)((Object)frequencyRange.range());
        if (!receiverBand.getRFRange().contains(frequencyRange)) {
            return false;
        }
        if (frequency4.isGreaterThan((AbstractDoubleWithUnit)frequency2)) {
            return false;
        }
        if (frequency4.isLessThanOrEqualTo((AbstractDoubleWithUnit)frequency)) {
            return true;
        }
        if (receiverBand.getReceiverType() == ReceiverType.SSB) {
            return false;
        }
        FrequencyRange frequencyRange2 = this.basebands.basebandWidestFrequencyGap(bl);
        if (frequencyRange2 == null) {
            return false;
        }
        if (((Frequency)((Object)frequencyRange2.range())).isLessThan((AbstractDoubleWithUnit)frequency3)) {
            return false;
        }
        FrequencyRange frequencyRange3 = this.basebands.getLsbBBs().getWholeRange(bl);
        FrequencyRange frequencyRange4 = this.basebands.getUsbBBs().getWholeRange(bl);
        if (((Frequency)((Object)frequencyRange3.range())).isGreaterThan((AbstractDoubleWithUnit)frequency) || ((Frequency)((Object)frequencyRange4.range())).isGreaterThan((AbstractDoubleWithUnit)frequency)) {
            return false;
        }
        if (receiverBand.getReceiverType().equals((Object)ReceiverType.TSB)) {
            BaseBandList baseBandList = this.basebands.getLsbBBs();
            BaseBandList baseBandList2 = this.basebands.getUsbBBs();
            if (baseBandList.size() == 3 && baseBandList2.size() == 1 || baseBandList.size() == 1 && baseBandList2.size() == 3) {
                return false;
            }
        }
        return this.testLO1Constraints(receiverBand, bl);
    }

    private boolean testLO1UpperConstraints(ReceiverBand receiverBand, boolean bl) {
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax());
        Frequency frequency3 = (Frequency)((Frequency)((Frequency)((Object)receiverBand.getHardRFRange().max())).minus((AbstractDoubleWithUnit)frequency2)).minus((AbstractDoubleWithUnit)frequency);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(bl);
        return ((Frequency)((Object)frequencyRange.min())).isLessThanOrEqualTo((AbstractDoubleWithUnit)frequency3);
    }

    private boolean testLO1LowerConstraints(ReceiverBand receiverBand, boolean bl) {
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax());
        Frequency frequency3 = (Frequency)((Frequency)((Frequency)((Object)receiverBand.getHardRFRange().min())).plus((AbstractDoubleWithUnit)frequency2, true)).plus((AbstractDoubleWithUnit)frequency, true);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(bl);
        return ((Frequency)((Object)frequencyRange.max())).isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency3);
    }

    private boolean testLO1Constraints(ReceiverBand receiverBand, boolean bl) {
        return this.testLO1UpperConstraints(receiverBand, bl) && this.testLO1LowerConstraints(receiverBand, bl);
    }

    private Set<ReceiverBand> getSuitableReceiverSet() throws BaseBandNotDeployableException {
        if (this.basebands.size() == 0) {
            throw new BaseBandNotDeployableException("Ranges must have at least one element.");
        }
        FrequencyRange frequencyRange = this.basebands.getWholeRange(true);
        return ReceiverExpert.getInstance().getSuitableReceiverSet(frequencyRange);
    }

    private ReceiverBand getOneSuitableReceiverBand() throws BaseBandNotDeployableException {
        ReceiverBand receiverBand;
        Set<ReceiverBand> set = this.getSuitableReceiverSet();
        if (set.size() == 2) {
            receiverBand = ReceiverBand.getReceiverBand(FrequencySetup.RECEIVERBAND_ALMA_RB_03);
        } else {
            if (set.size() == 0) {
                throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
            }
            ReceiverBand[] receiverBandArray = set.toArray(new ReceiverBand[1]);
            receiverBand = receiverBandArray[0];
        }
        return receiverBand;
    }

    public Frequency[] getAdjustedBaseBandCenterFrequenciesRest() throws BaseBandNotDeployableException {
        if (this.isDeployable(false)) {
            return this.relabelling();
        }
        if (!this.isDeployable(true)) {
            throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
        }
        ReceiverBand receiverBand = this.getOneSuitableReceiverBand();
        for (BaseBand baseBand : this.basebands) {
            if (receiverBand.getRFMax() <= ((Frequency)((Object)baseBand.max())).getContentInGHz()) {
                baseBand.setCenterSky(Frequency.createFrequencyGHZ(receiverBand.getRFMax() - 1.0 - 1.0E-9));
            }
            if (!(receiverBand.getRFMin() >= ((Frequency)((Object)baseBand.min())).getContentInGHz())) continue;
            baseBand.setCenterSky(Frequency.createFrequencyGHZ(receiverBand.getRFMin() + 1.0 + 1.0E-9));
        }
        if (this.isDeployable(false)) {
            return this.relabelling();
        }
        switch (receiverBand.getReceiverType()) {
            case SSB: {
                this.adjustSSB(receiverBand);
                break;
            }
            case TSB: 
            case DSB: {
                this.adjustTSB(receiverBand);
                break;
            }
            default: {
                throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
            }
        }
        if (!this.isDeployable(false)) {
            throw new BaseBandNotDeployableException("Unexpected failure -- configuration failed");
        }
        return this.relabelling();
    }

    private Frequency[] relabelling() throws BaseBandNotDeployableException {
        int n;
        Frequency[] frequencyArray = this.basebands.getCenterFrequenciesRest();
        Frequency[] frequencyArray2 = this.basebands.getCenterFrequenciesSky();
        ReceiverBand receiverBand = this.getOneSuitableReceiverBand();
        if (!receiverBand.getReceiverType().equals((Object)ReceiverType.TSB)) {
            return frequencyArray;
        }
        FrequencyRange frequencyRange = this.basebands.getWholeRange(false);
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - receiverBand.getIFMin());
        if (frequency.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequencyRange.range())) {
            return frequencyArray;
        }
        Frequency frequency2 = (Frequency)((Object)frequencyRange.mid());
        int n2 = this.basebands.size();
        Frequency[] frequencyArray3 = new Frequency[n2];
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            frequencyArray3[n] = frequencyArray[n];
            blArray[n] = frequencyArray2[n].isLessThan((AbstractDoubleWithUnit)frequency2);
        }
        switch (n2) {
            case 1: {
                return frequencyArray;
            }
            case 2: {
                if (blArray[0] == blArray[1]) {
                    return frequencyArray;
                }
                return new Frequency[]{frequencyArray3[0], dummyFrequency, frequencyArray3[1]};
            }
            case 3: {
                if (blArray[0] == blArray[1]) {
                    return frequencyArray;
                }
                if (blArray[0] == blArray[2]) {
                    this.ssp.swapGroupIndex(1, 2);
                    return new Frequency[]{frequencyArray3[0], frequencyArray3[2], frequencyArray3[1]};
                }
                return new Frequency[]{frequencyArray3[0], dummyFrequency, frequencyArray3[1], frequencyArray3[2]};
            }
            case 4: {
                n = 0;
                for (boolean bl : blArray) {
                    if (!bl) continue;
                    ++n;
                }
                switch (n) {
                    case 0: 
                    case 4: {
                        return frequencyArray;
                    }
                    case 1: 
                    case 3: {
                        throw new BaseBandNotDeployableException("Basebands pairs 0/1 and 2/3 must use the same sideband within the pair");
                    }
                    case 2: {
                        if (blArray[0] == blArray[1]) {
                            return frequencyArray;
                        }
                        if (blArray[0] == blArray[2]) {
                            this.ssp.swapGroupIndex(1, 2);
                            return new Frequency[]{frequencyArray3[0], frequencyArray3[2], frequencyArray3[1], frequencyArray3[3]};
                        }
                        this.ssp.swapGroupIndex(1, 3);
                        return new Frequency[]{frequencyArray3[0], frequencyArray3[3], frequencyArray3[1], frequencyArray3[2]};
                    }
                }
                throw new BaseBandNotDeployableException("Unexpected error");
            }
        }
        throw new BaseBandNotDeployableException("Unexpected error");
    }

    private void adjustSSB(ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        this.clipRange(receiverBand);
    }

    private void adjustTSB(ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        BaseBandList baseBandList;
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax() * 2.0);
        Frequency frequency3 = Frequency.createFrequencyGHZ(receiverBand.getIFMin() * 2.0);
        FrequencyRange frequencyRange = this.basebands.getWholeRange(true);
        Frequency frequency4 = (Frequency)((Object)frequencyRange.range());
        if (frequency4.isLessThan((AbstractDoubleWithUnit)frequency)) {
            this.clipRange(receiverBand);
            return;
        }
        BaseBandList baseBandList2 = this.basebands.getLsbBBs();
        BaseBandList baseBandList3 = this.basebands.getUsbBBs();
        if (receiverBand.getReceiverType().equals((Object)ReceiverType.TSB) && (baseBandList2.size() == 3 && baseBandList3.size() == 1 || baseBandList2.size() == 1 && baseBandList3.size() == 3)) {
            String string = "Can not allocate 3 bandbands to one sideband and 1 to the other.";
            throw new BaseBandNotDeployableException(string);
        }
        BaseBandList baseBandList4 = this.basebands.getLsbBBs();
        if (((Frequency)((Object)baseBandList4.getWholeRange(false).range())).isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency)) {
            this.clipRange(receiverBand, baseBandList4, frequency);
        }
        if (((Frequency)((Object)(baseBandList = this.basebands.getUsbBBs()).getWholeRange(false).range())).isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency)) {
            this.clipRange(receiverBand, baseBandList, frequency);
        }
        if (this.isDeployable(false)) {
            return;
        }
        if (((Frequency)((Object)this.basebands.getWholeRange(false).range())).isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency2)) {
            this.clipOutside(receiverBand);
        }
        if (this.isDeployable(false)) {
            return;
        }
        if (((Frequency)((Object)this.basebands.basebandWidestFrequencyGap(false).range())).isLessThanOrEqualTo((AbstractDoubleWithUnit)frequency3)) {
            this.clipInside(receiverBand);
        }
        if (this.isDeployable(false)) {
            return;
        }
        if (!this.testLO1UpperConstraints(receiverBand, false)) {
            this.clipLO1UpperConstraints(receiverBand);
        } else if (!this.testLO1LowerConstraints(receiverBand, false)) {
            this.clipLO1LowerConstraints(receiverBand);
        }
        if (this.isDeployable(false)) {
            return;
        }
        throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
    }

    private void clipRange(ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() - receiverBand.getIFMin());
        this.clipRange(receiverBand, this.basebands, frequency);
    }

    private void clipRange(ReceiverBand receiverBand, BaseBandList baseBandList, Frequency frequency) throws BaseBandNotDeployableException {
        Object object;
        Object object22;
        Object object32;
        Object object42;
        FrequencyRange frequencyRange = baseBandList.getWholeRange(true);
        Frequency frequency2 = (Frequency)((Object)frequencyRange.range());
        if (frequency2.isGreaterThan((AbstractDoubleWithUnit)frequency)) {
            throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
        }
        boolean bl = true;
        boolean bl2 = true;
        BaseBandList baseBandList2 = new BaseBandList(baseBandList.v);
        BaseBandList baseBandList3 = new BaseBandList(baseBandList.v);
        BaseBandList baseBandList4 = new BaseBandList(baseBandList.v);
        for (Object object42 : baseBandList) {
            if (((Frequency)((Object)((BaseBand)object42).getRange(true).min())).isEqual((AbstractDoubleWithUnit)frequencyRange.min())) {
                baseBandList2.add(object42);
                continue;
            }
            if (((Frequency)((Object)((BaseBand)object42).getRange(true).max())).isEqual((AbstractDoubleWithUnit)frequencyRange.max())) {
                baseBandList3.add(object42);
                continue;
            }
            baseBandList4.add(object42);
        }
        Object object5 = (Frequency)((Object)baseBandList3.getWholeRange(false).max());
        object42 = (Frequency)((Object)baseBandList2.getWholeRange(false).min());
        FrequencyRange frequencyRange2 = new FrequencyRange((Frequency)((Object)object42), (Frequency)((Object)object5));
        Frequency frequency3 = (Frequency)((Frequency)((Object)frequencyRange2.range())).minus((AbstractDoubleWithUnit)frequency, true);
        Frequency frequency4 = BASEBANDWIDTH;
        Frequency frequency5 = BASEBANDWIDTH;
        for (Object object32 : baseBandList2) {
            object22 = (Frequency)((Object)((BaseBand)object32).getLeftMargin().range());
            if (!object22.isLessThan(frequency3.half(true))) continue;
            bl = false;
            if (!object22.isLessThan((AbstractDoubleWithUnit)frequency4)) continue;
            frequency4 = object22;
        }
        for (Object object32 : baseBandList3) {
            object22 = (Frequency)((Object)((BaseBand)object32).getRightMargin().range());
            if (!object22.isLessThan(frequency3.half(true))) continue;
            bl2 = false;
            if (!object22.isLessThan((AbstractDoubleWithUnit)frequency5)) continue;
            frequency5 = object22;
        }
        if (bl && bl2) {
            if (frequency3.isZero()) {
                frequency3 = FREQ_OFFSET;
            }
            for (Object object32 : baseBandList2) {
                ((BaseBand)object32).shift((Frequency)frequency3.half(true));
            }
            for (Object object32 : baseBandList3) {
                ((BaseBand)object32).shift((Frequency)((Frequency)frequency3.half(true)).multiply(-1.0, true));
            }
        } else if (bl) {
            object = (Frequency)frequency3.minus((AbstractDoubleWithUnit)frequency5, true);
            for (Object object22 : baseBandList2) {
                ((BaseBand)object22).shift((Frequency)((Object)object));
            }
            for (Object object22 : baseBandList3) {
                ((BaseBand)object22).shift((Frequency)frequency5.multiply(-1.0));
            }
        } else {
            object = (Frequency)frequency3.minus((AbstractDoubleWithUnit)frequency4, true);
            for (Object object22 : baseBandList3) {
                ((BaseBand)object22).shift((Frequency)object.multiply(-1.0));
            }
            for (Object object22 : baseBandList2) {
                ((BaseBand)object22).shift(frequency4);
            }
        }
        object = (Frequency)((Object)baseBandList2.getWholeRange(false).min());
        object32 = (Frequency)((Object)baseBandList3.getWholeRange(false).max());
        for (BaseBand baseBand : baseBandList4) {
            if (((Frequency)((Object)baseBand.min())).isLessThan((AbstractDoubleWithUnit)object)) {
                baseBand.shift((Frequency)object.minus((AbstractDoubleWithUnit)baseBand.min(), true));
            }
            if (!((Frequency)((Object)baseBand.max())).isGreaterThan((AbstractDoubleWithUnit)object32)) continue;
            baseBand.shift((Frequency)object32.minus((AbstractDoubleWithUnit)baseBand.max(), true));
        }
    }

    private void clipOutside(ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMax() * 2.0);
        this.clipRange(receiverBand, this.basebands, frequency);
    }

    private void clipInside(ReceiverBand receiverBand) throws BaseBandNotDeployableException {
        Object object;
        Object object2;
        Object object32;
        Object object42;
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin() * 2.0);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(true);
        Frequency frequency2 = (Frequency)((Object)frequencyRange.range());
        if (frequency2.isLessThan((AbstractDoubleWithUnit)frequency)) {
            throw new BaseBandNotDeployableException(DEFAULTERRORMESSAGE);
        }
        boolean bl = true;
        boolean bl2 = true;
        BaseBandList baseBandList = new BaseBandList(this.basebands.v);
        BaseBandList baseBandList2 = new BaseBandList(this.basebands.v);
        BaseBandList baseBandList3 = new BaseBandList(this.basebands.v);
        for (Object object42 : this.basebands) {
            if (((Frequency)((Object)((BaseBand)object42).getRange(true).min())).isEqual((AbstractDoubleWithUnit)frequencyRange.max())) {
                baseBandList.add(object42);
                continue;
            }
            if (((Frequency)((Object)((BaseBand)object42).getRange(true).max())).isEqual((AbstractDoubleWithUnit)frequencyRange.min())) {
                baseBandList2.add(object42);
                continue;
            }
            baseBandList3.add(object42);
        }
        Object object5 = (Frequency)((Object)baseBandList.getWholeRange(false).min());
        object42 = (Frequency)((Object)baseBandList2.getWholeRange(false).max());
        FrequencyRange frequencyRange2 = new FrequencyRange((Frequency)((Object)object42), (Frequency)((Object)object5));
        Frequency frequency3 = (Frequency)frequency.minus((AbstractDoubleWithUnit)frequencyRange2.range(), true);
        Frequency frequency4 = BASEBANDWIDTH;
        Frequency frequency5 = BASEBANDWIDTH;
        for (Object object32 : baseBandList) {
            object2 = (Frequency)((Object)object32.getLeftMargin().range());
            if (!object2.isLessThan((AbstractDoubleWithUnit)frequency3)) continue;
            bl = false;
            if (!object2.isLessThan((AbstractDoubleWithUnit)frequency4)) continue;
            frequency4 = object2;
        }
        for (Object object32 : baseBandList2) {
            object2 = (Frequency)((Object)object32.getRightMargin().range());
            if (!object2.isLessThan((AbstractDoubleWithUnit)frequency3)) continue;
            bl2 = false;
            if (!object2.isLessThan((AbstractDoubleWithUnit)frequency5)) continue;
            frequency5 = object2;
        }
        if (bl && bl2) {
            for (Object object32 : baseBandList) {
                ((BaseBand)object32).shift((Frequency)frequency3.half(true));
            }
            for (Object object32 : baseBandList2) {
                ((BaseBand)object32).shift((Frequency)((Frequency)frequency3.half(true)).multiply(-1.0));
            }
        } else {
            object = (Frequency)((Frequency)((Frequency)frequency4.plus((AbstractDoubleWithUnit)frequency5, true)).minus((AbstractDoubleWithUnit)frequency3, true)).half();
            if (frequency4.isLessThan((AbstractDoubleWithUnit)frequency5)) {
                object32 = (Frequency)frequency4.minus((AbstractDoubleWithUnit)object, true);
                if (object32.getContent() <= 0.0) {
                    object32 = Frequency.createFrequencyGHZ(0.0);
                }
                object2 = (Frequency)((Frequency)frequency3.minus((AbstractDoubleWithUnit)object32)).plus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
            } else {
                object2 = (Frequency)frequency5.minus((AbstractDoubleWithUnit)object, true);
                if (object2.getContent() <= 0.0) {
                    object2 = Frequency.createFrequencyGHZ(0.0);
                }
                object32 = (Frequency)((Frequency)frequency3.minus((AbstractDoubleWithUnit)object2)).plus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
            }
            for (BaseBand baseBand : baseBandList) {
                baseBand.shift((Frequency)((Object)object32));
            }
            for (BaseBand baseBand : baseBandList2) {
                baseBand.shift((Frequency)object2.multiply(-1.0, true));
            }
        }
        object = (Frequency)((Object)baseBandList2.getWholeRange(false).max());
        object32 = (Frequency)((Object)baseBandList.getWholeRange(false).min());
        for (Object object6 : baseBandList3) {
            if (((Frequency)((Object)((VupRange)object6).min())).isGreaterThan((AbstractDoubleWithUnit)object) && ((Frequency)((Object)((VupRange)object6).min())).isLessThan((AbstractDoubleWithUnit)object32)) {
                ((BaseBand)object6).shift((Frequency)object32.minus((AbstractDoubleWithUnit)((VupRange)object6).min(), true));
            }
            if (!((Frequency)((Object)((VupRange)object6).max())).isLessThan((AbstractDoubleWithUnit)object32) || !((Frequency)((Object)((VupRange)object6).max())).isGreaterThan((AbstractDoubleWithUnit)object)) continue;
            ((BaseBand)object6).shift((Frequency)object.minus((AbstractDoubleWithUnit)((VupRange)object6).max(), true));
        }
    }

    private void clipLO1UpperConstraints(ReceiverBand receiverBand) {
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax());
        Frequency frequency3 = (Frequency)((Frequency)((Frequency)((Object)receiverBand.getRFRange().max())).minus((AbstractDoubleWithUnit)frequency2, true)).minus((AbstractDoubleWithUnit)frequency, true);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(false);
        Frequency frequency4 = (Frequency)frequency3.minus((AbstractDoubleWithUnit)frequencyRange.min(), true);
        for (BaseBand baseBand : this.basebands) {
            if (!((Frequency)((Object)baseBand.max())).isEqual((AbstractDoubleWithUnit)frequencyRange.min())) continue;
            baseBand.shift(frequency4);
        }
    }

    private void clipLO1LowerConstraints(ReceiverBand receiverBand) {
        Frequency frequency = Frequency.createFrequencyGHZ(receiverBand.getIFMin());
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getIFMax());
        Frequency frequency3 = (Frequency)((Frequency)((Frequency)((Object)receiverBand.getRFRange().min())).plus((AbstractDoubleWithUnit)frequency2, true)).plus((AbstractDoubleWithUnit)frequency, true);
        FrequencyRange frequencyRange = this.basebands.basebandWidestFrequencyGap(false);
        Frequency frequency4 = (Frequency)frequency3.minus((AbstractDoubleWithUnit)frequencyRange.max(), true);
        for (BaseBand baseBand : this.basebands) {
            if (!((Frequency)((Object)baseBand.min())).isEqual((AbstractDoubleWithUnit)frequencyRange.max())) continue;
            baseBand.shift(frequency4);
        }
    }

    private FrequencyRange[] getBaseBandRanges(Frequency[] frequencyArray) {
        int n = frequencyArray.length;
        FrequencyRange[] frequencyRangeArray = new FrequencyRange[n];
        Frequency frequency = Frequency.createFrequencyGHZ(1.0);
        for (int i = 0; i < n; ++i) {
            Frequency frequency2 = frequencyArray[i];
            frequencyRangeArray[i] = new FrequencyRange((Frequency)frequency2.minus((AbstractDoubleWithUnit)frequency, true), (Frequency)frequency2.plus((AbstractDoubleWithUnit)frequency, true));
        }
        return frequencyRangeArray;
    }

    public Collection<BaseBand> getBasebands() {
        ArrayList<BaseBand> arrayList = new ArrayList<BaseBand>();
        arrayList.addAll(this.basebands);
        return Collections.unmodifiableCollection(arrayList);
    }

    public BaseBandList getBaseBandList() {
        return this.basebands;
    }

    public class BaseBandList
    extends ArrayList<BaseBand> {
        private Velocity v;

        public BaseBandList(Velocity velocity) {
            this.v = velocity == null ? Velocity.createVelocity() : velocity;
        }

        public Frequency[] getCenterFrequenciesSky() {
            ArrayList<Frequency> arrayList = new ArrayList<Frequency>();
            for (BaseBand baseBand : this) {
                arrayList.add(baseBand.centerSky);
            }
            return arrayList.toArray(new Frequency[arrayList.size()]);
        }

        public Frequency[] getCenterFrequenciesRest() {
            ArrayList<Frequency> arrayList = new ArrayList<Frequency>();
            for (BaseBand baseBand : this) {
                arrayList.add(this.v.reverseShift(baseBand.centerSky));
            }
            return arrayList.toArray(new Frequency[arrayList.size()]);
        }

        public FrequencyRange getWholeRange(boolean bl) {
            Range[] rangeArray = new FrequencyRange[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                rangeArray[i] = ((BaseBand)this.get(i)).getRange(bl);
            }
            return FrequencyRange.wholeRange(rangeArray);
        }

        public BaseBand addNewBaseBand(Frequency frequency) {
            BaseBand baseBand = new BaseBand(frequency, this.v);
            this.add(baseBand);
            return baseBand;
        }

        public FrequencyRange basebandWidestFrequencyGap(boolean bl) {
            List<FrequencyRange> list = this.getBasebandFrequencyGaps(bl);
            if (list.size() == 0) {
                return null;
            }
            FrequencyRange frequencyRange = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                FrequencyRange frequencyRange2 = list.get(i);
                if (!((Frequency)((Object)frequencyRange2.range())).isGreaterThan((AbstractDoubleWithUnit)frequencyRange.range())) continue;
                frequencyRange = frequencyRange2;
            }
            return frequencyRange;
        }

        public BaseBandList getLsbBBs() {
            FrequencyRange frequencyRange = this.basebandWidestFrequencyGap(false);
            if (frequencyRange == null) {
                return this;
            }
            Frequency frequency = (Frequency)((Object)frequencyRange.mid());
            BaseBandList baseBandList = new BaseBandList(this.v);
            for (BaseBand baseBand : this) {
                if (!((Frequency)((Object)baseBand.mid())).isLessThan((AbstractDoubleWithUnit)frequency)) continue;
                baseBandList.add(baseBand);
            }
            return baseBandList;
        }

        public BaseBandList getUsbBBs() {
            FrequencyRange frequencyRange = this.basebandWidestFrequencyGap(false);
            if (frequencyRange == null) {
                return this;
            }
            Frequency frequency = (Frequency)((Object)frequencyRange.mid());
            BaseBandList baseBandList = new BaseBandList(this.v);
            for (BaseBand baseBand : this) {
                if (!((Frequency)((Object)baseBand.mid())).isGreaterThan((AbstractDoubleWithUnit)frequency)) continue;
                baseBandList.add(baseBand);
            }
            return baseBandList;
        }

        protected List<FrequencyRange> getBasebandFrequencyGaps(boolean bl) {
            ArrayList<FrequencyRange> arrayList = new ArrayList<FrequencyRange>();
            Comparator<FrequencyRange> comparator = new Comparator<FrequencyRange>(){

                @Override
                public int compare(FrequencyRange frequencyRange, FrequencyRange frequencyRange2) {
                    if (!((Frequency)((Object)frequencyRange.min())).equals(frequencyRange2.min())) {
                        return ((Frequency)((Object)frequencyRange.min())).compareTo((AbstractDoubleWithUnit)frequencyRange2.min());
                    }
                    return ((Frequency)((Object)frequencyRange.max())).compareTo((AbstractDoubleWithUnit)frequencyRange2.max());
                }
            };
            List list = this.stream().map(baseBand -> ((BaseBand)baseBand).getRange(bl)).collect(Collectors.toList());
            list.sort(comparator);
            FrequencyRange frequencyRange = (FrequencyRange)list.get(0);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FrequencyRange frequencyRange2;
                FrequencyRange frequencyRange3 = frequencyRange2 = (FrequencyRange)iterator.next();
                if (((Frequency)((Object)frequencyRange.max())).isLessThan((AbstractDoubleWithUnit)frequencyRange3.min())) {
                    arrayList.add(new FrequencyRange((Frequency)((Object)frequencyRange.max()), (Frequency)((Object)frequencyRange3.min())));
                    frequencyRange = frequencyRange3;
                    continue;
                }
                if (!((Frequency)((Object)frequencyRange3.max())).isGreaterThan((AbstractDoubleWithUnit)frequencyRange.max())) continue;
                frequencyRange = frequencyRange3;
            }
            return arrayList;
        }
    }

    public class BaseBand
    extends FrequencyRange {
        Frequency centerSky;
        Velocity v;
        List<SpectralWindow> windowList;
        private Frequency freqTolerance;

        public Frequency getCenterSky() {
            return this.centerSky;
        }

        public BaseBand() {
            super(null, null);
            this.windowList = new ArrayList<SpectralWindow>();
            this.freqTolerance = Frequency.createFrequencyGHZ(1.0E-9);
            this.v = Velocity.createVelocity();
        }

        public BaseBand(Frequency frequency, Velocity velocity) {
            super(null, null);
            this.windowList = new ArrayList<SpectralWindow>();
            this.freqTolerance = Frequency.createFrequencyGHZ(1.0E-9);
            this.v = velocity == null ? Velocity.createVelocity() : velocity;
            this.setCenterRest(frequency);
        }

        private void setCenterRest(Frequency frequency) {
            this.centerSky = frequency.dopplerShifted(this.v);
            this.setRange();
        }

        private void setCenterSky(Frequency frequency) {
            this.centerSky = frequency;
            this.setRange();
        }

        private void setRange() {
            double d = this.centerSky.getContentInGHz();
            this.setMin(Frequency.createFrequencyGHZ(d - HALFBASEBANDWITHGHZ));
            this.setMax(Frequency.createFrequencyGHZ(d + HALFBASEBANDWITHGHZ));
        }

        private void setCenter() {
            this.setCenterSky((Frequency)((Object)this.getRange(true).mid()));
        }

        public SpectralWindow addNewSpectralWindow(Frequency frequency, Frequency frequency2) throws BaseBandNotDeployableException {
            SpectralWindow spectralWindow = new SpectralWindow(frequency, frequency2, this.v);
            this.addSpectralWindow(spectralWindow);
            return spectralWindow;
        }

        private void addSpectralWindow(SpectralWindow spectralWindow) {
            this.windowList.add(spectralWindow);
        }

        public SpectralWindow[] getSpectralWindowArray() {
            SpectralWindow[] spectralWindowArray = new SpectralWindow[this.windowList.size()];
            return this.windowList.toArray(spectralWindowArray);
        }

        private FrequencyRange getRange(boolean bl) {
            if (bl) {
                return FrequencyRange.wholeRange(this.getSpectralWindowArray());
            }
            return new FrequencyRange((Frequency)((Object)this.min()), (Frequency)((Object)this.max()));
        }

        FrequencyRange getLeftMargin() {
            FrequencyRange frequencyRange = this.getRange(true);
            return new FrequencyRange((Frequency)((Object)this.min()), (Frequency)((Object)frequencyRange.min()));
        }

        FrequencyRange getRightMargin() {
            FrequencyRange frequencyRange = this.getRange(true);
            return new FrequencyRange((Frequency)((Object)frequencyRange.max()), (Frequency)((Object)this.max()));
        }

        private boolean canShift(Frequency frequency) {
            double d;
            if (frequency.getContent() >= 0.0) {
                double d2;
                Frequency frequency2 = (Frequency)((Frequency)((Object)this.getRightMargin().range())).minus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
                if (frequency.isLessThan((AbstractDoubleWithUnit)frequency2)) {
                    return true;
                }
                double d3 = frequency.getContentInGHz();
                return Math.abs(d3 - (d2 = frequency2.getContent())) < this.freqTolerance.getContentInGHz();
            }
            Frequency frequency3 = (Frequency)((Frequency)((Object)this.getLeftMargin().range())).plus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
            if (((Frequency)frequency.multiply(-1.0)).isLessThan((AbstractDoubleWithUnit)frequency3)) {
                return true;
            }
            double d4 = frequency.getContentInGHz() * -1.0;
            return Math.abs(d4 - (d = frequency3.getContent())) < this.freqTolerance.getContentInGHz();
        }

        private boolean shift(Frequency frequency) {
            boolean bl = this.canShift(frequency);
            if (bl) {
                Frequency frequency2 = frequency.getContent() >= 0.0 ? (Frequency)frequency.plus((AbstractDoubleWithUnit)FREQ_OFFSET, true) : (Frequency)frequency.minus((AbstractDoubleWithUnit)FREQ_OFFSET, true);
                this.centerSky = (Frequency)this.centerSky.plus((AbstractDoubleWithUnit)frequency2, true);
                this.setRange();
            }
            return bl;
        }
    }

    public class SpectralWindow
    extends FrequencyRange {
        public SpectralWindow(Frequency frequency, Frequency frequency2, Velocity velocity) throws BaseBandNotDeployableException {
            super(null, null);
            try {
                this.setRange(frequency.dopplerShifted(velocity), frequency2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BaseBandNotDeployableException(numberFormatException);
            }
        }

        public SpectralWindow(ScienceSpectralWindow scienceSpectralWindow, Velocity velocity) throws BaseBandNotDeployableException {
            super(null, null);
            try {
                if (scienceSpectralWindow.getIsSkyFrequency()) {
                    this.setRange(scienceSpectralWindow.getCenterFrequency(), (Frequency)((Object)scienceSpectralWindow.getBandwidth()));
                } else {
                    this.setRange(scienceSpectralWindow.getCenterFrequency().dopplerShifted(velocity), (Frequency)((Object)scienceSpectralWindow.getBandwidth()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new BaseBandNotDeployableException(numberFormatException);
            }
        }

        private void setRange(Frequency frequency, Frequency frequency2) {
            MathContext mathContext = new MathContext(13);
            BigDecimal bigDecimal = new BigDecimal(((Frequency)frequency2.half(true)).getContentInGHz(), mathContext);
            BigDecimal bigDecimal2 = new BigDecimal(frequency.getContentInGHz(), mathContext);
            this.setMin(Frequency.createFrequencyGHZ(bigDecimal2.subtract(bigDecimal).doubleValue()));
            this.setMax(Frequency.createFrequencyGHZ(bigDecimal2.add(bigDecimal).doubleValue()));
        }
    }
}

