/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.ReceiverExpert;
import alma.obsprep.util.Range;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FrequencyRangeInspector {
    protected List<Range<Frequency>> windowList;
    private StringBuffer warningMessage = new StringBuffer();
    private Velocity sourceVelocity = null;

    public FrequencyRangeInspector(Range<Frequency>[] rangeArray) {
        this.setWindowList(rangeArray);
    }

    public FrequencyRangeInspector(List<Range<Frequency>> list) {
        this.setWindowList(list);
    }

    public void setWindowList(Range<Frequency>[] rangeArray) {
        this.setWindowList(Arrays.asList(rangeArray));
    }

    public void setWindowList(List<Range<Frequency>> list) {
        this.windowList = list;
    }

    public Velocity getSourceVelocity() {
        if (this.sourceVelocity == null) {
            this.sourceVelocity = Velocity.createVelocity();
        }
        return this.sourceVelocity;
    }

    public void setSourceVelocity(Velocity velocity) {
        this.sourceVelocity = velocity;
    }

    public String getWarningMessage() {
        return this.warningMessage.toString();
    }

    public void addWarningMessage(String string) {
        this.warningMessage.append(string + "\n");
    }

    public Set<ReceiverBand> getSuitableReceiverSet(Velocity velocity) {
        if (this.windowList.size() == 0) {
            this.addWarningMessage("No spectral window in the list.");
            return new HashSet<ReceiverBand>();
        }
        Range range = this.getWholeFrequencyRangeRest();
        Range range2 = this.toSkyRange(range, velocity);
        return ReceiverExpert.getInstance().getSuitableReceiverSet(range2);
    }

    public boolean inOneReceiverBand(Velocity velocity) {
        boolean bl;
        boolean bl2 = bl = this.getSuitableReceiverSet(velocity).size() > 0;
        if (!bl) {
            this.addWarningMessage("No suitable receiver band for the range :" + this.toSkyRange(this.getWholeFrequencyRangeRest(), velocity));
        }
        return bl;
    }

    public boolean inOneBaseBand(Velocity velocity) {
        boolean bl;
        boolean bl2 = this.windowList.size() == 0;
        boolean bl3 = bl = this.windowList.size() == 1;
        if (bl2 || bl) {
            return true;
        }
        Range range = this.getWholeFrequencyRangeRest();
        Range range2 = this.toSkyRange(range, velocity);
        boolean bl4 = ((Frequency)((Object)range2.range())).getContentInGHz() < 2.0;
        this.addWarningMessage("The desired frequency range " + range + " is too wide for a BaseBand.");
        return bl4;
    }

    public Range getWholeFrequencyRangeRest() {
        if (this.windowList.size() == 0) {
            return new VupRange<Frequency>(Frequency.createFrequency(), Frequency.createFrequency());
        }
        VupRange vupRange = new VupRange(this.windowList.get(0));
        for (Range<Frequency> range : this.windowList) {
            vupRange = vupRange.expand(range);
        }
        return vupRange;
    }

    public Range toSkyRange(Range<Frequency> range, Velocity velocity) {
        return new VupRange<Frequency>(velocity.dopplerShift(range.min()), velocity.dopplerShift(range.max()));
    }

    public Range toRestRange(Range<Frequency> range, Velocity velocity) {
        return new VupRange<Frequency>(velocity.reverseShift(range.min()), velocity.reverseShift(range.max()));
    }

    public Range getRangeCenterRange() {
        if (this.windowList.size() == 0) {
            return new VupRange<Frequency>(Frequency.createFrequency(), Frequency.createFrequency());
        }
        Frequency frequency = this.windowList.get(0).mid();
        VupRange vupRange = new VupRange(frequency, frequency);
        for (Range<Frequency> range : this.windowList) {
            vupRange = vupRange.expand((Frequency)((ValueUnitPair)range.mid()));
        }
        return vupRange;
    }
}

