/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.CalibrationRequirements;
import alma.obsprep.bo.obsproject.ControlBlock;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnitDependencies;
import alma.obsprep.bo.obsproject.WeatherConstraints;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObsProcedure;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.RadiometricPointingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.TemporalConstraints;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.generator.BaselineCalibrationCalibratorParametersFactory;
import alma.obsprep.services.generator.CalibratorSurveyCalibratorParametersFactory;
import alma.obsprep.services.generator.ObservatoryGoalFieldSourceWorker;
import alma.obsprep.services.generator.ObservatoryGoalSpectralSpecWorker;
import alma.obsprep.services.generator.RadiometricPointingCalibratorParametersFactory;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Length;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Speed;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;

public class ObservatoryGoalSchedBlockWorker {
    private final String mode;
    private final ObservatoryGoal goal;
    private final ObservatoryGoalFieldSourceWorker fsWorker;
    private final ObservatoryGoalSpectralSpecWorker ssWorker;
    private final ObservingModeExpert ome = ObservingModeExpert.getInstance();
    private final CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(CorrelatorType.BL);

    public ObservatoryGoalSchedBlockWorker(ObservatoryGoal observatoryGoal) {
        this.goal = observatoryGoal;
        this.mode = "Calibration Target Survey";
        this.fsWorker = new ObservatoryGoalFieldSourceWorker(observatoryGoal);
        this.ssWorker = new ObservatoryGoalSpectralSpecWorker(observatoryGoal.getSpectralSetupParameters(), observatoryGoal.getIntegrationTime());
    }

    public List<SchedBlock> getSchedBlocks() throws WizardSBGenerationException {
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        SBGenerationContext sBGenerationContext = new SBGenerationContext();
        sBGenerationContext.setArray(RequestedArray.TWELVE_M).setSBGenerationSchema(EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.STANDARD_CYCLE1)).setSBType(SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION);
        schedBlock.setSbGenerationContext(sBGenerationContext);
        schedBlock.setName(this.determineSBName(this.goal));
        this.configure(schedBlock);
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        arrayList.add(schedBlock);
        return arrayList;
    }

    private String determineSBName(ObservatoryGoal observatoryGoal) {
        if (observatoryGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: observatoryGoal");
        }
        String string = null;
        if (observatoryGoal.getUseQuery()) {
            string = "query";
        } else {
            if (observatoryGoal.getObservatoryGoalTargetParameters().length == 0) {
                throw new WizardSBGenerationException("No sources have been defined");
            }
            string = observatoryGoal.getObservatoryGoalTargetParameters()[0].getSourceName();
        }
        assert (string != null);
        return string;
    }

    private void configure(SchedBlock schedBlock) {
        Object object;
        schedBlock.setModeName(this.mode);
        this.ome.updateSchedBlock(schedBlock, this.mode);
        this.configure(schedBlock.getObsProcedure());
        this.configure(schedBlock.getUnitDependencies());
        ObservatoryGoalSchedBlockWorker.configure(schedBlock.getObsUnitControl());
        ObservatoryGoalSchedBlockWorker.configure(schedBlock.getPreconditions());
        ObservatoryGoalSchedBlockWorker.configure(schedBlock.getSchedBlockControl());
        ObservatoryGoalSchedBlockWorker.configure(schedBlock.getSchedulingConstraints());
        SpectralSpec spectralSpec = this.ssWorker.getSpectralSpec();
        schedBlock.addSpectralSpec(spectralSpec);
        Frequency frequency = this.goal.getRepresentativeFrequency();
        schedBlock.getSchedulingConstraints().setRepresentativeFrequency(frequency);
        schedBlock.getSchedulingConstraints().setRepresentativeReceiverBand(spectralSpec.getReceiverBandName());
        ArrayList<FieldSource> arrayList = new ArrayList<FieldSource>(this.fsWorker.getTargetFieldSources());
        String string = this.goal.getPurpose();
        HashSet<String> hashSet = new HashSet<String>(ObservingModeExpert.getCalibratorIntents(this.goal));
        for (String object22 : hashSet) {
            arrayList.addAll(this.fsWorker.getCalibratorFieldSources(object22));
        }
        schedBlock.setFieldSource(arrayList.toArray(new FieldSource[arrayList.size()]));
        if ("Calibrator Survey".equals(string)) {
            object = new CalibratorSurveyCalibratorParametersFactory(spectralSpec, this.goal.getIntegrationTime());
        } else if ("Baseline Calibration".equals(string)) {
            object = new BaselineCalibrationCalibratorParametersFactory(spectralSpec, this.goal.getIntegrationTime());
        } else if ("Radiometric Pointing".equals(string)) {
            object = new RadiometricPointingCalibratorParametersFactory(spectralSpec, this.goal.getIntegrationTime());
        } else {
            throw new AssertionError((Object)"Cannot generate SBs for unhandled Observatory Goal");
        }
        for (String string2 : hashSet) {
            for (Target target : this.fsWorker.getCalibratorTargets(string2)) {
                ObservingGroup[] observingGroupArray = object.getCalibratorParameters(string2, 0);
                schedBlock.addObservingParameters((ObservingParameters)observingGroupArray);
                ObservatoryGoalSchedBlockWorker.linkTargetStructure(target, schedBlock.getSpectralSpec(0), (ObservingParameters)observingGroupArray);
                schedBlock.addTarget(target);
            }
        }
        for (Target target : this.fsWorker.getTargets()) {
            schedBlock.addTarget(target);
        }
        if (string.equals("Calibrator Survey")) {
            AmplitudeCalParameters amplitudeCalParameters = object.getAmplitudeCalParameters(2);
            schedBlock.addObservingParameters((ObservingParameters)((Object)amplitudeCalParameters));
            for (Target target : this.fsWorker.getTargets()) {
                ObservatoryGoalSchedBlockWorker.linkTargetStructure(target, schedBlock.getSpectralSpec(0), (ObservingParameters)((Object)amplitudeCalParameters));
            }
        } else if (string.equals("Radiometric Pointing")) {
            PointingCalParameters pointingCalParameters = object.getPointingCalParameters(2);
            schedBlock.addObservingParameters((ObservingParameters)((Object)pointingCalParameters));
            for (Target target : this.fsWorker.getTargets()) {
                ObservatoryGoalSchedBlockWorker.linkTargetStructure(target, schedBlock.getSpectralSpec(0), (ObservingParameters)((Object)pointingCalParameters));
            }
        } else if (string.equals("Baseline Calibration")) {
            DelayCalParameters delayCalParameters = object.getDelayCalParameters(2);
            schedBlock.addObservingParameters((ObservingParameters)((Object)delayCalParameters));
            for (Target target : this.fsWorker.getTargets()) {
                ObservatoryGoalSchedBlockWorker.linkTargetStructure(target, schedBlock.getSpectralSpec(0), (ObservingParameters)((Object)delayCalParameters));
            }
        } else {
            throw new AssertionError((Object)("Unhandled ObservatoryGoal purpose: " + string));
        }
        RadiometricPointingParameters radiometricPointingParameters = this.getRadiometricPointingParameters();
        schedBlock.addObservingParameters((ObservingParameters)((Object)radiometricPointingParameters));
        ObservingGroup[] observingGroupArray = new ObservingGroup[]{this.fsWorker.getInitialCalibrationObservingGroup(), this.fsWorker.getTargetsObservingGroup()};
        String[] stringArray = new String[]{"Calibrators", "Science"};
        schedBlock.setObservingGroup(observingGroupArray);
        int n = 1;
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            observingGroup.setName(stringArray[n - 1]);
            observingGroup.setIndex(n++);
        }
        double d = this.goal.getIntegrationTime().getContentInUnits(Time.UNIT_S);
        double d2 = spectralSpec.getCorrelatorConfiguration().getIntegrationDuration().getContentInUnits(Time.UNIT_S);
        double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, null);
        for (ObservingParameters observingParameters : schedBlock.getObservingParameters()) {
            if (!(observingParameters instanceof ScienceParameters)) continue;
            ScienceParameters scienceParameters = (ScienceParameters)((Object)observingParameters);
            scienceParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
        }
    }

    private static void linkTargetStructure(Target target, SpectralSpec spectralSpec, ObservingParameters observingParameters) {
        target.addObservingParameters(observingParameters);
        target.setSpectralSpec(spectralSpec);
    }

    private RadiometricPointingParameters getRadiometricPointingParameters() {
        RadiometricPointingParameters radiometricPointingParameters = RadiometricPointingParameters.createRadiometricPointingParameters();
        return radiometricPointingParameters;
    }

    private ScienceParameters getScienceParameters(ObservatoryGoal observatoryGoal) {
        ScienceParameters scienceParameters = ScienceParameters.createScienceParameters();
        scienceParameters.setName("Cal Survey Params");
        SpectralSetupParameters spectralSetupParameters = observatoryGoal.getSpectralSetupParameters();
        ScienceSpectralWindow scienceSpectralWindow = spectralSetupParameters.getRepresentativeSpectralWindow();
        Frequency frequency = scienceSpectralWindow.getCenterFrequency();
        scienceParameters.setRepresentativeFrequency(frequency.deepCopy());
        scienceParameters.setRepresentativeBandwidth(spectralSetupParameters.getRepresentativeBandwidth());
        scienceParameters.setSensitivityGoal(Sensitivity.createSensitivity((double)10.0, (String)Sensitivity.UNIT_JY));
        double d = observatoryGoal.getIntegrationTime().getContentInUnits(Time.UNIT_S);
        scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)d, (String)IntTimeSource.UNIT_S));
        return scienceParameters;
    }

    private void configure(UnitDependencies unitDependencies) {
        unitDependencies.setExecutionCount(1);
        unitDependencies.setExpression("");
        unitDependencies.setDelay(Time.createTime((double)0.0, (String)Time.UNIT_S));
    }

    private void configure(ObsProcedure obsProcedure) {
        obsProcedure.setObsProcScript(this.ome.getControlScriptForMode(this.mode));
    }

    private static void configure(Preconditions preconditions) {
        preconditions.setBaselineCalValid(false);
        preconditions.setPolarizationCalValid(false);
        preconditions.setMinAllowedHA(UserAngle.createUserAngle(0.0, UserAngle.USERUNIT_DEG));
        preconditions.setMaxAllowedHA(UserAngle.createUserAngle(359.999999, UserAngle.USERUNIT_DEG));
        WeatherConstraints weatherConstraints = preconditions.getWeatherConstraints();
        weatherConstraints.setMaxPWVC(Length.createLength((double)10.0, (String)Length.UNIT_MM));
        weatherConstraints.setSeeing(Angle.createAngle((double)3.0, (String)Angle.UNIT_ARCSEC));
        weatherConstraints.setPhaseStability(Angle.createAngle((double)40.0, (String)Angle.UNIT_DEG));
        weatherConstraints.setMaxWindVelocity(Speed.createSpeed((double)60.0, (String)Speed.UNIT_KM_S));
        preconditions.setWeatherConstraints(weatherConstraints);
    }

    private static void configure(SchedBlockControl schedBlockControl) {
        schedBlockControl.setSBMaximumTime(Time.createTime((double)6.0, (String)Time.UNIT_H));
        schedBlockControl.setIndefiniteRepeat(true);
        schedBlockControl.setRunQuicklook(true);
    }

    private static void configure(ObsUnitControl obsUnitControl) {
        obsUnitControl.setArrayRequested(ControlBlock.ARRAYREQUESTED_TWELVE_M);
        obsUnitControl.setMaximumTime(Time.createTime((double)0.0, (String)Time.UNIT_H));
        obsUnitControl.setEstimatedExecutionTime(Time.createTime((double)0.0, (String)Time.UNIT_S));
        CalibrationRequirements calibrationRequirements = obsUnitControl.getCalibrationRequirements();
        calibrationRequirements.setPointingAccuracy(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
    }

    private static void configure(SchedulingConstraints schedulingConstraints) {
        schedulingConstraints.setMinAcceptableAngResolution(Angle.createAngle((double)0.1, (String)Angle.UNIT_ARCSEC));
        schedulingConstraints.setMaxAcceptableAngResolution(Angle.createAngle((double)10.0, (String)Angle.UNIT_ARCSEC));
        schedulingConstraints.setDynamicRange(1.0);
    }

    private static void configure(TemporalConstraints temporalConstraints) {
        temporalConstraints.setStartTime(null);
        temporalConstraints.setEndTime(null);
        temporalConstraints.setAllowedMargin(Time.createTime((double)0.0, (String)Time.UNIT_S));
    }
}

