/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.ACASpectralSpecWorker;
import alma.obsprep.services.generator.AbstractSBGenerator;
import alma.obsprep.services.generator.BLSpectralSpecWorker;
import alma.obsprep.services.generator.FieldSourceWorker;
import alma.obsprep.services.generator.ObservingParametersWorker;
import alma.obsprep.services.generator.SchedBlockWorker;
import alma.obsprep.services.generator.ScienceGoalCalibratorParametersFactory;
import alma.obsprep.services.generator.SpectralSpecWorker;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public abstract class ObservingSBGenerator
extends AbstractSBGenerator {
    protected SchedBlockWorker sbworker;
    protected SpectralSpecWorker blssworker;
    protected SpectralSpecWorker acassworker;
    protected ObservingParametersWorker obsprmworker;

    public ObservingSBGenerator(ScienceGoal scienceGoal, ObsUnitSet obsUnitSet) {
        super(scienceGoal, obsUnitSet);
        this.sbworker = new SchedBlockWorker(scienceGoal);
        this.obsprmworker = new ObservingParametersWorker(scienceGoal);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        Velocity velocity = scienceGoal.getSoleTargetParameters().getSourceVelocity();
        this.acassworker = System.getProperty("UseBLCorrForAca", "false").equalsIgnoreCase("false") ? new ACASpectralSpecWorker(spectralSetupParameters, velocity) : new BLSpectralSpecWorker(spectralSetupParameters, velocity);
        this.blssworker = new BLSpectralSpecWorker(spectralSetupParameters, velocity);
    }

    protected abstract void setupSBMode(SchedBlock var1);

    @Override
    public void generate() throws WizardSBGenerationException {
        if (!this.canGenerate()) {
            return;
        }
        this.setupOUS(this.obsUnitSet);
        for (SchedBlock schedBlock : this.sbworker.getSchedBlocks()) {
            schedBlock.setStatus(this.obsUnitSet.getStatus());
            this.setupTargetStructure(schedBlock);
            this.obsUnitSet.addSchedBlock(schedBlock);
            schedBlock.setObsUnitSet(this.obsUnitSet);
        }
        if (this.scienceGoal.getName() == null || this.scienceGoal.getName().length() == 0) {
            this.scienceGoal.setName(this.scienceGoal.getSoleTargetParameters().getSourceName());
        }
    }

    protected void setupOUS(ObsUnitSet obsUnitSet) {
        UserAngle userAngle = this.scienceGoal.getPerformanceParameters().getDesiredAngularResolution();
        obsUnitSet.getDataProcessingParameters().setAngularResolution(userAngle.deepCopy());
        obsUnitSet.setName(this.scienceGoal.getSoleTargetParameters().getSourceName() + "-SI");
    }

    /*
     * WARNING - void declaration
     */
    protected void setupTargetStructure(SchedBlock schedBlock) throws WizardSBGenerationException {
        Object object;
        Time time;
        Object object2;
        FieldSourceWorker fieldSourceWorker = new FieldSourceWorker(schedBlock.getObsUnitControl().getArrayRequested(), this.scienceGoal);
        this.setupSBMode(schedBlock);
        HashMap<String, SpectralSpec> hashMap = null;
        hashMap = schedBlock.isForBL() ? this.blssworker.getSpectralSpecHash() : this.acassworker.getSpectralSpecHash();
        SpectralSpec spectralSpec = hashMap.get("SCIENCE");
        SpectralSpec spectralSpec2 = hashMap.get("POINTING");
        SpectralSpec spectralSpec3 = hashMap.get("TDMAmpBP");
        SpectralSpec spectralSpec4 = hashMap.get("TDMPhase");
        SpectralSpec spectralSpec5 = hashMap.get("TDMATM");
        schedBlock.addSpectralSpec(spectralSpec);
        schedBlock.addSpectralSpec(spectralSpec2);
        if (spectralSpec3 != null) {
            schedBlock.addSpectralSpec(spectralSpec3);
        }
        if (spectralSpec4 != null) {
            schedBlock.addSpectralSpec(spectralSpec4);
        }
        if (spectralSpec5 != null) {
            schedBlock.addSpectralSpec(spectralSpec5);
        }
        if (spectralSpec5 != null) {
            this.calculateTimeAndDurations(spectralSpec, 1000.0, 1.0, 10.0);
        } else {
            this.calculateTimeAndDurations(spectralSpec, 1000.0, 1.0, 2.0);
        }
        this.calculateTimeAndDurations(spectralSpec2, 1000.0, 1.0, 2.0);
        if (spectralSpec3 != null) {
            this.calculateTimeAndDurations(spectralSpec3, 1000.0, 1.0, 2.0);
        }
        if (spectralSpec4 != null) {
            this.calculateTimeAndDurations(spectralSpec4, 1000.0, 1.0, 2.0);
        }
        if (spectralSpec5 != null) {
            this.calculateTimeAndDurations(spectralSpec5, 1000.0, 1.0, 2.0);
        }
        SchedBlockExpert schedBlockExpert = SchedBlockExpert.getInstance(this.scienceGoal);
        ArrayList<FieldSource> arrayList = new ArrayList<FieldSource>(fieldSourceWorker.getTargetFieldSources());
        HashSet<String> hashSet = new HashSet<String>(ObservingModeExpert.getCalibratorIntents(this.scienceGoal));
        for (String string : hashSet) {
            if (string.equals(QuerySource.INTENDEDUSE_ATMOSPHERIC)) continue;
            arrayList.addAll(fieldSourceWorker.getCalibratorFieldSource(string));
        }
        schedBlock.setFieldSource(arrayList.toArray(new FieldSource[arrayList.size()]));
        ScienceGoalCalibratorParametersFactory scienceGoalCalibratorParametersFactory = new ScienceGoalCalibratorParametersFactory(spectralSpec);
        int n = 0;
        int n2 = 0;
        block8: for (String object42 : hashSet) {
            for (Target target : fieldSourceWorker.getCalibratorTarget(object42)) {
                Time time2;
                object2 = null;
                if (schedBlock.getObservingParametersCount(this.getParametersTypeFromIntent(object42)) > 0) {
                    object2 = (CalibratorParameters)((Object)schedBlock.getObservingParameters(this.getParametersTypeFromIntent(object42))[0]);
                } else {
                    object2 = scienceGoalCalibratorParametersFactory.getCalibratorParameters(object42, 0);
                    schedBlock.addObservingParameters((ObservingParameters)object2);
                }
                if (object2 == null) continue block8;
                if (object42.equals(QuerySource.INTENDEDUSE_AMPLITUDE) || object42.equals(QuerySource.INTENDEDUSE_SIDEBANDRATIO)) {
                    if (spectralSpec3 != null) {
                        ObservingSBGenerator.linkTargetStructure(target, spectralSpec3, (ObservingParameters)object2);
                        time = spectralSpec3.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    } else {
                        ObservingSBGenerator.linkTargetStructure(target, spectralSpec, (ObservingParameters)object2);
                        time = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    }
                    object = object2.getSubScanDuration().adjustToIntegerMultipleOf(time);
                    object2.setSubScanDuration((Time)object);
                    time2 = target.getFieldSource().getReference(0).getSubScanDuration().adjustToIntegerMultipleOf(time);
                    target.getFieldSource().getReference(0).setSubScanDuration(time2);
                } else if (object42.equals(QuerySource.INTENDEDUSE_PHASE)) {
                    if (spectralSpec4 != null) {
                        ObservingSBGenerator.linkTargetStructure(target, spectralSpec4, (ObservingParameters)object2);
                        time = spectralSpec4.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    } else {
                        ObservingSBGenerator.linkTargetStructure(target, spectralSpec, (ObservingParameters)object2);
                        time = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    }
                    object = object2.getSubScanDuration().adjustToIntegerMultipleOf(time);
                    object2.setSubScanDuration((Time)object);
                    time2 = target.getFieldSource().getReference(0).getSubScanDuration().adjustToIntegerMultipleOf(time);
                    target.getFieldSource().getReference(0).setSubScanDuration(time2);
                } else if (object42.equals(QuerySource.INTENDEDUSE_ATMOSPHERIC)) {
                    time = Time.createTimeSec(0.0);
                    if (n2 < 2) {
                        if (spectralSpec3 != null) {
                            ObservingSBGenerator.linkTargetStructure(target, spectralSpec3, (ObservingParameters)object2);
                            time = spectralSpec3.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                        } else if (spectralSpec5 != null) {
                            ObservingSBGenerator.linkTargetStructure(target, spectralSpec5, (ObservingParameters)object2);
                            time = spectralSpec5.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                        } else {
                            ObservingSBGenerator.linkTargetStructure(target, spectralSpec, (ObservingParameters)object2);
                            time = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                        }
                    } else if (n2 == 2) {
                        if (spectralSpec5 != null) {
                            ObservingSBGenerator.linkTargetStructure(target, spectralSpec5, (ObservingParameters)object2);
                            time = spectralSpec5.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                        } else {
                            ObservingSBGenerator.linkTargetStructure(target, spectralSpec, (ObservingParameters)object2);
                            time = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                        }
                    } else if (spectralSpec4 != null) {
                        ObservingSBGenerator.linkTargetStructure(target, spectralSpec4, (ObservingParameters)object2);
                        time = spectralSpec4.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    } else if (spectralSpec5 != null) {
                        ObservingSBGenerator.linkTargetStructure(target, spectralSpec5, (ObservingParameters)object2);
                        time = spectralSpec5.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    } else {
                        ObservingSBGenerator.linkTargetStructure(target, spectralSpec, (ObservingParameters)object2);
                        time = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    }
                    object = object2.getSubScanDuration().adjustToIntegerMultipleOf(time);
                    object2.setSubScanDuration((Time)object);
                    ++n2;
                } else if (object42.equals(QuerySource.INTENDEDUSE_POINTING)) {
                    ObservingSBGenerator.linkTargetStructure(target, spectralSpec2, (ObservingParameters)object2);
                    time = spectralSpec2.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    object = object2.getSubScanDuration().adjustToIntegerMultipleOf(time);
                    object2.setSubScanDuration((Time)object);
                } else if (object42.equals(QuerySource.INTENDEDUSE_BANDPASS)) {
                    if (n == 0 && spectralSpec3 != null) {
                        ObservingSBGenerator.linkTargetStructure(target, spectralSpec3, (ObservingParameters)object2);
                        time = spectralSpec3.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                        object = object2.getSubScanDuration().adjustToIntegerMultipleOf(time);
                        object2.setSubScanDuration((Time)object);
                        time2 = target.getFieldSource().getReference(0).getSubScanDuration().adjustToIntegerMultipleOf(time);
                        target.getFieldSource().getReference(0).setSubScanDuration(time2);
                    } else {
                        ObservingSBGenerator.linkTargetStructure(target, spectralSpec, (ObservingParameters)object2);
                        time = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                        target.getFieldSource().setName("Bandpass (Science)");
                        object = object2.getSubScanDuration().adjustToIntegerMultipleOf(time);
                        object2.setSubScanDuration((Time)object);
                        time2 = target.getFieldSource().getReference(0).getSubScanDuration().adjustToIntegerMultipleOf(time);
                        target.getFieldSource().getReference(0).setSubScanDuration(time2);
                    }
                    ++n;
                } else {
                    ObservingSBGenerator.linkTargetStructure(target, spectralSpec, (ObservingParameters)object2);
                    time = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    object = object2.getSubScanDuration().adjustToIntegerMultipleOf(time);
                    object2.setSubScanDuration((Time)object);
                }
                schedBlock.addTarget(target);
            }
        }
        for (Target target : fieldSourceWorker.getTargets()) {
            schedBlock.addTarget(target);
        }
        for (Target target : fieldSourceWorker.getScienceCalTargets()) {
            schedBlock.addTarget(target);
        }
        Object object5 = this.obsprmworker.getScienceParameters();
        schedBlock.addObservingParameters((ObservingParameters)object5);
        Object var17_23 = null;
        if (schedBlock.getObservingParametersCount(this.getParametersTypeFromIntent(QuerySource.INTENDEDUSE_ATMOSPHERIC)) > 0) {
            CalibratorParameters calibratorParameters = (CalibratorParameters)((Object)schedBlock.getObservingParameters(this.getParametersTypeFromIntent(QuerySource.INTENDEDUSE_ATMOSPHERIC))[0]);
        } else {
            CalibratorParameters calibratorParameters = scienceGoalCalibratorParametersFactory.getCalibratorParameters(QuerySource.INTENDEDUSE_ATMOSPHERIC, 0);
            schedBlock.addObservingParameters((ObservingParameters)((Object)calibratorParameters));
        }
        for (Target target : fieldSourceWorker.getScienceCalTargets()) {
            void var17_26;
            if (spectralSpec5 != null) {
                ObservingSBGenerator.linkTargetStructure(target, spectralSpec5, (ObservingParameters)var17_26);
                time = spectralSpec5.getAbstractCorrelatorConfiguration().getIntegrationDuration();
            } else {
                ObservingSBGenerator.linkTargetStructure(target, spectralSpec, (ObservingParameters)var17_26);
                time = spectralSpec.getAbstractCorrelatorConfiguration().getIntegrationDuration();
            }
            object2 = var17_26.getSubScanDuration().adjustToIntegerMultipleOf(time);
            var17_26.setSubScanDuration((Time)object2);
        }
        for (Target target : fieldSourceWorker.getScienceTargets()) {
            ObservingSBGenerator.linkTargetStructure(target, spectralSpec, object5);
        }
        ObservingGroup[] observingGroupArray = new ObservingGroup[]{fieldSourceWorker.getInitialCalibrationObservingGroup(), fieldSourceWorker.getTargetsObservingGroup()};
        String[] stringArray = new String[]{"Calibrators", "Science"};
        schedBlock.setObservingGroup(observingGroupArray);
        int n3 = 1;
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            observingGroup.setName(stringArray[n3 - 1]);
            observingGroup.setIndex(n3++);
            int n4 = observingGroup.getOrderedTargetCount();
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                void var31_72;
                if (!orderedTarget.getTarget().hasPointingCalParameters()) continue;
                String string = orderedTarget.getTarget().getFieldSource().getName();
                String string2 = "";
                int n5 = orderedTarget.getIndex();
                if (n5 < n4) {
                    if (observingGroup.getOrderedTarget(n5 + 1).getTarget().hasAtmosphericCalParameters()) {
                        if (n5 + 1 < n4) {
                            String string3 = " for " + observingGroup.getOrderedTarget(n5 + 2).getTarget().getFieldSource().getName();
                        }
                    } else {
                        String string4 = " for " + observingGroup.getOrderedTarget(n5 + 1).getTarget().getFieldSource().getName();
                    }
                }
                orderedTarget.getTarget().getFieldSource().setName(string + (String)var31_72);
            }
        }
        for (Target target : fieldSourceWorker.getScienceTargets()) {
            Object object3;
            FieldSource fieldSource;
            ScienceParameters scienceParameters = (ScienceParameters)((Object)target.getObservingParameters(AddInteractor.ObjectType.SCIENCEPARAMETERS));
            if (scienceParameters != null) {
                scienceParameters.setSensitivityGoal(schedBlockExpert.calcAllocatedSensitivity());
            }
            if (scienceParameters != null) {
                try {
                    void var24_49;
                    Time time4 = spectralSpec.isACASpectralSpec() ? schedBlockExpert.timeCalculateACA() : schedBlockExpert.timeCalculate();
                    time4 = (Time)time4.multiply(target.getFieldSource().getNumberOfPointings());
                    if (schedBlock.getSchedBlockControl().getExecutionCount() > 0) {
                        Time time5 = (Time)time4.divide(schedBlock.getSchedBlockControl().getExecutionCount());
                    }
                    scienceParameters.getIntegrationTime().setContentAndUnit(var24_49.getContent(), var24_49.getUnit());
                }
                catch (InvalidFrequencyException invalidFrequencyException) {
                    throw new WizardSBGenerationException(invalidFrequencyException);
                }
                catch (SourceNeverVisibleException sourceNeverVisibleException) {
                    throw new WizardSBGenerationException(sourceNeverVisibleException);
                }
            }
            if ((fieldSource = target.getFieldSource()) != fieldSourceWorker.getRepresentativeFieldSource()) continue;
            schedBlock.getSchedulingConstraints().setRepresentativeTarget(target);
            try {
                object3 = target.getFieldSource().getSourceCoordinates();
                schedBlock.getSchedulingConstraints().setRepresentativeCoordinates((SkyCoordinates)object3);
            }
            catch (Exception exception) {
                GUIUtilities.error(null, "Could not get coordinate information from representative target");
                SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
                schedBlock.getSchedulingConstraints().setRepresentativeCoordinates(skyCoordinates);
            }
            try {
                object3 = spectralSpec.getFrequencySetup().getReceiverBand();
                schedBlock.getSchedulingConstraints().setRepresentativeReceiverBand((String)object3);
            }
            catch (Exception exception) {
                GUIUtilities.error(null, "Could not get frequency information from representative target");
                String string = FrequencySetup.RECEIVERBAND_UNDEFINED;
                schedBlock.getSchedulingConstraints().setRepresentativeReceiverBand(string);
            }
        }
        object = spectralSpec.getCorrelatorConfiguration();
        double d = object.getIntegrationDuration().getContentInUnits(Time.UNIT_S);
        CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(((AbstractCorrelatorConfiguration)object).getCorrelatorType());
        double d2 = correlatorExpert.calcSubscanDuration(d, d, null);
        Time time6 = Time.createTime((double)d2, (String)Time.UNIT_S);
        for (ObservingParameters observingParameters : schedBlock.getObservingParameters()) {
            if (!(observingParameters instanceof ScienceParameters)) continue;
            ScienceParameters scienceParameters = (ScienceParameters)((Object)observingParameters);
            scienceParameters.setSubScanDuration(time6.deepCopy());
        }
    }

    protected void calculateTimeAndDurations(SpectralSpec spectralSpec, double d, double d2, double d3) throws WizardSBGenerationException {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
        double d4 = correlatorExpert.calcDumpDurationInmsecs(d) / 1000.0;
        if (abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration) {
            ((BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration)).setDumpDuration(Time.createTimeSec(d4));
        }
        double d5 = correlatorExpert.calcChannelAverageDurationInsecs(d2, d4);
        abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTimeSec(d5));
        double d6 = correlatorExpert.calcIntegrationDurationInsecs(d3, d5);
        abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)d6, (String)Time.UNIT_S));
    }

    private static void linkTargetStructure(Target target, SpectralSpec spectralSpec, ObservingParameters observingParameters) {
        target.addObservingParameters(observingParameters);
        target.setSpectralSpec(spectralSpec);
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getCorrelatorConfiguration().getBaseBandConfig()) {
            abstractBaseBandConfig.getBaseBandSpecification();
        }
    }

    private AddInteractor.ObjectType getParametersTypeFromIntent(String string) {
        if (string.equals(QuerySource.INTENDEDUSE_AMPLITUDE)) {
            return AddInteractor.ObjectType.AMPLITUDECALPARAMETERS;
        }
        if (string.equals(QuerySource.INTENDEDUSE_ATMOSPHERIC)) {
            return AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS;
        }
        if (string.equals(QuerySource.INTENDEDUSE_BANDPASS)) {
            return AddInteractor.ObjectType.BANDPASSCALPARAMETERS;
        }
        if (string.equals(QuerySource.INTENDEDUSE_DELAY)) {
            return AddInteractor.ObjectType.DELAYCALPARAMETERS;
        }
        if (string.equals(QuerySource.INTENDEDUSE_CHECKSOURCE)) {
            return AddInteractor.ObjectType.CHECKSOURCECALPARAMETERS;
        }
        if (string.equals(QuerySource.INTENDEDUSE_FOCUS)) {
            return AddInteractor.ObjectType.FOCUSCALPARAMETERS;
        }
        if (string.equals(QuerySource.INTENDEDUSE_PHASE)) {
            return AddInteractor.ObjectType.PHASECALPARAMETERS;
        }
        if (string.equals(QuerySource.INTENDEDUSE_POINTING)) {
            return AddInteractor.ObjectType.POINTINGCALPARAMETERS;
        }
        if (string.equals(QuerySource.INTENDEDUSE_SIDEBANDRATIO)) {
            return AddInteractor.ObjectType.SIDEBANDRATIOCALPARAMETERS;
        }
        if (string.equals(QuerySource.INTENDEDUSE_POLARIZATION)) {
            return AddInteractor.ObjectType.POLARIZATIONCALPARAMETERS;
        }
        throw new AssertionError((Object)("Unhandled calibrator intent: " + string));
    }
}

