/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.CalibrationRequirements;
import alma.obsprep.bo.obsproject.ControlBlock;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.AbstractSchedBlockWorker;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Length;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

public class SchedBlockWorker
extends AbstractSchedBlockWorker {
    private SchedBlockExpert sbexpert;

    public SchedBlockWorker(ScienceGoal scienceGoal) {
        super(scienceGoal);
        this.sbexpert = SchedBlockExpert.getInstance(scienceGoal);
    }

    protected void validate() throws WizardSBGenerationException {
    }

    @Override
    protected ArrayList<SchedBlock> getSchedBlocks() throws WizardSBGenerationException {
        this.validate();
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        List<Range> list = this.sbexpert.calcHourAngleRange();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(ControlBlock.ARRAYREQUESTED_TWELVE_M);
        if (this.scienceGoal.getPerformanceParameters().getUseACA()) {
            arrayList2.add(ControlBlock.ARRAYREQUESTED_ACA);
        }
        if (this.sbexpert.getUseTPArray() && this.scienceGoal.getPerformanceParameters().gettrueUseTP()) {
            arrayList2.add(ControlBlock.ARRAYREQUESTED_TP_ARRAY);
        }
        for (String string : arrayList2) {
            ArrayList<Range> arrayList3;
            try {
                arrayList3 = string == ControlBlock.ARRAYREQUESTED_TWELVE_M ? this.sbexpert.calcBLResolutionRange() : this.sbexpert.calcACAResolutionRange();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (Range range : arrayList3) {
                Angle angle = Angle.createAngle((double)range.min(), (String)Angle.UNIT_ARCSEC);
                Angle angle2 = Angle.createAngle((double)range.max(), (String)Angle.UNIT_ARCSEC);
                for (Range range2 : list) {
                    UserAngle userAngle = UserAngle.createUserAngle(range2.min(), Angle.UNIT_DEG);
                    UserAngle userAngle2 = UserAngle.createUserAngle(range2.max(), Angle.UNIT_DEG);
                    SchedBlock schedBlock = SchedBlock.createSchedBlock();
                    schedBlock.getObsUnitControl().setArrayRequested(string);
                    this.setupSchedBlock(schedBlock);
                    schedBlock.getSchedulingConstraints().setMinAcceptableAngResolution(angle);
                    schedBlock.getSchedulingConstraints().setMaxAcceptableAngResolution(angle2);
                    schedBlock.getPreconditions().setMinAllowedHA(userAngle);
                    schedBlock.getPreconditions().setMaxAllowedHA(userAngle2);
                    arrayList.add(schedBlock);
                }
            }
        }
        return arrayList;
    }

    protected void setupSchedBlock(SchedBlock schedBlock) throws WizardSBGenerationException {
        schedBlock.setName(this.scienceGoal.getSoleTargetParameters().getSourceName());
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        this.setupSchedulingConstraints(schedulingConstraints);
        Preconditions preconditions = schedBlock.getPreconditions();
        this.setupPreconditions(preconditions);
        SchedBlockControl schedBlockControl = schedBlock.getSchedBlockControl();
        ObsUnitControl obsUnitControl = schedBlock.getObsUnitControl();
        try {
            this.setupSchedBlockControl(schedBlockControl);
            this.setupObsUnitControl(obsUnitControl, this.determineSBGenerationSchema(this.scienceGoal));
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            throw new WizardSBGenerationException(invalidFrequencyException.getMessage(), invalidFrequencyException);
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
            throw new WizardSBGenerationException(sourceNeverVisibleException.getMessage(), sourceNeverVisibleException);
        }
        schedBlock.getObsUnitControl().setMaximumTime(schedBlockControl.calcMaxTime());
    }

    public EnumSet<SBGeneratorTemplate.SBGenerationSchema> determineSBGenerationSchema(ScienceGoal scienceGoal) {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.STANDARD_CYCLE1);
        if (scienceGoal.isSpectralScan()) {
            enumSet = EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN);
        } else {
            Collection<ScienceGoal> collection = null;
            try {
                collection = ScienceGoalSchedBlockGenerator.splitByTuning(scienceGoal);
            }
            catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings | IndexOutOfBoundsException exception) {
                Log.logger(SchedBlockWorker.class).warning("Unable to split by tuning " + exception.getMessage());
                throw new WizardSBGenerationException(exception);
            }
            assert (collection != null);
            if (collection.size() > 1) {
                enumSet = EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING);
            }
        }
        if (scienceGoal.isPolarizationObservation()) {
            enumSet.add(SBGeneratorTemplate.SBGenerationSchema.POLARISATION);
        }
        return enumSet;
    }

    protected void setupSchedulingConstraints(SchedulingConstraints schedulingConstraints) {
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Frequency frequency = this.scienceGoal.getRepresentativeFrequencyInSky();
        schedulingConstraints.setRepresentativeFrequency(frequency.deepCopy());
        schedulingConstraints.setDynamicRange(performanceParameters.getDesiredDynamicRange());
    }

    protected void setupPreconditions(Preconditions preconditions) {
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        Frequency frequency = this.scienceGoal.getRepresentativeFrequencyInSky();
        Latitude latitude = this.scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates().getLatitude();
        int n = WaterVaporColumns.wvindexSelector(frequency, latitude, Optional.ofNullable(this.scienceGoal.getSpectralSetupParameters().getReceiverBand()));
        String string = WaterVaporColumns.getWVIndexLabel(n);
        double d = 0.0;
        d = Float.parseFloat(string.substring(0, 3));
        preconditions.getWeatherConstraints().getMaxPWVC().setContent(d);
        preconditions.getWeatherConstraints().getMaxPWVC().setUnit(Length.UNIT_MM);
        boolean bl = !this.scienceGoal.getSpectralSetupParameters().getPolarisation().equals("1");
        preconditions.setPolarizationCalValid(bl);
    }

    protected void setupSchedBlockControl(SchedBlockControl schedBlockControl) throws InvalidFrequencyException, SourceNeverVisibleException {
        Time time = this.sbexpert.getNominalSBLengthPolicy();
        time.convertToFriendlyUnit();
        schedBlockControl.getSBMaximumTime().setContentAndUnit((ValueUnitPair)time);
        SchedBlock schedBlock = (SchedBlock)schedBlockControl.getParent();
        try {
            schedBlockControl.setExecutionCount(this.sbexpert.calcExecutionCountForAllSources(schedBlock.isForACA(), EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.STANDARD_CYCLE1)));
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            throw new WizardSBGenerationException(unableToFindSolutionException.getMessage(), unableToFindSolutionException);
        }
    }

    protected void setupObsUnitControl(ObsUnitControl obsUnitControl, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws InvalidFrequencyException, SourceNeverVisibleException {
        CalibrationRequirements calibrationRequirements = obsUnitControl.getCalibrationRequirements();
        Angle angle = Angle.createAngle((double)1.0, (String)Angle.UNIT_ARCSEC);
        calibrationRequirements.setPointingAccuracy(angle);
        calibrationRequirements.setBandpassAccuracy(0.1);
        calibrationRequirements.setPolarizationAccuracy(0.1);
        SchedBlock schedBlock = (SchedBlock)obsUnitControl.getParent();
        Time time = this.sbexpert.calcExecutionTime(schedBlock.isForACA(), enumSet);
        time.convertToFriendlyUnit();
        obsUnitControl.getEstimatedExecutionTime().setContentAndUnit((ValueUnitPair)time);
    }
}

