/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.generator.refactored.ArraySBGroupPostProcessorInterface;
import alma.obsprep.services.generator.refactored.TotalPowerScienceSBGroupPostProcessor;
import java.util.Collection;
import java.util.Optional;

public class ArraySBGroupPostProcessorFactory {
    public static Optional<ArraySBGroupPostProcessorInterface> getSBGroupPostProcessor(Collection<SchedBlock> collection) {
        if (collection == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: schedBlockGroup");
        }
        if (collection.size() == 0) {
            return Optional.empty();
        }
        Optional<Object> optional = Optional.empty();
        for (SchedBlock schedBlock : collection) {
            String string = schedBlock.getObsUnitControl().getArrayRequested();
            if (!optional.isPresent()) {
                optional = Optional.of(string);
                continue;
            }
            if (((String)optional.get()).equals(string)) continue;
            throw new IllegalArgumentException("All of the SBs in groups should be for the same array");
        }
        if (collection.iterator().next().isTotalPowerScienceSB()) {
            return Optional.of(new TotalPowerScienceSBGroupPostProcessor());
        }
        return Optional.empty();
    }
}

