/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.EnumSet;
import java.util.List;

public class IntegerMosaicEnforcer {
    protected double getProportionOfTOSForScienceTarget(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, Target target, List<Target> list) {
        assert (target != null);
        assert (enumSet != null);
        assert (list != null && list.size() > 0);
        IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource((double)0.0, (String)IntTimeSource.UNIT_S);
        for (Target target2 : list) {
            intTimeSource = (IntTimeSource)intTimeSource.plus((AbstractDoubleWithUnit)target2.getScienceParametersList()[0].getIntegrationTime());
        }
        return target.getScienceParametersList()[0].getIntegrationTime().getContentInUnits(IntTimeSource.UNIT_S) / intTimeSource.getContentInUnits(IntTimeSource.UNIT_S);
    }

    protected Time getActualTOSRequiredForSingleSBExec(List<Target> list) {
        Time time = Time.createTime();
        for (Target target : list) {
            ScienceParameters scienceParameters = target.getScienceParametersList()[0];
            double d = scienceParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
            time.aggregate(Time.createTimeSec(d * Math.ceil(scienceParameters.getIntegrationTime().getContentInUnits(Time.UNIT_S) / d)));
        }
        return time;
    }
}

