/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.ArrayRequested;
import java.util.EnumSet;

public enum RequestedArray {
    ACA(ControlBlockTArrayRequestedType.ACA, Antenna.ANTENNA_7M, Array.ARRAY_7M, ArrayRequested.ACA),
    TP(ControlBlockTArrayRequestedType.TP_ARRAY, Antenna.ANTENNA_12M, Array.ARRAY_TP, ArrayRequested.TP_ARRAY),
    TWELVE_M(ControlBlockTArrayRequestedType.TWELVE_M, Antenna.ANTENNA_12M, Array.ARRAY_12M, ArrayRequested.TWELVE_M),
    SEVEN_M(ControlBlockTArrayRequestedType.SEVEN_M, Antenna.ANTENNA_7M, Array.ARRAY_7M, ArrayRequested.SEVEN_M);

    private final ControlBlockTArrayRequestedType controlBlockType;
    private final Antenna antenna;
    private final Array array;
    private ArrayRequested controlBlockArray;

    private RequestedArray(ControlBlockTArrayRequestedType controlBlockTArrayRequestedType, Antenna antenna, Array array, ArrayRequested arrayRequested) {
        this.controlBlockType = controlBlockTArrayRequestedType;
        this.antenna = antenna;
        this.array = array;
        this.controlBlockArray = arrayRequested;
    }

    public String getType() {
        return this.controlBlockType.toString();
    }

    public Antenna getAntenna() {
        return this.antenna;
    }

    public Array getArray() {
        return this.array;
    }

    public ArrayRequested getControlBlockArray() {
        return this.controlBlockArray;
    }

    public boolean isInterferometeric() {
        return EnumSet.of(ACA, TWELVE_M, SEVEN_M).contains((Object)RequestedArray.valueOf(this.controlBlockType));
    }

    public static RequestedArray valueOf(ControlBlockTArrayRequestedType controlBlockTArrayRequestedType) {
        if (controlBlockTArrayRequestedType == null) {
            throw new NullPointerException("arrayRequestedType specified is null");
        }
        for (RequestedArray requestedArray : RequestedArray.values()) {
            if (!requestedArray.controlBlockType.equals(controlBlockTArrayRequestedType)) continue;
            return requestedArray;
        }
        throw new IllegalArgumentException("Unknown array type " + controlBlockTArrayRequestedType + " found ");
    }
}

