/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.Target;
import alma.valuetypes.Time;

public class RevisedIntegrationParameters {
    private Time subScanDuration;
    private int noOfSBExecs;
    private Time scienceIntegrationTime;
    private Integer mosaicsPerSB;
    private Target scienceTarget;

    public RevisedIntegrationParameters(Target target, Time time, int n, Time time2) {
        this.subScanDuration = time;
        this.noOfSBExecs = n;
        this.scienceIntegrationTime = time2;
        this.scienceTarget = target;
    }

    final Target getScienceTarget() {
        return this.scienceTarget;
    }

    final void setScienceTarget(Target target) {
        this.scienceTarget = target;
    }

    public Time getSubScanDuration() {
        return this.subScanDuration;
    }

    public void setSubScanDuration(Time time) {
        this.subScanDuration = time;
    }

    public int getNoOfSBExecs() {
        return this.noOfSBExecs;
    }

    public void setNoOfSBExecs(Integer n) {
        this.noOfSBExecs = n;
    }

    public Time getScienceIntegrationTime() {
        return this.scienceIntegrationTime;
    }

    public void setScienceIntegrationTime(Time time) {
        this.scienceIntegrationTime = time;
    }

    public String toString() {
        return "RevisedIntegrationParameters [subScanDuration=" + this.subScanDuration + ", noOfSBExecs=" + this.noOfSBExecs + ", scienceIntegrationTime=" + this.scienceIntegrationTime + ", mosaicsPerSB=" + this.mosaicsPerSB + ", scienceTarget=" + this.scienceTarget + "]";
    }

    private RevisedIntegrationParameters(Builder builder) {
        this.subScanDuration = builder.subScanDuration;
        this.noOfSBExecs = builder.noOfSBExecs;
        this.scienceIntegrationTime = builder.scienceIntegrationTime;
        this.mosaicsPerSB = builder.mosaicsPerSB;
        this.scienceTarget = builder.scienceTarget;
    }

    public static class Builder {
        private Time subScanDuration;
        private int noOfSBExecs;
        private Time scienceIntegrationTime;
        private int mosaicsPerSB;
        private Target scienceTarget;

        public String toString() {
            return "Builder [subScanDuration=" + this.subScanDuration + ", noOfSBExecs=" + this.noOfSBExecs + ", scienceIntegrationTime=" + this.scienceIntegrationTime + ", mosaicsPerSB=" + this.mosaicsPerSB + ", scienceTarget=" + this.scienceTarget + "]";
        }

        public Builder subScanDuration(Time time) {
            this.subScanDuration = time;
            return this;
        }

        public Builder noOfSBExecs(int n) {
            this.noOfSBExecs = n;
            return this;
        }

        public Builder scienceIntegrationTime(Time time) {
            this.scienceIntegrationTime = time.deepCopy();
            return this;
        }

        public Builder scienceTarget(Target target) {
            this.scienceTarget = target.deepCopy();
            return this;
        }

        public Builder mosaicsPerSB(Integer n) {
            this.mosaicsPerSB = n;
            return this;
        }

        public RevisedIntegrationParameters build() {
            return new RevisedIntegrationParameters(this);
        }
    }
}

