/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.annotations.TargetContext;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SchedBlockConsolidator {
    private final Log.Logger logger = Log.logger((Object)this);
    private static final List<TestUtilities.Prune> pruneAllEntityIds = Arrays.asList(new TestUtilities.Prune(" partId=\\S+", ""), new TestUtilities.Prune(" entityId=\\S+", ""), new TestUtilities.Prune(" entityPartId=\\S+", ""));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consolidate(SchedBlock schedBlock) {
        SchedBlock schedBlock2 = schedBlock;
        synchronized (schedBlock2) {
            SchedBlockConsolidator.consolidateSpectralSpecs(schedBlock);
            SchedBlockConsolidator.consolidateObservingParameters(schedBlock);
            SchedBlockConsolidator.consolidateFieldSources(schedBlock);
        }
    }

    static void consolidateFieldSources(SchedBlock schedBlock) {
        String string;
        HashMap<Integer, FieldSource> hashMap = new HashMap<Integer, FieldSource>();
        HashMap hashMap2 = new HashMap();
        for (FieldSource targetContext : schedBlock.getFieldSource()) {
            string = TestUtilities.pruneXml(targetContext.toXml(), TestUtilities.pruneEntityIds);
            int n = string.hashCode();
            if (hashMap.keySet().contains(n)) {
                hashMap2.put(targetContext.getEntityPartId(), hashMap.get(n));
                schedBlock.removeFieldSource(targetContext);
                continue;
            }
            hashMap.put(n, targetContext);
        }
        for (TargetContext targetContext : schedBlock.getTarget()) {
            string = targetContext.getCastorObject().getFieldSourceRef().getPartId();
            if (!hashMap2.containsKey(string)) continue;
            FieldSource fieldSource = (FieldSource)hashMap2.get(string);
            targetContext.setFieldSource(fieldSource);
        }
    }

    static void consolidateSpectralSpecs(SchedBlock schedBlock) {
        String string;
        HashMap<Integer, SpectralSpec> hashMap = new HashMap<Integer, SpectralSpec>(40);
        HashMap hashMap2 = new HashMap(40);
        for (SpectralSpec spectralSpecDocument : schedBlock.getSpectralSpec()) {
            string = spectralSpecDocument.toXml().replaceAll("<sbl:desiredCenterFrequency[ ]*unit=\"[\\w]+?\">[ ]*(?:(?i)(?:[+-]?)(?:(?=[.]?[0-9])(?:[0-9]*)(?:(?:[.])(?:[0-9]{0,}))?)(?:(?:[E])(?:(?:[+-]?)(?:[0-9]+))|))[ ]*</sbl:desiredCenterFrequency>", "<sbl:desiredCenterFrequency unit=\"MHz\">0.0</sbl:desiredCenterFrequency>");
            string = TestUtilities.pruneXml(string, pruneAllEntityIds);
            int n = string.hashCode();
            if (hashMap.keySet().contains(n)) {
                hashMap2.put(spectralSpecDocument.getEntityPartId(), hashMap.get(n));
                schedBlock.removeSpectralSpec(spectralSpecDocument);
                continue;
            }
            hashMap.put(n, spectralSpecDocument);
        }
        for (SpectralSpecDocument spectralSpecDocument : schedBlock.getTarget()) {
            string = spectralSpecDocument.getCastorObject().getAbstractInstrumentSpecRef().getPartId();
            if (!hashMap2.containsKey(string)) continue;
            SpectralSpec spectralSpec = (SpectralSpec)hashMap2.get(string);
            ((Target)spectralSpecDocument).setSpectralSpec(spectralSpec);
        }
    }

    static int getHash(ObservingParameters observingParameters) {
        String string = TestUtilities.pruneXml(observingParameters.toXml(), TestUtilities.pruneEntityIds);
        return string.hashCode();
    }

    static void consolidateObservingParameters(SchedBlock schedBlock) {
        HashMap<Integer, ObservingParameters> hashMap = new HashMap<Integer, ObservingParameters>(40);
        HashMap<String, ScienceParameters> hashMap2 = new HashMap<String, ScienceParameters>(40);
        ObservingParameters[] observingParametersArray = schedBlock.getObservingParameters();
        List<ConsolidatedScienceParameters> list = SchedBlockConsolidator.groupSimilarScienceParameters(Arrays.asList(observingParametersArray));
        for (ObservingParameters targetContext : observingParametersArray) {
            int n = SchedBlockConsolidator.getHash(targetContext);
            ScienceParameters scienceParameters = null;
            if (targetContext instanceof ScienceParameters) {
                block1: for (ConsolidatedScienceParameters consolidatedScienceParameters : list) {
                    if (n == SchedBlockConsolidator.getHash((ObservingParameters)((Object)consolidatedScienceParameters.getRepresentativeScienceParameters()))) break;
                    for (Object object : consolidatedScienceParameters.getSimilarScienceParameters()) {
                        if (n != SchedBlockConsolidator.getHash((ObservingParameters)object)) continue;
                        scienceParameters = consolidatedScienceParameters.getRepresentativeScienceParameters();
                        continue block1;
                    }
                }
            }
            if (hashMap.keySet().contains(n) || scienceParameters != null) {
                if (scienceParameters != null) {
                    hashMap2.put(targetContext.getEntityPartId(), scienceParameters);
                } else {
                    hashMap2.put(targetContext.getEntityPartId(), (ScienceParameters)((Object)hashMap.get(n)));
                }
                schedBlock.removeObservingParameters(targetContext);
                continue;
            }
            hashMap.put(n, targetContext);
        }
        for (TargetContext targetContext : schedBlock.getTarget()) {
            for (ObservingParameters observingParameters : targetContext.getObservingParameters()) {
                Object object;
                String string = observingParameters.getEntityPartId();
                if (!hashMap2.containsKey(string)) continue;
                object = (ObservingParameters)hashMap2.get(string);
                targetContext.removeObservingParameters(observingParameters);
                targetContext.addObservingParameters((ObservingParameters)object);
            }
        }
    }

    static List<ConsolidatedScienceParameters> groupSimilarScienceParameters(List<ObservingParameters> list) {
        ArrayList<ConsolidatedScienceParameters> arrayList = new ArrayList<ConsolidatedScienceParameters>();
        ArrayList<ScienceParameters> arrayList2 = new ArrayList<ScienceParameters>();
        for (ObservingParameters object : list) {
            if (!(object instanceof ScienceParameters)) continue;
            arrayList2.add((ScienceParameters)((Object)object));
        }
        Collections.sort(arrayList2, (scienceParameters, scienceParameters2) -> {
            if (scienceParameters.getIntegrationTime().isGreaterThan((AbstractDoubleWithUnit)scienceParameters2.getIntegrationTime())) {
                return -1;
            }
            if (scienceParameters2.getIntegrationTime().isGreaterThan((AbstractDoubleWithUnit)scienceParameters.getIntegrationTime())) {
                return 1;
            }
            return 0;
        });
        HashSet hashSet = new HashSet();
        for (ScienceParameters scienceParameters3 : arrayList2) {
            if (hashSet.contains((Object)scienceParameters3)) continue;
            ConsolidatedScienceParameters consolidatedScienceParameters = new ConsolidatedScienceParameters(scienceParameters3);
            hashSet.add(scienceParameters3);
            for (ScienceParameters scienceParameters4 : arrayList2) {
                if (((Object)((Object)scienceParameters3)).equals((Object)scienceParameters4) || hashSet.contains((Object)scienceParameters4) || !SchedBlockConsolidator.isScienceIntegrationTimeApproximatelyTheSame(scienceParameters3, scienceParameters4)) continue;
                consolidatedScienceParameters.addSimilarScienceParameters(scienceParameters4);
                hashSet.add(scienceParameters4);
            }
            arrayList.add(consolidatedScienceParameters);
        }
        return arrayList;
    }

    private static boolean isScienceIntegrationTimeApproximatelyTheSame(ScienceParameters scienceParameters, ScienceParameters scienceParameters2) {
        if (scienceParameters == null) {
            throw new IllegalArgumentException("scienceParametersA is null");
        }
        if (scienceParameters2 == null) {
            throw new IllegalArgumentException("scienceParametersB is null");
        }
        if (!scienceParameters.getSubScanDuration().isEqual((AbstractDoubleWithUnit)scienceParameters2.getSubScanDuration())) {
            return false;
        }
        double d = scienceParameters.getIntegrationTime().getContentInUnits(Time.UNIT_S);
        double d2 = scienceParameters2.getIntegrationTime().getContentInUnits(Time.UNIT_S);
        double d3 = scienceParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        if (Math.ceil(d / d3) == Math.ceil(d2 / d3)) {
            ScienceParameters scienceParameters3 = scienceParameters.deepCopy();
            ScienceParameters scienceParameters4 = scienceParameters2.deepCopy();
            scienceParameters3.setIntegrationTime(IntTimeSource.createIntTimeSource());
            scienceParameters4.setIntegrationTime(IntTimeSource.createIntTimeSource());
            String string = TestUtilities.pruneXml(scienceParameters3.toXml(), TestUtilities.pruneEntityIds);
            String string2 = TestUtilities.pruneXml(scienceParameters4.toXml(), TestUtilities.pruneEntityIds);
            if (string.hashCode() == string2.hashCode()) {
                return true;
            }
        }
        return false;
    }

    public static class ConsolidatedScienceParameters {
        private ScienceParameters representativeScienceParameters;
        private Set<ScienceParameters> similarScienceParameters = new HashSet<ScienceParameters>();

        public ConsolidatedScienceParameters(ScienceParameters scienceParameters) {
            this.representativeScienceParameters = scienceParameters;
        }

        public ScienceParameters getRepresentativeScienceParameters() {
            return this.representativeScienceParameters;
        }

        public Set<ScienceParameters> getSimilarScienceParameters() {
            return Collections.unmodifiableSet(this.similarScienceParameters);
        }

        void addSimilarScienceParameters(ScienceParameters scienceParameters) {
            this.similarScienceParameters.add(scienceParameters);
        }
    }
}

