/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.obsproject.OUSLocator;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ExecutiveFraction;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.ProposalFeedback;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.experts.spectralline.SpectralLineCatalogue;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ArraySBGroupPostProcessorFactory;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcerFactory;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.ScienceParametersSensitivityCalculator;
import alma.obsprep.services.generator.refactored.SolarSBConfigurator;
import alma.obsprep.services.generator.refactored.StaleSBDetector;
import alma.obsprep.services.generator.refactored.TotalPowerIntegrationTimeCalculator;
import alma.obsprep.services.generator.refactored.intermediatetarget.PhaseCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.spectralspec.Walsh90DegConfiguratorFactory;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import ca.odell.glazedlists.EventList;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class SchedBlockPostProcessor {
    private final Log.Logger logger = Log.logger((Object)this);
    private boolean isSBGenerationUserInitiated;
    private ScienceGoal piDefinedScienceGoal;
    private ObsUnitSet rootOUS;

    public void postProcessSBGroup(Integer n, PerformanceParameters performanceParameters, Boolean bl, int n2, ScienceGoal scienceGoal, ObsUnitSet obsUnitSet, Collection<Collection<SchedBlock>> collection) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.enforceMinimumExecutionTimes(bl, n2, obsUnitSet, scienceGoal);
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock : collection2) {
                try {
                    this.postProcessSB(scienceGoal, schedBlock);
                }
                catch (Exception exception) {
                    throw new WizardSBGenerationException(exception);
                }
            }
            ArraySBGroupPostProcessorFactory.getSBGroupPostProcessor(collection2).ifPresent(arraySBGroupPostProcessorInterface -> arraySBGroupPostProcessorInterface.postProcessSBArrayGroup(collection2));
        }
        stopwatch.stop();
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine(stopwatch.toString());
    }

    private void enforceMinimumExecutionTimes(Boolean bl, int n, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        boolean bl2 = scienceGoal.isStandAloneACA();
        ObsUnitSet obsUnitSet2 = null;
        Integer n2 = null;
        SBGeneratorTemplate.SchedBlockType schedBlockType = null;
        if (bl2) {
            n2 = 1;
            schedBlockType = SBGeneratorTemplate.SchedBlockType.ACA7M;
        } else {
            schedBlockType = SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION;
            try {
                n2 = scienceGoal.getNumberOf12MAntennaConfigurations();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                this.logger.warning("Unable to determine number of 12m antenna configurations");
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
        }
        assert (n2 != null && schedBlockType != null);
        try {
            obsUnitSet2 = this.findOUS(obsUnitSet, schedBlockType);
        }
        catch (UnknownEntityException unknownEntityException) {
            this.logger.warning("Unable to find SBs in OUS structure");
            throw new WizardSBGenerationException(unknownEntityException);
        }
        finally {
            if (obsUnitSet2 == null) {
                return;
            }
        }
        if (bl.booleanValue()) {
            this.enforceSBExecutionTimesForContinuousMonitoring(n, obsUnitSet2, scienceGoal);
        } else if (n2 > 1) {
            ObsUnitSet obsUnitSet3 = null;
            try {
                obsUnitSet3 = this.findOUS(obsUnitSet, SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION);
            }
            catch (UnknownEntityException unknownEntityException) {
                this.logger.warning("Unable to find SBs in OUS structure");
                throw new WizardSBGenerationException(unknownEntityException);
            }
            finally {
                if (obsUnitSet3 == null) {
                    throw new WizardSBGenerationException("Unable to find 12m compact array SBs in OUS structure");
                }
            }
            this.enforceSBExecutionTimesForMultiple12mConfigurations(obsUnitSet3, obsUnitSet2, scienceGoal);
        } else if (scienceGoal.getPerformanceParameters().getNeedsMoreTime()) {
            this.enforceSBExecutionTimeForTimeOverrides(obsUnitSet2, scienceGoal);
        } else if (scienceGoal.isPolarizationObservation()) {
            this.enforcePolarizationTime(scienceGoal, obsUnitSet);
        }
    }

    private void enforcePolarizationTime(ScienceGoal scienceGoal, ObsUnitSet obsUnitSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        List<SchedBlock> list = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(list, obsUnitSet);
        list = list.stream().filter(schedBlock -> schedBlock.is12mCompactArraySB() || schedBlock.is12mExtendedArraySB()).collect(Collectors.toList());
        assert (list != null);
        if (!list.isEmpty()) {
            Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
            this.enforceMinSBExecutionTime(time, list, scienceGoal);
        }
    }

    private void enforceSBExecutionTimeForTimeOverrides(ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        Time time2 = scienceGoal.getPerformanceParameters().getDesiredTime().deepCopy();
        if (time2 == null || time2.isZero()) {
            throw new WizardSBGenerationException("Time override requested is either not specified or zero");
        }
        if (scienceGoal.isPolarizationObservation()) {
            this.enforceProjectExecutionTime(Time.max(time2, time), obsUnitSet, scienceGoal);
        } else {
            this.enforceProjectExecutionTime(time2, obsUnitSet, scienceGoal);
        }
    }

    private void enforceSBExecutionTimesForMultiple12mConfigurations(ObsUnitSet obsUnitSet, ObsUnitSet obsUnitSet2, ScienceGoal scienceGoal) {
        assert (obsUnitSet != null);
        assert (obsUnitSet2 != null);
        Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        boolean bl = scienceGoal.getPerformanceParameters().getNeedsMoreTime();
        Time time2 = null;
        if (bl) {
            Time time3 = scienceGoal.getPerformanceParameters().getDesiredTime().deepCopy();
            if (time3 == null || time3.isZero()) {
                throw new WizardSBGenerationException("Time override requested is either not specified or zero");
            }
            Time time4 = null;
            try {
                time4 = (Time)time3.multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal));
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException("Unable to determine 12m compact array time multiplier: " + invalidObsProgramParametersException.getMessage());
            }
            assert (time4 != null);
            Time time5 = null;
            Time time6 = null;
            if (scienceGoal.isPolarizationObservation()) {
                time6 = Time.max(time3, time);
                time5 = Time.max(time4, time);
            } else {
                time5 = time4;
                time6 = time3;
            }
            assert (time5 != null);
            assert (time6 != null);
            this.enforceProjectExecutionTime(time5, obsUnitSet, scienceGoal);
            this.enforceProjectExecutionTime(time6, obsUnitSet2, scienceGoal);
        } else if (scienceGoal.isPolarizationObservation()) {
            this.enforcePolarizationTime(scienceGoal, obsUnitSet);
            this.enforcePolarizationTime(scienceGoal, obsUnitSet2);
        } else {
            try {
                for (SchedBlock schedBlock : obsUnitSet2.getSchedBlock()) {
                    if (!schedBlock.is12mExtendedArraySB()) continue;
                    time2 = (Time)ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal));
                }
            }
            catch (Exception exception) {
                this.logger.warning("Unable to determine execution time 12m extended array");
                throw new WizardSBGenerationException(exception);
            }
            finally {
                if (time2 == null) {
                    this.logger.warning("Unable to determine the minimum execution time for the 12m compact array");
                    throw new WizardSBGenerationException("Unable to determine the minimum execution time for the 12m compact array");
                }
            }
            assert (time2 != null);
            this.enforceProjectExecutionTime(time2, obsUnitSet, scienceGoal);
        }
    }

    private void enforceSBExecutionTimesForContinuousMonitoring(int n, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        Time time2 = scienceGoal.getPerformanceParameters().getMonitoringConstraint(n).getMonitoringLength();
        Time time3 = scienceGoal.isPolarizationObservation() ? (time2.isGreaterThan((AbstractDoubleWithUnit)time) ? time2 : time) : time2;
        this.enforceProjectExecutionTime(time3, obsUnitSet, scienceGoal);
    }

    private void addRestLinesToSBSpectralWindows(ScienceGoal scienceGoal, SchedBlock schedBlock) {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: schedBlock");
        }
        if (scienceGoal.isSpectralScan()) {
            return;
        }
        for (ScienceSpectralWindow scienceSpectralWindow : scienceGoal.getSpectralSetupParameters().getScienceSpectralWindow()) {
            ArrayList<ExpectedSpectralLine> arrayList = new ArrayList<ExpectedSpectralLine>(Arrays.asList(scienceSpectralWindow.getExpectedSpectralLine()));
            if (arrayList.isEmpty() && scienceSpectralWindow.hasSplatalogId()) {
                int n = scienceSpectralWindow.getSplatalogId();
                EventList<alma.obsprep.services.experts.spectralline.SpectralLine> eventList = SpectralLineCatalogue.getInstance(false).getRootCatalogue();
                Optional<alma.obsprep.services.experts.spectralline.SpectralLine> optional = eventList.stream().filter(spectralLine -> spectralLine.getLineId() == n).findFirst();
                if (optional.isPresent()) {
                    arrayList.add(ExpectedSpectralLine.createNewExpectedLine((alma.obsprep.services.experts.spectralline.SpectralLine)optional.get()));
                }
            }
            this.filterOutSpectralLinesNotInSPWPassbands(schedBlock);
            for (ExpectedSpectralLine expectedSpectralLine : arrayList) {
                for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
                    for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
                        for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                            FrequencyRange frequencyRange;
                            Frequency frequency = spectralSpec.getSourceVelocity().reverseShift(spectralWindowI.getEffectiveBandwidth());
                            if (spectralWindowI.isValidSideBandUseChoice(SideBandUse.SIDEBANDUSE_LSB) && (frequencyRange = FrequencyRange.fastCentredOn(spectralWindowI.getRestFrequencyLSB(), frequency)).contains(expectedSpectralLine.getRestFrequency())) {
                                Log.logger(SchedBlockPostProcessor.class).fine("Adding " + (Object)((Object)expectedSpectralLine) + " to list of rest lines associated with SPW");
                                spectralWindowI.addExpectedRestFrequencySpectralLine(expectedSpectralLine, SpectralSpec.SideBand.LSB);
                            }
                            if (!spectralWindowI.isValidSideBandUseChoice(SideBandUse.SIDEBANDUSE_USB) || !(frequencyRange = FrequencyRange.fastCentredOn(spectralWindowI.getRestFrequencyUSB(), frequency)).contains(expectedSpectralLine.getRestFrequency())) continue;
                            Log.logger(SchedBlockPostProcessor.class).fine("Adding " + (Object)((Object)expectedSpectralLine) + " to list of rest lines associated with SPW");
                            spectralWindowI.addExpectedRestFrequencySpectralLine(expectedSpectralLine, SpectralSpec.SideBand.USB);
                        }
                    }
                }
            }
        }
    }

    private void filterOutSpectralLinesNotInSPWPassbands(SchedBlock schedBlock) {
        for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
            for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
                for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                    List list;
                    FrequencyRange frequencyRange;
                    Frequency frequency = spectralSpec.getSourceVelocity().reverseShift(spectralWindowI.getEffectiveBandwidth());
                    if (spectralWindowI.isValidSideBandUseChoice(SideBandUse.SIDEBANDUSE_LSB)) {
                        frequencyRange = FrequencyRange.fastCentredOn(spectralWindowI.getRestFrequencyLSB(), frequency);
                        list = Arrays.stream(spectralWindowI.getLSB().getSpectralLine()).filter(spectralLine -> frequencyRange.contains(spectralLine.getRestFrequency())).collect(Collectors.toList());
                        spectralWindowI.clearSpectralLines(SpectralSpec.SideBand.LSB);
                        list.stream().forEach(spectralLine -> spectralWindowI.addSpectralLine(SpectralSpec.SideBand.LSB, (SpectralLine)((Object)spectralLine)));
                    }
                    if (!spectralWindowI.isValidSideBandUseChoice(SideBandUse.SIDEBANDUSE_USB)) continue;
                    frequencyRange = FrequencyRange.fastCentredOn(spectralWindowI.getRestFrequencyUSB(), frequency);
                    list = Arrays.stream(spectralWindowI.getUSB().getSpectralLine()).filter(spectralLine -> frequencyRange.contains(spectralLine.getRestFrequency())).collect(Collectors.toList());
                    spectralWindowI.clearSpectralLines(SpectralSpec.SideBand.USB);
                    list.stream().forEach(spectralLine -> spectralWindowI.addSpectralLine(SpectralSpec.SideBand.USB, (SpectralLine)((Object)spectralLine)));
                }
            }
        }
    }

    private void enforceProjectExecutionTime(Time time, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        Time time2;
        if (time == null) {
            this.logger.warning("The minimum project time is not set");
            return;
        }
        try {
            time2 = SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal);
        }
        catch (Exception exception) {
            this.logger.warning("Unable to determine the project execution time : " + exception.getMessage());
            throw new WizardSBGenerationException(exception);
        }
        this.logger.fine("Minimum execution time : " + time + " project time " + time2 + " for OUS " + obsUnitSet.getName());
        if (time2.isLessThan((AbstractDoubleWithUnit)time)) {
            try {
                this.adjustTOSInSBsToMatchRequestedMinimumExecutionTime(time2, time, obsUnitSet, scienceGoal);
            }
            catch (Exception exception) {
                this.logger.warning("Unable to increase the TOS in the science parameters : " + exception.getMessage());
                throw new WizardSBGenerationException(exception);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                try {
                    Time time3 = SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal);
                    this.logger.fine("Revised project time : " + time3.getContentInUnits(Time.UNIT_MIN) + " mins ");
                }
                catch (Exception exception) {
                    this.logger.warning("Unable to determine the project execution time : " + exception.getMessage());
                }
            }
        }
    }

    private void enforceMinSBExecutionTime(Time time, List<SchedBlock> list, ScienceGoal scienceGoal) {
        if (time == null) {
            this.logger.warning("The minimum SB execution time is not set");
            return;
        }
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: schedBlocks");
        }
        for (SchedBlock schedBlock : list) {
            try {
                this.adjustTOSInSBToMatchRequestedMinimumExecutionTime(time, schedBlock, scienceGoal);
            }
            catch (Exception exception) {
                this.logger.warning("Unable to increase the TOS in the science parameters : " + exception.getMessage());
                throw new WizardSBGenerationException(exception);
            }
            if (!this.logger.isLoggable(Level.FINE)) continue;
            try {
                Time time2 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                this.logger.fine("Revised SB execution time : " + time2.getContentInUnits(Time.UNIT_MIN) + " mins " + " for SB " + schedBlock.getName() + " minimum time required was " + time.getContentInUnits(Time.UNIT_MIN));
            }
            catch (Exception exception) {
                this.logger.warning("Unable to determine the SB execution time : " + exception.getMessage());
            }
        }
    }

    public static Time determineOUSExecutionTime(ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException, UnknownEntityException {
        Time time = Time.createTimeSec(0.0);
        for (ObsUnitSet obsUnitSetComponent : obsUnitSet.getObsUnitSet()) {
            time.aggregate(SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSetComponent, scienceGoal));
        }
        for (ObsUnitSetComponent obsUnitSetComponent : obsUnitSet.getSchedBlock()) {
            time.aggregate(ObservingTimeCalculator.getExecutionTimeForSB((SchedBlock)obsUnitSetComponent, scienceGoal));
        }
        return time;
    }

    private void postProcessSB(ScienceGoal scienceGoal, SchedBlock schedBlock) throws WizardSBGenerationException, Exception {
        Object object;
        Object object2;
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet;
        List<ObsUnitSet> list;
        Object object3;
        Object object4;
        boolean bl;
        boolean bl2;
        assert (scienceGoal != null && schedBlock != null);
        if (MiscUtils.isSpectralLinesToBeAddedToSBs()) {
            this.addRestLinesToSBSpectralWindows(scienceGoal, schedBlock);
        }
        if (bl2 = scienceGoal.isSolarScienceGoal()) {
            SolarSBConfigurator solarSBConfigurator = new SolarSBConfigurator(schedBlock);
            solarSBConfigurator.configureSBForSolar();
        }
        if (bl = schedBlock.getSbGenerationContext().getGoal().getSpectralSetupParameters().isWalshSwitching()) {
            this.walshSwitching90DegreePostProcessing(schedBlock);
        } else {
            this.setCorrelatorTimingsToTDMDefaults();
        }
        try {
            object4 = new OUSLocator.Builder();
            ((OUSLocator.Builder)object4).rootOUS(this.rootOUS).scienceGoal(scienceGoal).simultaneousArrayOperation(scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation());
            object3 = new OUSLocator((OUSLocator.Builder)object4);
            list = ((OUSLocator)object3).locateOUS();
        }
        catch (OUSLocator.UnableToLocateObsUnitSetException unableToLocateObsUnitSetException) {
            throw new WizardSBGenerationException(unableToLocateObsUnitSetException);
        }
        object4 = new ObservingTimeCalculator.Builder();
        ((ObservingTimeCalculator.Builder)object4).noSBGeneration(true).obsUnitSet(list.get(0)).scienceGoal(scienceGoal);
        object3 = new ObservingTimeCalculator((ObservingTimeCalculator.Builder)object4);
        ControlBlockTArrayRequestedType controlBlockTArrayRequestedType = ControlBlockTArrayRequestedType.valueOf((String)schedBlock.getObsUnitControl().getArrayRequested());
        RequestedArray requestedArray = RequestedArray.valueOf(controlBlockTArrayRequestedType);
        try {
            enumSet = SchedBlockWorker.determineSBGenerationSchema(scienceGoal, schedBlock);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).info("Unable to post-process SBs : " + unknownEntityException.getMessage());
            throw new WizardSBGenerationException(unknownEntityException);
        }
        boolean bl3 = false;
        if (requestedArray.equals((Object)RequestedArray.TWELVE_M) && !scienceGoal.isStandAloneACA() && !bl2) {
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            if (scienceGoalConfigurations.isEmpty()) {
                throw new WizardSBGenerationException("Unable to determine configurations");
            }
            object2 = ((ConfigurationSet)scienceGoalConfigurations.get(0)).getTM1Configuration();
            bl3 = Configuration.isLongBaselineConfiguration(((Optional)object2).orElse(Configuration.NO_CONFIG));
        }
        boolean bl4 = bl3 || bl2;
        object2 = IntegerMosaicEnforcerFactory.getIntegerMosaicEnforcer(bl4 ? IntegerMosaicEnforcerFactory.MosaicEnforcer.FIXED_SUBSCAN_MOSAIC_ENFORCER : IntegerMosaicEnforcerFactory.MosaicEnforcer.VARIABLE_SUBSCAN_MOSAIC_ENFORCER);
        if (!schedBlock.isTotalPowerScienceSB()) {
            if (!object2.enforceCompleteMosaicScansPerSBExec(schedBlock, requestedArray, enumSet)) {
                try {
                    SchedBlockWorker.quantizeIntegrationTimesOnSourceBySubscanDuration(schedBlock, enumSet);
                }
                catch (SchedBlockWorker.UnableToQuantizeIntegrationTimeException unableToQuantizeIntegrationTimeException) {
                    Log.logger(ScienceGoalSchedBlockGenerator.class).fine("Unable to quantize integration time");
                }
            }
        } else {
            double d;
            try {
                Array array = scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
                object = ((ObservingTimeCalculator)object3).getTotalArraySBScienceIntegrationTime(true, array);
            }
            catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
                Log.logger(ScienceGoalSchedBlockGenerator.class).info("Unable to post-process SBs : " + throwable.getMessage());
                throw new WizardSBGenerationException(throwable);
            }
            try {
                d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            TotalPowerIntegrationTimeCalculator.calculateSourceRasterTimes(schedBlock, (Time)object.multiply(d));
            SBGeneratorTemplate.enforceMinimumOnSourceTimePerSB(schedBlock);
            int n = bl2 ? 99 : TotalPowerIntegrationTimeCalculator.getTPSBExecutionCount(schedBlock, (Time)object, scienceGoal, list);
            schedBlock.getSchedBlockControl().setExecutionCount(n);
        }
        try {
            this.reviseCheckSourceObservingParameters(schedBlock, scienceGoal);
        }
        catch (SchedBlock.UnableToFindParentScienceGoalException unableToFindParentScienceGoalException) {
            this.logger.warning("Unable to adjust check source cycle: " + unableToFindParentScienceGoalException);
        }
        this.setEstimatedTimeForSBInOUS(schedBlock, (ObservingTimeCalculator)object3, requestedArray);
        try {
            object = new ScienceParametersSensitivityCalculator();
            ((ScienceParametersSensitivityCalculator)object).setScienceParametersSensitivity(schedBlock, requestedArray, (ObservingTimeCalculator)object3, scienceGoal, this.piDefinedScienceGoal);
        }
        catch (ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException unableToDetermineSensitivityException) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).warning("Error when determining the sensitivity: " + unableToDetermineSensitivityException.getMessage());
        }
        this.copyExecutiveSharesIntoSB(scienceGoal, schedBlock);
        if (this.isSBGenerationUserInitiated) {
            StaleSBDetector.getInstance().setSBInSyncWithGeneratingSG(schedBlock, this.piDefinedScienceGoal);
        }
    }

    public void copyExecutiveSharesIntoSB(ScienceGoal scienceGoal, SchedBlock schedBlock) {
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            this.copyExecutiveSharesIntoSBs(schedBlock, obsProposal);
        }
        catch (UnknownEntityException unknownEntityException) {
            String string = "Unable to copy across executive fractions to SB : " + unknownEntityException.getMessage();
            Log.logger(ScienceGoalSchedBlockGenerator.class).warning(string);
            throw new WizardSBGenerationException(string);
        }
        this.copyPhase1ParametersToSB(schedBlock, scienceGoal);
    }

    public void setEstimatedTimeForSBInOUS(SchedBlock schedBlock, ObservingTimeCalculator observingTimeCalculator, RequestedArray requestedArray) {
        Time time = null;
        try {
            time = schedBlock.isTotalPowerAmpcalSB() ? Time.createTime((double)45.0, (String)Time.UNIT_MIN) : observingTimeCalculator.getTotalRequestedTime(requestedArray.getArray(), true, schedBlock.is12mCompactArraySB(), true);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).info("Unable to post-process SBs : " + invalidObsProgramParametersException.getMessage());
            throw new WizardSBGenerationException(invalidObsProgramParametersException.getMessage());
        }
        schedBlock.getObsUnitControl().getEstimatedExecutionTime().setContentAndUnit((ValueUnitPair)time.convertToFriendlyUnit());
    }

    private void copyPhase1ParametersToSB(SchedBlock schedBlock, ScienceGoal scienceGoal) {
        Object object;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        if (schedBlock.getSbGenerationContext().isVLBI()) {
            schedulingConstraints.setScienceGoalLargestAngularScale(Angle.createAngle((double)1.0, (String)Angle.UNIT_MAS));
            schedulingConstraints.setScienceGoalDesiredResolution(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
        } else {
            object = Angle.createAngle((double)performanceParameters.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
            schedulingConstraints.setScienceGoalLargestAngularScale((Angle)((Object)object));
            Angle angle = Angle.createAngle((double)performanceParameters.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
            schedulingConstraints.setScienceGoalDesiredResolution(angle);
        }
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            schedulingConstraints.addNominalConfiguration("TP");
        } else if (schedBlock.isACA7mArraySB()) {
            schedulingConstraints.addNominalConfiguration("7M");
        } else if (schedBlock.is12mCompactArraySB() || schedBlock.is12mExtendedArraySB()) {
            object = null;
            try {
                object = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                String string = "Unable to determine configurations : " + invalidObsProgramParametersException.getMessage();
                Log.logger(ScienceGoalSchedBlockGenerator.class).info(string);
                throw new WizardSBGenerationException(string);
            }
            assert (object != null);
            Collections.sort(object);
            if (schedBlock.is12mCompactArraySB()) {
                object.stream().forEach(configurationSet -> configurationSet.getTM2Configuration().ifPresent(configuration -> schedulingConstraints.addNominalConfiguration(configuration.getName())));
            } else {
                object.stream().forEach(configurationSet -> configurationSet.getTM1Configuration().ifPresent(configuration -> schedulingConstraints.addNominalConfiguration(configuration.getName())));
            }
        } else {
            throw new WizardSBGenerationException("Unable to determine type of SB");
        }
    }

    private void copyExecutiveSharesIntoSBs(SchedBlock schedBlock, ObsProposal obsProposal) {
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        if (obsProposal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProposal");
        }
        ProposalFeedback proposalFeedback = obsProposal.getProposalFeedback();
        if (proposalFeedback != null) {
            TimeAllocationBreakdown timeAllocationBreakdown = schedBlock.getTimeAllocationBreakdown();
            timeAllocationBreakdown.clearExecutiveFraction();
            for (String string : ExecutiveFraction.getKnownNameList()) {
                ExecutiveFraction executiveFraction = proposalFeedback.getTimeAllocationBreakdown().getExecutiveFraction(string);
                timeAllocationBreakdown.addExecutiveFraction(executiveFraction.deepCopy());
            }
        }
    }

    private void reviseCheckSourceObservingParameters(SchedBlock schedBlock, ScienceGoal scienceGoal) throws SchedBlock.UnableToFindParentScienceGoalException {
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            return;
        }
        if (PhaseCalIntermediateTarget.HIGHBANDS.contains(scienceGoal.getSpectralSetupParameters().getReceiverBand())) {
            return;
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            Time time = Time.createTime();
            Time time2 = null;
            Time time3 = null;
            Target target = null;
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                Target target2 = orderedTarget.getTarget();
                for (ScienceParameters scienceParameters : target2.getScienceParametersList()) {
                    time.aggregate(scienceParameters.getIntegrationTime().getTime());
                }
                if (target2.hasPhaseCalParameters()) {
                    time2 = target2.getPhaseCalParametersList()[0].getCycleTime();
                    time3 = target2.getPhaseCalParametersList()[0].getSubScanDuration();
                }
                if (!target2.hasCheckSourceCalParameters()) continue;
                target = target2;
            }
            if (time.isZero() || time2 == null || target == null) continue;
            time = (Time)time.multiply(0.3333333333333333);
            Time time4 = (Time)((Time)((Time)time2.plus((AbstractDoubleWithUnit)Time.createTimeSec(7.0))).plus((AbstractDoubleWithUnit)time3)).multiply(3.0);
            CheckSourceCalParameters checkSourceCalParameters = target.getCheckSourceCalParametersList()[0];
            if (time4.isGreaterThan((AbstractDoubleWithUnit)time)) {
                checkSourceCalParameters.setCycleTime(time4);
                continue;
            }
            checkSourceCalParameters.setCycleTime(time);
        }
    }

    private ObsUnitSet findOUS(ObsUnitSet obsUnitSet, SBGeneratorTemplate.SchedBlockType schedBlockType) throws UnknownEntityException {
        ObsUnitSetComponent obsUnitSetComponent2;
        if (SBGeneratorTemplate.SchedBlockType.TPSCIENCE.equals((Object)schedBlockType)) {
            throw new RuntimeException("There can be multiple TP science SBs: this method cannot support that");
        }
        ObsUnitSet obsUnitSet2 = null;
        for (ObsUnitSetComponent obsUnitSetComponent2 : obsUnitSet.getSchedBlock()) {
            if (!obsUnitSetComponent2.getSbGenerationContext().getSBType().equals((Object)schedBlockType)) continue;
            return obsUnitSet;
        }
        ObsUnitSetComponent[] obsUnitSetComponentArray = obsUnitSet.getObsUnitSet();
        int n = obsUnitSetComponentArray.length;
        for (int i = 0; i < n && (obsUnitSet2 = this.findOUS((ObsUnitSet)(obsUnitSetComponent2 = obsUnitSetComponentArray[i]), schedBlockType)) == null; ++i) {
        }
        return obsUnitSet2;
    }

    void setCorrelatorTimingsToTDMDefaults() {
        if (this.piDefinedScienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (this.rootOUS == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsUnitSet");
        }
        SpectralSetupParameters spectralSetupParameters = this.piDefinedScienceGoal.getSpectralSetupParameters();
        if (!spectralSetupParameters.isSpectralLine()) {
            return;
        }
        boolean bl = true;
        for (ScienceSpectralWindow targetArray : spectralSetupParameters.getScienceSpectralWindow()) {
            if (targetArray.isModeFilterTDM()) continue;
            bl = false;
            break;
        }
        if (bl) {
            ArrayList arrayList = new ArrayList();
            SchedBlockWorker.findSBsUnderOUS((List<SchedBlock>)arrayList, this.rootOUS);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                SchedBlock schedBlock = (SchedBlock)iterator.next();
                if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) continue;
                for (Target target : schedBlock.getTarget()) {
                    if (!target.hasScienceParameters()) continue;
                    SpectralSpecFactory.calculateTDMTimeAndDurations(true, target.getSpectralSpec(), schedBlock.getSbGenerationContext());
                }
            }
        }
    }

    public synchronized void adjustTOSInSBsToMatchRequestedMinimumExecutionTime(Time time, Time time2, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) throws UnknownEntityException, InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        time2 = time2.isLessThanOrEqualTo((AbstractDoubleWithUnit)Time.createTime((double)10.0, (String)Time.UNIT_H)) ? (Time)time2.multiply(1.04) : (Time)time2.multiply(1.08);
        Log.logger(SchedBlockWorker.class).fine("ObsUnit : " + obsUnitSet + " project execution time : ");
        Time time3 = (Time)time2.minus((AbstractDoubleWithUnit)time);
        for (SchedBlock schedBlock : obsUnitSet.getSchedBlock()) {
            Object object;
            Object object22;
            Object object32;
            RequestedArray requestedArray;
            EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = SchedBlockWorker.determineSBGenerationSchema(scienceGoal, schedBlock);
            Time time4 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
            RequestedArray requestedArray2 = requestedArray = scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
            if (!schedBlock.getObsUnitControl().getArrayRequested().equals(requestedArray.getType())) continue;
            Integer scienceParametersArray = 0;
            IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource();
            Log.logger(SchedBlockWorker.class).fine("Re-adjusting the execution time of the SB : " + schedBlock.getEntityID());
            HashMap<String, ScienceParameters> hashMap = new HashMap<String, ScienceParameters>();
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                for (Object object32 : observingGroup.getOrderedTarget()) {
                    Target target = object32.getTarget();
                    if (!target.hasScienceParameters() || !((ScienceParameters)((Object)(object22 = target.getScienceParametersList()[0]))).isIntegrationTimeChangeable()) continue;
                    Integer n = scienceParametersArray;
                    Integer n2 = scienceParametersArray = Integer.valueOf(scienceParametersArray + 1);
                    for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                        intTimeSource = (IntTimeSource)intTimeSource.plus((AbstractDoubleWithUnit)scienceParameters.getIntegrationTime());
                        if (hashMap.containsKey(scienceParameters.getEntityPartId())) continue;
                        hashMap.put(scienceParameters.getEntityPartId(), scienceParameters);
                    }
                }
            }
            boolean bl = true;
            if (scienceParametersArray > 0) {
                this.apportionAdditionalTOSToScienceParameters(enumSet, scienceParametersArray, intTimeSource, hashMap);
            } else {
                bl = false;
            }
            int n = schedBlock.getSchedBlockControl().getExecutionCount();
            Time time5 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
            Time object52 = (Time)time5.minus((AbstractDoubleWithUnit)time4);
            if (object52.isLessThan((AbstractDoubleWithUnit)time3)) {
                object = (Time)time3.minus((AbstractDoubleWithUnit)object52);
                int n3 = (int)Math.ceil(((Time)object).getContentInUnits(Time.UNIT_S) / (time5.getContentInUnits(Time.UNIT_S) / (double)n));
                schedBlock.getSchedBlockControl().setExecutionCount(n + n3);
                if (!bl) continue;
                Time time6 = (Time)Time.createTimeSec(30.0).divide(hashMap.size());
                object32 = Time.createTimeSec(0.0);
                boolean bl2 = false;
                block4: while (!bl2 && SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal).isGreaterThan((AbstractDoubleWithUnit)time2)) {
                    object22 = hashMap.keySet().iterator();
                    while (object22.hasNext()) {
                        String string = (String)object22.next();
                        ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(string));
                        Time time7 = (Time)scienceParameters.getIntegrationTime().getTime().deepCopy().minus((AbstractDoubleWithUnit)time6);
                        if (time7.isGreaterThan((AbstractDoubleWithUnit)object32)) {
                            scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time7.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                            continue;
                        }
                        bl2 = true;
                        continue block4;
                    }
                }
                continue;
            }
            if (!bl) continue;
            object = (Time)Time.createTimeSec(30.0).divide(hashMap.size());
            Time time8 = Time.createTimeSec(0.0);
            int n4 = 0;
            object32 = new HashMap();
            block6: while (n4 == 0 && SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal).isGreaterThan((AbstractDoubleWithUnit)time2)) {
                for (Object object22 : hashMap.keySet()) {
                    ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(object22));
                    Time time9 = (Time)scienceParameters.getIntegrationTime().getTime().minus((AbstractDoubleWithUnit)object);
                    if (time9.isGreaterThan((AbstractDoubleWithUnit)time8)) {
                        object32.put(object22, scienceParameters.getIntegrationTime());
                        scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time9.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                        continue;
                    }
                    n4 = 1;
                    continue block6;
                }
            }
            if (!SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal).isLessThan((AbstractDoubleWithUnit)time2)) continue;
            assert (object32.size() != 0);
            for (Object object22 : hashMap.keySet()) {
                ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(object22));
                scienceParameters.setIntegrationTime((IntTimeSource)((Object)object32.get(object22)));
            }
        }
    }

    private void apportionAdditionalTOSToScienceParameters(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, Integer n, IntTimeSource intTimeSource, Map<String, ScienceParameters> map) {
        double d = SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet);
        Time time = (Time)((Time)SchedBlockExpert.NOMINAL_SB_LENGTH.divide(d)).minus((AbstractDoubleWithUnit)intTimeSource.getTime());
        Time time2 = (Time)time.divide(n.intValue());
        for (String string : map.keySet()) {
            ScienceParameters scienceParameters = map.get(string);
            Time time3 = (Time)scienceParameters.getIntegrationTime().getTime().plus((AbstractDoubleWithUnit)time2);
            scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time3.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
        }
    }

    public synchronized void adjustTOSInSBToMatchRequestedMinimumExecutionTime(Time time, SchedBlock schedBlock, ScienceGoal scienceGoal) throws UnknownEntityException, InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        RequestedArray requestedArray;
        Time time2 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
        if (time2.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)time)) {
            return;
        }
        time = (Time)time.multiply(1.34);
        Time time3 = (Time)time.minus((AbstractDoubleWithUnit)time2);
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = SchedBlockWorker.determineSBGenerationSchema(scienceGoal, schedBlock);
        RequestedArray requestedArray2 = requestedArray = scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
        if (schedBlock.getObsUnitControl().getArrayRequested().equals(requestedArray.getType())) {
            Time time4;
            Object object;
            int n;
            Object object2;
            int n2 = 0;
            IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource();
            Log.logger(SchedBlockWorker.class).fine("Re-adjusting the execution time of the SB : " + schedBlock.getEntityID());
            HashMap<String, ScienceParameters> hashMap = new HashMap<String, ScienceParameters>();
            for (Target object42 : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
                object2 = object42.getScienceParametersList()[0];
                if (!object2.isIntegrationTimeChangeable()) continue;
                ++n2;
                for (ScienceParameters scienceParameters : object42.getScienceParametersList()) {
                    intTimeSource = (IntTimeSource)intTimeSource.plus((AbstractDoubleWithUnit)scienceParameters.getIntegrationTime());
                    if (hashMap.containsKey(scienceParameters.getEntityPartId())) continue;
                    hashMap.put(scienceParameters.getEntityPartId(), scienceParameters);
                }
            }
            boolean bl = true;
            if (n2 > 0) {
                this.apportionAdditionalTOSToScienceParameters(enumSet, n2, intTimeSource, hashMap);
            } else {
                bl = false;
            }
            Time time5 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
            object2 = (Time)time5.minus((AbstractDoubleWithUnit)time2);
            HashMap hashMap2 = new HashMap();
            Time time6 = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            if (object2.isLessThan((AbstractDoubleWithUnit)time3)) {
                int time10 = schedBlock.getSchedBlockControl().getExecutionCount();
                Time time7 = (Time)time3.minus((AbstractDoubleWithUnit)object2);
                n = (int)Math.ceil(time7.getContentInUnits(Time.UNIT_S) / (time5.getContentInUnits(Time.UNIT_S) / (double)time10));
                schedBlock.getSchedBlockControl().setExecutionCount(time10 + n);
                if (bl) {
                    Time time8 = Time.createTimeSec(0.0);
                    boolean bl2 = false;
                    object = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                    Time time9 = Time.createTimeSec(30.0);
                    Time time11 = Time.createTimeSec(10.0);
                    while (!bl2 && object.isGreaterThan((AbstractDoubleWithUnit)time)) {
                        boolean bl3 = ((Time)object.minus((AbstractDoubleWithUnit)time)).isGreaterThan((AbstractDoubleWithUnit)time6);
                        time4 = (Time)(bl3 ? time9 : time11).divide(hashMap.size());
                        for (String string : hashMap.keySet()) {
                            ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(string));
                            Time time12 = (Time)scienceParameters.getIntegrationTime().getTime().minus((AbstractDoubleWithUnit)time4);
                            if (time12.isGreaterThan((AbstractDoubleWithUnit)time8)) {
                                hashMap2.put(string, scienceParameters.getIntegrationTime());
                                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time12.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                                continue;
                            }
                            bl2 = true;
                            break;
                        }
                        object = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                    }
                }
            } else if (bl) {
                Time time13 = (Time)Time.createTimeSec(30.0).divide(hashMap.size());
                Time time14 = Time.createTimeSec(0.0);
                n = 0;
                block4: while (n == 0 && ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal).isGreaterThan((AbstractDoubleWithUnit)time)) {
                    for (String string : hashMap.keySet()) {
                        object = (ScienceParameters)((Object)hashMap.get(string));
                        time4 = (Time)object.getIntegrationTime().getTime().minus((AbstractDoubleWithUnit)time13);
                        if (time4.isGreaterThan((AbstractDoubleWithUnit)time14)) {
                            hashMap2.put(string, object.getIntegrationTime());
                            object.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time4.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                            continue;
                        }
                        n = 1;
                        continue block4;
                    }
                }
            }
            if (ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal).isLessThan((AbstractDoubleWithUnit)time)) {
                assert (hashMap2.size() != 0);
                for (String string : hashMap.keySet()) {
                    ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(string));
                    scienceParameters.setIntegrationTime((IntTimeSource)((Object)hashMap2.get(string)));
                }
            }
        }
    }

    private void walshSwitching90DegreePostProcessing(SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            return;
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        if (!sBGenerationContext.getGoal().getSpectralSetupParameters().isWalshSwitching()) {
            return;
        }
        Walsh90DegConfiguratorFactory.Walsh90DegSpectralSpecConfigurator walsh90DegSpectralSpecConfigurator = null;
        HashSet<SpectralSpec> hashSet = new HashSet<SpectralSpec>();
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            SpectralSpec spectralSpec = target.getSpectralSpec();
            if (!spectralSpec.getAbstractCorrelatorConfiguration().getEnable90DegreeWalshFunction()) continue;
            hashSet.add(spectralSpec);
        }
        for (Target target : schedBlock.getAllTargets(Optional.empty())) {
            if (walsh90DegSpectralSpecConfigurator == null) {
                walsh90DegSpectralSpecConfigurator = Walsh90DegConfiguratorFactory.getConfigurator(target.getSpectralSpec().getAbstractCorrelatorConfiguration());
            }
            walsh90DegSpectralSpecConfigurator.configureObservingParameters(target, sBGenerationContext);
            if (!hashSet.contains(target.getSpectralSpec())) continue;
            walsh90DegSpectralSpecConfigurator.configureFieldSource(target, sBGenerationContext);
        }
    }

    private SchedBlockPostProcessor(Builder builder) {
        this.isSBGenerationUserInitiated = builder.isSBGenerationUserInitiated;
        this.piDefinedScienceGoal = builder.userDefinedScienceGoal;
        this.rootOUS = builder.rootOUS;
    }

    public static class Builder {
        private boolean isSBGenerationUserInitiated;
        private ScienceGoal userDefinedScienceGoal;
        private ObsUnitSet rootOUS;

        public Builder isSBGenerationUserInitiated(boolean bl) {
            this.isSBGenerationUserInitiated = bl;
            return this;
        }

        public Builder userDefinedScienceGoal(ScienceGoal scienceGoal) {
            this.userDefinedScienceGoal = scienceGoal;
            return this;
        }

        public Builder rootOUS(ObsUnitSet obsUnitSet) {
            this.rootOUS = obsUnitSet;
            return this;
        }

        public SchedBlockPostProcessor build() {
            return new SchedBlockPostProcessor(this);
        }
    }

    public class SPWLineMatch {
        private ExpectedSpectralLine line;
        private SpectralWindowI window;

        public SPWLineMatch(ExpectedSpectralLine expectedSpectralLine) {
            this.setLine(expectedSpectralLine);
        }

        public ExpectedSpectralLine getLine() {
            return this.line;
        }

        public void setLine(ExpectedSpectralLine expectedSpectralLine) {
            this.line = expectedSpectralLine;
        }

        public SpectralWindowI getWindow() {
            return this.window;
        }

        public void setWindow(SpectralWindowI spectralWindowI) {
            this.window = spectralWindowI;
        }
    }
}

