/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.annotations.TargetContext;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationRequirements;
import alma.obsprep.bo.obsproject.NonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.P2GAlerter;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParameters;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.KeywordValue;
import alma.valuetypes.Latitude;
import alma.valuetypes.Length;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jsky.coords.WorldCoords;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class SchedBlockWorker {
    private static CacheAccess<Integer, ObsUnitSet> sbOutputCache = JCS.getInstance((String)"obsUnitSetCache");
    private static final String mode_12m = "Standard Interferometry";
    private static final String mode_Tp = "Standard Single Dish";
    private static final String mode_TPSolar = "Solar Single Dish";
    private static String mode_12mSolar = "Solar Interferometry";

    public static void setupSchedBlock(ScienceGoal scienceGoal, SchedBlock schedBlock, RequestedArray requestedArray, Double d, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws WizardSBGenerationException {
        ObsUnitControl obsUnitControl = schedBlock.getObsUnitControl();
        SchedBlockExpert schedBlockExpert = SchedBlockExpert.getInstance(scienceGoal);
        try {
            SchedBlockWorker.setupObsUnitControl(schedBlockExpert, obsUnitControl, requestedArray);
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
            throw new WizardSBGenerationException(exception.getMessage(), exception);
        }
        SchedBlockWorker.setupSBMode(schedBlock, requestedArray);
        SchedBlockWorker.setupExpertParameters(scienceGoal, schedBlock);
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        SchedBlockWorker.setupSchedulingConstraints(scienceGoal, schedulingConstraints, schedBlock);
        String string = schedBlock.generateName(scienceGoal);
        schedBlock.setName(string);
        Preconditions preconditions = schedBlock.getPreconditions();
        SchedBlockWorker.setupPreconditions(scienceGoal, preconditions);
        SchedBlockControl schedBlockControl = schedBlock.getSchedBlockControl();
        try {
            SchedBlockWorker.applyAntennaTOSMultiplier(scienceGoal, schedBlock, d, requestedArray);
            SchedBlockWorker.setupSchedBlockControl(schedBlockExpert, schedBlockControl, requestedArray, enumSet);
            if (!RequestedArray.TP.equals((Object)requestedArray)) {
                SchedBlockWorker.quantizeScienceIntegrationTimes(schedBlock, schedBlockExpert, enumSet);
            }
        }
        catch (UnableToFindSolutionException | SourceNeverVisibleException | InvalidFrequencyException exception) {
            throw new WizardSBGenerationException(exception.getMessage(), exception);
        }
        obsUnitControl.setMaximumTime(schedBlockControl.calcMaxTime());
    }

    private static void setupExpertParameters(ScienceGoal scienceGoal, SchedBlock schedBlock) {
        Frequency frequency;
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: goal");
        }
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        if (scienceGoal.getSpectralSetupParameters().getPolarisation().equals(SpectralSetupParameters.POLARISATION_FULL)) {
            object = KeywordValue.createKeywordValue();
            object.setKeyword("SessionControl");
            object.setValue("1");
            schedBlock.addExpertParameter((KeywordValue)((Object)object));
        }
        if (!schedBlock.isTotalPowerScienceSB() && !schedBlock.isTotalPowerAmpcalSB() && (frequency = ((NonOverlappingBandwidthCalculator)(object = NonOverlappingBandwidthCalculator.getCalculator(scienceGoal.getSpectralSetupParameters(), scienceGoal.getKeyTargetParameters()))).calculatePerPoln()).isLessThan((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(0.9375))) {
            KeywordValue keywordValue = KeywordValue.createKeywordValue();
            keywordValue.setKeyword("useDGC");
            keywordValue.setValue("1");
            schedBlock.addExpertParameter(keywordValue);
        }
    }

    private static void applyAntennaTOSMultiplier(ScienceGoal scienceGoal, SchedBlock schedBlock, Double d, RequestedArray requestedArray) {
        if (!RequestedArray.TP.equals((Object)requestedArray)) {
            if (d == 1.0) {
                return;
            }
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                    Target target = orderedTarget.getTarget();
                    if (!target.hasScienceParameters()) continue;
                    for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                        IntTimeSource intTimeSource = scienceParameters.getIntegrationTime().deepCopy();
                        scienceParameters.setIntegrationTime((IntTimeSource)intTimeSource.multiply(d));
                    }
                }
            }
        }
    }

    public static void quantizeScienceIntegrationTimes(SchedBlock schedBlock, SchedBlockExpert schedBlockExpert, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws InvalidFrequencyException, SourceNeverVisibleException, UnableToFindSolutionException {
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
        int n = SchedBlockExpert.calcExecutionCount(SchedBlockExpert.getTotalTOSForSB(schedBlock).getTime(), enumSet);
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                if (hashSet.contains((Object)scienceParameters)) continue;
                IntTimeSource intTimeSource = scienceParameters.getIntegrationTime().deepCopy();
                scienceParameters.setIntegrationTime((IntTimeSource)intTimeSource.divide(n));
                hashSet.add(scienceParameters);
            }
        }
    }

    static double getMaxTimeOnSourcePerSBExec(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        double d = ((Time)SchedBlockExpert.NOMINAL_SB_LENGTH.divide(SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet))).getContentInUnits(Time.UNIT_S);
        assert (d > 0.0);
        return d;
    }

    private static void setupSBMode(SchedBlock schedBlock, RequestedArray requestedArray) {
        String string = mode_12m;
        boolean bl = schedBlock.getSbGenerationContext().isSolar();
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            string = mode_Tp;
            if (bl) {
                string = mode_TPSolar;
            }
        } else if (RequestedArray.TWELVE_M.equals((Object)requestedArray) && bl) {
            string = mode_12mSolar;
        }
        schedBlock.setModeName(string);
        ObservingModeExpert observingModeExpert = ObservingModeExpert.getInstance();
        observingModeExpert.updateSchedBlock(schedBlock, string);
    }

    private static void setupSchedulingConstraints(ScienceGoal scienceGoal, SchedulingConstraints schedulingConstraints, SchedBlock schedBlock) {
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        schedulingConstraints.setRepresentativeFrequency(frequency.deepCopy());
        schedulingConstraints.setDynamicRange(performanceParameters.getDesiredDynamicRange());
        HashSet<String> hashSet = new HashSet<String>();
        for (SpectralSpec spectralSpec : schedBlock.getSpectralSpec()) {
            hashSet.add(spectralSpec.getReceiverBand().getName());
        }
        schedulingConstraints.setRequiredReceiverBands(hashSet.toArray(new String[hashSet.size()]));
    }

    private static void setupPreconditions(ScienceGoal scienceGoal, Preconditions preconditions) {
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        Latitude latitude = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates().getLatitude();
        int n = WaterVaporColumns.wvindexSelector(frequency, latitude, Optional.ofNullable(scienceGoal.getSpectralSetupParameters().getReceiverBand()));
        String string = WaterVaporColumns.getWVIndexLabel(n);
        double d = 0.0;
        Pattern pattern = Pattern.compile("(\\d+\\.\\d+)[ ]*mm.*");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new WizardSBGenerationException("Programming error - unable to parse pmvc values: " + string);
        }
        d = Double.parseDouble(matcher.group(1));
        preconditions.getWeatherConstraints().getMaxPWVC().setContent(d);
        preconditions.getWeatherConstraints().getMaxPWVC().setUnit(Length.UNIT_MM);
        boolean bl = !scienceGoal.getSpectralSetupParameters().getPolarisation().equals("1");
        preconditions.setPolarizationCalValid(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupSchedBlockControl(SchedBlockExpert schedBlockExpert, SchedBlockControl schedBlockControl, RequestedArray requestedArray, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws InvalidFrequencyException, SourceNeverVisibleException, UnableToFindSolutionException {
        Time time = schedBlockExpert.getNominalSBLengthPolicy(requestedArray);
        time.convertToFriendlyUnit();
        SchedBlockControl schedBlockControl2 = schedBlockControl;
        synchronized (schedBlockControl2) {
            schedBlockControl.getSBMaximumTime().setContentAndUnit((ValueUnitPair)time);
            Time time2 = SchedBlockExpert.getTotalTOSForSB((SchedBlock)schedBlockControl.getParent()).getTime();
            if (RequestedArray.TWELVE_M.equals((Object)requestedArray)) {
                Integer n = SchedBlockExpert.calcExecutionCount(time2, enumSet);
                schedBlockControl.setExecutionCount(n);
            } else if (requestedArray.equals((Object)RequestedArray.ACA) || requestedArray.equals((Object)RequestedArray.SEVEN_M)) {
                Time time3 = (Time)SchedBlockExpert.NOMINAL_SB_LENGTH.divide(SchedBlockExpert.NOMINAL_TOTAL_TO_SCIENCE_ACA_7M_RATIO);
                schedBlockControl.setExecutionCount((int)Math.ceil(time2.getContentInUnits(Time.UNIT_S) / time3.getContentInUnits(Time.UNIT_S)));
            } else if (!requestedArray.equals((Object)RequestedArray.TP)) {
                throw new WizardSBGenerationException("Unknown array encountered " + (Object)((Object)requestedArray));
            }
        }
    }

    private static void setupObsUnitControl(SchedBlockExpert schedBlockExpert, ObsUnitControl obsUnitControl, RequestedArray requestedArray) throws InvalidFrequencyException, SourceNeverVisibleException {
        CalibrationRequirements calibrationRequirements = obsUnitControl.getCalibrationRequirements();
        Angle angle = Angle.createAngle((double)1.0, (String)Angle.UNIT_ARCSEC);
        calibrationRequirements.setPointingAccuracy(angle);
        calibrationRequirements.setBandpassAccuracy(0.1);
        calibrationRequirements.setPolarizationAccuracy(0.1);
        obsUnitControl.setArrayRequested(requestedArray.getType());
    }

    public static EnumSet<SBGeneratorTemplate.SBGenerationSchema> determineSBGenerationSchema(ScienceGoal scienceGoal, SchedBlock schedBlock) throws UnknownEntityException {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = SchedBlockWorker.determineSBGenerationSchema(scienceGoal);
        if (schedBlock.getObsUnitControl().getArrayRequested().equals(RequestedArray.SEVEN_M.getType()) || schedBlock.getObsUnitControl().getArrayRequested().equals(RequestedArray.ACA.getType())) {
            SchedBlockWorker.addMinorSBGenerationSchema(enumSet, SBGeneratorTemplate.SBGenerationSchema.ACA_7M);
        }
        return enumSet;
    }

    private static void setMajorSBGenerationSchema(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGeneratorTemplate.SBGenerationSchema sBGenerationSchema) {
        enumSet.removeAll((Collection<?>)ImmutableList.of((Object)((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING), (Object)((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN_MULTIPLE_SB), (Object)((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN), (Object)((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD_CYCLE1)));
        enumSet.add(sBGenerationSchema);
    }

    private static void addMinorSBGenerationSchema(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGeneratorTemplate.SBGenerationSchema sBGenerationSchema) {
        if (sBGenerationSchema.equals((Object)SBGeneratorTemplate.SBGenerationSchema.SOLAR) && enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.VLBI)) {
            return;
        }
        if (sBGenerationSchema.equals((Object)SBGeneratorTemplate.SBGenerationSchema.VLBI) && enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SOLAR)) {
            enumSet.remove((Object)SBGeneratorTemplate.SBGenerationSchema.SOLAR);
        }
        enumSet.add(sBGenerationSchema);
    }

    private static EnumSet<SBGeneratorTemplate.SBGenerationSchema> determineSBGenerationSchema(ScienceGoal scienceGoal) throws UnknownEntityException {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = EnumSet.noneOf(SBGeneratorTemplate.SBGenerationSchema.class);
        SchedBlockWorker.setMajorSBGenerationSchema(enumSet, SBGeneratorTemplate.SBGenerationSchema.STANDARD_CYCLE1);
        if (scienceGoal.isSpectralScan()) {
            SchedBlockWorker.setMajorSBGenerationSchema(enumSet, SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN);
        } else if (!scienceGoal.getSpectralSetupParameters().isSingleContinuumSkyFrequency()) {
            Collection<ScienceGoal> collection = null;
            try {
                collection = ScienceGoalSchedBlockGenerator.splitByTuning(scienceGoal);
            }
            catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings | IndexOutOfBoundsException exception) {
                Log.logger(SchedBlockWorker.class).warning("Unable to split by tuning " + exception.getMessage());
                throw new WizardSBGenerationException(exception);
            }
            assert (collection != null);
            if (collection.size() > 1) {
                SchedBlockWorker.setMajorSBGenerationSchema(enumSet, SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING);
            }
        }
        if (scienceGoal.isPolarizationObservation()) {
            SchedBlockWorker.addMinorSBGenerationSchema(enumSet, SBGeneratorTemplate.SBGenerationSchema.POLARISATION);
        }
        if (scienceGoal.getObsProposal().isVLBI()) {
            SchedBlockWorker.addMinorSBGenerationSchema(enumSet, SBGeneratorTemplate.SBGenerationSchema.VLBI);
        }
        if (scienceGoal.isSolarScienceGoal()) {
            SchedBlockWorker.addMinorSBGenerationSchema(enumSet, SBGeneratorTemplate.SBGenerationSchema.SOLAR);
        }
        assert (!enumSet.containsAll((Collection<?>)ImmutableList.of((Object)((Object)SBGeneratorTemplate.SBGenerationSchema.SOLAR), (Object)((Object)SBGeneratorTemplate.SBGenerationSchema.VLBI)))) : "VLBI and solar together is not permitted";
        return enumSet;
    }

    public static void renameMultipleTuningObservingGroups(SchedBlock schedBlock, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        String string;
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING) || enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                string = observingGroup.getName();
                if (string.startsWith(ObservingGroupManager.ObservingGroupType.CALIBRATOR.getGroupLabelPrefix())) {
                    observingGroup.setName("One time calibrators");
                }
                if (!string.startsWith(ObservingGroupManager.ObservingGroupType.SCIENCE.getGroupLabelPrefix())) continue;
                observingGroup.setName(string.replace(ObservingGroupManager.ObservingGroupType.SCIENCE.getGroupLabelPrefix(), "Tuning Group"));
            }
        }
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD_CYCLE1)) {
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                string = observingGroup.getName();
                if (string.startsWith(ObservingGroupManager.ObservingGroupType.CALIBRATOR.getGroupLabelPrefix())) {
                    observingGroup.setName("Calibrators");
                }
                if (!string.startsWith(ObservingGroupManager.ObservingGroupType.SCIENCE.getGroupLabelPrefix())) continue;
                observingGroup.setName("Science");
            }
        }
    }

    public static EnumSet<SBGeneratorTemplate.SBGenerationSchema> determineSBGenerationSchema(ScienceGoal scienceGoal, RequestedArray requestedArray) throws UnknownEntityException {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = SchedBlockWorker.determineSBGenerationSchema(scienceGoal);
        if (requestedArray.equals((Object)RequestedArray.ACA) || requestedArray.equals((Object)RequestedArray.SEVEN_M)) {
            enumSet.add(SBGeneratorTemplate.SBGenerationSchema.ACA_7M);
        }
        return enumSet;
    }

    public static void appendTuningIndicatorToSpectralSpecs(ObsUnitSet obsUnitSet) throws UnknownEntityException {
        for (SchedBlock schedBlock : obsUnitSet.findSchedBlocks()) {
            int n = 0;
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                Iterator<Target> iterator = observingGroup.getAllOrderedTargets(Optional.of(target -> target.hasScienceParameters())).iterator();
                if (iterator.hasNext()) {
                    Target target2 = iterator.next();
                    target2.getSpectralSpec().setName(target2.getSpectralSpec().getName() + "_" + n);
                }
                ++n;
            }
        }
    }

    public static SchedBlock findSBUnderScienceGoal(ScienceGoal scienceGoal, SBGeneratorTemplate.SchedBlockType schedBlockType) throws SBNotFoundException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (schedBlockType == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: schedBlockType");
        }
        SchedBlock schedBlock = SchedBlockWorker.locateSB(scienceGoal.getObsUnitSet(), schedBlockType);
        if (schedBlock == null) {
            throw new SBNotFoundException();
        }
        return schedBlock;
    }

    private static SchedBlock locateSB(ObsUnitSet obsUnitSet, SBGeneratorTemplate.SchedBlockType schedBlockType) {
        Object object;
        try {
            for (SchedBlock obsUnitSetComponent : obsUnitSet.getSchedBlock()) {
                object = RequestedArray.valueOf(ControlBlockTArrayRequestedType.valueOf((String)obsUnitSetComponent.getObsUnitControl().getArrayRequested()));
                if (!object.equals((Object)schedBlockType.getArrayType())) continue;
                if (object.equals((Object)RequestedArray.TP)) {
                    if (schedBlockType.equals((Object)SBGeneratorTemplate.SchedBlockType.TPAMPCAL) && obsUnitSetComponent.isTotalPowerAmpcalSB()) {
                        return obsUnitSetComponent;
                    }
                    if (!schedBlockType.equals((Object)SBGeneratorTemplate.SchedBlockType.TPSCIENCE) || !obsUnitSetComponent.isTotalPowerScienceSB()) continue;
                    return obsUnitSetComponent;
                }
                if (object.equals((Object)RequestedArray.TWELVE_M)) {
                    if (!schedBlockType.equals((Object)obsUnitSetComponent.getSbGenerationContext().getSBType())) continue;
                    return obsUnitSetComponent;
                }
                return obsUnitSetComponent;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return null;
        }
        for (ObsUnitSetComponent obsUnitSetComponent : obsUnitSet.getObsUnitSet()) {
            object = SchedBlockWorker.locateSB((ObsUnitSet)obsUnitSetComponent, schedBlockType);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void quantizeIntegrationTimesOnSourceBySubscanDuration(SchedBlock schedBlock, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws UnableToQuantizeIntegrationTimeException {
        if (schedBlock.isTotalPowerScienceSB()) {
            return;
        }
        SchedBlock schedBlock2 = schedBlock;
        synchronized (schedBlock2) {
            void var10_33;
            Time time;
            Object object;
            Object object2;
            for (Target target : schedBlock.getTarget()) {
                PointingPattern pointingPattern;
                if (!target.hasScienceParameters() || !target.getFieldSource().getFieldPattern().isPointingPattern() || !(pointingPattern = (PointingPattern)((Object)target.getFieldSource().getFieldPattern())).isDerivedFromRectanglePointingPattern()) continue;
                return;
            }
            HashMap hashMap = new HashMap();
            int n = schedBlock.getSchedBlockControl().getExecutionCount();
            if (n == 0 || n > 5000) {
                Log.logger(SchedBlockWorker.class).info("SB execution count exceeds limits: not running algorithm");
                return;
            }
            if (Log.logger(SchedBlockWorker.class).fine()) {
                for (Target target : schedBlock.getTarget()) {
                    void var10_27;
                    if (!target.hasScienceParameters()) continue;
                    Object object4 = target.getScienceParametersList()[0];
                    if (hashMap.get(object4) == null) {
                        IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource();
                        hashMap.put(object4, intTimeSource);
                    } else {
                        IntTimeSource intTimeSource = (IntTimeSource)((Object)hashMap.get(object4));
                    }
                    IntTimeSource object32 = (IntTimeSource)var10_27.plus(object4.getIntegrationTime().multiply(n));
                    hashMap.put(object4, object32);
                }
                for (IntTimeSource intTimeSource : hashMap.values()) {
                    Log.logger(SchedBlockWorker.class).fine("Unquantized total integration time :" + (Object)((Object)intTimeSource));
                }
            }
            HashMap<ScienceParameters, Time> hashMap2 = new HashMap<ScienceParameters, Time>();
            for (Object object4 : schedBlock.getTarget()) {
                if (!object4.hasScienceParameters()) continue;
                ScienceParameters scienceParameters = object4.getScienceParametersList()[0];
                hashMap2.put(scienceParameters, scienceParameters.getSubScanDuration().deepCopy());
            }
            int n2 = 0;
            Time time2 = Time.createTimeSec(0.0);
            block7: while (!SchedBlockWorker.verifyIntegrationTimesCanBeQuantizedWithExistingSubscanDurations(schedBlock, enumSet)) {
                HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
                for (Target target : schedBlock.getScienceTargets()) {
                    ScienceParameters scienceParameters = target.getScienceParametersList()[0];
                    if (hashSet.contains((Object)scienceParameters)) continue;
                    object2 = target.getSpectralSpec().getAbstractCorrelatorConfiguration().getIntegrationDuration();
                    object = scienceParameters.getSubScanDuration();
                    time = (Time)scienceParameters.getSubScanDuration().minus((AbstractDoubleWithUnit)object2);
                    while (time.isGreaterThan((AbstractDoubleWithUnit)time2) && SchedBlockWorker.getAlignedSubscanDuration(time, target).isEqual((AbstractDoubleWithUnit)object)) {
                        time = (Time)time.minus((AbstractDoubleWithUnit)object2);
                    }
                    if (time.isGreaterThan((AbstractDoubleWithUnit)time2)) {
                        scienceParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(time, target));
                        hashSet.add(scienceParameters);
                        continue;
                    }
                    for (Target target2 : schedBlock.getTarget()) {
                        if (!target2.hasScienceParameters()) continue;
                        ScienceParameters scienceParameters2 = target2.getScienceParametersList()[0];
                        assert (hashMap2.get((Object)scienceParameters2) != null);
                        scienceParameters2.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration((Time)hashMap2.get((Object)scienceParameters2), target));
                    }
                    SchedBlockWorker.increaseNumberOfSBExecs(schedBlock);
                    if (++n2 <= 100) continue block7;
                    Log.logger(SchedBlockWorker.class).warning("Unable to quantize science integration time by subscan duration");
                    throw new UnableToQuantizeIntegrationTimeException();
                }
            }
            Object object3 = schedBlock.getObservingParameters();
            int n3 = ((ObservingParameters[])object3).length;
            boolean bl = false;
            while (var10_33 < n3) {
                ObservingParameters observingParameters = object3[var10_33];
                if (observingParameters instanceof ScienceParameters) {
                    object2 = (ScienceParameters)((Object)observingParameters);
                    object = object2.getIntegrationTime().getTime().deepCopy();
                    time = object2.getIntegrationTime().getTime().deepCopy();
                    double d = object.getContentInUnits(Time.UNIT_S);
                    double d2 = object2.getSubScanDuration().getContentInUnits(Time.UNIT_S);
                    double d3 = Math.ceil(d / d2);
                    object = Time.createTimeSec(d3 * d2 - 0.1);
                    object2.setIntegrationTime(IntTimeSource.createIntTimeSource((double)object.getContentInUnits(Time.UNIT_S), (String)IntTimeSource.UNIT_S));
                    Log.logger(SchedBlockWorker.class).fine("Quantized integration time for science parameters is " + object + " was " + time);
                }
                ++var10_33;
            }
            hashMap.clear();
            if (Log.logger(SchedBlockWorker.class).fine()) {
                void var10_35;
                object3 = schedBlock.getTarget();
                n3 = ((TargetContext[])object3).length;
                boolean bl2 = false;
                while (var10_35 < n3) {
                    TargetContext targetContext = object3[var10_35];
                    if (((Target)targetContext).hasScienceParameters()) {
                        object2 = ((Target)targetContext).getScienceParametersList()[0];
                        if (hashMap.get(object2) == null) {
                            object = IntTimeSource.createIntTimeSource();
                            hashMap.put(object2, object);
                        } else {
                            object = (IntTimeSource)((Object)hashMap.get(object2));
                        }
                        object = (IntTimeSource)object.plus(object2.getIntegrationTime().multiply(n));
                        hashMap.put(object2, object);
                    }
                    ++var10_35;
                }
                for (IntTimeSource intTimeSource : hashMap.values()) {
                    Log.logger(SchedBlockWorker.class).fine("Quantized total integration time " + (Object)((Object)intTimeSource));
                }
            }
        }
    }

    private static void increaseNumberOfSBExecs(SchedBlock schedBlock) {
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
        assert (schedBlock != null);
        int n = schedBlock.getSchedBlockControl().getExecutionCount();
        Log.logger(SchedBlock.class).fine("Incrementing the number of SB executions from " + n + " to " + (n + 1));
        schedBlock.getSchedBlockControl().setExecutionCount(n + 1);
        for (Target target : schedBlock.getTarget()) {
            ScienceParameters scienceParameters;
            if (!target.hasScienceParameters() || hashSet.contains((Object)(scienceParameters = target.getScienceParametersList()[0]))) continue;
            double d = (double)n / ((double)n + 1.0);
            IntTimeSource intTimeSource = (IntTimeSource)scienceParameters.getIntegrationTime().multiply(d);
            Log.logger(SchedBlock.class).fine("Changing int time from " + (Object)((Object)scienceParameters.getIntegrationTime()) + " to " + (Object)((Object)intTimeSource));
            assert (!intTimeSource.isZero());
            scienceParameters.setIntegrationTime(intTimeSource);
            hashSet.add(scienceParameters);
        }
    }

    private static boolean verifyIntegrationTimesCanBeQuantizedWithExistingSubscanDurations(SchedBlock schedBlock, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        Time time = Time.createTime();
        for (Target target : schedBlock.getTarget()) {
            if (!target.hasScienceParameters()) continue;
            ScienceParameters scienceParameters = target.getScienceParametersList()[0];
            double d = scienceParameters.getIntegrationTime().getContentInUnits(IntTimeSource.UNIT_S);
            double d2 = scienceParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
            double d3 = d2 * Math.ceil(d / d2);
            time.aggregate(Time.createTimeSec(d3));
        }
        assert (time.getContent() > 0.0);
        double d = SchedBlockWorker.getMaxTimeOnSourcePerSBExec(enumSet);
        return time.getContentInUnits(Time.UNIT_S) < d;
    }

    public static Time getAlignedSubscanDuration(Time time, Target target) {
        if (time == null) {
            throw new NullPointerException("subscan is null");
        }
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (time.isLessThanOrEqualTo((AbstractDoubleWithUnit)Time.createTimeSec(0.0))) {
            throw new IllegalArgumentException("Subscan duration should be greater than zero");
        }
        SpectralSpec spectralSpec = (SpectralSpec)((Object)target.getAbstractInstrumentSpec());
        assert (spectralSpec != null);
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
        if (abstractCorrelatorConfiguration == null) {
            return time;
        }
        CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
        double d = time.getContentInUnits(Time.UNIT_S);
        assert (d >= 0.0);
        double d2 = abstractCorrelatorConfiguration.getIntegrationDuration().getContentInUnits(Time.UNIT_S);
        assert (d2 >= 0.0);
        double d3 = correlatorExpert.calcSubscanDuration(d, d2, null);
        assert (d3 >= 0.0);
        return Time.createTimeSec(d3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMosaicPointingsOverlapping(TargetParameters targetParameters) throws InfiniteBandwithException, NotAMosaicException {
        Object object;
        boolean bl;
        if (targetParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: targetParameters");
        }
        if (targetParameters.getFieldSinglePointCount() > 1 && !targetParameters.isMosaic()) {
            throw new NotAMosaicException();
        }
        if (targetParameters.getFieldSinglePointCount() == 1) {
            return true;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        SpatialVisualParameters spatialVisualParameters = targetParameters.getSpatialVisualParameters();
        ScienceGoal scienceGoal = targetParameters.getScienceGoal();
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: spatial");
        }
        spatialVisualParameters.setContextDocument(scienceGoal);
        Double d = spatialVisualParameters.getFovSize().getContentInUnits(Angle.UNIT_ARCMIN);
        if (d.isInfinite()) {
            throw new InfiniteBandwithException();
        }
        Log.logger(SchedBlockWorker.class).fine("Dealing with a mosaic - Max mosaic spread is : " + d + " (arcmin) " + d * 60.0 + " (arcsec)");
        Log.logger(SchedBlockWorker.class).fine("Distance between pointings for  : " + targetParameters.getSourceName());
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
        SinglePoint[] singlePointArray = targetParameters.getFieldSinglePoint();
        LinkedHashSet<Set<SinglePoint>> linkedHashSet = new LinkedHashSet<Set<SinglePoint>>(30);
        for (SinglePoint singlePoint : singlePointArray) {
            void var13_25;
            void var13_28;
            SkyPoint skyPoint = singlePoint.getCentre().getAbsoluteCoordinates(skyCoordinates).getAbsoluteSkyPointInICRSDeg();
            Object var13_26 = null;
            for (Set set : linkedHashSet) {
                if (!set.contains((Object)singlePoint)) continue;
                Set set2 = set;
                break;
            }
            if (var13_28 == null) {
                LinkedHashSet<SinglePoint> linkedHashSet2 = new LinkedHashSet<SinglePoint>(50);
                linkedHashSet2.add(singlePoint);
                linkedHashSet.add(linkedHashSet2);
            }
            assert (var13_25 != null);
            for (Object object2 : singlePointArray) {
                Object object3;
                double d2;
                if (object2 == singlePoint || !((d2 = WorldCoords.dist((double)(object3 = object2.getCentre().getAbsoluteCoordinates(skyCoordinates).getAbsoluteSkyPointInICRSDeg()).getX(), (double)object3.getY(), (double)skyPoint.getX(), (double)skyPoint.getY())) < d) || var13_25.contains(object2)) continue;
                var13_25.add(object2);
            }
        }
        assert (SchedBlockWorker.verifyAllPointingsAreInClusters(singlePointArray, linkedHashSet));
        Log.logger(SchedBlockWorker.class).fine("Number of pointing clusters found : " + linkedHashSet.size());
        if (linkedHashSet.size() == 1) {
            Log.logger(SchedBlockWorker.class).fine("Pointings in source " + targetParameters.getSourceName() + " overlap");
            return true;
        }
        for (Set set : linkedHashSet) {
            if (set.size() != singlePointArray.length) continue;
            Log.logger(SchedBlockWorker.class).fine("Pointings in source " + targetParameters.getSourceName() + " overlap - all pointings are in the same cluster");
            return true;
        }
        ArrayList arrayList = new ArrayList();
        do {
            bl = false;
            block5: for (Set set : linkedHashSet) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Set set3 = (Set)iterator.next();
                    if (set != set3) continue;
                    continue block5;
                }
                block7: for (Set set4 : linkedHashSet) {
                    if (set4 == set) continue;
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        Set set5 = (Set)object.next();
                        if (set4 != set5) continue;
                        continue block7;
                    }
                    for (SinglePoint singlePoint : set) {
                        SkyPoint skyPoint = singlePoint.getCentre().getAbsoluteCoordinates(skyCoordinates).getAbsoluteSkyPointInICRSDeg();
                        assert (skyPoint != null);
                        for (Object object3 : set4) {
                            SkyPoint skyPoint2 = object3.getCentre().getAbsoluteCoordinates(skyCoordinates).getAbsoluteSkyPointInICRSDeg();
                            assert (object3 != null);
                            double d3 = WorldCoords.dist((double)skyPoint2.getX(), (double)skyPoint2.getY(), (double)skyPoint.getX(), (double)skyPoint.getY());
                            assert (d3 >= 0.0);
                            if (!(d3 < d) && object3 != singlePoint) continue;
                            arrayList.add(set4);
                            set.addAll(set4);
                            bl = true;
                            continue block7;
                        }
                    }
                }
            }
        } while (bl);
        boolean bl2 = false;
        block11: for (Set set : linkedHashSet) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (Set)iterator.next();
                if (object != set) continue;
                continue block11;
            }
            Log.logger(SchedBlockWorker.class).fine("clusterSize: " + set.size() + " looking for " + singlePointArray.length);
            if (set.size() != singlePointArray.length) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            Log.logger(SchedBlockWorker.class).fine("Pointings in source " + targetParameters.getSourceName() + " overlap");
        } else {
            Log.logger(SchedBlockWorker.class).fine("Pointings in source " + targetParameters.getSourceName() + " do not overlap");
        }
        System.out.println("timing " + stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return bl2;
    }

    private static boolean verifyAllPointingsAreInClusters(SinglePoint[] singlePointArray, Set<Set<SinglePoint>> set) {
        LinkedHashSet<SinglePoint> linkedHashSet = new LinkedHashSet<SinglePoint>(40);
        for (Set<SinglePoint> set2 : set) {
            for (SinglePoint singlePoint : set2) {
                linkedHashSet.add(singlePoint);
            }
        }
        Log.logger(SchedBlockWorker.class).fine("pointingCluster.size(): " + set.size());
        return linkedHashSet.size() == singlePointArray.length;
    }

    public static List<SchedBlock> findSBsInSG(AbstractScienceGoal abstractScienceGoal) {
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        ObsUnitSet obsUnitSet = abstractScienceGoal.getObsUnitSet();
        if (obsUnitSet == null) {
            return arrayList;
        }
        SchedBlockWorker.findSBsUnderOUS(arrayList, obsUnitSet);
        return arrayList;
    }

    public static List<SchedBlock> findSBsUnderOUS(List<SchedBlock> list, ObsUnitSet obsUnitSet) {
        if (obsUnitSet == null) {
            return list;
        }
        try {
            Arrays.stream(obsUnitSet.getSchedBlock()).forEach(schedBlock -> list.add((SchedBlock)schedBlock));
        }
        catch (UnknownEntityException unknownEntityException) {
            return list;
        }
        for (ObsUnitSet obsUnitSet2 : obsUnitSet.getObsUnitSet()) {
            SchedBlockWorker.findSBsUnderOUS(list, obsUnitSet2);
        }
        return list;
    }

    public static void findSBsUnderOUS(List<SchedBlock> list, List<ObsUnitSet> list2) {
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: schedblocks");
        }
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        list2.stream().forEach(obsUnitSet -> {
            try {
                Arrays.stream(obsUnitSet.getSchedBlock()).forEach(schedBlock -> list.add((SchedBlock)schedBlock));
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(SchedBlockWorker.class).warning("Unable to find SBs");
            }
        });
        list2.stream().forEach(obsUnitSet -> SchedBlockWorker.findSBsUnderOUS(list, obsUnitSet));
    }

    public static ObsUnitSet generateSBs(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        Integer n = Objects.hash(scienceGoal.toXml());
        ObsUnitSet obsUnitSet = (ObsUnitSet)sbOutputCache.get((Object)n);
        if (obsUnitSet != null) {
            Log.logger(P2GAlerter.class).fine("Using cached SBs");
            return obsUnitSet;
        }
        obsUnitSet = ObsUnitSet.createObsUnitSet();
        ScienceGoalSchedBlockGenerator scienceGoalSchedBlockGenerator = new ScienceGoalSchedBlockGenerator(scienceGoal, obsUnitSet, false);
        try {
            scienceGoalSchedBlockGenerator.generate();
        }
        catch (WizardSBGenerationException wizardSBGenerationException) {
            throw new InvalidObsProgramParametersException(wizardSBGenerationException);
        }
        sbOutputCache.put((Object)n, (Object)obsUnitSet);
        return obsUnitSet;
    }

    public static class SBNotFoundException
    extends Exception {
        private static final long serialVersionUID = -1376482961494088385L;
    }

    public static class UnableToQuantizeIntegrationTimeException
    extends Exception {
        private static final long serialVersionUID = 2270109901775084793L;
    }

    public static class InfiniteBandwithException
    extends Exception {
    }

    public static class NotAMosaicException
    extends Exception {
    }
}

