/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnitDependencies;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.SchedBlockGenerator;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.OUSStructureBuilderFactory;
import alma.obsprep.services.generator.refactored.OUSStructureBuilderInterface;
import alma.obsprep.services.generator.refactored.SchedBlockPostProcessor;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGenerator;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGeneratorFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorFactory;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class ScienceGoalSchedBlockGenerator
implements SchedBlockGenerator {
    private boolean isSBGenerationUserInitiated = false;
    private static CacheAccess<Integer, Integer> tuningsCache = JCS.getInstance((String)"tuningsCache");
    private static final int NO_PREVIOUS_VISIT = 0;
    private final Log.Logger logger = Log.logger((Object)this);
    private final ScienceGoal userDefinedScienceGoal;
    private final OUSGenerator ousGenerator;
    private final ObsUnitSet rootOUS;
    private SchedBlockPostProcessor schedBlockPostProcessor;

    private boolean canGenerate(ScienceGoal scienceGoal) throws WizardSBGenerationException {
        boolean bl;
        if (scienceGoal.getTargetParametersCount() == 0) {
            return false;
        }
        for (Object n : scienceGoal.getTargetParameters()) {
            if (!n.isPointingPattern() || n.getPointingPattern().getPhaseCenterCoordinates().length >= 1) continue;
            Log.logger(SpectralSpecFactory.class).warning("At least one pointing should be defined: " + n.getSourceName());
            throw new WizardSBGenerationException("At least one pointing should be defined: " + n.getSourceName());
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        try {
            if (performanceParameters.getDesiredLargestScale().isLessThan((AbstractDoubleWithUnit)Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCMIN)) && !this.userDefinedScienceGoal.getObsProposal().isVLBI()) {
                throw new WizardSBGenerationException("An invalid desired LAS has been specified");
            }
        }
        catch (UnknownEntityException spectralSetupParameters) {
            throw new WizardSBGenerationException("Cannot determine if project is a VLBI project");
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        String string = spectralSetupParameters.getType();
        if (string.equals(SpectralSetupParameters.TYPE_FULL)) {
            Object n;
            n = spectralSetupParameters;
            if (((SpectralSetupParameters)((Object)n)).getScienceSpectralWindowCount() == 0) {
                throw new WizardSBGenerationException("Spectral Setup has no lines and no scans specified");
            }
            if (((SpectralSetupParameters)((Object)n)).isFullPolarisation().booleanValue() && !Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
                Set<ReceiverBand> n2 = ReceiverBand.getFullPolarizationReceiverBands();
                bl = false;
                for (ReceiverBand receiverBand : n2) {
                    try {
                        ArrayList<Frequency> arrayList = new ArrayList<Frequency>();
                        Arrays.stream(n.getAbstractScienceSpectralWindow()).forEach(abstractScienceSpectralWindow -> arrayList.add(abstractScienceSpectralWindow.getCenterFrequency().dopplerShifted(scienceGoal.getKeyTargetParameters().getSourceVelocity())));
                        if (!receiverBand.equals(ReceiverBand.getReceiverBand(arrayList))) continue;
                        bl = true;
                    }
                    catch (ReceiverBand.ReceiverNotFoundException | IllegalArgumentException exception) {
                        throw new WizardSBGenerationException("Full polarization only allowed for bands 3, 4, 5, 6 and 7");
                    }
                }
                if (!bl) {
                    throw new WizardSBGenerationException("Full polarization only allowed for bands 3, 4, 5, 6 and 7");
                }
            }
        } else if (string.equals(SpectralSetupParameters.TYPE_CONTINUUM) || string.equals(SpectralSetupParameters.TYPE_SCAN)) {
            // empty if block
        }
        int n = AlmaPolicies.getInstance().getMaxNumberPointings();
        int n2 = 0;
        bl = scienceGoal.isStandAloneACA();
        Array array = bl ? Array.ARRAY_7M : Array.ARRAY_12M;
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            n2 += targetParameters.getNumberOfPointings(array);
        }
        if (n2 > AlmaPolicies.getInstance().getMaxNumberPointings()) {
            throw new WizardSBGenerationException("The maximum number of " + n + " pointings has been exceeded - " + n2 + " are scheduled");
        }
        if (n2 == 0) {
            throw new WizardSBGenerationException("There are no pointings in this science goal");
        }
        if (bl && spectralSetupParameters.isFullPolarisation().booleanValue()) {
            throw new WizardSBGenerationException("Standalone ACA cannot be used with full polarization");
        }
        if (bl && spectralSetupParameters.isSpectralScan()) {
            throw new WizardSBGenerationException("Standalone ACA cannot be used with spectral scans");
        }
        if (bl && !performanceParameters.getUseACA()) {
            throw new WizardSBGenerationException("Standalone ACA cannot be used when the science goal configuration precludes the use of the ACA");
        }
        return true;
    }

    public ScienceGoalSchedBlockGenerator(CalibratedAbstractScienceGoal calibratedAbstractScienceGoal, ObsUnitSet obsUnitSet, boolean bl) {
        if (calibratedAbstractScienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: goal");
        }
        if (obsUnitSet == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsUnitSet");
        }
        this.userDefinedScienceGoal = (ScienceGoal)calibratedAbstractScienceGoal;
        this.rootOUS = obsUnitSet;
        this.ousGenerator = OUSGeneratorFactory.getOUSGenerator(calibratedAbstractScienceGoal);
        this.isSBGenerationUserInitiated = bl;
        SchedBlockPostProcessor.Builder builder = new SchedBlockPostProcessor.Builder();
        builder.isSBGenerationUserInitiated(bl).rootOUS(obsUnitSet).userDefinedScienceGoal(this.userDefinedScienceGoal);
        this.schedBlockPostProcessor = builder.build();
        assert (this.schedBlockPostProcessor != null);
    }

    @Override
    public void generate() throws WizardSBGenerationException {
        Collection<ScienceGoal> collection;
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.userDefinedScienceGoal == null) {
            throw new WizardSBGenerationException("Illegal argument. The argument cannot be null: goal");
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(this.userDefinedScienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        for (ScienceGoal object2 : collection) {
            if (this.canGenerate(object2)) continue;
            return;
        }
        if (this.userDefinedScienceGoal.getName() == null || this.userDefinedScienceGoal.getName().length() == 0) {
            this.userDefinedScienceGoal.setName(this.userDefinedScienceGoal.getSoleTargetParameters().getSourceName());
        }
        int n = 1;
        PerformanceParameters performanceParameters = this.userDefinedScienceGoal.getPerformanceParameters();
        Boolean bl = false;
        Boolean bl2 = false;
        if (performanceParameters.getIsTimeConstrained()) {
            switch (performanceParameters.getTypeOfTimingConstraint()) {
                case TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS: {
                    n = performanceParameters.getVisitConstraintCount();
                    if (n == 0) {
                        throw new WizardSBGenerationException("Multiple visits are selected but no visits are defined");
                    }
                    bl2 = true;
                    break;
                }
                case TIMINGCONSTRAINT_UNDECIDED: {
                    n = 1;
                    break;
                }
                case TIMINGCONSTRAINTSTYPE_SPECIFICDATES: {
                    if (performanceParameters.getTemporalParametersCount() == 0) {
                        throw new WizardSBGenerationException("Specific dates have been requested but no dates are defined");
                    }
                    n = 1;
                }
            }
        }
        if (bl.booleanValue() && performanceParameters.getNeedsMoreTime()) {
            throw new WizardSBGenerationException("Continuous monitoring and a time override cannot both be requested simultaneously");
        }
        this.rootOUS.setName("SG OUS (" + this.userDefinedScienceGoal.getName() + ")");
        OUSStructureBuilderFactory.OUSStructureTypesEnum oUSStructureTypesEnum = null;
        if (ScienceGoalSchedBlockGenerator.isMultiTuningOUSStructureRequired(this.userDefinedScienceGoal)) {
            // empty if block
        }
        oUSStructureTypesEnum = this.userDefinedScienceGoal.getPerformanceParameters().getIsSimultaneous12and7() ? OUSStructureBuilderFactory.OUSStructureTypesEnum.Simultaneous12mAndACAObserving : OUSStructureBuilderFactory.OUSStructureTypesEnum.StandardOUSStructure;
        assert (oUSStructureTypesEnum != null);
        OUSStructureBuilderInterface oUSStructureBuilderInterface = OUSStructureBuilderFactory.getOUSStructureBuilder(oUSStructureTypesEnum, this.ousGenerator, this.rootOUS, this.userDefinedScienceGoal);
        oUSStructureBuilderInterface.createOUSStructure(this.schedBlockPostProcessor, collection, n, bl, bl2);
        if (n > 0 && performanceParameters.getTypeOfTimingConstraint().equals((Object)PerformanceParameters.TimingConstraintType.TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS)) {
            this.createSBTemporalDependencies(this.rootOUS, this.userDefinedScienceGoal, n);
        }
        stopwatch.stop();
        Log.logger(ScienceGoalSchedBlockGenerator.class).info("SB generation took " + stopwatch);
    }

    public static boolean isMultiTuningOUSStructureRequired(ScienceGoal scienceGoal) {
        if (scienceGoal.isSpectralScan()) {
            ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(scienceGoal);
            try {
                return observingTimeCalculator.getTotalOnSourceTime(Array.ARRAY_12M, true).isGreaterThan((AbstractDoubleWithUnit)SBGeneratorFactory.SPECTRAL_SCAN_MULTIPLE_SB_THRESHOLD_TIME);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException("Unable to determine if a multi-tuning OUS structure is required " + invalidObsProgramParametersException.getMessage());
            }
        }
        return false;
    }

    private void createSBTemporalDependencies(ObsUnitSet obsUnitSet, ScienceGoal scienceGoal, int n) {
        Collection<ScienceGoal> collection;
        if (n < 2) {
            return;
        }
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: userDefinedScienceGoal");
        }
        if (obsUnitSet == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: rootOUS");
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        int n2 = collection.size();
        for (int i = 0; i < n; ++i) {
            VisitConstraint visitConstraint = scienceGoal.getPerformanceParameters().getVisitConstraint(i);
            if (visitConstraint.getIsFixedStart()) continue;
            Time time = visitConstraint.getRequiredDelay();
            int n3 = visitConstraint.getPreviousVisitId();
            for (int j = 0; j < n2; ++j) {
                ObsUnitSet obsUnitSet2 = obsUnitSet.getObsUnitSet(i * n2 + j);
                ObsUnitSet obsUnitSet3 = null;
                if (n3 != 0) {
                    obsUnitSet3 = obsUnitSet.getObsUnitSet((n3 - 1) * n2 + j);
                }
                int n4 = obsUnitSet2.getObsUnitSetCount();
                for (int k = 0; k < n4; ++k) {
                    ObsUnitSet obsUnitSet4 = null;
                    if (obsUnitSet3 != null) {
                        obsUnitSet4 = obsUnitSet3.getObsUnitSet(k);
                    }
                    ObsUnitSet obsUnitSet5 = obsUnitSet2.getObsUnitSet(k);
                    for (int i2 = 0; i2 < obsUnitSet5.getSchedBlockCount(); ++i2) {
                        SchedBlock schedBlock = null;
                        SchedBlock schedBlock2 = null;
                        try {
                            if (obsUnitSet4 != null) {
                                schedBlock = obsUnitSet4.getSchedBlock(i2);
                            }
                            schedBlock2 = obsUnitSet5.getSchedBlock(i2);
                        }
                        catch (UnknownEntityException unknownEntityException) {
                            throw new WizardSBGenerationException("Unable to get SB " + unknownEntityException.getMessage());
                        }
                        UnitDependencies unitDependencies = schedBlock2.getUnitDependencies();
                        if (n3 != 0) {
                            unitDependencies.setDelay(time.deepCopy());
                            unitDependencies.addDependencyList(schedBlock.getEntityID());
                        }
                        unitDependencies.setExecutionCount(1);
                        unitDependencies.setExpression("");
                    }
                }
            }
        }
    }

    public static int getNumberOfTunings(ScienceGoal scienceGoal) throws IndexOutOfBoundsException, MinTuningsCalculator.UnableToCalculateMinNumberOfTunings {
        Integer n = scienceGoal.toXml().hashCode();
        Integer n2 = (Integer)tuningsCache.get((Object)n);
        if (n2 != null) {
            return n2;
        }
        Collection<ScienceGoal> collection = ScienceGoalSchedBlockGenerator.splitByTuning(scienceGoal);
        n2 = collection.size();
        tuningsCache.put((Object)n, (Object)n2);
        return n2;
    }

    public static Collection<ScienceGoal> splitByTuning(ScienceGoal scienceGoal) throws IndexOutOfBoundsException, MinTuningsCalculator.UnableToCalculateMinNumberOfTunings {
        ArrayList<ScienceGoal> arrayList = new ArrayList<ScienceGoal>();
        HashSet<TargetParameters> hashSet = new HashSet<TargetParameters>();
        for (MinTuningsCalculator.TuningResult tuningResult : MinTuningsCalculator.getLO1Tunings(scienceGoal)) {
            int n;
            TargetParameters targetParameters;
            ScienceGoal scienceGoal2 = scienceGoal.deepCopy();
            scienceGoal2.getSpectralSetupParameters().setRepresentativeFrequency(scienceGoal.getRepresentativeFrequency());
            Set<TargetParameters> set = tuningResult.getTargets();
            int n2 = 0;
            HashMap<TargetParameters, TargetParameters> hashMap = new HashMap<TargetParameters, TargetParameters>();
            set.removeAll(hashSet);
            TargetParameters[] targetParametersArray = new TargetParameters[set.size()];
            for (TargetParameters targetParameters2 : set) {
                targetParameters = targetParameters2.deepCopy();
                hashMap.put(targetParameters2, targetParameters);
                targetParametersArray[n2++] = targetParameters;
            }
            TargetParameters targetParameters3 = (TargetParameters)hashMap.get(tuningResult.getKeyTarget());
            for (n = 0; n < targetParametersArray.length; ++n) {
                if (targetParametersArray[n] != targetParameters3) continue;
                if (n == 0) break;
                targetParameters = targetParametersArray[0];
                targetParametersArray[0] = targetParametersArray[n];
                targetParametersArray[n] = targetParameters;
                break;
            }
            scienceGoal2.setTargetParameters(targetParametersArray);
            for (n = 0; n < scienceGoal2.getTargetParametersCount(); ++n) {
                if (scienceGoal2.getTargetParameters(n) != targetParameters3) continue;
                scienceGoal2.setKeyTargetParameters(n);
                break;
            }
            scienceGoal2.setScienceGoalType(ScienceGoal.ScienceGoalType.TUNINGSPECIFIC);
            arrayList.add(scienceGoal2);
            hashSet.addAll(set);
        }
        return arrayList;
    }

    public static class UnableToDetermineSensitivityException
    extends Exception {
        public UnableToDetermineSensitivityException(String string) {
            super(string);
        }
    }

    public class UnableToLocateSBException
    extends Exception {
        public UnableToLocateSBException(String string) {
            super(string);
        }
    }
}

