/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import alma.valuetypes.UserSensitivity;
import java.util.ArrayList;

public class ScienceParametersSensitivityCalculator {
    private Sensitivity getSensitivityForACA7m(ObservingTimeCalculator observingTimeCalculator, Target target, Frequency frequency, double d) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException, InvalidFrequencyException, SourceNeverVisibleException, InvalidObsProgramParametersException {
        Sensitivity sensitivity;
        Time time;
        if (observingTimeCalculator == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: observingTimeCalculator");
        }
        if (target == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: target");
        }
        if (frequency == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: repFreq");
        }
        TargetParameters targetParameters = target.getFieldSource().getTargetParameters();
        if (targetParameters == null) {
            throw new ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException("keyTargetParameters has not been specified");
        }
        int n = targetParameters.getNumberOfPointings();
        FieldPattern.FieldPatternType fieldPatternType = targetParameters.getFieldPatternType();
        switch (fieldPatternType) {
            case POINT: {
                int n2 = target.getFieldSource().getNumberOfPointings();
                time = (Time)((Time)((Time)observingTimeCalculator.singlePointOnSourceTime(Array.ARRAY_12M, targetParameters, false).multiply(d)).multiply(n)).divide(n2);
                assert (time != null);
                sensitivity = observingTimeCalculator.singlePointOnSourceSensitivity(RequestedArray.SEVEN_M.getArray(), time, targetParameters, frequency);
                assert (sensitivity != null);
                break;
            }
            case RECTANGLE: {
                Rectangle rectangle = targetParameters.getFieldRectangle()[0];
                int n3 = rectangle.getNumberOfPointings(Array.ARRAY_7M);
                time = (Time)((Time)((Time)observingTimeCalculator.singlePointOnSourceTime(Array.ARRAY_12M, targetParameters, false).multiply(n)).multiply(d)).divide(n3);
                assert (time != null);
                sensitivity = observingTimeCalculator.singlePointOnSourceSensitivity(RequestedArray.SEVEN_M.getArray(), time, targetParameters, frequency);
                assert (sensitivity != null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported field type defined: " + (Object)((Object)fieldPatternType));
            }
        }
        Log.logger(this.getClass()).fine(String.format("Sensitivity for ACA 7-m for an integration time of %s for a sky freq of %s and a declination of %s is %s", time.toString(), frequency.toString(), targetParameters.getSourceCoordinates().getLatitude().toString(), sensitivity.toString()));
        return sensitivity;
    }

    private Sensitivity getSensitivityForTM(RequestedArray requestedArray, ObservingTimeCalculator observingTimeCalculator, Target target, Frequency frequency, double d) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException, InvalidFrequencyException, SourceNeverVisibleException, InvalidObsProgramParametersException {
        if (observingTimeCalculator == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: observingTimeCalculator");
        }
        if (target == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: target");
        }
        if (frequency == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: repFreq");
        }
        TargetParameters targetParameters = target.getFieldSource().getTargetParameters();
        if (targetParameters == null) {
            throw new ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException("keyTargetParameters has not been specified");
        }
        Time time = (Time)observingTimeCalculator.singlePointOnSourceTime(Array.ARRAY_12M, targetParameters, false).multiply(d);
        assert (time != null);
        Sensitivity sensitivity = observingTimeCalculator.singlePointOnSourceSensitivity(requestedArray.getArray(), time, targetParameters, frequency);
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine(String.format("Sensitivity for array %s for an integration time of %s for a sky freq of %s and a declination of %s is %s", requestedArray.getArray().toString(), time.toString(), frequency.toString(), targetParameters.getSourceCoordinates().getLatitude().toString(), sensitivity.toString()));
        return sensitivity;
    }

    private Sensitivity getTPAmpCalSBSensitivity(RequestedArray requestedArray, ObservingTimeCalculator observingTimeCalculator, int n, Target target, ScienceParameters scienceParameters, Frequency frequency) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException, InvalidFrequencyException, SourceNeverVisibleException {
        if (target == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: target");
        }
        if (scienceParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceParameters");
        }
        if (frequency == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: repFreq");
        }
        if (observingTimeCalculator == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: observingTimeCalculator");
        }
        if (requestedArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: arrayRequested");
        }
        TargetParameters targetParameters = target.getFieldSource().getQuerySource().getKeyTargetParameters();
        if (targetParameters == null) {
            throw new ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException("keyTargetParameters has not been specified");
        }
        RectanglePattern rectanglePattern = (RectanglePattern)((Object)target.getFieldSource().getFieldPattern());
        double d = rectanglePattern.getLatitudeLength().getContentInUnits(Latitude.UNIT_ARCSEC) * rectanglePattern.getLongitudeLength().getContentInUnits(Longitude.UNIT_ARCSEC);
        Angle angle = Antenna.ANTENNA_12M.getBeamArea(frequency);
        assert (angle != null);
        Time time = (Time)((Time)scienceParameters.getIntegrationTime().getTime().multiply(n)).divide(d / angle.getContentInUnits(Angle.UNIT_ARCSEC));
        assert (time != null);
        Sensitivity sensitivity = observingTimeCalculator.singlePointOnSourceSensitivity(requestedArray.getArray(), time, targetParameters, frequency);
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine(String.format("Sensitivity for array %s for an integration time of %s for a sky freq of %s and a declination of %s is %s", requestedArray.getArray().toString(), time.toString(), frequency.toString(), targetParameters.getSourceCoordinates().getLatitude().toString(), sensitivity.toString()));
        return sensitivity;
    }

    private Sensitivity getTPScienceSBSensitivity(RequestedArray requestedArray, ObservingTimeCalculator observingTimeCalculator, Target target, Frequency frequency, double d, SchedBlock schedBlock) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException, InvalidFrequencyException, SourceNeverVisibleException, InvalidObsProgramParametersException {
        RectanglePatternI rectanglePatternI;
        int n;
        Array array;
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        if (observingTimeCalculator == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: observingTimeCalculator");
        }
        if (target == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: target");
        }
        if (frequency == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: repFreq");
        }
        if (requestedArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: arrayRequested");
        }
        FieldSource fieldSource = target.getFieldSource();
        TargetParameters targetParameters = fieldSource.getTargetParameters();
        if (targetParameters == null) {
            throw new ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException("keyTargetParameters has not been specified");
        }
        FieldPattern.FieldPatternType fieldPatternType = targetParameters.getFieldPatternType();
        boolean bl = schedBlock.getSbGenerationContext().getGoal().isStandAloneACA();
        Array array2 = array = bl ? Array.ARRAY_7M : Array.ARRAY_12M;
        if (fieldPatternType.equals((Object)FieldPattern.FieldPatternType.POINT)) {
            n = targetParameters.getNumberOfPointings();
        } else if (fieldPatternType.equals((Object)FieldPattern.FieldPatternType.RECTANGLE)) {
            rectanglePatternI = targetParameters.getFieldRectangle()[0];
            n = ((Rectangle)rectanglePatternI).getNumberOfPointings(array);
        } else {
            throw new RuntimeException("Unsupported field type found: " + (Object)((Object)fieldPatternType));
        }
        rectanglePatternI = (RectanglePattern)((Object)fieldSource.getFieldPattern());
        Time time = (Time)((Time)observingTimeCalculator.singlePointOnSourceTime(array, targetParameters, false).multiply(d)).multiply(n);
        assert (time != null);
        Sensitivity sensitivity = observingTimeCalculator.singlePointOnSourceSensitivity(requestedArray.getArray(), time, targetParameters, frequency);
        double d2 = Antenna.ANTENNA_12M.getBeamSize(frequency).getArcsec();
        double d3 = Math.PI * Math.pow(d2 / 2.0, 2.0);
        double d4 = rectanglePatternI.getLatitudeLength().getContentInUnits(Latitude.UNIT_ARCSEC);
        double d5 = rectanglePatternI.getLongitudeLength().getContentInUnits(Longitude.UNIT_ARCSEC);
        double d6 = d4 * d5;
        Sensitivity sensitivity2 = (Sensitivity)sensitivity.multiply(1.24 * Math.sqrt(d6 / d3));
        double d7 = Math.min(d4, d5);
        double d8 = target.getFieldSource().getReference(0).getSubScanDuration().getSecs();
        double d9 = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to find science parameters")).getSubScanDuration().getSecs();
        Sensitivity sensitivity3 = (Sensitivity)sensitivity.multiply(1.19 * Math.sqrt(d7 / d2) * Math.sqrt(d9 / d8));
        double d10 = sensitivity2.getContentInUnits(Sensitivity.UNIT_MJY);
        double d11 = sensitivity3.getContentInUnits(Sensitivity.UNIT_MJY);
        sensitivity = Sensitivity.createSensitivity((double)Math.sqrt(Math.pow(d10, 2.0) + Math.pow(d11, 2.0)), (String)Sensitivity.UNIT_MJY);
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine(String.format("Sensitivity for array %s for an integration time of %s for a sky freq of %s and a declination of %s is %s", requestedArray.getArray().toString(), time.toString(), frequency.toString(), targetParameters.getSourceCoordinates().getLatitude().toString(), sensitivity.toString()));
        return sensitivity;
    }

    void setScienceParametersSensitivity(SchedBlock schedBlock, RequestedArray requestedArray, ObservingTimeCalculator observingTimeCalculator, ScienceGoal scienceGoal, ScienceGoal scienceGoal2) throws ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException {
        int n = schedBlock.getSchedBlockControl().getExecutionCount();
        boolean bl = scienceGoal.isStandAloneACA();
        ArrayList<ScienceParameters> arrayList = new ArrayList<ScienceParameters>();
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            Sensitivity sensitivity;
            ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to find science parameters"));
            if (arrayList.contains((Object)scienceParameters)) continue;
            try {
                boolean bl2;
                Frequency frequency = scienceGoal2.getPerformanceParameters().getRepresentativeFrequency();
                FieldPattern fieldPattern = target.getFieldSource().getFieldPattern();
                assert (fieldPattern != null);
                double d = schedBlock.getSbGenerationContext().getAntennaRelatedTOSTimeMultiplier();
                boolean bl3 = scienceGoal.getPerformanceParameters().getDesiredSensitivity().inTemperatureUnit();
                boolean bl4 = bl && schedBlock.isACA7mArraySB();
                boolean bl5 = bl2 = !bl3 && schedBlock.is12mExtendedArraySB();
                if (bl4 || bl2) {
                    UserSensitivity userSensitivity = scienceGoal.getPerformanceParameters().getDesiredSensitivity();
                    String string = userSensitivity.getFriendlyUnit();
                    sensitivity = Sensitivity.createSensitivity((double)userSensitivity.getContentInUnits(string), (String)string);
                } else {
                    sensitivity = schedBlock.isTotalPowerAmpcalSB() ? this.getTPAmpCalSBSensitivity(requestedArray, observingTimeCalculator, n, target, scienceParameters, frequency) : (schedBlock.isTotalPowerScienceSB() ? this.getTPScienceSBSensitivity(requestedArray, observingTimeCalculator, target, frequency, d, schedBlock) : (schedBlock.isACA7mArraySB() ? this.getSensitivityForACA7m(observingTimeCalculator, target, frequency, d) : this.getSensitivityForTM(requestedArray, observingTimeCalculator, target, frequency, d)));
                }
            }
            catch (SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException exception) {
                Log.logger(ScienceGoalSchedBlockGenerator.class).warning("Unable to determine sensitivity from integration time");
                continue;
            }
            assert (sensitivity != null);
            Log.logger(ScienceGoalSchedBlockGenerator.class).fine("Sensitivity calculated from science integration time : " + (Object)((Object)sensitivity));
            scienceParameters.setSensitivityGoal(sensitivity);
            arrayList.add(scienceParameters);
        }
    }
}

