/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.TotalPowerSBScienceTargetDistributor;
import alma.obsprep.services.generator.refactored.intermediatetarget.TPRasterData;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TotalPowerIntegrationTimeCalculator {
    private static final double tpMaxTOSPerSB_s = AlmaPolicies.getInstance().getTpMaxTOSPerSB().getSecs();

    public static int getTPSBExecutionCount(SchedBlock schedBlock2, Time time, ScienceGoal scienceGoal, List<ObsUnitSet> list) throws WizardSBGenerationException, Exception {
        if (schedBlock2 == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        if (time == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: tosFor12mExtendedArray");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (!schedBlock2.isTotalPowerScienceSB()) {
            throw new IllegalArgumentException("sb must be a TP science SB");
        }
        List<SchedBlock> list2 = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(list2, list);
        list2 = list2.stream().filter(schedBlock -> schedBlock.isTotalPowerScienceSB()).collect(Collectors.toList());
        if (list2.isEmpty()) {
            throw new WizardSBGenerationException("Unable to find TP SBs when expected");
        }
        boolean bl = list2.size() > 1 || list2.stream().filter(schedBlock -> schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).size() > 1).findFirst().isPresent();
        int n = bl ? TotalPowerIntegrationTimeCalculator.getTPExecutionCountForMultipleSources(schedBlock2, scienceGoal, list) : TotalPowerIntegrationTimeCalculator.getTPExecutionCountForSingleSource(schedBlock2, time, scienceGoal);
        assert (n > 0);
        return n;
    }

    static int getTPExecutionCountForMultipleSources(SchedBlock schedBlock2, ScienceGoal scienceGoal, List<ObsUnitSet> list) throws WizardSBGenerationException, Exception {
        double d;
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(arrayList, list);
        SBGeneratorTemplate.SchedBlockType schedBlockType = scienceGoal.isStandAloneACA() ? SBGeneratorTemplate.SchedBlockType.ACA7M : SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION;
        List list2 = arrayList.stream().filter(schedBlock -> schedBlock.getSbGenerationContext().getSBType().equals((Object)schedBlockType)).collect(Collectors.toList());
        Target target = schedBlock2.getAllTargets(ScienceParameters.scienceParametersFilter).get(0);
        Optional<Object> optional = Optional.empty();
        SchedBlock schedBlock3 = null;
        for (SchedBlock schedBlock4 : list2) {
            optional = schedBlock4.getScienceTargets().stream().filter(target2 -> target2.getFieldSource().getSourceName().equals(target.getFieldSource().getSourceName())).findFirst();
            if (!optional.isPresent()) continue;
            schedBlock3 = schedBlock4;
            break;
        }
        assert (schedBlock3 != null);
        double d2 = ((Target)optional.orElseThrow(() -> new WizardSBGenerationException("Unable to identify the SB in which the target " + target.getName() + " is located"))).getFirstScienceParameters().orElseThrow(Target.UnableToFindScienceParametersException).getIntegrationTime().getSecs();
        d2 *= (double)schedBlock3.getSchedBlockControl().getExecutionCount();
        try {
            d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        assert (d > 0.0);
        double d3 = d2 * d;
        double d4 = target.getFirstScienceParameters().orElseThrow(Target.UnableToFindScienceParametersException).getIntegrationTime().getSecs();
        int n = (int)Math.ceil(d3 / d4);
        assert (n > 0);
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine(" minTotalTOSTPTimeNeeded_s=" + d3 / 60.0 + " (min) tpSBExecutionCount=" + n + " minTotalTOSTPTimeNeededForSource_s=" + d3 + " tpArrayTimeMultiplier=" + d + " itosOfTPSource_s : " + d4);
        return n;
    }

    static int getTPExecutionCountForSingleSource(SchedBlock schedBlock, Time time, ScienceGoal scienceGoal) {
        double d;
        double d2;
        try {
            d2 = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
            d = ObservingTimeCalculator.getTotalTOSTimeForSB(schedBlock, true).getContentInUnits(Time.UNIT_S);
        }
        catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException | InvalidObsProgramParametersException exception) {
            throw new WizardSBGenerationException(exception);
        }
        assert (d2 > 0.0);
        assert (d > 0.0);
        double d3 = ((Time)time.multiply(d2)).getSecs();
        int n = (int)Math.ceil(d3 / d);
        assert (n > 0);
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine("principalArrayTOS=" + time + " minTotalTOSTPTimeNeeded_s=" + d3 / 60.0 + " (min) tpSBExecutionCount=" + n + " tosScheduledForSingleTPSBExec_s=" + d + " tpArrayTimeMultiplier=" + d2);
        return n;
    }

    public static void calculateSourceRasterTimes(SchedBlock schedBlock, Time time) throws UnknownEntityException {
        Object object;
        Object object2;
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        if (!schedBlock.isTotalPowerScienceSB()) {
            throw new IllegalArgumentException("Illegal argument: sb (" + schedBlock + ") " + "did not pass the test: should be TP science SB");
        }
        if (schedBlock.getSbGenerationContext().getGoal().isSolarScienceGoal()) {
            return;
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        if (list.size() == 1) {
            object2 = list.get(0).getFirstScienceParameters().get();
            object = ((ScienceParameters)((Object)object2)).getTPRasterData().get();
            object2.getIntegrationTime().multiply(((TPRasterData)object).getN_repeat(), (AbstractDoubleWithUnit)object2.getIntegrationTime());
        } else {
            TotalPowerIntegrationTimeCalculator.scaleScienceParametersITOS(schedBlock, time);
        }
        if (Log.logger(TotalPowerSBScienceTargetDistributor.class).fine()) {
            object2 = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
            object = new HashSet();
            object2.stream().forEach(arg_0 -> TotalPowerIntegrationTimeCalculator.lambda$calculateSourceRasterTimes$271((Set)object, schedBlock, arg_0));
        }
    }

    static void scaleScienceParametersITOS(SchedBlock schedBlock, Time time) {
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        while (TotalPowerIntegrationTimeCalculator.isScalingITOSPermissible(list, time)) {
            HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
            for (Target target : list) {
                ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("No science parameters found when expected"));
                if (hashSet.contains((Object)scienceParameters)) continue;
                TPRasterData tPRasterData = scienceParameters.getTPRasterData().orElseThrow(() -> new WizardSBGenerationException("Unable to fetch TP raster data"));
                Time time2 = scienceParameters.getIntegrationTime().getTime();
                time2 = ((Time)time2.plus((AbstractDoubleWithUnit)tPRasterData.getT_rect())).adjustToIntegerMultipleOf(tPRasterData.getT_rect());
                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time2.getSecs(), (String)IntTimeSource.UNIT_S));
                hashSet.add(scienceParameters);
            }
        }
    }

    private static boolean isScalingITOSPermissible(List<Target> list, Time time) {
        if (time == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: totalTPTOSForAllTargets");
        }
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: allScienceTargets");
        }
        if (list.size() < 1) {
            throw new IllegalArgumentException("Illegal argument: allScienceTargets.size() (" + list.size() + ") " + "did not pass the test: allScienceTargets.size() < 1");
        }
        double d = 0.0;
        for (Target target : list) {
            ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("No science parameters found when expected"));
            TPRasterData tPRasterData = scienceParameters.getTPRasterData().orElseThrow(() -> new WizardSBGenerationException("No TP raster data found for science parameters"));
            d += scienceParameters.getIntegrationTime().getSecs() + tPRasterData.getT_rect().getSecs();
        }
        boolean bl = d <= tpMaxTOSPerSB_s;
        Log.logger(TotalPowerSBScienceTargetDistributor.class).fine("isScalingPermissible: " + bl + " scaledTotalITOS: " + d + " tpMaxTOSPerSBSecs " + tpMaxTOSPerSB_s);
        return bl;
    }

    private static /* synthetic */ void lambda$calculateSourceRasterTimes$271(Set set, SchedBlock schedBlock, Target target) {
        target.getScienceParametersCollection().stream().filter(scienceParameters -> !set.contains(scienceParameters)).forEach(scienceParameters -> {
            set.add(scienceParameters);
            Log.logger(TotalPowerSBScienceTargetDistributor.class).fine("SB name " + schedBlock.getName() + " ITOS reported " + (Object)((Object)scienceParameters.getIntegrationTime()));
        });
    }
}

