/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.services.generator.refactored.ArraySBGroupPostProcessorInterface;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class TotalPowerScienceSBGroupPostProcessor
implements ArraySBGroupPostProcessorInterface {
    @Override
    public void postProcessSBArrayGroup(Collection<SchedBlock> collection) {
        if (collection == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: schedBlockGroup");
        }
        if (collection.size() == 0) {
            throw new IllegalArgumentException("Illegal argument: schedBlockGroup.size() (" + collection.size() + ") " + "did not pass the test: schedBlockGroup.size() == 0");
        }
        if (collection.size() > 1) {
            this.distributeSBExecutionTime(collection);
        }
    }

    private void distributeSBExecutionTime(Collection<SchedBlock> collection) {
        Map<SchedBlock, Double> map = collection.stream().collect(Collectors.toMap(schedBlock -> schedBlock, this::calculateTimeOnSource));
        double d = map.keySet().stream().mapToDouble(schedBlock -> (Double)map.get(schedBlock)).sum();
        double d2 = collection.iterator().next().getObsUnitControl().getEstimatedExecutionTime().getSecs();
        for (SchedBlock schedBlock2 : collection) {
            Time time = schedBlock2.getObsUnitControl().getEstimatedExecutionTime();
            time.setContentAndUnit(d2 * map.get(schedBlock2) / d, Time.UNIT_S);
            time.convertToFriendlyUnit();
        }
    }

    private double calculateTimeOnSource(SchedBlock schedBlock) {
        double d = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).stream().mapToDouble(target -> target.getFirstScienceParameters().get().getIntegrationTime().getSecs()).sum();
        return d * (double)schedBlock.getSchedBlockControl().getExecutionCount();
    }
}

