/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcer;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcerInterface;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.RevisedIntegrationParameters;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;

public class VaryingSubscanIntegerMosaicEnforcer
extends IntegerMosaicEnforcer
implements IntegerMosaicEnforcerInterface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean enforceCompleteMosaicScansPerSBExec(SchedBlock schedBlock, RequestedArray requestedArray, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) throws UnknownEntityException, InvalidObsProgramParametersException {
        assert (schedBlock != null);
        assert (requestedArray != null);
        assert (enumSet != null);
        boolean bl = false;
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            return false;
        }
        Array array = requestedArray.getArray();
        ArrayList<RevisedIntegrationParameters> arrayList = new ArrayList<RevisedIntegrationParameters>();
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
        SchedBlock schedBlock2 = schedBlock;
        synchronized (schedBlock2) {
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                    ScienceParameters scienceParameters;
                    Target target = orderedTarget.getTarget();
                    int n = target.getFieldSource().getFieldPattern().getNumberOfPointings();
                    if (!target.hasScienceParameters() || hashSet.contains((Object)(scienceParameters = target.getScienceParametersList()[0]))) continue;
                    if (!target.getFieldSource().getFieldPattern().isPointingPattern()) {
                        Log.logger(SchedBlockWorker.class).fine("Unable to apply integer mosaic scan algorithm: not a pointing pattern");
                        return false;
                    }
                    Time time = (Time)scienceParameters.getIntegrationTime().getTime().multiply(schedBlock.getSchedBlockControl().getExecutionCount());
                    RevisedIntegrationParameters revisedIntegrationParameters = this.adjustSubscanDurationForMosaicBasedSources(target, n, time.getContentInDefaultUnits(), enumSet, array, schedBlock, false);
                    if (revisedIntegrationParameters == null) {
                        return false;
                    }
                    if (revisedIntegrationParameters.getSubScanDuration().isLessThan((AbstractDoubleWithUnit)Time.createTimeSec(3.0)) && (revisedIntegrationParameters = this.adjustSubscanDurationForMosaicBasedSources(target, n, time.getContentInDefaultUnits(), enumSet, array, schedBlock, true)) == null) {
                        return false;
                    }
                    arrayList.add(revisedIntegrationParameters);
                    hashSet.add(scienceParameters);
                }
            }
            int n = 0;
            double d = 0.0;
            for (RevisedIntegrationParameters revisedIntegrationParameters : arrayList) {
                Log.logger(SchedBlockWorker.class).fine("revisedIntegrationParameters: " + revisedIntegrationParameters);
                ScienceParameters scienceParameters = revisedIntegrationParameters.getScienceTarget().getScienceParametersList()[0];
                assert (scienceParameters != null);
                bl = true;
                assert (revisedIntegrationParameters.getNoOfSBExecs() > 0);
                if (revisedIntegrationParameters.getNoOfSBExecs() > n) {
                    n = revisedIntegrationParameters.getNoOfSBExecs();
                    schedBlock.getSchedBlockControl().setExecutionCount(n);
                }
                scienceParameters.setSubScanDuration(revisedIntegrationParameters.getSubScanDuration());
                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)revisedIntegrationParameters.getScienceIntegrationTime().getContentInDefaultUnits(), (String)IntTimeSource.UNIT_S));
                scienceParameters.setIntegrationTimeChangeable(false);
                d += scienceParameters.getIntegrationTime().getContentInUnits(IntTimeSource.UNIT_S);
                assert (n > 0);
                assert (d < SchedBlockWorker.getMaxTimeOnSourcePerSBExec(enumSet));
            }
        }
        return bl;
    }

    private RevisedIntegrationParameters adjustSubscanDurationForMosaicBasedSources(Target target, int n, double d, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, Array array, SchedBlock schedBlock, boolean bl) {
        double d2;
        double d3;
        double d4;
        RevisedIntegrationParameters.Builder builder = new RevisedIntegrationParameters.Builder();
        double d5 = 0.0;
        if (target == null || enumSet == null || array == null) {
            throw new NullPointerException("Invalid input parameters");
        }
        if (n == 0 || d == 0.0) {
            throw new IllegalArgumentException("totalOnSourceTimeForTarget and noOfPointings should be greater than zero");
        }
        if (!target.hasScienceParameters()) {
            throw new IllegalArgumentException("target should be a science target");
        }
        ScienceParameters scienceParameters = target.getScienceParametersList()[0];
        assert (scienceParameters != null);
        if (Array.ARRAY_TP.equals((Object)array)) {
            return null;
        }
        double d6 = this.getProportionOfTOSForScienceTarget(enumSet, target, schedBlock.getScienceTargets());
        double d7 = SchedBlockWorker.getMaxTimeOnSourcePerSBExec(enumSet) * d6;
        if (bl) {
            Time time = this.getActualTOSRequiredForSingleSBExec(schedBlock.getScienceTargets());
            d7 = time.getContentInUnits(Time.UNIT_S) * d6;
        }
        double d8 = d / (double)n;
        assert (d8 > 0.0);
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = target.getSpectralSpec().getCorrelatorConfiguration();
        int n2 = Array.ARRAY_7M.equals((Object)array) ? 11 : (abstractCorrelatorConfiguration.isTDM() ? 2 : 1);
        assert (n2 == 11 || n2 == 2 || n2 == 1);
        double d9 = scienceParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S);
        if (CorrelatorType.BL.equals((Object)abstractCorrelatorConfiguration.getCorrelatorType())) {
            BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            d4 = bLCorrelatorConfiguration.getDumpDuration().getContentInUnits(Time.UNIT_S);
        } else {
            d4 = CorrelatorExpert.getInstance(CorrelatorType.ACA).calcDumpDurationInmsecs() / 1000.0;
        }
        double d10 = (double)n2 * d4;
        int n3 = (int)Math.ceil(d8 * (double)n / d7);
        if (n3 == 0) {
            return null;
        }
        if (n3 == Integer.MAX_VALUE) {
            throw new WizardSBGenerationException("The calculated required number of SB executions is too high, is the desired sensitivity too high?");
        }
        if (n3 > 5000) {
            Log.logger(SchedBlockWorker.class).info("SB execution count exceeds limits: not running algorithm");
            return null;
        }
        double d11 = (double)n * d9;
        boolean bl2 = false;
        double d12 = 0.0;
        while (!bl2) {
            d3 = d8 * (double)n / (double)n3;
            if (d3 <= 0.0) {
                throw new WizardSBGenerationException("Unable to calculate integer mosaic scan: requested TOS per SB execution is zero or less");
            }
            while (d11 > d7) {
                if ((d9 -= d10) < 1.0) {
                    throw new WizardSBGenerationException("Unable to determine integer number of mosaic scans per SB execution: too many pointings?");
                }
                d2 = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d9), target).getContentInUnits(Time.UNIT_S);
                d11 = (double)n * d2;
                assert (d11 > 0.0);
            }
            assert (d9 > 0.0);
            d9 = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d9), target).getContentInUnits(Time.UNIT_S);
            d5 = Math.ceil(d3 / d11);
            assert (d5 > 0.0);
            d12 = d11 * d5;
            assert (d12 > 0.0);
            if (d12 > d7) {
                d2 = d9;
                double d13 = d11;
                double d14 = d12;
                double d15 = d5;
                boolean bl3 = false;
                do {
                    if ((d9 -= d10) < 1.0) {
                        bl3 = true;
                        break;
                    }
                    double d16 = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d9), target).getContentInUnits(Time.UNIT_S);
                    d11 = (double)n * d16;
                    d5 = Math.ceil(d3 / d11);
                    if (d5 < 1.0) {
                        bl3 = true;
                        break;
                    }
                    d12 = d11 * d5;
                    assert (d12 > 0.0);
                } while (d12 > d7 && !bl3);
                if (d12 > d7 || bl3) {
                    d9 = d2;
                    d11 = d13;
                    d12 = d14;
                    d5 = d15;
                    ++n3;
                    continue;
                }
                d9 = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d9), target).getContentInUnits(Time.UNIT_S);
                bl2 = true;
                break;
            }
            bl2 = true;
            break;
        }
        assert (d5 > 0.0 && d9 > 0.0 && n3 > 0 && d12 > 0.0);
        builder.subScanDuration(Time.createTimeSec(d9)).noOfSBExecs(n3).scienceIntegrationTime(Time.createTimeSec(d12 - 0.1));
        d3 = (double)n3 * d12;
        d2 = d12 * (double)n3;
        while (d2 > d && !((d9 -= d10) <= 0.0)) {
            Time time = SchedBlockWorker.getAlignedSubscanDuration(Time.createTimeSec(d9), target);
            d11 = (double)n * time.getContentInUnits(Time.UNIT_S);
            assert (d11 >= 0.0);
            d2 = d5 * d11 * (double)n3;
            if (!(d2 > d)) continue;
            assert (d11 * d5 > 0.0);
            builder.subScanDuration(time);
            builder.scienceIntegrationTime(Time.createTimeSec(d11 * d5 - 0.1));
            d3 = d2;
        }
        builder.mosaicsPerSB((int)d5);
        builder.scienceTarget(target);
        RevisedIntegrationParameters revisedIntegrationParameters = builder.build();
        Log.logger(SchedBlockWorker.class).fine("No of required SB execs : " + n3 + " On-source time per SB : " + revisedIntegrationParameters.getScienceIntegrationTime() + " Total on-source time actually required : " + d3 + " Total time initially requested : " + d + " No Of Mosaics per SB : " + d5 + " Initial time per pointing : " + d / (double)n + " Recalculated time per pointing : " + revisedIntegrationParameters.getSubScanDuration().getContentInUnits(Time.UNIT_S) * d5 * (double)n3 + " Subscan duration : " + revisedIntegrationParameters.getSubScanDuration() + " No of Pointings : " + n + " target : " + revisedIntegrationParameters.getScienceTarget().getName());
        Log.logger(SchedBlockWorker.class).fine("Ratio of requested to required time : " + d3 / d);
        return revisedIntegrationParameters;
    }
}

