/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindowNotFoundException;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import java.util.EnumSet;

public enum AtmosphericWindow {
    GHZ321(321.0, 329.0),
    GHZ365(365.0, 100000.0),
    GHZ175(175.0, 191.0);

    private FrequencyRange window;

    private AtmosphericWindow(Double d, Double d2) {
        this.window = new FrequencyRange(Frequency.createFrequencyGHZ(d), Frequency.createFrequencyGHZ(d2));
    }

    private FrequencyRange getWindow() {
        return this.window;
    }

    public static AtmosphericWindow determineAtmosphericWindow(Frequency frequency, EnumSet<AtmosphericWindow> enumSet) throws AtmosphericWindowNotFoundException {
        if (enumSet == null || enumSet.isEmpty()) {
            throw new IllegalArgumentException("No windows to search for");
        }
        if (frequency == null) {
            throw new NullPointerException("representativeFrequency is null");
        }
        for (AtmosphericWindow atmosphericWindow : enumSet) {
            if (!atmosphericWindow.getWindow().contains(frequency)) continue;
            return atmosphericWindow;
        }
        throw new AtmosphericWindowNotFoundException("Atmospheric window not found for RF " + frequency.toString());
    }
}

