/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AbstractIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.util.Collections;

public abstract class CalWithPointingIntermediateTarget
extends AbstractIntermediateTarget {
    private final ObsType intent;
    private final boolean independentPointing;

    public CalWithPointingIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObsType obsType, boolean bl, SBGenerationContext sBGenerationContext) {
        this.intent = obsType;
        this.independentPointing = bl;
        Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, this.getGroupIndex(), sBGenerationContext);
        this.completeTargetConstruction(target, spectralSetupParameters, requestedArray);
    }

    private void completeTargetConstruction(Target target, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) {
        Target target2 = this.getPointingTarget(spectralSetupParameters, requestedArray, target, this.sbContext);
        Collections.addAll(this.targets, target2, target);
        if (!this.independentPointing) {
            target2.setFieldSource(target.getFieldSource());
        }
        OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
        orderedTarget.setTarget(target2);
        OrderedTarget orderedTarget2 = OrderedTarget.createOrderedTarget();
        orderedTarget2.setTarget(target);
        Collections.addAll(this.orderedTargets, orderedTarget, orderedTarget2);
    }

    private Target getPointingTarget(SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, Target target, SBGenerationContext sBGenerationContext) {
        SkyCoordinates skyCoordinates = target.getFieldSource().getSourceCoordinates().deepCopy();
        QuerySource querySource = QuerySource.createQuerySource(ObsType.POINTING.getCalIntent());
        querySource.setQueryCenter(skyCoordinates);
        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        querySource.setMaxSources(40);
        Target target2 = TargetCreator.createTarget(querySource, spectralSetupParameters, this.getGroupIndex(), sBGenerationContext);
        target2.getFieldSource().setName("Pointing for " + (Object)((Object)this.intent));
        return target2;
    }
}

