/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.AmplitudeCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.BandpassCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.CheckSourceIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.DelayCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.FocusCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.PhaseCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.PointingCalForCalGroupIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.PointingCalForScienceGroupIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.PolarizationCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ScienceIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.SidebandRatioCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

public class IntermediateTargetFactory {
    public static Collection<IntermediateTarget> getIntermediateTarget(ScienceGoal scienceGoal, TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, SBGenerationContext sBGenerationContext) {
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = sBGenerationContext.getSchemaToUseForSBGeneration();
        assert (enumSet != null);
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        switch (targetWithIntent.getObsType()) {
            case AMPLITUDE: {
                if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.ACA_TP)) {
                    arrayList.add(new AmplitudeCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext));
                } else {
                    arrayList.add(new AmplitudeCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.CALIBRATOR, enumSet, sBGenerationContext));
                }
                return arrayList;
            }
            case ATMOSPHERIC: {
                return arrayList;
            }
            case BANDPASS: {
                arrayList.add(new BandpassCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case DELAY: {
                arrayList.add(new DelayCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case CHECKSOURCE: {
                arrayList.add(new CheckSourceIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case FOCUS: {
                arrayList.add(new FocusCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case PHASE: {
                arrayList.add(new PhaseCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case POINTING: {
                arrayList.add(new PointingCalForCalGroupIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                if (!sBGenerationContext.isVLBI()) {
                    arrayList.add(new PointingCalForScienceGroupIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                }
                return arrayList;
            }
            case POLARIZATION: {
                if (!sBGenerationContext.isVLBI()) {
                    arrayList.add(new PolarizationCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, enumSet, ObservingGroupManager.ObservingGroupType.CALIBRATOR.getNominalObservingGroup(), sBGenerationContext, ObservingGroupManager.ObservingGroupType.CALIBRATOR));
                }
                arrayList.add(new PolarizationCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case SCIENCE: {
                arrayList.add(new ScienceIntermediateTarget(scienceGoal, targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
            case SIDEBANDRATIO: {
                arrayList.add(new SidebandRatioCalIntermediateTarget(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager, n, enumSet, sBGenerationContext));
                return arrayList;
            }
        }
        throw new UnsupportedOperationException("Could not generate intermediate target with parameters set to target='" + targetWithIntent + "', ssp='" + (Object)((Object)spectralSetupParameters) + "', array='" + (Object)((Object)requestedArray) + "'.");
    }
}

