/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.valuetypes.Time;

public class TPRasterData {
    private double n_repeat = 0.0;
    private Time t_osmax = Time.createTime();
    private Time t_rect = Time.createTime();
    private boolean isSolarTPSB = false;
    private Time t_expectedTotalITOS = Time.createTime();

    private TPRasterData(Builder builder) {
        this.n_repeat = builder.n_repeat;
        this.t_osmax = builder.t_osmax;
        this.t_rect = builder.t_rect;
        this.isSolarTPSB = builder.isSolarTPSB;
        this.t_expectedTotalITOS = builder.t_expectedTotalITOS;
    }

    public void setN_repeat(double d) {
        this.n_repeat = d;
    }

    public void setT_osmax(Time time) {
        this.t_osmax = time;
    }

    public void setT_rect(Time time) {
        this.t_rect = time;
    }

    public void setSolarTPSB(boolean bl) {
        this.isSolarTPSB = bl;
    }

    public boolean isSolarTPSB() {
        return this.isSolarTPSB;
    }

    public double getN_repeat() {
        return this.n_repeat;
    }

    public Time getT_osmax() {
        return this.t_osmax;
    }

    public Time getT_rect() {
        return this.t_rect;
    }

    public Time getT_expectedTotalITOS() {
        return this.t_expectedTotalITOS;
    }

    public void setT_expectedTotalITOS(Time time) {
        this.t_expectedTotalITOS = time;
    }

    public TPRasterData deepCopy() {
        Builder builder = new Builder();
        builder.isSolarTPSB(this.isSolarTPSB()).n_repeat(this.getN_repeat()).t_osmax(this.getT_osmax().deepCopy()).t_rect(this.getT_rect().deepCopy()).t_expectedTotalITOS(this.getT_expectedTotalITOS().deepCopy());
        return builder.build();
    }

    public static class Builder {
        private double n_repeat;
        private Time t_osmax;
        private Time t_rect;
        private boolean isSolarTPSB;
        public Time t_expectedTotalITOS;

        public Builder t_expectedTotalITOS(Time time) {
            this.t_expectedTotalITOS = time;
            return this;
        }

        public Builder n_repeat(double d) {
            this.n_repeat = d;
            return this;
        }

        public Builder isSolarTPSB(boolean bl) {
            this.isSolarTPSB = bl;
            return this;
        }

        public Builder t_osmax(Time time) {
            this.t_osmax = time;
            return this;
        }

        public Builder t_rect(Time time) {
            this.t_rect = time;
            return this;
        }

        public TPRasterData build() {
            return new TPRasterData(this);
        }
    }
}

