/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.CalibrationConfiguration;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.ConfigurationBound;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.ObjectFactory;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.ReceiverRelatedTime;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.SpectralMode;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimeQueryInterface;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationTimeException;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Time;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;

public class CalibrationConfigurationHelper
implements CalibrationTimeQueryInterface {
    private CalibrationConfiguration calibrationConfiguration = null;
    private static CalibrationConfigurationHelper instance;

    public CalibrationConfiguration getCalibrationConfiguration() {
        return this.calibrationConfiguration;
    }

    private CalibrationConfigurationHelper() throws FileNotFoundException, JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        assert (jAXBContext != null && unmarshaller != null);
        ValidationEventCollector validationEventCollector = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)validationEventCollector);
        InputStream inputStream = null;
        String string = System.getProperty("Telescope", "Cycle3");
        String string2 = string + "CalibrationConfiguration.xml";
        Log.logger(CalibrationConfigurationHelper.class).fine("Loading CALIBRATIONCONFIGURATIONFILE: " + string2);
        try {
            ValidationEvent[] validationEventArray = MiscUtils.findResource(AlmaPolicies.ALMA_POLICIES_PROPERTIES_FOLDER, string2);
            inputStream = validationEventArray.openStream();
        }
        catch (Exception exception) {
            Log.logger(AlmaCapabilities.class).log(Level.WARNING, "Error accessing " + string2 + " file: " + exception.getMessage(), (Throwable)exception);
        }
        assert (inputStream != null);
        this.calibrationConfiguration = (CalibrationConfiguration)unmarshaller.unmarshal(inputStream);
        if (validationEventCollector.hasEvents()) {
            for (ValidationEvent validationEvent : validationEventCollector.getEvents()) {
                Log.logger(CalibrationConfigurationHelper.class).warning(validationEvent.getMessage());
            }
            throw new JAXBException("Unable to unmarshall calibration configuration XML");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (CalibrationConfiguration.Calibration calibration : this.calibrationConfiguration.getCalibration()) {
            for (ConfigurationBound configurationBound : calibration.getConfigurationBound()) {
                stringBuffer.append(configurationBound.getName() + " cycle time \n");
                for (ReceiverRelatedTime receiverRelatedTime : configurationBound.getCycleTime()) {
                    stringBuffer.append("band " + receiverRelatedTime.getReceiverBand() + "=" + receiverRelatedTime.getTime().getContent() + " " + receiverRelatedTime.getTime().getUnit() + " ");
                }
                stringBuffer.append("\n");
                stringBuffer.append(configurationBound.getName() + " scan time \n");
                for (ReceiverRelatedTime receiverRelatedTime : configurationBound.getDefaultIntegrationTime()) {
                    stringBuffer.append("band " + receiverRelatedTime.getReceiverBand() + "=" + receiverRelatedTime.getTime().getContent() + " " + receiverRelatedTime.getTime().getUnit() + " ");
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public static CalibrationConfigurationHelper getInstance() throws FileNotFoundException, JAXBException {
        if (null == instance) {
            instance = new CalibrationConfigurationHelper();
        }
        return instance;
    }

    @Override
    public Time getCalibrationTime(Configuration configuration, ObsType obsType, CorrelatorType correlatorType, CalibrationTimeQueryInterface.CalibrationTimeType calibrationTimeType, int n, SpectralMode spectralMode) throws UnableToDetermineCalibrationTimeException {
        if (configuration == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: configuration");
        }
        if (obsType == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: calibrationType");
        }
        if (correlatorType == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: correlatorType");
        }
        if (calibrationTimeType == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: calibrationTimeType");
        }
        if (spectralMode == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: spectralMode");
        }
        if (this.calibrationConfiguration == null) {
            throw new UnableToDetermineCalibrationTimeException("Unable to process calibration time configuration XML file: processing of the calibration configuration file failed.");
        }
        if (!EnumSet.of(CalibrationTimeQueryInterface.CalibrationTimeType.CYCLETIME, CalibrationTimeQueryInterface.CalibrationTimeType.DEFAULTINTEGRATIONTIME).contains((Object)calibrationTimeType)) {
            throw new IllegalArgumentException("Unable to process a calibration type of " + (Object)((Object)calibrationTimeType));
        }
        for (CalibrationConfiguration.Calibration calibration : this.calibrationConfiguration.getCalibration()) {
            if (!calibration.getCorrelator().name().equals(correlatorType.toString()) || !calibration.getType().toString().equals(obsType.toString())) continue;
            for (ConfigurationBound configurationBound : calibration.getConfigurationBound()) {
                List<ReceiverRelatedTime> list = null;
                if (!configurationBound.getSpectralMode().equals((Object)spectralMode) || !configurationBound.getName().equals(configuration.getName())) continue;
                switch (calibrationTimeType) {
                    case CYCLETIME: {
                        list = configurationBound.getCycleTime();
                        break;
                    }
                    case DEFAULTINTEGRATIONTIME: {
                        list = configurationBound.getDefaultIntegrationTime();
                        break;
                    }
                    default: {
                        throw new UnableToDetermineCalibrationTimeException("Unknown calibration time type specified: " + (Object)((Object)calibrationTimeType));
                    }
                }
                assert (list != null);
                for (ReceiverRelatedTime receiverRelatedTime : list) {
                    if (n != receiverRelatedTime.getReceiverBand()) continue;
                    String string = "Found " + receiverRelatedTime.getTime().getContent() + " for:" + (Object)((Object)calibrationTimeType) + " for configuration bound calibration " + (Object)((Object)obsType) + " for receiver " + n + " for correlator type " + (Object)((Object)correlatorType) + " where the configuration is " + configuration.getName() + " and spectral mode is " + (Object)((Object)spectralMode);
                    Log.logger(CalibrationConfigurationHelper.class).fine(string);
                    switch (receiverRelatedTime.getTime().getUnit().toUpperCase()) {
                        case "S": {
                            return Time.createTime((double)receiverRelatedTime.getTime().getContent(), (String)Time.UNIT_S);
                        }
                        case "MIN": {
                            return Time.createTime((double)receiverRelatedTime.getTime().getContent(), (String)Time.UNIT_MIN);
                        }
                    }
                    throw new UnableToDetermineCalibrationTimeException("Unknown time unit type: " + receiverRelatedTime.getTime().getUnit());
                }
            }
        }
        String string = "Unable to find " + (Object)((Object)calibrationTimeType) + " for configuration bound calibration " + (Object)((Object)obsType) + " for receiver " + n + " for correlator type " + (Object)((Object)correlatorType) + " where the configuration is " + configuration.getName() + " and spectral mode is " + (Object)((Object)spectralMode);
        Log.logger(CalibrationConfigurationHelper.class).warning(string);
        throw new UnableToDetermineCalibrationTimeException(string);
    }

    @Override
    public Time getCalibrationTime(ObsType obsType, CorrelatorType correlatorType, CalibrationTimeQueryInterface.CalibrationTimeType calibrationTimeType, int n, SpectralMode spectralMode) throws UnableToDetermineCalibrationTimeException {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        for (UIManager.LookAndFeelInfo object2 : UIManager.getInstalledLookAndFeels()) {
            if (!"Metal".equals(object2.getName())) continue;
            try {
                UIManager.setLookAndFeel(object2.getClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                exception.printStackTrace();
            }
            break;
        }
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        Object object = null;
        try {
            object = CalibrationConfigurationHelper.getInstance();
        }
        catch (FileNotFoundException | JAXBException throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
        assert (object != null);
        for (Configuration configuration : Configuration.getKnownConfigurations(RequestedArray.TWELVE_M)) {
            void var4_11;
            Object var4_9 = null;
            try {
                Time time = ((CalibrationConfigurationHelper)object).getCalibrationTime(configuration, ObsType.PHASE, CorrelatorType.BL, CalibrationTimeQueryInterface.CalibrationTimeType.CYCLETIME, 2, null);
            }
            catch (UnableToDetermineCalibrationTimeException unableToDetermineCalibrationTimeException) {
                // empty catch block
            }
            if (var4_11 == null) continue;
            System.out.println("Time is: " + var4_11);
        }
    }
}

