/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimerInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Time;

abstract class CalibrationTimer
implements CalibrationTimerInterface {
    private static final int FIVE_MINS = 300;
    protected SpectralSpec ss = null;
    protected SBGenerationContext sbContext = null;

    public CalibrationTimer(SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sbContext");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: ss");
        }
        this.ss = spectralSpec;
        this.sbContext = sBGenerationContext;
    }

    @Override
    public Time getScanDuration() {
        return this.getScanDuration(this.getDefaultIntegrationTime());
    }

    protected Time getAlignedSubscanDuration(Time time) {
        double d = time.getContentInUnits(Time.UNIT_S);
        double d2 = this.ss.getCorrelatorConfiguration().getIntegrationDuration().getContentInUnits(Time.UNIT_S);
        double d3 = this.ss.getCorrelatorExpert().calcSubscanDuration(d, d2, null);
        return Time.createTime((double)d3, (String)Time.UNIT_S);
    }

    @Override
    public Time getScanDuration(Time time) {
        if (time.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)Time.createTime((double)5.0, (String)Time.UNIT_MIN))) {
            double d = time.getContentInUnits(Time.UNIT_S);
            long l = Math.round(d % 300.0);
            if (l > 0L) {
                return Time.createTimeSec(60.48);
            }
            return Time.createTimeSec(302.4);
        }
        return this.getAlignedSubscanDuration(time);
    }
}

