/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.SpectralMode;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.intermediatetarget.PhaseCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationConfigurationHelper;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimeQueryInterface;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimer;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationTimeException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import java.io.FileNotFoundException;
import java.util.EnumSet;
import javax.xml.bind.JAXBException;

class ConfigurationDrivenPhaseTimer
extends CalibrationTimer {
    private static final Time VLBI_DEFAULT_PHASE_INT_TIME = Time.createTimeSec(30.0);
    protected ScienceGoal scienceGoal = null;
    private CalibrationConfigurationHelper calibrationConfigurationHelper = null;

    public ConfigurationDrivenPhaseTimer(ScienceGoal scienceGoal, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        super(spectralSpec, sBGenerationContext);
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        this.scienceGoal = scienceGoal;
        try {
            this.calibrationConfigurationHelper = CalibrationConfigurationHelper.getInstance();
        }
        catch (FileNotFoundException | JAXBException throwable) {
            Log.logger(ConfigurationDrivenPhaseTimer.class).warning("Unable to read in the configuration specific calibration parameter XML file");
            throw new WizardSBGenerationException(throwable);
        }
    }

    private Time getAdjustedTimeParameter(CalibrationTimeQueryInterface.CalibrationTimeType calibrationTimeType) {
        Time time = null;
        if (calibrationTimeType == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: calibrationTimeType");
        }
        if (!EnumSet.of(CalibrationTimeQueryInterface.CalibrationTimeType.SUBSCANTIME, CalibrationTimeQueryInterface.CalibrationTimeType.DEFAULTINTEGRATIONTIME).contains((Object)calibrationTimeType)) {
            throw new IllegalArgumentException("calibrationTimeType of " + (Object)((Object)calibrationTimeType) + " is unknown: cannot process it");
        }
        Time time2 = this.fetchTime(CalibrationTimeQueryInterface.CalibrationTimeType.DEFAULTINTEGRATIONTIME);
        Time time3 = time2.deepCopy();
        ReceiverBand receiverBand = this.sbContext.getGoal().getSpectralSetupParameters().getReceiverBand();
        if (PhaseCalIntermediateTarget.HIGHBANDS.contains(receiverBand)) {
            if (time2.isEqual((AbstractDoubleWithUnit)Time.createTimeSec(30.0), 0.001)) {
                time3 = Time.createTimeSec(30.0);
            } else if (time2.isEqual((AbstractDoubleWithUnit)Time.createTimeSec(60.0), 0.001)) {
                time3 = Time.createTimeSec(60.0);
            } else if (time2.isEqual((AbstractDoubleWithUnit)Time.createTimeSec(120.0), 0.001)) {
                time3 = Time.createTimeSec(120.0);
            }
        }
        assert (time3 != null);
        time3 = this.getAlignedSubscanDuration(time3);
        switch (calibrationTimeType) {
            case DEFAULTINTEGRATIONTIME: {
                time = time2;
                break;
            }
            case SUBSCANTIME: {
                time = time3;
                break;
            }
            default: {
                throw new IllegalArgumentException("calibrationTimeType of " + (Object)((Object)calibrationTimeType) + " is unknown: cannot process it");
            }
        }
        assert (time != null);
        return time;
    }

    @Override
    public Time getDefaultIntegrationTime() {
        return this.getAdjustedTimeParameter(CalibrationTimeQueryInterface.CalibrationTimeType.DEFAULTINTEGRATIONTIME);
    }

    private Time fetchTime(CalibrationTimeQueryInterface.CalibrationTimeType calibrationTimeType) {
        Object object;
        assert (this.calibrationConfigurationHelper != null);
        assert (this.scienceGoal != null);
        SchedBlockExpert.RequiredConfigurations requiredConfigurations = null;
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        assert (performanceParameters != null);
        TargetParameters[] targetParametersArray = performanceParameters.getScienceGoal().getTargetParameters();
        assert (targetParametersArray != null);
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        assert (spectralSetupParameters != null);
        SpectralMode spectralMode = spectralSetupParameters.isPureTDM() ? SpectralMode.TDM : SpectralMode.FDM;
        Frequency frequency = this.scienceGoal.getRepresentativeFrequencyInSky();
        assert (frequency != null);
        try {
            object = this.scienceGoal.getObsProposal();
            if (object != null && object.isVLBI()) {
                return VLBI_DEFAULT_PHASE_INT_TIME.deepCopy();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ConfigurationDrivenPhaseTimer.class).warning("Unable to determine if project is a VLBI project");
            throw new WizardSBGenerationException("Unable to determine if project is a VLBI project");
        }
        try {
            if (this.scienceGoal.getScienceGoalType().equals((Object)ScienceGoal.ScienceGoalType.TUNINGSPECIFIC)) {
                assert (this.scienceGoal.getParentScienceGoal() != null);
                requiredConfigurations = SchedBlockExpert.getRecommended12mConfigurations(this.scienceGoal.getParentScienceGoal(), frequency);
            } else {
                requiredConfigurations = SchedBlockExpert.getRecommended12mConfigurations(this.scienceGoal, frequency);
            }
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger(ConfigurationDrivenPhaseTimer.class).warning("Unable to determine 12m configurations to be used");
            throw new WizardSBGenerationException(invalidConfigurationParametersException);
        }
        assert (requiredConfigurations != null);
        Configuration configuration = requiredConfigurations.getBest12mExtConfig();
        assert (configuration != null);
        object = this.sbContext.getSBType();
        assert (object != null);
        if (!EnumSet.of(SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION, SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION).contains(object)) {
            throw new WizardSBGenerationException("A configuration-driven phase timer cannot be used with anything other than the 12-m array currently");
        }
        if (this.sbContext.getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION)) {
            try {
                configuration = requiredConfigurations.getTwelveMetreCompactConfig();
            }
            catch (SchedBlockExpert.UnableToDetermine12mCompactConfiguration unableToDetermine12mCompactConfiguration) {
                String string = "A second 12-m more compact configuration is recommended but could not be found: " + unableToDetermine12mCompactConfiguration.getMessage();
                Log.logger(ConfigurationDrivenPhaseTimer.class).warning(string);
                throw new WizardSBGenerationException(string);
            }
        }
        Time time = null;
        try {
            time = this.calibrationConfigurationHelper.getCalibrationTime(configuration, ObsType.PHASE, CorrelatorType.BL, calibrationTimeType, this.ss.getReceiverBand().getNumber(), spectralMode);
        }
        catch (UnableToDetermineCalibrationTimeException unableToDetermineCalibrationTimeException) {
            throw new WizardSBGenerationException(unableToDetermineCalibrationTimeException);
        }
        String string = String.format("For configuration %s at freq %.4g GHz the %s time is %.4g secs", configuration.getName(), performanceParameters.getRepresentativeFrequency().getContentInGHz(), calibrationTimeType.toString(), time.getContentInUnits(Time.UNIT_S));
        Log.logger(ConfigurationDrivenPhaseTimer.class).fine(string);
        assert (time != null);
        return time;
    }

    @Override
    public Time getCycleTime() {
        return this.fetchTime(CalibrationTimeQueryInterface.CalibrationTimeType.CYCLETIME);
    }
}

