/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.InterferometrySchedBlockGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import java.util.Collection;

public class ACASBGenerator
extends InterferometrySchedBlockGenerator {
    public ACASBGenerator() {
        super(RequestedArray.SEVEN_M);
        this.sbContext.setArray(this.array).setSBType(SBGeneratorTemplate.SchedBlockType.ACA7M);
    }

    @Override
    public double getAntennaMultiplier(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        return Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACA7M, scienceGoal);
    }

    @Override
    public Collection<Collection<SchedBlock>> getSchedBlocks(ScienceGoal scienceGoal) {
        Collection<Collection<SchedBlock>> collection = super.getSchedBlocks(scienceGoal);
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock : collection2) {
                schedBlock.getSbGenerationContext().setSBType(this.sbContext.getSBType());
            }
        }
        return collection;
    }
}

