/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockConsolidator;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTargetFactory;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.PolarizationCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public abstract class InterferometrySchedBlockGenerator
extends SBGeneratorTemplate {
    public InterferometrySchedBlockGenerator(RequestedArray requestedArray) {
        super(requestedArray);
    }

    @Override
    public Collection<Collection<SchedBlock>> getSchedBlocks(ScienceGoal scienceGoal) {
        Object object;
        Object object2;
        Object object3;
        List<IntermediateTarget> list;
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet;
        try {
            this.antennaRelatedTOSTimeMultiplier = this.getAntennaMultiplier(scienceGoal);
            this.sbContext.setAntennaRelatedTOSTimeMultiplier(this.antennaRelatedTOSTimeMultiplier);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException.getMessage());
        }
        Collection<ScienceGoal> collection = null;
        try {
            collection = ScienceGoalSchedBlockGenerator.splitByTuning(scienceGoal);
            if (collection.isEmpty() && !scienceGoal.getSpectralSetupParameters().isSpectralScan()) {
                throw new WizardSBGenerationException("Unable to determine tunings - is the spectral setup valid?");
            }
        }
        catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings | IndexOutOfBoundsException exception) {
            Log.logger(InterferometrySchedBlockGenerator.class).warning("Unable to split the science goal up into distinct tunings");
            throw new WizardSBGenerationException(exception);
        }
        assert (collection != null);
        try {
            enumSet = SchedBlockWorker.determineSBGenerationSchema(scienceGoal, this.array);
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new WizardSBGenerationException(unknownEntityException);
        }
        this.sbContext.setScienceGoal(scienceGoal).setSBGenerationSchema(enumSet);
        this.parentScienceGoal = scienceGoal;
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            list = this.getIntermediateTargets(scienceGoal, enumSet);
        } else if (collection.size() == 1) {
            list = this.getIntermediateTargets(scienceGoal, enumSet);
        } else {
            object3 = 1;
            list = new ArrayList<IntermediateTarget>();
            for (ScienceGoal object4 : collection) {
                object2 = object3;
                object3 = (Integer)object3 + 1;
                Integer n = object3;
                list.addAll(this.getIntermediateTargets(object4, (Integer)object2, enumSet));
            }
            this.removeRedundantCalibrationsFromOG1(list, enumSet);
        }
        object3 = SchedBlock.createSchedBlock();
        for (IntermediateTarget intermediateTarget : list) {
            for (Target target : intermediateTarget.getTargets()) {
                this.addTargetToSchedBlock((SchedBlock)object3, target);
            }
            this.getObservingGroup((SchedBlock)object3, "Calibrators 1");
            for (OrderedTarget orderedTarget : intermediateTarget.getOrderedTargets()) {
                object = orderedTarget.getTarget();
                ObservingGroup observingGroup = this.getObservingGroup((SchedBlock)object3, (Target)object);
                orderedTarget.setIndex(observingGroup.getOrderedTargetCount() + 1);
                observingGroup.addOrderedTarget(orderedTarget);
            }
            object2 = intermediateTarget.getRepresentativeTarget();
            if (object2 == null) continue;
            this.setRepresentativeParameters((SchedBlock)object3, (Target)object2);
        }
        boolean bl = InterferometrySchedBlockGenerator.enforceMinimumOnSourceTimePerSB((SchedBlock)object3);
        double d = this.antennaRelatedTOSTimeMultiplier;
        if (bl && this.antennaRelatedTOSTimeMultiplier < 1.0) {
            d = 1.0;
        }
        ((SchedBlock)object3).setSbGenerationContext(this.sbContext);
        SchedBlockWorker.setupSchedBlock(scienceGoal, (SchedBlock)object3, this.array, d, enumSet);
        SchedBlockWorker.renameMultipleTuningObservingGroups((SchedBlock)object3, enumSet);
        SchedBlockConsolidator.consolidate((SchedBlock)object3);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object3);
        object = new ArrayList();
        object.add(arrayList);
        this.setObservingGroupDopplerTarget((SchedBlock)object3);
        return object;
    }

    private void removeRedundantCalibrationsFromOG1(List<IntermediateTarget> list, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.POLARISATION)) {
            ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
            boolean bl = false;
            for (IntermediateTarget intermediateTarget : list) {
                PolarizationCalIntermediateTarget polarizationCalIntermediateTarget;
                if (!(intermediateTarget instanceof PolarizationCalIntermediateTarget) || (polarizationCalIntermediateTarget = (PolarizationCalIntermediateTarget)intermediateTarget).getObservingGroupPointer() != ObservingGroupManager.ObservingGroupType.CALIBRATOR.getNominalObservingGroup().intValue()) continue;
                if (bl) {
                    arrayList.add(intermediateTarget);
                    continue;
                }
                bl = true;
            }
            list.removeAll(arrayList);
        }
    }

    @Override
    protected List<IntermediateTarget> getAmpCalInclusiveSystemCalIntermediateTargets(ScienceGoal scienceGoal, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        ArrayList<QuerySource> arrayList = new ArrayList<QuerySource>();
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE));
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_BANDPASS));
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_PHASE));
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POINTING));
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.POLARISATION)) {
            arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POLARIZATION));
        }
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        for (QuerySource object : arrayList) {
            object.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
            object.setQueryCenter(skyCoordinates.deepCopy());
            object.setMaxSources(40);
        }
        ArrayList arrayList2 = new ArrayList();
        for (QuerySource querySource : arrayList) {
            arrayList2.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        return arrayList2;
    }

    @Override
    protected List<IntermediateTarget> getSystemCalIntermediateTargets(ScienceGoal scienceGoal, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        ArrayList<QuerySource> arrayList = new ArrayList<QuerySource>();
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_BANDPASS));
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_PHASE));
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POINTING));
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.POLARISATION)) {
            arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POLARIZATION));
        }
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        for (QuerySource object : arrayList) {
            object.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
            object.setQueryCenter(skyCoordinates.deepCopy());
            object.setMaxSources(40);
        }
        ArrayList arrayList2 = new ArrayList();
        for (QuerySource querySource : arrayList) {
            arrayList2.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        return arrayList2;
    }

    @Override
    protected List<IntermediateTarget> getManualCalIntermediateTargets(ScienceGoal scienceGoal, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POINTING);
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        querySource.setQueryCenter(skyCoordinates.deepCopy());
        querySource.setMaxSources(40);
        arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        for (CalibrationTargetParameters targetWithIntent : calibrationSetupParameters.getCalibrationTargetParameters()) {
            if (targetWithIntent.getObsType().equals((Object)ObsType.POINTING)) continue;
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, targetWithIntent, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        for (TargetWithIntent targetWithIntent : calibrationSetupParameters.getQuerySource()) {
            if (((QuerySource)targetWithIntent).getObsType().equals((Object)ObsType.POINTING)) continue;
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, targetWithIntent, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        return arrayList;
    }
}

