/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import java.util.EnumSet;

public class SBGenerationContext {
    private RequestedArray array = null;
    private SBGeneratorTemplate.SchedBlockType sbType = null;
    private ScienceGoal goal = null;
    private EnumSet<SBGeneratorTemplate.SBGenerationSchema> schemaToUseForSBGeneration = null;
    private SchedBlock sb = null;
    private Integer spectralScanTuningIndex = null;
    private Configuration configuration = null;
    private double antennaRelatedTOSTimeMultiplier = 1.0;

    public final RequestedArray getArray() {
        if (this.array == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: array");
        }
        return this.array;
    }

    public final SBGeneratorTemplate.SchedBlockType getSBType() {
        if (this.sbType == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sbType");
        }
        return this.sbType;
    }

    public boolean isVLBI() {
        return this.schemaToUseForSBGeneration.contains((Object)SBGeneratorTemplate.SBGenerationSchema.VLBI);
    }

    public final ScienceGoal getGoal() {
        return this.goal;
    }

    public final EnumSet<SBGeneratorTemplate.SBGenerationSchema> getSchemaToUseForSBGeneration() {
        if (this.schemaToUseForSBGeneration == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: schemaToUseForSBGeneration");
        }
        return this.schemaToUseForSBGeneration;
    }

    public final SchedBlock getSB() {
        return this.sb;
    }

    public SBGenerationContext setArray(RequestedArray requestedArray) {
        this.array = requestedArray;
        return this;
    }

    public SBGenerationContext setSBType(SBGeneratorTemplate.SchedBlockType schedBlockType) {
        this.sbType = schedBlockType;
        return this;
    }

    public SBGenerationContext setScienceGoal(ScienceGoal scienceGoal) {
        this.goal = scienceGoal;
        return this;
    }

    public SBGenerationContext setSBGenerationSchema(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        this.schemaToUseForSBGeneration = enumSet;
        return this;
    }

    public SBGenerationContext setSB(SchedBlock schedBlock) {
        this.sb = schedBlock;
        return this;
    }

    public Configuration getMostExtendedConfiguration() {
        if (this.goal != null && this.goal.getPerformanceParameters().isAngularResolutionModeAny()) {
            SBGenerationContext sBGenerationContext = this;
            return sBGenerationContext.configuration.getMostExtendedAnyConfiguration();
        }
        return this.configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public SBGenerationContext setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public String toString() {
        return "SBGenerationContext [array=" + (Object)((Object)this.array) + ", sbType=" + (Object)((Object)this.sbType) + ", goal=" + this.goal + ", schemaToUseForSBGeneration=" + this.schemaToUseForSBGeneration + ", sb=" + this.sb + "]";
    }

    public SBGenerationContext deepCopy() {
        SBGenerationContext sBGenerationContext = new SBGenerationContext();
        sBGenerationContext.setArray(this.getArray()).setScienceGoal(this.getGoal()).setSBType(this.getSBType()).setSB(this.getSB() != null ? this.getSB() : null).setConfiguration(this.getConfiguration()).setSBGenerationSchema(this.getSchemaToUseForSBGeneration()).setAntennaRelatedTOSTimeMultiplier(this.getAntennaRelatedTOSTimeMultiplier());
        return sBGenerationContext;
    }

    public boolean isTM1SB() {
        return this.sbType.equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION);
    }

    public boolean isTM2SB() {
        return this.sbType.equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION);
    }

    public boolean isTPScienceSB() {
        return this.sbType.equals((Object)SBGeneratorTemplate.SchedBlockType.TPSCIENCE);
    }

    public boolean isTPAmpCalSB() {
        return this.sbType.equals((Object)SBGeneratorTemplate.SchedBlockType.TPAMPCAL);
    }

    public boolean isSolar() {
        return this.schemaToUseForSBGeneration.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SOLAR);
    }

    public Integer getSpectralScanTuningIndex() {
        return this.spectralScanTuningIndex;
    }

    public void setSpectralScanTuningIndex(Integer n) {
        this.spectralScanTuningIndex = n;
    }

    public double getAntennaRelatedTOSTimeMultiplier() {
        return this.antennaRelatedTOSTimeMultiplier;
    }

    public void setAntennaRelatedTOSTimeMultiplier(double d) {
        this.antennaRelatedTOSTimeMultiplier = d;
    }
}

