/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTargetFactory;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.RepresentativeTargetCalculator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerator;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class SBGeneratorTemplate
implements SBGenerator {
    protected SBGenerationContext sbContext = new SBGenerationContext();
    protected ScienceGoal parentScienceGoal = null;
    protected Double antennaRelatedTOSTimeMultiplier = 1.0;
    private ObservingGroupManager observingGroupManager = new ObservingGroupManager();
    protected final RequestedArray array;
    private Integer tuningGroup = 1;

    public abstract double getAntennaMultiplier(ScienceGoal var1) throws InvalidObsProgramParametersException;

    public SBGeneratorTemplate(RequestedArray requestedArray) {
        this.array = requestedArray;
        this.sbContext.setArray(requestedArray);
        this.observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.CALIBRATOR, 1);
        this.observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
    }

    protected void setRepresentativeParameters(SchedBlock schedBlock, Target target) {
        Object object;
        Object object2;
        FieldSource fieldSource = target.getFieldSource();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        schedulingConstraints.setRepresentativeTarget(target);
        try {
            object2 = fieldSource.getSourceCoordinates().deepCopy();
            object2.getLatitude().convertToUnit(Latitude.UNIT_DEG);
            object2.getLongitude().convertToUnit(Longitude.UNIT_DEG);
            schedulingConstraints.setRepresentativeCoordinates((SkyCoordinates)object2);
        }
        catch (Exception exception) {
            GUIUtilities.error(null, "Could not get coordinate information from representative target");
            object = SkyCoordinates.createAbsoluteCoordinates();
            object.getLatitude().convertToUnit(Latitude.UNIT_DEG);
            object.getLongitude().convertToUnit(Longitude.UNIT_DEG);
            schedulingConstraints.setRepresentativeCoordinates((SkyCoordinates)object);
        }
        try {
            object2 = target.getSpectralSpec().getFrequencySetup().getReceiverBand();
            schedulingConstraints.setRepresentativeReceiverBand((String)object2);
        }
        catch (Exception exception) {
            GUIUtilities.error(null, "Could not get frequency information from representative target");
            object = FrequencySetup.RECEIVERBAND_UNDEFINED;
            schedulingConstraints.setRepresentativeReceiverBand((String)object);
        }
    }

    protected void sortTargets(List<IntermediateTarget> list) {
        Collections.sort(list, new Comparator<IntermediateTarget>(){

            @Override
            public int compare(IntermediateTarget intermediateTarget, IntermediateTarget intermediateTarget2) {
                return intermediateTarget.getTargetPriority() - intermediateTarget2.getTargetPriority();
            }
        });
    }

    protected List<IntermediateTarget> getIntermediateTargets(ScienceGoal scienceGoal, Integer n, EnumSet<SBGenerationSchema> enumSet) {
        this.tuningGroup = n;
        return this.getIntermediateTargets(scienceGoal, enumSet);
    }

    protected List<IntermediateTarget> getIntermediateTargets(ScienceGoal scienceGoal, EnumSet<SBGenerationSchema> enumSet) {
        if (enumSet == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: schemaToUseForSBGeneration");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: goal");
        }
        CopyOnWriteArrayList<IntermediateTarget> copyOnWriteArrayList = new CopyOnWriteArrayList<IntermediateTarget>();
        if (MiscUtils.isParallelismToBeUsed()) {
            // empty if block
        }
        Arrays.asList(scienceGoal.getTargetParameters()).stream().forEach(targetParameters -> copyOnWriteArrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, targetParameters, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), this.tuningGroup, this.sbContext)));
        CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
        if (calibrationSetupParameters.isSystemDefinedCalibration()) {
            copyOnWriteArrayList.addAll(this.getSystemCalIntermediateTargets(scienceGoal, this.tuningGroup, enumSet));
        } else if (calibrationSetupParameters.isAmplitudeSpecificSystemDefinedCalibration()) {
            copyOnWriteArrayList.addAll(this.getAmpCalInclusiveSystemCalIntermediateTargets(scienceGoal, this.tuningGroup, enumSet));
        } else {
            copyOnWriteArrayList.addAll(this.getManualCalIntermediateTargets(scienceGoal, this.tuningGroup, enumSet));
        }
        this.sortTargets(copyOnWriteArrayList);
        return copyOnWriteArrayList;
    }

    protected abstract List<IntermediateTarget> getManualCalIntermediateTargets(ScienceGoal var1, Integer var2, EnumSet<SBGenerationSchema> var3);

    protected abstract List<IntermediateTarget> getSystemCalIntermediateTargets(ScienceGoal var1, Integer var2, EnumSet<SBGenerationSchema> var3);

    protected abstract List<IntermediateTarget> getAmpCalInclusiveSystemCalIntermediateTargets(ScienceGoal var1, Integer var2, EnumSet<SBGenerationSchema> var3);

    private void sortOrderedGroupsByIndex(SchedBlock schedBlock) {
        ObservingGroup[] observingGroupArray = schedBlock.getObservingGroup();
        final List<String> list = this.observingGroupManager.getOrderedListOfObservingGroupNames();
        Arrays.sort(observingGroupArray, new Comparator<ObservingGroup>(){

            @Override
            public int compare(ObservingGroup observingGroup, ObservingGroup observingGroup2) {
                return list.indexOf(observingGroup.getName()) - list.indexOf(observingGroup2.getName());
            }
        });
        schedBlock.setObservingGroup(observingGroupArray);
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            try {
                observingGroup.setIndex(this.observingGroupManager.getObservingGroupIndex(observingGroup.getName()));
            }
            catch (ObservingGroupManager.ObservingGroupNotFoundException observingGroupNotFoundException) {
                throw new RuntimeException("Unable to determine group index");
            }
        }
    }

    protected void addTargetToSchedBlock(SchedBlock schedBlock, Target target) {
        schedBlock.addFieldSource(target.getFieldSource());
        schedBlock.addSpectralSpec(target.getSpectralSpec());
        for (ObservingParameters object : target.getObservingParameters()) {
            schedBlock.addObservingParameters(object);
        }
        schedBlock.addTarget(target);
        for (AbstractBaseBandConfig abstractBaseBandConfig : target.getSpectralSpec().getCorrelatorConfiguration().getBaseBandConfig()) {
            abstractBaseBandConfig.getBaseBandSpecification();
        }
    }

    public ObservingGroupManager getObservingGroupManager() {
        return this.observingGroupManager;
    }

    public void setObservingGroupManager(ObservingGroupManager observingGroupManager) {
        this.observingGroupManager = observingGroupManager;
    }

    public ObservingGroup getObservingGroup(SchedBlock schedBlock, String string) {
        ObservingGroupManager.ObservingGroupData observingGroupData = null;
        try {
            observingGroupData = this.observingGroupManager.getObservingGroupByIndex(this.observingGroupManager.getObservingGroupIndex(string));
        }
        catch (ObservingGroupManager.ObservingGroupNotFoundException observingGroupNotFoundException) {
            throw new RuntimeException(observingGroupNotFoundException);
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            if (!observingGroup.getName().equals(observingGroupData.getObservingGroupName()) || observingGroup.getIndex() != observingGroupData.getObservingGroupIndex().intValue()) continue;
            return observingGroup;
        }
        ObservingGroup observingGroup = ObservingGroup.createObservingGroup();
        observingGroup.setName(observingGroupData.getObservingGroupName());
        observingGroup.setIndex(observingGroupData.getObservingGroupIndex());
        schedBlock.addObservingGroup(observingGroup);
        this.sortOrderedGroupsByIndex(schedBlock);
        return observingGroup;
    }

    protected ObservingGroup getObservingGroup(SchedBlock schedBlock, Target target) {
        ObservingGroupManager.ObservingGroupData observingGroupData = null;
        try {
            observingGroupData = this.observingGroupManager.getObservingGroupByIndex(target.getIntendedObservingGroupList()[0]);
        }
        catch (ObservingGroupManager.ObservingGroupNotFoundException observingGroupNotFoundException) {
            throw new WizardSBGenerationException(observingGroupNotFoundException);
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            if (!observingGroup.getName().equals(observingGroupData.getObservingGroupName()) || observingGroup.getIndex() != observingGroupData.getObservingGroupIndex().intValue()) continue;
            return observingGroup;
        }
        ObservingGroup observingGroup = ObservingGroup.createObservingGroup();
        observingGroup.setName(observingGroupData.getObservingGroupName());
        observingGroup.setIndex(observingGroupData.getObservingGroupIndex());
        schedBlock.addObservingGroup(observingGroup);
        this.sortOrderedGroupsByIndex(schedBlock);
        return observingGroup;
    }

    public static boolean enforceMinimumOnSourceTimePerSB(SchedBlock schedBlock) {
        ArrayList<ScienceParameters> arrayList = new ArrayList<ScienceParameters>();
        Time time = Time.createTimeSec(0.0);
        for (ObservingGroup object : schedBlock.getObservingGroup()) {
            for (OrderedTarget orderedTarget : object.getOrderedTarget()) {
                Target target2 = orderedTarget.getTarget();
                for (ScienceParameters scienceParameters : target2.getScienceParametersList()) {
                    time.aggregate(scienceParameters.getIntegrationTime().getTime());
                    arrayList.add(scienceParameters);
                }
            }
        }
        boolean bl = false;
        Time time2 = Time.createTime();
        for (Target target3 : schedBlock.getAllTargets(Optional.of(target -> target.hasAmplitudeCalParameters()))) {
            for (AmplitudeCalParameters amplitudeCalParameters : target3.getAmplitudeCalParametersList()) {
                time2.aggregate(amplitudeCalParameters.getDefaultIntegrationTime());
            }
        }
        for (Target target4 : schedBlock.getAllTargets(Optional.of(target -> target.hasBandpassCalParameters()))) {
            for (BandpassCalParameters bandpassCalParameters : target4.getBandpassCalParametersList()) {
                time2.aggregate(bandpassCalParameters.getDefaultIntegrationTime());
            }
        }
        Time time3 = Time.max(time2 = (Time)time2.divide(2.0), AlmaPolicies.getInstance().getMinTimeOnSourcePerSB());
        if (time.isLessThan((AbstractDoubleWithUnit)time3)) {
            bl = true;
            Integer n = arrayList.size();
            Time time4 = (Time)((Time)time3.minus((AbstractDoubleWithUnit)time)).divide(n.intValue());
            for (ScienceParameters scienceParameters : arrayList) {
                Time time5 = (Time)scienceParameters.getIntegrationTime().getTime().plus((AbstractDoubleWithUnit)time4);
                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time5.getContentInDefaultUnits(), (String)IntTimeSource.UNIT_S));
            }
        }
        return bl;
    }

    @Override
    public void setObservingGroupDopplerTarget(SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            String string = observingGroup.getName();
            assert (string != null);
            try {
                if (!SBTimeEstimateHelper.GroupType.SCIENCE.equals((Object)SBTimeEstimateHelper.GroupType.getGroupType(string))) continue;
                RepresentativeTargetCalculator representativeTargetCalculator = new RepresentativeTargetCalculator();
                Target target = representativeTargetCalculator.getRepresentativeScienceTargetInObservingGroup(observingGroup, schedBlock, this.sbContext);
                observingGroup.setMainTarget(target);
                Log.logger(SBGeneratorTemplate.class).fine(String.format("Rep. target for observing group %s is %s", observingGroup.getName(), target.getFieldSource().getSourceName()));
            }
            catch (SchedBlock.UnableToFindParentScienceGoalException | SBTimeEstimateHelper.UnknownObservingGroupTypeException | RepresentativeTargetCalculator.UnableToDetermineRepTargetForObservingGroupException exception) {
                throw new WizardSBGenerationException("Unable to set the doppler target for the observing group: " + string + " " + exception.getMessage());
            }
        }
    }

    private /* synthetic */ void lambda$getIntermediateTargets$92(List list, ScienceGoal scienceGoal, TargetParameters targetParameters) {
        list.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, targetParameters, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), this.tuningGroup, this.sbContext));
    }

    public static enum SchedBlockType {
        SCHEDBLOCKTYPEUNKNOWN("", null),
        TWELVEMEXTENDEDCONFIGURATION("12m extended configuration", RequestedArray.TWELVE_M),
        TWELVEMCOMPACTCONFIGURATION("12m compact configuration", RequestedArray.TWELVE_M),
        ACA7M("ACA 7m", RequestedArray.SEVEN_M),
        TPAMPCAL("TP ampcal", RequestedArray.TP),
        TPSCIENCE("TP science SB", RequestedArray.TP);

        private String description;
        private RequestedArray arrayType;

        public String getDescription() {
            return this.description;
        }

        private SchedBlockType(String string2, RequestedArray requestedArray) {
            this.description = string2;
            this.setArrayType(requestedArray);
        }

        public RequestedArray getArrayType() {
            return this.arrayType;
        }

        public void setArrayType(RequestedArray requestedArray) {
            this.arrayType = requestedArray;
        }
    }

    public static enum SBGenerationSchema {
        STANDARD_CYCLE1,
        SPECTRAL_SCAN,
        MULTIPLE_TUNING,
        POLARISATION,
        ACA_7M,
        ACA_TP,
        VLBI,
        OBSERVATORYGOAL,
        SOLAR,
        SPECTRAL_SCAN_MULTIPLE_SB;

    }
}

