/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.sbbuilder.TwelveMetreArrayARLimitsExpert;
import alma.obsprep.services.generator.refactored.sbbuilder.TwelveMetreExtendedConfigurationSBGenerator;
import alma.valuetypes.Angle;

public class TM1ArrayARLimitsExpert
extends TwelveMetreArrayARLimitsExpert {
    @Override
    public Range calcResolutionRange(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, ObsProposal.VLBIProposalDetectedException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument - the argument goal cannot be null");
        }
        try {
            if (scienceGoal.getObsProposal().isVLBI()) {
                throw new ObsProposal.VLBIProposalDetectedException();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TwelveMetreExtendedConfigurationSBGenerator.class).warning("Unable to determine if project is a VLBI project");
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        double d = scienceGoal.getPerformanceParameters().getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
        double d2 = d - d * 0.2;
        double d3 = d + d * 0.2;
        return new Range(d2, d3);
    }
}

