/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.TwelveMetreArrayARLimitsExpert;
import alma.obsprep.services.generator.refactored.sbbuilder.TwelveMetreCompactConfigurationSBGenerator;
import alma.valuetypes.Frequency;

public class TM2ArrayARLimitsExpert
extends TwelveMetreArrayARLimitsExpert
implements AngularResolutionLimitsExpertInterface {
    @Override
    public Range calcResolutionRange(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, ObsProposal.VLBIProposalDetectedException {
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument - the argument goal cannot be null");
        }
        try {
            if (scienceGoal.getObsProposal().isVLBI()) {
                throw new ObsProposal.VLBIProposalDetectedException();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TwelveMetreCompactConfigurationSBGenerator.class).warning("Unable to determine if project is a VLBI project");
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        if (scienceGoal.getNumberOf12mConfigurations() == 1) {
            throw new InvalidObsProgramParametersException("No second 12m configuration detected");
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        Configuration configuration = null;
        try {
            configuration = Configuration.getBestConfiguration(performanceParameters.getDesiredAngularResolution(), frequency, RequestedArray.TWELVE_M, scienceGoal);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger((Object)this).severe("Cannot establish the best array configuration for a desired angular resolution of " + performanceParameters.getDesiredAngularResolution() + " with a rep. freq of " + (Object)((Object)frequency));
            throw new InvalidObsProgramParametersException(invalidConfigurationParametersException);
        }
        Double d = null;
        if (Configuration.getIsSecondConfigurationRequired(configuration, performanceParameters.getDesiredLargestScale(), frequency, scienceGoal)) {
            try {
                Configuration configuration2 = Configuration.getSecondCompactConfiguration(configuration);
                d = configuration2.getAchievableResolution(frequency.getContentInGHz(), scienceGoal, RequestedArray.TWELVE_M);
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                throw new InvalidObsProgramParametersException("A second 12m compact configuration is expected");
            }
        } else {
            throw new InvalidObsProgramParametersException("A second 12m compact configuration is expected");
        }
        assert (d != null);
        return new Range(d * 0.8, d * 1.2);
    }
}

