/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.MatchedConfiguration;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.TwelveMetreSBGenerator;
import alma.obsprep.util.AngleRange;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;

public abstract class TwelveMetreArrayARLimitsExpert
implements AngularResolutionLimitsExpertInterface {
    private void ensureNearestConfigurationARIsIncludedInSBConstraintsARRange(ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations, SchedBlock schedBlock) {
        Object object;
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        if (scienceGoalConfigurations == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: configurationsToBeScheduled");
        }
        ScienceGoal scienceGoal = schedBlock.getSbGenerationContext().getGoal();
        if (!EnumSet.of(AngularResolutionMode.Single, AngularResolutionMode.Range).contains(scienceGoal.getPerformanceParameters().getAngularResolutionMode())) {
            return;
        }
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        AngleRange angleRange = AngleRange.wholeRange(new Angle[]{schedulingConstraints.getMinAcceptableAngResolution(), schedulingConstraints.getMaxAcceptableAngResolution()});
        Optional<Object> optional = Optional.empty();
        VupRange vupRange = null;
        for (Object object2 : scienceGoalConfigurations) {
            object = schedBlock.is12mExtendedArraySB() ? object2.getTM1Configuration() : object2.getTM2Configuration();
            if (!object.isPresent()) continue;
            Configuration configuration = object.get();
            Angle angle = null;
            Angle angle2 = null;
            try {
                angle = configuration.getAchievableAngularResolutionForClusters(scienceGoal, SfiControlParameterModel.RequestAngularResolutionEnum.FINEST, frequency, RequestedArray.TWELVE_M);
                angle2 = configuration.getAchievableAngularResolutionForClusters(scienceGoal, SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST, frequency, RequestedArray.TWELVE_M);
            }
            catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
                Log.logger(TwelveMetreSBGenerator.class).warning("Unable to determine ARs for configuration " + exception.getMessage());
                return;
            }
            assert (angle != null && angle2 != null);
            AngleRange angleRange2 = AngleRange.wholeRange(new Angle[]{angle, angle2});
            Optional<ValueUnitPair<Angle>> optional2 = angleRange2.separation(angleRange);
            if (!optional2.isPresent()) {
                return;
            }
            if (optional.isPresent() && !optional2.get().isLessThan((ValueUnitPair)optional.get())) continue;
            optional = Optional.of((Angle)optional2.get());
            vupRange = AngleRange.createRange(angle, angle2);
        }
        if (optional.isPresent()) {
            Object object2;
            Object object3 = (Angle)((Object)vupRange.min());
            if (((Angle)((Object)angleRange.max())).isLessThan((AbstractDoubleWithUnit)object3)) {
                object2 = (Angle)object3.multiply(0.05);
                angleRange.setMax(object3.plus((AbstractDoubleWithUnit)object2));
            } else {
                object2 = (Angle)((Object)vupRange.max());
                object = (Angle)object2.multiply(0.05);
                angleRange.setMin(object2.minus((AbstractDoubleWithUnit)object));
            }
            schedulingConstraints.setMinAcceptableAngResolution((Angle)((Object)angleRange.min()));
            schedulingConstraints.setMaxAcceptableAngResolution((Angle)((Object)angleRange.max()));
        }
    }

    private void setARLimitsForScheduledMaxMinConfigurations(ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations, SchedBlock schedBlock, ScienceGoal scienceGoal) {
        Configuration configuration;
        assert (schedBlock != null);
        assert (scienceGoal != null);
        assert (scienceGoalConfigurations != null);
        if (!schedBlock.is12mExtendedArraySB()) {
            return;
        }
        if (scienceGoalConfigurations.isEmpty()) {
            throw new WizardSBGenerationException("Illegal argument: configurationsToBeScheduled.isEmpty() (" + scienceGoalConfigurations.isEmpty() + ") " + "did not pass the test: configurationsToBeScheduled.isEmpty() test");
        }
        Configuration configuration2 = Configuration.getMostExtendedConfiguration(RequestedArray.TWELVE_M);
        try {
            configuration = Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M);
        }
        catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
            throw new WizardSBGenerationException("Unable to determine most compact 12-m configuration: " + unableToDetermineConfigurationException.getMessage());
        }
        try {
            Angle angle;
            Configuration configuration3 = scienceGoalConfigurations.getMostExtendedTM1Configuration();
            Configuration configuration4 = scienceGoalConfigurations.getMostCompactTM1Configuration();
            assert (configuration3 != null);
            assert (configuration4 != null);
            SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
            if (configuration.equals(configuration4)) {
                UserAngle userAngle = Angle.max(scienceGoal.getPerformanceParameters().getDesiredAngularResolution(), scienceGoal.getPerformanceParameters().getAcceptableAngularResolution());
                angle = Angle.createAngleArcsec(((Angle)((Object)userAngle)).getArcsec());
                schedulingConstraints.setMaxAcceptableAngResolution((Angle)angle.multiply(1.05));
            }
            if (configuration2.equals(configuration3)) {
                UserAngle userAngle = Angle.min(scienceGoal.getPerformanceParameters().getDesiredAngularResolution(), scienceGoal.getPerformanceParameters().getAcceptableAngularResolution());
                angle = Angle.createAngleArcsec(((Angle)((Object)userAngle)).getArcsec());
                schedulingConstraints.setMinAcceptableAngResolution((Angle)angle.multiply(0.95));
            }
            if (schedulingConstraints.getMinAcceptableAngResolution().isGreaterThan((AbstractDoubleWithUnit)schedulingConstraints.getMaxAcceptableAngResolution())) {
                angle = schedulingConstraints.getMinAcceptableAngResolution().deepCopy();
                Angle angle2 = schedulingConstraints.getMaxAcceptableAngResolution().deepCopy();
                schedulingConstraints.setMaxAcceptableAngResolution(angle);
                schedulingConstraints.setMinAcceptableAngResolution(angle2);
            }
        }
        catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
            Log.logger(TwelveMetreSBGenerator.class).warning(unableToDetermineConfigurationException.getMessage());
            return;
        }
    }

    @Override
    public void setARLimitsInSBConstraints(ScienceGoal scienceGoal, Collection<Collection<SchedBlock>> collection) {
        this.setBaselineARRangeInTMSBs(scienceGoal, collection);
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = null;
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            String string = "Unable to determine configurations : " + invalidObsProgramParametersException.getMessage();
            Log.logger(ScienceGoalSchedBlockGenerator.class).info(string);
            throw new WizardSBGenerationException(string);
        }
        assert (scienceGoalConfigurations != null);
        AngularResolutionMode angularResolutionMode = scienceGoal.getPerformanceParameters().getAngularResolutionMode();
        if (EnumSet.of(AngularResolutionMode.Any, AngularResolutionMode.Range).contains(angularResolutionMode)) {
            for (Collection<SchedBlock> collection2 : collection) {
                for (SchedBlock schedBlock : collection2) {
                    if (schedBlock.is12mExtendedArraySB()) {
                        this.setTM1AngularResolutionInSBConstraints(scienceGoalConfigurations, schedBlock, scienceGoal);
                        continue;
                    }
                    if (!schedBlock.is12mCompactArraySB()) continue;
                    this.setTM2AngularResolutioninSBConstraints(scienceGoalConfigurations, schedBlock, scienceGoal);
                }
            }
        }
        if (EnumSet.of(AngularResolutionMode.Single, AngularResolutionMode.Range).contains(angularResolutionMode)) {
            for (Collection<SchedBlock> collection2 : collection) {
                for (SchedBlock schedBlock : collection2) {
                    assert (scienceGoalConfigurations != null && !scienceGoalConfigurations.isEmpty());
                    this.ensureNearestConfigurationARIsIncludedInSBConstraintsARRange(scienceGoalConfigurations, schedBlock);
                }
            }
        }
        if (AngularResolutionMode.Range.equals(angularResolutionMode)) {
            for (Collection<SchedBlock> collection2 : collection) {
                for (SchedBlock schedBlock : collection2) {
                    this.setARLimitsForScheduledMaxMinConfigurations(scienceGoalConfigurations, schedBlock, scienceGoal);
                }
            }
        }
    }

    private void setBaselineARRangeInTMSBs(ScienceGoal scienceGoal, Collection<Collection<SchedBlock>> collection) {
        Range range;
        try {
            range = this.calcResolutionRange(scienceGoal);
        }
        catch (ObsProposal.VLBIProposalDetectedException | InvalidObsProgramParametersException exception) {
            throw new WizardSBGenerationException("Unable to calculate the resolution range");
        }
        assert (range != null);
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock : collection2) {
                if (!schedBlock.is12mExtendedArraySB() && !schedBlock.is12mCompactArraySB()) continue;
                SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
                schedulingConstraints.setMinAcceptableAngResolution(Angle.createAngleArcsec(range.min()));
                schedulingConstraints.setMaxAcceptableAngResolution(Angle.createAngleArcsec(range.max()));
            }
        }
    }

    private void setTM1AngularResolutionInSBConstraints(ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations, SchedBlock schedBlock, ScienceGoal scienceGoal) {
        if (schedBlock == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sb");
        }
        if (!schedBlock.is12mExtendedArraySB()) {
            throw new IllegalArgumentException("Unable to set the angular resolution in the SB constraints for anything other than TM1");
        }
        if (scienceGoalConfigurations == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: configurationsToBeScheduled");
        }
        if (scienceGoalConfigurations.isEmpty()) {
            throw new IllegalArgumentException("There are no configurations to be scheduled");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoalWithSpatiallyAdjacentSources");
        }
        AngularResolutionMode angularResolutionMode = scienceGoal.getPerformanceParameters().getAngularResolutionMode();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        UserAngle userAngle = performanceParameters.getAcceptableAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC) > performanceParameters.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC) ? performanceParameters.getAcceptableAngularResolution() : performanceParameters.getDesiredAngularResolution();
        UserAngle userAngle2 = performanceParameters.getAcceptableAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC) < performanceParameters.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC) ? performanceParameters.getAcceptableAngularResolution() : performanceParameters.getDesiredAngularResolution();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        double d = spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset().getContentInGHz();
        switch (angularResolutionMode) {
            case Any: {
                double d2;
                MatchedConfiguration matchedConfiguration = null;
                try {
                    matchedConfiguration = ConfigurationHelper.getBestMatchedConfiguration(d, RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.FINEST, false);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    throw new WizardSBGenerationException("Unable to determine angular resolution for 12-m most compact configuration");
                }
                assert (matchedConfiguration != null);
                schedulingConstraints.setMinAcceptableAngResolution((Angle)matchedConfiguration.getConfigurationAR().multiply(0.9));
                try {
                    d2 = Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M).getAchievableResolution(d, scienceGoal, RequestedArray.TWELVE_M);
                }
                catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException exception) {
                    throw new WizardSBGenerationException("Unable to determine angular resolution for 12-m most compact configuration");
                }
                Angle angle = Angle.createAngle((double)(d2 * 2.0), (String)Angle.UNIT_ARCSEC);
                schedulingConstraints.setMaxAcceptableAngResolution(angle);
                break;
            }
            case Range: {
                MatchedConfiguration matchedConfiguration;
                try {
                    matchedConfiguration = ConfigurationHelper.getBestMatchedConfiguration(d, RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.FINEST, false);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    throw new WizardSBGenerationException("Unable to determine angular resolution for 12-m most compact configuration");
                }
                assert (matchedConfiguration != null);
                UserAngle userAngle3 = UserAngle.createUserAngle((Angle)((Angle)((Angle)userAngle2.plus((AbstractDoubleWithUnit)userAngle)).half()).multiply(1.2));
                UserAngle userAngle4 = Angle.max(userAngle3, userAngle).deepCopy();
                schedulingConstraints.setMaxAcceptableAngResolution(userAngle4.getAngle(Angle.UNIT_ARCSEC));
                if (scienceGoalConfigurations.isConfigurationsTruncated()) {
                    UserAngle userAngle5 = UserAngle.createUserAngle((Angle)matchedConfiguration.getConfigurationAR().multiply(0.9));
                    UserAngle userAngle6 = UserAngle.createUserAngle((Angle)userAngle4.divide(1.5));
                    schedulingConstraints.setMinAcceptableAngResolution(Angle.min(userAngle5, userAngle6).getAngle(Angle.UNIT_ARCSEC));
                    break;
                }
                userAngle3 = UserAngle.createUserAngle((Angle)((Angle)((Angle)userAngle2.plus((AbstractDoubleWithUnit)userAngle)).half()).multiply(0.8));
                schedulingConstraints.setMinAcceptableAngResolution(Angle.min(userAngle3, userAngle2).getAngle(Angle.UNIT_ARCSEC));
                break;
            }
            case SACA: {
                throw new RuntimeException("Illegal angular resolution mode detected for this method");
            }
        }
    }

    private void setTM2AngularResolutioninSBConstraints(ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations, SchedBlock schedBlock, ScienceGoal scienceGoal) {
        Angle angle;
        Angle angle2;
        assert (schedBlock != null);
        assert (scienceGoal != null);
        assert (scienceGoalConfigurations != null);
        if (!schedBlock.is12mCompactArraySB()) {
            throw new WizardSBGenerationException("One can only set the AR SB constraints for a TM2 SB");
        }
        if (scienceGoalConfigurations.isEmpty()) {
            throw new WizardSBGenerationException("Illegal argument: configurationsToBeScheduled.isEmpty() (" + scienceGoalConfigurations.isEmpty() + ") " + "did not pass the test: configurationsToBeScheduled.isEmpty() test");
        }
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        try {
            double d = scienceGoal.getSpectralSetupParameters().getRepresentativeFrequencyWithSkyOffset().getContentInGHz();
            Configuration configuration = scienceGoalConfigurations.getMostExtendedTM2Configuration();
            Configuration configuration2 = scienceGoalConfigurations.getMostCompactTM2Configuration();
            assert (configuration != null);
            assert (configuration2 != null);
            angle2 = Angle.createAngleArcsec(configuration.getAchievableResolution(d, scienceGoal, RequestedArray.TWELVE_M));
            angle = Angle.createAngleArcsec(configuration2.getAchievableResolution(d, scienceGoal, RequestedArray.TWELVE_M));
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException exception) {
            Log.logger(TwelveMetreSBGenerator.class).warning(exception.getMessage());
            return;
        }
        assert (angle2 != null);
        assert (angle != null);
        schedulingConstraints.setMinAcceptableAngResolution((Angle)angle2.multiply(0.8));
        schedulingConstraints.setMaxAcceptableAngResolution((Angle)angle.multiply(1.2));
    }
}

