/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.sbbuilder.TwelveMetreSBGenerator;
import alma.valuetypes.Frequency;

public class TwelveMetreExtendedConfigurationSBGenerator
extends TwelveMetreSBGenerator {
    @Override
    public double getAntennaMultiplier(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        return 1.0;
    }

    public TwelveMetreExtendedConfigurationSBGenerator(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        this.sbContext.setSBType(SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION).setArray(RequestedArray.TWELVE_M);
        this.sbContext.setConfiguration(this.determineConfigurationToBeUsed(scienceGoal));
    }

    private Configuration determineConfigurationToBeUsed(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument - the argument goal cannot be null");
        }
        try {
            object = scienceGoal.getObsProposal();
            if (object != null && object.isVLBI()) {
                return Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M);
            }
        }
        catch (UnknownEntityException | Configuration.UnableToDetermineConfigurationException throwable) {
            Log.logger(TwelveMetreExtendedConfigurationSBGenerator.class).warning("Unable to determine if project is a VLBI project");
            throw new InvalidObsProgramParametersException(throwable);
        }
        object = scienceGoal.getPerformanceParameters();
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        Configuration configuration = null;
        try {
            configuration = Configuration.getBestConfiguration(object.getDesiredAngularResolution(), frequency, RequestedArray.TWELVE_M, scienceGoal);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger((Object)this).severe("Cannot establish the best array configuration for a desired angular resolution of " + object.getDesiredAngularResolution() + " with a rep. freq of " + (Object)((Object)frequency));
            throw new InvalidObsProgramParametersException(invalidConfigurationParametersException);
        }
        return configuration;
    }

    @Override
    protected AngularResolutionLimitsExpertInterface getSBAngularResolutionLimitsExpert() {
        return AngularResolutionLimitsExpertFactory.getARLimitsExpert(SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION);
    }
}

