/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.InterferometrySchedBlockGenerator;
import alma.valuetypes.Angle;
import alma.valuetypes.UserAngle;
import java.util.ArrayList;
import java.util.Collection;

public abstract class TwelveMetreSBGenerator
extends InterferometrySchedBlockGenerator {
    public TwelveMetreSBGenerator() {
        super(RequestedArray.TWELVE_M);
    }

    protected abstract AngularResolutionLimitsExpertInterface getSBAngularResolutionLimitsExpert();

    protected Collection<Range> getHourAngleRange(ScienceGoal scienceGoal) {
        SchedBlockExpert schedBlockExpert = SchedBlockExpert.getInstance(scienceGoal);
        return schedBlockExpert.calcHourAngleRange();
    }

    void setSpectralScanTuningIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal argument: tuningIndex (" + n + ") " + "did not pass the test: tuningIndex < 0");
        }
        this.sbContext.setSpectralScanTuningIndex(n);
    }

    @Override
    public Collection<Collection<SchedBlock>> getSchedBlocks(ScienceGoal scienceGoal) {
        this.sbContext.setScienceGoal(scienceGoal);
        ArrayList<Collection<SchedBlock>> arrayList = new ArrayList<Collection<SchedBlock>>();
        Collection<Range> collection = this.getHourAngleRange(scienceGoal);
        Collection<Collection<SchedBlock>> collection2 = super.getSchedBlocks(scienceGoal);
        for (Collection<SchedBlock> collection3 : collection2) {
            for (SchedBlock schedBlock : collection3) {
                schedBlock.getSbGenerationContext().setSBType(this.sbContext.getSBType());
            }
        }
        if (this.sbContext.isVLBI()) {
            return collection2;
        }
        this.setHourAngleConstraints(arrayList, collection, collection2);
        AngularResolutionLimitsExpertInterface angularResolutionLimitsExpertInterface = this.getSBAngularResolutionLimitsExpert();
        angularResolutionLimitsExpertInterface.setARLimitsInSBConstraints(scienceGoal, collection2);
        return arrayList;
    }

    private void setHourAngleConstraints(Collection<Collection<SchedBlock>> collection, Collection<Range> collection2, Collection<Collection<SchedBlock>> collection3) {
        for (Range range : collection2) {
            UserAngle userAngle = UserAngle.createUserAngle(range.min(), Angle.UNIT_DEG);
            UserAngle userAngle2 = UserAngle.createUserAngle(range.max(), Angle.UNIT_DEG);
            for (Collection<SchedBlock> collection4 : collection3) {
                ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
                for (SchedBlock schedBlock : collection4) {
                    Preconditions preconditions = schedBlock.getPreconditions();
                    preconditions.setMinAllowedHA(userAngle);
                    preconditions.setMaxAllowedHA(userAngle2);
                    arrayList.add(schedBlock);
                }
                collection.add(arrayList);
            }
        }
    }
}

