/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACAPhaseSwitchingConfiguration;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.ACASpectralSpecWorker;
import alma.obsprep.services.generator.refactored.spectralspec.BLSpectralSpecWorker;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecWorker;
import alma.obsprep.services.generator.refactored.spectralspec.Walsh90DegConfiguratorFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import alma.valuetypes.Velocity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SpectralSpecFactory {
    private static final String DELAY = "DELAY";
    private static final String TDMATM = "TDMATM";
    private static final String FOCUS = "FOCUS";
    private static final String SCIENCE = "SCIENCE";
    private static final String POINTING = "POINTING";
    private SBGenerationContext sbContext = null;
    private static final Map<CorrelatorType, Map<SpectralMode, Map<TimeTypes, Double>>> desiredCorrelatorParameterTimes;

    public SpectralSpecFactory(SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sbContext");
        }
        this.sbContext = sBGenerationContext;
    }

    public SpectralSpec getSpectralSpec(SpectralSetupParameters spectralSetupParameters, Velocity velocity, TargetWithIntent targetWithIntent) {
        ObsType obsType = targetWithIntent.getObsType();
        return this.getSpectralSpec(spectralSetupParameters, velocity, obsType);
    }

    public SpectralSpec getSpectralSpec(SpectralSetupParameters spectralSetupParameters, Velocity velocity, ObsType obsType) {
        SpectralSpecWorker spectralSpecWorker = this.getSpectralSpecWorker(spectralSetupParameters, velocity);
        Map<String, SpectralSpec> map = spectralSpecWorker.getSpectralSpecGroup();
        return this.getSpectralSpecFromMap(map, obsType, spectralSetupParameters);
    }

    private SpectralSpec getSpectralSpecFromMap(Map<String, SpectralSpec> map, ObsType obsType, SpectralSetupParameters spectralSetupParameters) {
        RequestedArray requestedArray = this.sbContext.getArray();
        if (requestedArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: array");
        }
        if (!spectralSetupParameters.isSingleContinuum()) {
            boolean bl = spectralSetupParameters.needsTDMSpec(requestedArray);
            if (RequestedArray.TP.equals((Object)requestedArray) && ObsType.AMPLITUDE.equals((Object)obsType)) {
                bl = false;
            }
            return this.getSpectralSpec(map, obsType, bl, spectralSetupParameters);
        }
        return this.getTDMSpectralSpec(map, obsType, requestedArray, spectralSetupParameters);
    }

    private SpectralSpec getSpectralSpec(Map<String, SpectralSpec> map, ObsType obsType, boolean bl, SpectralSetupParameters spectralSetupParameters) {
        SpectralSpec spectralSpec;
        RequestedArray requestedArray = this.sbContext.getArray();
        if (requestedArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: array");
        }
        boolean bl2 = RequestedArray.TP.equals((Object)requestedArray);
        if (ObsType.DELAY.equals((Object)obsType) && bl2) {
            spectralSpec = map.get(DELAY);
            SpectralSpecFactory.calculateTDMTimeAndDurations(true, spectralSpec, this.sbContext);
        } else {
            switch (obsType) {
                case AMPLITUDE: 
                case BANDPASS: 
                case PHASE: {
                    spectralSpec = this.getCalSpec(map, bl, obsType, requestedArray, true);
                    break;
                }
                case ATMOSPHERIC: {
                    spectralSpec = map.get(TDMATM);
                    SpectralSpecFactory.calculateTDMTimeAndDurations(true, spectralSpec, this.sbContext);
                    break;
                }
                case FOCUS: {
                    spectralSpec = map.get(bl2 ? FOCUS : POINTING);
                    SpectralSpecFactory.calculateTDMTimeAndDurations(true, spectralSpec, this.sbContext);
                    break;
                }
                case POINTING: {
                    spectralSpec = map.get(POINTING);
                    SpectralSpecFactory.calculateTDMTimeAndDurations(false, spectralSpec, this.sbContext);
                    break;
                }
                default: {
                    spectralSpec = map.get(SCIENCE);
                    this.calculateFDMTimeAndDurations(true, spectralSpec);
                }
            }
        }
        if (bl2) {
            this.configureTPSpectralSpec(spectralSpec, obsType, spectralSetupParameters);
        }
        return spectralSpec;
    }

    private void optimiseIntegrationTimeForLongBaselineSpectralSpecs(SpectralSpec spectralSpec) {
        if (spectralSpec == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: ss");
        }
        if (RequestedArray.TWELVE_M.equals((Object)this.sbContext.getArray())) {
            Configuration configuration = this.sbContext.getConfiguration();
            if (configuration == null) {
                String string = "A valid configuration should be specified for the 12-m array";
                Log.logger(SpectralSpecFactory.class).warning(string);
                throw new WizardSBGenerationException(string);
            }
            if (configuration.isLongBaselineConfiguration()) {
                AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
                abstractCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, this.sbContext.getArray().getControlBlockArray());
                DataRate dataRate = spectralSpec.getInstantaneousDataRate();
                if (dataRate == null) {
                    throw new NullPointerException("Illegal argument. The argument cannot be null: instantaneousDataRate");
                }
                double d = AlmaPolicies.getInstance().getWarningDataRateMBPS();
                DataRate dataRate2 = DataRate.createDataRate((double)d, (String)DataRate.UNIT_MB_S);
                assert (dataRate.isGreaterThan((AbstractDoubleWithUnit)DataRate.createDataRate()));
                assert (d > 0.0);
                if (!(abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration)) {
                    throw new WizardSBGenerationException("Expected a BL correlator configuration when optimising the integration duration");
                }
                BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
                double d2 = bLCorrelatorConfiguration.getChannelAverageDuration().getContentInUnits(Time.UNIT_S);
                CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
                double d3 = correlatorExpert.calcIntegrationDurationInsecs(2.016, d2);
                bLCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
                bLCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, this.sbContext.getArray().getControlBlockArray());
                dataRate = spectralSpec.getInstantaneousDataRate();
                if (dataRate.isGreaterThan((AbstractDoubleWithUnit)dataRate2)) {
                    d3 = correlatorExpert.calcIntegrationDurationInsecs(3.024, d2);
                    bLCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
                    bLCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, this.sbContext.getArray().getControlBlockArray());
                }
            }
        }
    }

    private void configureTPSpectralSpec(SpectralSpec spectralSpec, ObsType obsType, SpectralSetupParameters spectralSetupParameters) {
        ScienceGoal scienceGoal = null;
        if (spectralSetupParameters.getParent() instanceof ScienceGoal) {
            scienceGoal = (ScienceGoal)spectralSetupParameters.getParent();
        }
        if (scienceGoal == null) {
            throw new WizardSBGenerationException("Science goal is null when configuring spectral spec");
        }
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
        switch (obsType) {
            case FOCUS: 
            case DELAY: {
                this.configureTPDelayAndFocusSpectralSpec(spectralSpec, abstractCorrelatorConfiguration);
                break;
            }
            case AMPLITUDE: 
            case SCIENCE: {
                this.configureTPScienceSpectralSpecs(spectralSpec, abstractCorrelatorConfiguration, obsType, spectralSetupParameters);
                break;
            }
        }
    }

    private void configureTPScienceSBScienceSpectralSpec(SpectralSpec spectralSpec, ObsType obsType, SpectralSetupParameters spectralSetupParameters, AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        Frequency frequency;
        try {
            frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        TargetParameters targetParameters = spectralSetupParameters.getScienceGoal().getTargetParameters()[0];
        assert (targetParameters != null);
        Rectangle rectangle = null;
        if (targetParameters.isRectanglePattern()) {
            rectangle = targetParameters.getSingleRectangle().getTPArrayRectangle(spectralSpec);
        } else if (targetParameters.isPointingPattern()) {
            if (!targetParameters.isMosaic() && targetParameters.getPointingPattern().getPhaseCenterCoordinates().length > 1) {
                String string = "Multiple pointings that require Total Power must go into separate Field Sources (" + targetParameters.getSourceName() + ") if not mosaic";
                Log.logger(SpectralSpecFactory.class).warning(string);
                throw new WizardSBGenerationException(string);
            }
            if (targetParameters.getPointingPattern().getPhaseCenterCoordinates().length < 1) {
                Log.logger(SpectralSpecFactory.class).warning("At least one pointing should be specified - " + targetParameters.getSourceName());
                throw new WizardSBGenerationException("At least one pointing should be specified - " + targetParameters.getSourceName());
            }
            boolean bl = false;
            try {
                bl = SchedBlockWorker.isMosaicPointingsOverlapping(targetParameters);
            }
            catch (SchedBlockWorker.InfiniteBandwithException infiniteBandwithException) {
                String string = "The bandwidth cannot be calculated - unable to do mosaic spacing checks for target " + targetParameters.getSourceName();
                Log.logger(SpectralSpecFactory.class).warning(string);
                throw new WizardSBGenerationException(string);
            }
            catch (SchedBlockWorker.NotAMosaicException notAMosaicException) {
                throw new RuntimeException("Logic error in determining if target parameters " + targetParameters.getSourceName() + " is a mosaic");
            }
            if (!bl) {
                throw new WizardSBGenerationException("Pointings in mosaic for target " + targetParameters.getSourceName() + " do not overlap");
            }
            try {
                rectangle = SchedBlockExpert.getBoundingRectangle(targetParameters).getTPArrayRectangle(spectralSpec);
                Log.logger(SpectralSpecFactory.class).fine("TP bounding rectangle dimensions (arcsec) are : " + rectangle.getLongitudeLength().getContentInUnits(Angle.UNIT_ARCSEC) + " " + rectangle.getLatitudeLength().getContentInUnits(Angle.UNIT_ARCSEC));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.logger(SpectralSpecFactory.class).warning("Unable to determine minimum bounding box around pointings: " + illegalArgumentException.getMessage());
                throw new WizardSBGenerationException(illegalArgumentException);
            }
        }
        ValueUnitPair<Angle> valueUnitPair = SpectralSpecFactory.getL(rectangle, spectralSpec, obsType, Optional.of(targetParameters));
        Integer n = spectralSpec.getReceiverBand().getNumber();
        double d = CorrelatorExpert.TPCorrelatorConfiguratorHelper.calcIntegrationDurationInSecs(valueUnitPair, n, frequency, obsType);
        double d2 = CorrelatorExpert.TPCorrelatorConfiguratorHelper.calculateChannelAverageDurationInMsecs(valueUnitPair, n, frequency, obsType);
        abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)d, (String)Time.UNIT_S));
        abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTime((double)d2, (String)Time.UNIT_MS));
    }

    private void configureTPScienceSpectralSpecs(SpectralSpec spectralSpec, AbstractCorrelatorConfiguration abstractCorrelatorConfiguration, ObsType obsType, SpectralSetupParameters spectralSetupParameters) {
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_TWO_LOS);
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setEnable90DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setCAM(AbstractCorrelatorConfiguration.CAM_FAST);
        if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) {
            ACACorrelatorConfiguration aCACorrelatorConfiguration = (ACACorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ACAPhaseSwitchingConfiguration.createACAPhaseSwitchingConfiguration();
            aCAPhaseSwitchingConfiguration.setDoD180demodulation(false);
            aCAPhaseSwitchingConfiguration.setDoD180modulation(false);
            aCACorrelatorConfiguration.setACAPhaseSwitchingConfiguration(aCAPhaseSwitchingConfiguration);
        }
        this.setDataProduct(spectralSpec, AbstractBaseBandConfig.DATAPRODUCTS_AUTO_ONLY);
        if (ObsType.SCIENCE.equals((Object)obsType)) {
            this.configureTPScienceSBScienceSpectralSpec(spectralSpec, obsType, spectralSetupParameters, abstractCorrelatorConfiguration);
        } else if (ObsType.AMPLITUDE.equals((Object)obsType)) {
            abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)144.0, (String)Time.UNIT_MS));
            abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTime((double)144.0, (String)Time.UNIT_MS));
        }
    }

    private void configureTPDelayAndFocusSpectralSpec(SpectralSpec spectralSpec, AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTime((double)1.008, (String)Time.UNIT_S));
        abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)10.08, (String)Time.UNIT_S));
        this.setDataProduct(spectralSpec, AbstractBaseBandConfig.DATAPRODUCTS_CROSS_AND_AUTO);
        abstractCorrelatorConfiguration.setCAM(AbstractCorrelatorConfiguration.CAM_NORMAL);
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_TWO_LOS);
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setEnable90DegreeWalshFunction(false);
        if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) {
            ACACorrelatorConfiguration aCACorrelatorConfiguration = (ACACorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
            ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration = ACAPhaseSwitchingConfiguration.createACAPhaseSwitchingConfiguration();
            aCAPhaseSwitchingConfiguration.setDoD180demodulation(false);
            aCAPhaseSwitchingConfiguration.setDoD180modulation(false);
            aCACorrelatorConfiguration.setACAPhaseSwitchingConfiguration(aCAPhaseSwitchingConfiguration);
        }
    }

    static SpectralSpec convertToTopo(SpectralSpec spectralSpec) {
        SpectralSpec spectralSpec2 = spectralSpec.deepCopy();
        spectralSpec2.setSourceVelocity(spectralSpec.getSourceVelocity().deepCopy());
        Velocity velocity = spectralSpec.getSourceVelocity();
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec2.getBaseBandConfig()) {
            Frequency frequency = velocity.dopplerShift(abstractBaseBandConfig.getCenterFrequency());
            abstractBaseBandConfig.setCenterFrequency(frequency);
        }
        FrequencySetup frequencySetup = spectralSpec2.getFrequencySetup();
        frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
        spectralSpec2.setName(spectralSpec2.getName() + " (topo)");
        spectralSpec2.calculateCorrelatorSetup(Velocity.createVelocity());
        spectralSpec2.getCorrelatorConfiguration().updateSideband();
        return spectralSpec2;
    }

    public static void calculateTDMTimeAndDurations(boolean bl, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) throws WizardSBGenerationException {
        CorrelatorType correlatorType = spectralSpec.isBLSpectralSpec() ? CorrelatorType.BL : CorrelatorType.ACA;
        SpectralSpecFactory.calculateTimeAndDurations(spectralSpec, desiredCorrelatorParameterTimes.get((Object)correlatorType).get((Object)SpectralMode.TDM).get((Object)TimeTypes.DUMPDURATION), desiredCorrelatorParameterTimes.get((Object)correlatorType).get((Object)SpectralMode.TDM).get((Object)TimeTypes.CHANNELAVG), desiredCorrelatorParameterTimes.get((Object)correlatorType).get((Object)SpectralMode.TDM).get((Object)TimeTypes.INTEGRATIONTIME));
        if (bl) {
            boolean bl2 = sBGenerationContext.getGoal().getSpectralSetupParameters().isWalshSwitching();
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
            if (bl2) {
                Walsh90DegConfiguratorFactory.getConfigurator(abstractCorrelatorConfiguration).configureSpectralSpec(sBGenerationContext, spectralSpec);
            }
        }
    }

    private void calculateFDMTimeAndDurations(boolean bl, SpectralSpec spectralSpec) throws WizardSBGenerationException {
        boolean bl2 = this.sbContext.getGoal().getSpectralSetupParameters().isWalshSwitching();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
        if (spectralSpec.isBLSpectralSpec()) {
            if (spectralSpec.isPureTDM()) {
                SpectralSpecFactory.calculateTDMTimeAndDurations(bl, spectralSpec, this.sbContext);
            } else {
                SpectralSpecFactory.calculateTimeAndDurations(spectralSpec, desiredCorrelatorParameterTimes.get((Object)CorrelatorType.BL).get((Object)SpectralMode.FDM).get((Object)TimeTypes.DUMPDURATION), desiredCorrelatorParameterTimes.get((Object)CorrelatorType.BL).get((Object)SpectralMode.FDM).get((Object)TimeTypes.CHANNELAVG), desiredCorrelatorParameterTimes.get((Object)CorrelatorType.BL).get((Object)SpectralMode.FDM).get((Object)TimeTypes.INTEGRATIONTIME));
                this.optimiseIntegrationTimeForLongBaselineSpectralSpecs(spectralSpec);
            }
        } else {
            SpectralSpecFactory.calculateTimeAndDurations(spectralSpec, desiredCorrelatorParameterTimes.get((Object)CorrelatorType.ACA).get((Object)SpectralMode.FDM).get((Object)TimeTypes.DUMPDURATION), desiredCorrelatorParameterTimes.get((Object)CorrelatorType.ACA).get((Object)SpectralMode.FDM).get((Object)TimeTypes.CHANNELAVG), desiredCorrelatorParameterTimes.get((Object)CorrelatorType.ACA).get((Object)SpectralMode.FDM).get((Object)TimeTypes.INTEGRATIONTIME));
        }
        if (bl2 && bl) {
            Walsh90DegConfiguratorFactory.getConfigurator(abstractCorrelatorConfiguration).configureSpectralSpec(this.sbContext, spectralSpec);
        }
    }

    private SpectralSpec getCalSpec(Map<String, SpectralSpec> map, boolean bl, ObsType obsType, RequestedArray requestedArray, boolean bl2) {
        SpectralSpec spectralSpec;
        SpectralSpec spectralSpec2 = spectralSpec = bl ? map.get("TDMPhase") : map.get(SCIENCE);
        if (RequestedArray.TP.equals((Object)requestedArray) && ObsType.AMPLITUDE.equals((Object)obsType)) {
            SpectralSpecFactory.calculateTimeAndDurations(spectralSpec, 1000.0, 0.1, 0.1);
            spectralSpec = SpectralSpecFactory.convertToTopo(spectralSpec);
        }
        if (bl) {
            SpectralSpecFactory.calculateTDMTimeAndDurations(bl2, spectralSpec, this.sbContext);
        } else {
            this.calculateFDMTimeAndDurations(bl2, spectralSpec);
        }
        return spectralSpec;
    }

    private SpectralSpec getTDMSpectralSpec(Map<String, SpectralSpec> map, ObsType obsType, RequestedArray requestedArray, SpectralSetupParameters spectralSetupParameters) {
        SpectralSpec spectralSpec;
        boolean bl = true;
        switch (obsType) {
            case POINTING: {
                spectralSpec = map.get(POINTING);
                bl = false;
                break;
            }
            case FOCUS: {
                bl = false;
                if (RequestedArray.TP.equals((Object)requestedArray)) {
                    spectralSpec = map.get(FOCUS);
                    break;
                }
                spectralSpec = map.get(POINTING);
                break;
            }
            default: {
                spectralSpec = obsType.equals((Object)ObsType.DELAY) && RequestedArray.TP.equals((Object)requestedArray) ? map.get(DELAY) : map.get(SCIENCE);
            }
        }
        SpectralSpecFactory.calculateTDMTimeAndDurations(bl, spectralSpec, this.sbContext);
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            this.configureTPSpectralSpec(spectralSpec, obsType, spectralSetupParameters);
        }
        return spectralSpec;
    }

    private void setDataProduct(SpectralSpec spectralSpec, String string) {
        for (int i = 0; i < spectralSpec.getBaseBandConfigCount(); ++i) {
            AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec.getBaseBandConfig(i);
            abstractBaseBandConfig.setDataProducts(string);
        }
    }

    private SpectralSpecWorker getSpectralSpecWorker(SpectralSetupParameters spectralSetupParameters, Velocity velocity) {
        RequestedArray requestedArray = this.sbContext.getArray();
        if (requestedArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: requestedArray");
        }
        switch (requestedArray) {
            case ACA: {
                if (System.getProperty("UseBLCorrForAca", "false").equalsIgnoreCase("false")) {
                    return new ACASpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
                }
                return new BLSpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
            }
            case TP: {
                if (System.getProperty("UseBLCorrForAca", "false").equalsIgnoreCase("false")) {
                    return new ACASpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
                }
                return new BLSpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
            }
            case SEVEN_M: {
                if (System.getProperty("UseBLCorrForAca", "false").equalsIgnoreCase("false")) {
                    return new ACASpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
                }
                return new BLSpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
            }
        }
        return new BLSpectralSpecWorker(spectralSetupParameters, velocity, this.sbContext);
    }

    private static void calculateTimeAndDurations(SpectralSpec spectralSpec, double d, double d2, double d3) throws WizardSBGenerationException {
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
        double d4 = correlatorExpert.calcDumpDurationInmsecs(d) / 1000.0;
        if (abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration) {
            ((BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration)).setDumpDuration(Time.createTimeSec(d4));
        }
        double d5 = correlatorExpert.calcChannelAverageDurationInsecs(d2, d4);
        abstractCorrelatorConfiguration.setChannelAverageDuration(Time.createTimeSec(d5));
        double d6 = correlatorExpert.calcIntegrationDurationInsecs(d3, d5);
        abstractCorrelatorConfiguration.setIntegrationDuration(Time.createTime((double)d6, (String)Time.UNIT_S));
    }

    public static ValueUnitPair<Angle> getL(Rectangle rectangle, SpectralSpec spectralSpec, ObsType obsType, Optional<TargetParameters> optional) {
        Frequency frequency;
        if (spectralSpec == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: ss");
        }
        if (obsType == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsType");
        }
        UserAngle userAngle = null;
        try {
            frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.LOWESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        assert (frequency != null);
        if (ObsType.AMPLITUDE.equals((Object)obsType)) {
            UserAngle userAngle2 = UserAngle.createUserAngle(6.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
            userAngle2.setAntenna(Antenna.ANTENNA_12M);
            userAngle = userAngle2;
        } else if (ObsType.SCIENCE.equals((Object)obsType)) {
            if (rectangle == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: rectangle");
            }
            userAngle = rectangle.getLongitudeLength().isGreaterThan(rectangle.getLatitudeLength()) ? rectangle.getLongitudeLength() : rectangle.getLatitudeLength();
        } else {
            throw new IllegalArgumentException("Cannot calculate L for this type of obstype " + (Object)((Object)obsType));
        }
        assert (userAngle != null);
        return userAngle;
    }

    static {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap<TimeTypes, Double> hashMap3 = new HashMap<TimeTypes, Double>();
        hashMap3.put(TimeTypes.DUMPDURATION, 1000.0);
        hashMap3.put(TimeTypes.CHANNELAVG, 1.0);
        hashMap3.put(TimeTypes.INTEGRATIONTIME, 2.0);
        hashMap2.put(SpectralMode.TDM, Collections.unmodifiableMap(hashMap3));
        hashMap3 = new HashMap();
        hashMap3.put(TimeTypes.DUMPDURATION, 1000.0);
        hashMap3.put(TimeTypes.CHANNELAVG, 1.0);
        hashMap3.put(TimeTypes.INTEGRATIONTIME, 6.048);
        hashMap2.put(SpectralMode.FDM, Collections.unmodifiableMap(hashMap3));
        hashMap.put(CorrelatorType.BL, Collections.unmodifiableMap(hashMap2));
        hashMap2 = new HashMap();
        hashMap3 = new HashMap();
        hashMap3.put(TimeTypes.DUMPDURATION, 1000.0);
        hashMap3.put(TimeTypes.CHANNELAVG, 1.0);
        hashMap3.put(TimeTypes.INTEGRATIONTIME, 1.0);
        hashMap2.put(SpectralMode.TDM, Collections.unmodifiableMap(hashMap3));
        hashMap3 = new HashMap();
        hashMap3.put(TimeTypes.DUMPDURATION, 1000.0);
        hashMap3.put(TimeTypes.CHANNELAVG, 1.0);
        hashMap3.put(TimeTypes.INTEGRATIONTIME, 10.0);
        hashMap2.put(SpectralMode.FDM, Collections.unmodifiableMap(hashMap3));
        hashMap.put(CorrelatorType.ACA, Collections.unmodifiableMap(hashMap2));
        desiredCorrelatorParameterTimes = Collections.unmodifiableMap(hashMap);
    }

    private static enum TimeTypes {
        DUMPDURATION,
        CHANNELAVG,
        INTEGRATIONTIME;

    }

    private static enum SpectralMode {
        FDM,
        TDM;

    }
}

