/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.enumerations.NetSideBand;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowBand;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.SingleContinuumExpert;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.Range;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class SpectralSpecWorker {
    protected final SpectralSetupParameters ssp;
    protected final Velocity velocity;
    protected final CorrelatorExpert correxp;
    protected final SBGenerationContext sbContext;
    private static final Frequency THREE_GHZ = Frequency.createFrequencyGHZ(3.0);
    private static final Frequency TWO_GHZ = Frequency.createFrequencyGHZ(2.0);

    public SpectralSpecWorker(SpectralSetupParameters spectralSetupParameters, CorrelatorType correlatorType, Velocity velocity, SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sbContext");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: ssp");
        }
        if (velocity == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: soleTargetVelocity");
        }
        if (correlatorType == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: correlator");
        }
        this.ssp = spectralSetupParameters;
        this.velocity = velocity.deepCopy();
        this.sbContext = sBGenerationContext;
        this.correxp = CorrelatorExpert.getInstance(correlatorType);
    }

    public Map<String, SpectralSpec> getSpectralSpecGroup() throws WizardSBGenerationException {
        this.validate();
        SpectralSpec spectralSpec = this.createSpectralSpecWithCorrelatorConfiguration();
        this.setupSpectralSpec(spectralSpec);
        SpectralSpecMap<String, SpectralSpec> spectralSpecMap = new SpectralSpecMap<String, SpectralSpec>(spectralSpec);
        spectralSpecMap.put("SCIENCE", spectralSpec);
        return spectralSpecMap;
    }

    protected abstract SpectralSpec createSpectralSpecWithCorrelatorConfiguration();

    protected void validate() throws WizardSBGenerationException {
    }

    private void setupSpectralSpec(SpectralSpec spectralSpec) {
        String string = this.ssp.getType();
        Frequency frequency = null;
        Frequency frequency2 = null;
        String string2 = null;
        ReceiverBand receiverBand = null;
        Velocity velocity = this.velocity.deepCopy();
        spectralSpec.setSourceVelocity(velocity);
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        if (string.equals(SpectralSetupParameters.TYPE_CONTINUUM)) {
            frequency = this.ssp.getSingleContinuumFrequency();
            if (this.ssp.isSingleContinuumSkyFrequency()) {
                frequency2 = frequency.deepCopy();
                string2 = "SkyCont(" + (Object)((Object)frequency) + ")";
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
            } else {
                string2 = "RestCont(" + (Object)((Object)frequency) + ")";
                frequency2 = frequency.dopplerShifted(velocity);
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_REST);
            }
        } else if (string.equals(SpectralSetupParameters.TYPE_FULL)) {
            ScienceSpectralWindow scienceSpectralWindow = this.ssp.getScienceSpectralWindow(0);
            if (this.ssp.getSSPDerivedFromSpectralScanSetup().booleanValue()) {
                frequency = scienceSpectralWindow.getCenterFrequency();
                frequency2 = frequency.deepCopy();
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
            } else {
                frequency = scienceSpectralWindow.getCenterFrequency();
                frequency2 = frequency.dopplerShifted(velocity);
                frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_REST);
            }
            if (this.ssp.getRepresentativeSpectralWindow() == null) {
                Log.logger(SpectralSpecWorker.class).warning("Unable to determine representative spectral window");
                throw new WizardSBGenerationException("Unable to determine representative spectral window");
            }
            string2 = this.ssp.getRepresentativeSpectralWindow().getTransitionName();
        } else if (string.equals(SpectralSetupParameters.TYPE_SCAN)) {
            throw new RuntimeException("Spectral Window Type is not supported : " + string);
        }
        receiverBand = this.ssp.getReceiverBand();
        if (receiverBand == null) {
            throw new WizardSBGenerationException("Unable to determine receiver band ");
        }
        frequencySetup.getRestFrequency().setContentInGHz(frequency.getContentInGHz());
        spectralSpec.setName(string2 + " Science setup");
        spectralSpec.getFrequencySetup().setRestFrequency(frequency.deepCopy());
        spectralSpec.getFrequencySetup().setTransitionName(string2);
        spectralSpec.getFrequencySetup().setReceiverBand(receiverBand.getName());
        spectralSpec.setReceiverType(receiverBand.getType());
        this.setupSpectralSpecCorrelatorConfiguration(spectralSpec, string, this.ssp);
    }

    private void setupSpectralSpecCorrelatorConfiguration(SpectralSpec spectralSpec, String string, SpectralSetupParameters spectralSetupParameters) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: ssp");
        }
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        this.setupCommonCorrelatorConfiguration(abstractCorrelatorConfiguration);
        boolean bl = spectralSetupParameters.isWalshSwitching();
        if (spectralSpec.getReceiverType() == SpectralSpec.RECEIVERTYPE_TSB || spectralSpec.getReceiverType() == SpectralSpec.RECEIVERTYPE_DSB) {
            String string2 = bl ? AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE : AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_TWO_LOS;
            abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(true);
            abstractCorrelatorConfiguration.setLOOffsettingMode(string2);
        }
        if (bl) {
            abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE);
        }
    }

    private void setupSpectralSpec(SpectralSpec spectralSpec, Frequency frequency, String string) {
        ReceiverBand receiverBand = null;
        try {
            receiverBand = ReceiverBand.getReceiverBand(frequency);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUIUtilities.warning(null, illegalArgumentException.getMessage());
            throw new WizardSBGenerationException(illegalArgumentException.getMessage());
        }
        spectralSpec.setSourceVelocity(this.velocity.deepCopy());
        FrequencySetup frequencySetup = spectralSpec.getFrequencySetup();
        Frequency frequency2 = frequency.deepCopy();
        frequencySetup.setRestFrequency(frequency2);
        frequencySetup.setDopplerReference(FrequencySetup.DOPPLERREFERENCE_TOPO);
        spectralSpec.setName("B" + receiverBand.getNumber() + " " + string + " Setup");
        spectralSpec.getFrequencySetup().setRestFrequency(frequency2);
        spectralSpec.getFrequencySetup().setTransitionName(string);
        spectralSpec.getFrequencySetup().setReceiverBand(receiverBand.getName());
        spectralSpec.setReceiverType(receiverBand.getType());
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
        CorrConfigMode corrConfigMode = this.correxp.getContinuumMode(CorrPolarization.DOUBLE);
        SingleContinuumExpert singleContinuumExpert = new SingleContinuumExpert(frequency, Velocity.createVelocity(), ObservingFrequency.FrequencyType.SKY_FREQUENCY);
        Range<Frequency>[] rangeArray = singleContinuumExpert.singleContinuumBasebands(false);
        for (int i = 0; i < 4; ++i) {
            Frequency frequency3 = rangeArray[i].mid();
            AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
            abstractBaseBandConfig.setCenterFrequency(frequency3);
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        spectralSpec.calculateCorrelatorSetup(Velocity.createVelocity());
        spectralSpec.getCorrelatorConfiguration().updateSideband();
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(true);
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE);
    }

    public SpectralSpec cloneTDMPhaseSpectralSpec(SpectralSpec spectralSpec) {
        boolean[] blArray;
        int n;
        int[] nArray;
        SpectralSpec spectralSpec2 = spectralSpec.deepCopy();
        Velocity velocity = this.velocity.deepCopy();
        AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec2.getAbstractCorrelatorConfiguration();
        CorrConfigMode corrConfigMode = this.correxp.getContinuumMode(CorrPolarization.DOUBLE);
        Frequency frequency = spectralSpec.getLO1Frequency();
        ReceiverBand receiverBand = spectralSpec2.getReceiverBand();
        Frequency frequency2 = Frequency.createFrequencyGHZ(receiverBand.getLOMin());
        Frequency frequency3 = Frequency.createFrequencyGHZ(receiverBand.getLOMax());
        FrequencyRange frequencyRange = new FrequencyRange(frequency2, frequency3);
        frequency = frequencyRange.clip(frequency);
        Frequency frequency4 = frequency.inverseDopplerShifted(velocity);
        spectralSpec2.setSourceVelocity(velocity);
        spectralSpec2.setName("TDM Cal Setup");
        spectralSpec2.setRestFrequency(frequency4);
        spectralSpec2.clearBaseBand();
        FrequencyRange frequencyRange2 = receiverBand.getIFRange();
        Frequency frequency5 = (Frequency)((Object)frequencyRange2.mid());
        if (((Frequency)((Object)frequencyRange2.range())).getContentInGHz() >= 8.0) {
            nArray = new int[]{-3, -1, 1, 3};
            n = this.mostWindowsInSideband(spectralSpec, SpectralSpec.SideBand.USB);
            blArray = new boolean[]{n, n, n, n};
        } else {
            nArray = new int[]{-1, 1, -1, 1};
            blArray = new boolean[]{false, false, true, true};
        }
        for (n = 0; n < 4; ++n) {
            int n2 = blArray[n] ? 1 : -1;
            AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
            Frequency frequency6 = Frequency.createFrequencyGHZ(nArray[n]);
            Frequency frequency7 = (Frequency)((Frequency)frequency.plus(frequency5.multiply(n2))).plus((AbstractDoubleWithUnit)frequency6);
            abstractBaseBandConfig.setCenterFrequency(this.velocity.reverseShift(frequency7));
            abstractBaseBandConfig.setLO2Frequency((Frequency)((Frequency)frequency5.plus((AbstractDoubleWithUnit)frequency6)).plus((AbstractDoubleWithUnit)THREE_GHZ));
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        spectralSpec2.calculateCorrelatorSetup(this.velocity);
        spectralSpec2.getCorrelatorConfiguration().updateSideband();
        return spectralSpec2;
    }

    protected boolean mostWindowsInSideband(SpectralSpec spectralSpec, SpectralSpec.SideBand sideBand) {
        int n = 0;
        int n2 = 0;
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                if (spectralWindowI.getSideBandUse().uses(sideBand)) {
                    ++n;
                    continue;
                }
                ++n2;
            }
        }
        return n >= n2;
    }

    public SpectralSpec cloneTDMAtmCalSpectralSpec(SpectralSpec spectralSpec) {
        SpectralSpec spectralSpec2 = spectralSpec.deepCopy();
        CorrConfigMode corrConfigMode = this.correxp.getContinuumMode(CorrPolarization.DOUBLE);
        spectralSpec2.setName("TDM Atm Cal setup");
        for (int i = 0; i < spectralSpec2.getBaseBandCount(); ++i) {
            AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec2.getBaseBandConfig(i);
            for (int j = 0; j < abstractBaseBandConfig.getSingleSpectralWindowCount(); ++j) {
                abstractBaseBandConfig.removeSingleSpectralWindow(abstractBaseBandConfig.getSingleSpectralWindow(j));
            }
            AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
            abstractSpectralWindow.setCorrConfigMode(corrConfigMode);
            abstractSpectralWindow.adjustCenterFrequency();
            abstractSpectralWindow.publishCorrConfigMode();
        }
        return spectralSpec2;
    }

    protected void setupCommonCorrelatorConfiguration(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        abstractCorrelatorConfiguration.setAPCDataSets(AbstractCorrelatorConfiguration.APCDATASETS_AP_UNCORRECTED);
        abstractCorrelatorConfiguration.setCAM(AbstractCorrelatorConfiguration.CAM_NORMAL);
        abstractCorrelatorConfiguration.setEnable180DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setEnable90DegreeWalshFunction(false);
        abstractCorrelatorConfiguration.setLOOffsettingMode(AbstractCorrelatorConfiguration.LOOFFSETTINGMODE_NONE);
        this.setupBasebands(abstractCorrelatorConfiguration);
        boolean bl = this.sbContext.getGoal().getSpectralSetupParameters().isWalshSwitching();
        if (bl) {
            abstractCorrelatorConfiguration.setEnable90DegreeWalshFunction(bl);
        }
    }

    protected void setupBasebands(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        Object object;
        Velocity velocity = this.ssp.isSingleContinuum() && this.ssp.isSingleContinuumSkyFrequency() || this.ssp.getSSPDerivedFromSpectralScanSetup() != false ? Velocity.createVelocity() : this.ssp.getSourceVelocity();
        SpectralSpec spectralSpec = (SpectralSpec)abstractCorrelatorConfiguration.getParent();
        try {
            object = new BaseBandDeployer(this.ssp);
            Frequency[] frequencyArray = ((BaseBandDeployer)object).getAdjustedBaseBandCenterFrequenciesRest();
            String[] stringArray = BaseBandSpecification.getKnownBaseBandNameList();
            for (int i = 0; i < frequencyArray.length; ++i) {
                if (frequencyArray[i].isEqual((AbstractDoubleWithUnit)BaseBandDeployer.dummyFrequency)) continue;
                AbstractBaseBandConfig abstractBaseBandConfig = this.addNewBaseBandConfig(abstractCorrelatorConfiguration);
                abstractBaseBandConfig.setCenterFrequency(frequencyArray[i]);
                abstractBaseBandConfig.setBaseBandName(stringArray[i]);
            }
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            throw new WizardSBGenerationException(baseBandNotDeployableException);
        }
        try {
            object = this.ssp.getGroupIndexSet();
        }
        catch (InvalidGroupIndexException invalidGroupIndexException) {
            invalidGroupIndexException.printStackTrace();
            throw new WizardSBGenerationException(invalidGroupIndexException);
        }
        spectralSpec.calculateCorrelatorSetup(velocity);
        int n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ScienceSpectralWindow[] scienceSpectralWindowArray;
            int n2 = (Integer)iterator.next();
            for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray = this.ssp.getScienceSpectralWindowGroup(n2)) {
                AbstractSpectralWindow abstractSpectralWindow = this.addNewSpectralWindow(abstractCorrelatorConfiguration.getBaseBandConfig(n), scienceSpectralWindow);
                abstractSpectralWindow.setCorrConfigMode(scienceSpectralWindow.getCorrConfigMode());
                abstractSpectralWindow.adjustCenterFrequency();
                abstractSpectralWindow.publishCorrConfigMode();
                abstractSpectralWindow.setScienceSpectralWindow(scienceSpectralWindow);
                SpectralLine spectralLine = SpectralLine.createSpectralLine();
                spectralLine.setRestFrequency(scienceSpectralWindow.getCenterFrequency().deepCopy());
                spectralLine.setTransition(scienceSpectralWindow.getTransitionName());
                spectralLine.setSplatalogId(scienceSpectralWindow.getSplatalogId());
                abstractSpectralWindow.addSpectralLine(spectralLine);
                if (abstractSpectralWindow.getBandwidth().isEqual((AbstractDoubleWithUnit)TWO_GHZ)) continue;
                Frequency frequency = (Frequency)abstractCorrelatorConfiguration.getBaseBandConfig(n).getBaseBandSpecification().getCenterFrequencySky().minus((AbstractDoubleWithUnit)abstractCorrelatorConfiguration.getBaseBandConfig(n).getBaseBandSpecification().getActualBaseBandCenterFrequencySky(), true);
                Frequency frequency2 = Frequency.createFrequencyMHZ(0.0);
                frequency2 = abstractSpectralWindow.getSideBand().equals(NetSideBand.USB.toString()) ? (Frequency)abstractSpectralWindow.getCenterFrequency().minus((AbstractDoubleWithUnit)frequency, true) : (Frequency)abstractSpectralWindow.getCenterFrequency().plus((AbstractDoubleWithUnit)frequency, true);
                frequency2.convertToMHz();
                abstractSpectralWindow.setDesiredCenterFrequency(frequency2);
            }
            ++n;
        }
    }

    protected AbstractBaseBandConfig addNewBaseBandConfig(AbstractCorrelatorConfiguration abstractCorrelatorConfiguration) {
        SpectralSpec spectralSpec = abstractCorrelatorConfiguration.getSpectralSpec();
        AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec.addNewBaseBand().getBaseBandConfig();
        abstractBaseBandConfig.setDataProducts(AbstractBaseBandConfig.DATAPRODUCTS_CROSS_AND_AUTO);
        abstractBaseBandConfig.setSwitchingType(SpectralSpec.SWITCHINGTYPE_NO_SWITCHING);
        return abstractBaseBandConfig;
    }

    protected AbstractSpectralWindow addNewSpectralWindow(AbstractBaseBandConfig abstractBaseBandConfig, ScienceSpectralWindow scienceSpectralWindow) {
        AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)abstractBaseBandConfig.addNewSpectralWindow();
        Frequency frequency = Frequency.createFrequencyGHZ(1.875);
        abstractSpectralWindow.setEffectiveBandwidth(frequency);
        abstractSpectralWindow.setEffectiveNumberOfChannels(7680);
        abstractSpectralWindow.setAssociatedSpectralWindowNumberInPair(0);
        abstractSpectralWindow.setSpectralAveragingFactor(scienceSpectralWindow.getAdvancedWindowSetup().getSmoothingFactor());
        abstractSpectralWindow.setWindowFunction(scienceSpectralWindow.getAdvancedWindowSetup().getSmoothingFunction());
        abstractSpectralWindow.setPolnProducts(CorrPolarization.getCorrPolarization((String)this.ssp.getPolarisation()).polnProducts);
        abstractSpectralWindow.setScienceSpectralWindow(scienceSpectralWindow);
        Velocity velocity = this.ssp.isSingleContinuumSkyFrequency() || this.ssp.getSSPDerivedFromSpectralScanSetup() != false ? Velocity.createVelocity() : this.ssp.getSourceVelocity();
        Frequency[] frequencyArray = abstractSpectralWindow.getBaseBandConfig().getLOFrequencies();
        Frequency frequency2 = frequencyArray[0];
        Frequency frequency3 = frequencyArray[1];
        Frequency frequency4 = scienceSpectralWindow.getCenterFrequency().dopplerShifted(velocity);
        NetSideBand netSideBand = frequency4.compareTo((AbstractDoubleWithUnit)frequency2) > 0 ? NetSideBand.USB : NetSideBand.LSB;
        abstractSpectralWindow.setSideBand(netSideBand.toString());
        if (scienceSpectralWindow.getBandWidth().isEqual((AbstractDoubleWithUnit)BaseBandDeployer.BASEBANDWIDTH)) {
            abstractSpectralWindow.getCenterFrequency().setContentInMHz(3000.0);
        } else {
            Frequency frequency5 = netSideBand.getBaseBandFrequency(frequency4, frequency2, frequency3);
            abstractSpectralWindow.getCenterFrequency().setContentInMHz(frequency5.getContentInMHz());
        }
        abstractSpectralWindow.setBandParameters((Frequency)((Object)scienceSpectralWindow.getBandWidth()), scienceSpectralWindow.getNumberOfChannels(), SpectralWindowBand.ChannelType.NOMINAL);
        return abstractSpectralWindow;
    }

    protected void setupChannelAverageRegion(AbstractSpectralWindow abstractSpectralWindow, String string) {
        for (ChannelAverageRegion channelAverageRegion : this.correxp.calcChannelAverageRegions(abstractSpectralWindow, string)) {
            abstractSpectralWindow.addChannelAverageRegion(channelAverageRegion);
        }
    }

    private class SpectralSpecMap<K, V extends SpectralSpec>
    extends HashMap<K, V> {
        private SpectralSpec scienceSpectralSpec = null;

        @Override
        public V get(Object object) {
            assert (this.scienceSpectralSpec != null);
            SpectralSpec spectralSpec = null;
            if (this.containsKey(object)) {
                spectralSpec = (SpectralSpec)super.get(object);
            } else {
                switch ((String)object) {
                    case "TDMPhase": {
                        SpectralSpec spectralSpec2 = SpectralSpecWorker.this.cloneTDMPhaseSpectralSpec(this.scienceSpectralSpec);
                        this.put("TDMPhase", spectralSpec2);
                        spectralSpec = spectralSpec2;
                        break;
                    }
                    case "POINTING": {
                        SpectralSpec spectralSpec3 = SpectralSpecWorker.this.createSpectralSpecWithCorrelatorConfiguration();
                        spectralSpec3.setSourceVelocity(SpectralSpecWorker.this.velocity.deepCopy());
                        switch (this.scienceSpectralSpec.getReceiverBand().getNumber()) {
                            case 3: {
                                SpectralSpecWorker.this.setupSpectralSpec(spectralSpec3, Frequency.createFrequencyGHZ(103.0), "Pointing");
                                break;
                            }
                            case 4: {
                                SpectralSpecWorker.this.setupSpectralSpec(spectralSpec3, Frequency.createFrequencyGHZ(155.0), "Pointing");
                                break;
                            }
                            case 5: {
                                SpectralSpecWorker.this.setupSpectralSpec(spectralSpec3, Frequency.createFrequencyGHZ(203.0), "Pointing");
                                break;
                            }
                            default: {
                                SpectralSpecWorker.this.setupSpectralSpec(spectralSpec3, Frequency.createFrequencyGHZ(223.25), "Pointing");
                            }
                        }
                        this.put("POINTING", spectralSpec3);
                        spectralSpec = spectralSpec3;
                        break;
                    }
                    case "FOCUS": {
                        SpectralSpec spectralSpec4 = SpectralSpecWorker.this.createSpectralSpecWithCorrelatorConfiguration();
                        spectralSpec4.setSourceVelocity(SpectralSpecWorker.this.velocity.deepCopy());
                        if (this.scienceSpectralSpec.getReceiverBand().getNumber() == 8) {
                            SpectralSpecWorker.this.setupSpectralSpec(spectralSpec4, Frequency.createFrequencyGHZ(410.5), "Focus");
                            this.put("FOCUS", spectralSpec4);
                            spectralSpec = spectralSpec4;
                            break;
                        }
                        if (this.scienceSpectralSpec.getReceiverBand().getNumber() != 7) break;
                        SpectralSpecWorker.this.setupSpectralSpec(spectralSpec4, Frequency.createFrequencyGHZ(290.0), "Focus");
                        this.put("FOCUS", spectralSpec4);
                        spectralSpec = spectralSpec4;
                        break;
                    }
                    case "DELAY": {
                        SpectralSpec spectralSpec5 = SpectralSpecWorker.this.createSpectralSpecWithCorrelatorConfiguration();
                        SpectralSpecWorker.this.setupSpectralSpec(spectralSpec5);
                        if (SpectralSpecWorker.this.sbContext.getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.TPAMPCAL)) {
                            spectralSpec5 = SpectralSpecFactory.convertToTopo(spectralSpec5);
                        }
                        spectralSpec5.setName("Delay Setup");
                        this.put("DELAY", spectralSpec5);
                        spectralSpec = spectralSpec5;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown key provided for spectral spec map: " + object);
                    }
                }
            }
            return (V)spectralSpec;
        }

        public SpectralSpecMap(SpectralSpec spectralSpec) {
            if (spectralSpec == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: ss");
            }
            this.scienceSpectralSpec = spectralSpec;
        }
    }

    public static enum Type {
        BL,
        ACA;

    }
}

