/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.targetcreator.CalibratorFieldSourceWorker;
import alma.obsprep.services.generator.refactored.targetcreator.FieldSourceWorkerUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Velocity;

class QuerySourceFieldSourceWorker
extends CalibratorFieldSourceWorker {
    QuerySourceFieldSourceWorker() {
    }

    public static FieldSource getFieldSource(alma.obsprep.bo.obsproject.QuerySource querySource, RequestedArray requestedArray, SpectralSpec spectralSpec) {
        FieldSource fieldSource = QuerySourceFieldSourceWorker.createCalibratorFieldSource();
        QuerySource querySource2 = QuerySource.createQuerySource(querySource);
        String string = querySource.getIntendedUse();
        switch (querySource.getObsType()) {
            case AMPLITUDE: {
                querySource2.setSearchRadius(Angle.createAngle((double)0.0, (String)Angle.UNIT_DEG));
                break;
            }
            case BANDPASS: {
                querySource2.setSearchRadius(Angle.createAngle((double)120.0, (String)Angle.UNIT_DEG));
                break;
            }
            case PHASE: {
                querySource2.setSearchRadius(Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG));
                break;
            }
            case POINTING: {
                querySource2.setSearchRadius(Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG));
            }
        }
        fieldSource.setIsQuery(true);
        fieldSource.setQuerySource(querySource2);
        fieldSource.setName(string);
        fieldSource.setSourceName("query");
        fieldSource.setSourceVelocity(Velocity.createVelocity());
        if (RequestedArray.TP.equals((Object)requestedArray) && ObsType.AMPLITUDE.equals((Object)querySource.getObsType())) {
            QuerySourceFieldSourceWorker.setUpTPAmplitudeRasterScan(fieldSource, spectralSpec);
        }
        Reference reference = FieldSourceWorkerUtils.getAtmosphericReference(spectralSpec, fieldSource);
        fieldSource.addReference(reference);
        return fieldSource;
    }
}

