/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.ObservingParametersAbstractFactory;
import alma.obsprep.services.generator.refactored.obsparams.ObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.targetcreator.ITargetCreatorHelper;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class ScienceGoalTargetCreatorHelper
implements ITargetCreatorHelper {
    private final ObservingParameters obsParams;
    private final SpectralSpec spectralSpec;
    private static final Collection<ObsType> SOURCE_VELOCITY_TARGETS;

    public ScienceGoalTargetCreatorHelper(RequestedArray requestedArray, TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, int n, SBGenerationContext sBGenerationContext) {
        BusinessObject businessObject = spectralSetupParameters.getParent();
        if (!(businessObject instanceof ScienceGoal)) {
            throw new IllegalArgumentException("SpectralSetupParameters must belong to a ScienceGoal");
        }
        ObsType obsType = targetWithIntent.getObsType();
        Velocity velocity = SOURCE_VELOCITY_TARGETS.contains((Object)obsType) ? spectralSetupParameters.getSourceVelocity().deepCopy() : targetWithIntent.getSourceVelocity().getVelocityInBary(targetWithIntent.getSourceCoordinates());
        SpectralSpecFactory spectralSpecFactory = new SpectralSpecFactory(sBGenerationContext);
        this.spectralSpec = spectralSpecFactory.getSpectralSpec(spectralSetupParameters, velocity, targetWithIntent);
        ObservingParametersFactory observingParametersFactory = ObservingParametersAbstractFactory.getFactory(spectralSetupParameters, this.spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
        this.obsParams = observingParametersFactory.getObservingParameters(targetWithIntent.getObsType(), n, spectralSetupParameters, this.spectralSpec, sBGenerationContext);
    }

    @Override
    public ObservingParameters getObservingParameters() {
        return this.obsParams;
    }

    @Override
    public SpectralSpec getSpectralSpec() {
        return this.spectralSpec;
    }

    static {
        ArrayList<ObsType> arrayList = new ArrayList<ObsType>();
        arrayList.addAll(ObsType.ALL_TYPES);
        arrayList.remove((Object)ObsType.SCIENCE);
        SOURCE_VELOCITY_TARGETS = Collections.unmodifiableCollection(arrayList);
    }
}

