/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.common.horizonsparser.HorizonParser;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.AbstractTargetParametersData;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.editors.spatialvisual.RectangleMosaic;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameters;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.targetcreator.FieldSourceWorkerUtils;
import alma.obsprep.util.OTHorizonParser;
import alma.obsprep.util.OTLoggerAdapter;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import alma.valuetypes.Velocity;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TargetParametersFieldSourceWorker {
    private static final Collection<RequestedArray> arraysForWhichRectanglesAreConvertedToPointingMosaic = ImmutableList.of((Object)((Object)RequestedArray.TWELVE_M), (Object)((Object)RequestedArray.ACA), (Object)((Object)RequestedArray.SEVEN_M));

    public static FieldSource getFieldSource(TargetParameters targetParameters, RequestedArray requestedArray, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        TargetParametersFieldSourceWorker.validate(targetParameters);
        FieldSource fieldSource = FieldSource.createFieldSource();
        TargetParametersFieldSourceWorker.setupFieldSource(targetParameters, fieldSource, requestedArray, spectralSpec, sBGenerationContext);
        Reference reference = FieldSourceWorkerUtils.getAtmosphericReference(spectralSpec, fieldSource);
        fieldSource.addReference(reference);
        return fieldSource;
    }

    private static void validate(TargetParameters targetParameters) throws WizardSBGenerationException {
        String string = targetParameters.getType();
        if (TargetParameters.TYPE_F_MULTIPLEPOINTS.equals(string)) {
            if (targetParameters.getFieldSinglePointCount() != targetParameters.getFieldCount()) {
                String string2 = "Only SinglePoint is allowed for this field type : " + string;
                throw new WizardSBGenerationException(string2);
            }
            int n = 0;
            String string3 = targetParameters.getSourceName() + "-";
            for (SinglePoint singlePoint : targetParameters.getFieldSinglePoint()) {
                singlePoint.getCentre().setFieldName(string3 + ++n);
            }
        } else if (TargetParameters.TYPE_F_SINGLERECTANGLE.equals(string)) {
            Rectangle rectangle = (Rectangle)((Object)targetParameters.getField(0));
            if (rectangle.getLong().getContentInDefaultUnits() <= 0.0 || rectangle.getShort().getContentInDefaultUnits() <= 0.0 || rectangle.getSpacing().getContentInDefaultUnits() <= 0.0) {
                String string4 = "Mapping rectangle definition is invalid. Check your science goal";
                throw new WizardSBGenerationException(string4);
            }
        } else {
            throw new WizardSBGenerationException("Unknown TargetParameter type : " + string);
        }
    }

    private static void setupFieldSource(TargetParameters targetParameters, FieldSource fieldSource, RequestedArray requestedArray, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        fieldSource.setName("Primary:");
        fieldSource.setSourceName(targetParameters.gettrueSourceName());
        fieldSource.setTargetParameters(targetParameters);
        Object object = targetParameters.gettrueSourceCoordinates();
        if (object != null) {
            SkyCoordinates skyCoordinates = null;
            skyCoordinates = ((SkyCoordinates)object.deepCopy()).getICRSSkyCoordinates();
            fieldSource.setSourceCoordinates(skyCoordinates);
        }
        if ((object = targetParameters.gettruePmRA()) != null) {
            fieldSource.setPMRA((AngularVelocity)object.deepCopy());
        }
        if ((object = targetParameters.gettruePmDec()) != null) {
            fieldSource.setPMDec((AngularVelocity)object.deepCopy());
        }
        if ((object = targetParameters.gettrueParallax()) != null) {
            fieldSource.setParallax((Angle)object.deepCopy());
        }
        fieldSource.setNonSiderealMotion(targetParameters.gettrueNonSiderealMotion());
        String string = targetParameters.getSolarSystemObject();
        if (string != null) {
            fieldSource.setSolarSystemObject(string);
            if (fieldSource.gettrueSourceName().equals("")) {
                fieldSource.setSourceName(string);
            }
        }
        if ((string = targetParameters.gettrueSourceEphemeris()) != null && targetParameters.gettrueNonSiderealMotion()) {
            fieldSource.setSourceEphemeris(string);
            if (targetParameters.getSolarSystemObject() != null && targetParameters.getSolarSystemObject().equals(TargetParameters.SOLARSYSTEMOBJECT_SUN)) {
                fieldSource.initialiseFieldSourceAttributesWithEphemerisData(Optional.of(targetParameters.getSourceName()));
                if (requestedArray.isInterferometeric()) {
                    fieldSource.setSolarSystemObject(AbstractTargetParametersData.SOLARSYSTEMOBJECT_EPHEMERIS);
                }
            } else {
                fieldSource.initialiseFieldSourceAttributesWithEphemerisData(Optional.empty());
            }
            if (fieldSource.gettrueSourceName().equals("")) {
                fieldSource.setSourceName("Ephemeris Object");
            }
        }
        if ((object = targetParameters.gettrueSourceVelocity()) != null) {
            fieldSource.setSourceVelocity((Velocity)object.deepCopy());
        }
        if (fieldSource.getSourceVelocity().getReferenceSystem() == Velocity.REFERENCESYSTEM_HEL) {
            fieldSource.getSourceVelocity().setReferenceSystem(Velocity.REFERENCESYSTEM_BAR);
        }
        try {
            TargetParametersFieldSourceWorker.setupFieldPattern(targetParameters, fieldSource, requestedArray, spectralSpec, sBGenerationContext);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException("Unable to set up field source : " + incompleteCorrelatorSetupFoundException.getLocalizedMessage());
        }
    }

    private static void setupFieldPattern(TargetParameters targetParameters, FieldSource fieldSource, RequestedArray requestedArray, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) throws SpectralSpec.IncompleteCorrelatorSetupFoundException {
        if (sBGenerationContext == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sbContext");
        }
        if (targetParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: tp");
        }
        if (fieldSource == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: fs");
        }
        if (requestedArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: requestedArray");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: ss");
        }
        if (targetParameters.getNonSiderealMotion() && !StringUtils.isEmpty((CharSequence)targetParameters.getSourceEphemeris())) {
            try {
                Class<TargetParametersFieldSourceWorker> clazz = TargetParametersFieldSourceWorker.class;
                Log.Logger logger = Log.logger(clazz);
                OTHorizonParser oTHorizonParser = new OTHorizonParser(new OTLoggerAdapter(logger, clazz.getName(), null), targetParameters.getSourceEphemeris());
                assert (oTHorizonParser != null);
                List list = oTHorizonParser.parseEphemeris();
                if (list.size() > 0) {
                    HorizonParser.ParsedEphemerisLine parsedEphemerisLine = (HorizonParser.ParsedEphemerisLine)list.get(0);
                    SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
                    skyCoordinates.setLatitude(Latitude.createLatitude((double)parsedEphemerisLine.declination, (String)Latitude.UNIT_RAD));
                    skyCoordinates.setLongitude(Longitude.createLongitude((double)parsedEphemerisLine.rightAscension, (String)Longitude.UNIT_RAD));
                    skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
                    skyCoordinates.setType(SkyCoordinates.TYPE_ABSOLUTE);
                }
            }
            catch (HorizonParser.UnableToParseEphemerisDataException | IOException | NullPointerException throwable) {
                // empty catch block
            }
        }
        if (targetParameters.isPointingPattern()) {
            TargetParametersFieldSourceWorker.configureFieldPatternForPointingPattern(targetParameters, fieldSource, requestedArray, spectralSpec, sBGenerationContext);
        } else if (targetParameters.isRectanglePattern()) {
            TargetParametersFieldSourceWorker.configureFieldPatternForRectanglePattern(targetParameters, fieldSource, requestedArray, spectralSpec);
        }
    }

    private static void configureFieldPatternForRectanglePattern(TargetParameters targetParameters, FieldSource fieldSource, RequestedArray requestedArray, SpectralSpec spectralSpec) {
        RectanglePattern rectanglePattern = RectanglePattern.createRectanglePattern();
        fieldSource.setFieldPattern((FieldPattern)((Object)rectanglePattern));
        TargetParametersFieldSourceWorker.setupRectanglePattern(targetParameters, rectanglePattern, requestedArray, spectralSpec);
        if (arraysForWhichRectanglesAreConvertedToPointingMosaic.contains((Object)requestedArray)) {
            TargetParametersFieldSourceWorker.setupStandardPointingMosaic(targetParameters, fieldSource, requestedArray);
        }
    }

    private static void configureFieldPatternForPointingPattern(TargetParameters targetParameters, FieldSource fieldSource, RequestedArray requestedArray, SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) throws SpectralSpec.IncompleteCorrelatorSetupFoundException {
        boolean bl;
        PointingPattern pointingPattern = PointingPattern.createPointingPattern();
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
        boolean bl2 = bl = RequestedArray.SEVEN_M.equals((Object)requestedArray) && targetParameters.getIsMosaic() && !sBGenerationContext.getGoal().isStandAloneACA();
        if (bl) {
            TargetParametersFieldSourceWorker.setupMinBoundingBoxACA7mPointingPattern(targetParameters, pointingPattern, spectralSpec);
            pointingPattern.matchSystemToOrigin();
        } else if (RequestedArray.TP.equals((Object)requestedArray)) {
            RectanglePattern rectanglePattern = RectanglePattern.createRectanglePattern();
            fieldSource.setFieldPattern((FieldPattern)((Object)rectanglePattern));
            Rectangle rectangle = SchedBlockExpert.getBoundingRectangle(targetParameters);
            assert (rectangle != null);
            Frequency frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
            assert (frequency != null);
            rectangle.setReferenceFrequency(frequency);
            TargetParametersFieldSourceWorker.setupRectanglePattern(rectangle, rectanglePattern, RequestedArray.TP, spectralSpec, targetParameters);
        } else {
            TargetParametersFieldSourceWorker.setupPointingPattern(targetParameters, pointingPattern);
            pointingPattern.matchSystemToOrigin();
        }
    }

    private static void setupMinBoundingBoxACA7mPointingPattern(TargetParameters targetParameters, PointingPattern pointingPattern, SpectralSpec spectralSpec) {
        Frequency frequency;
        if (targetParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: tp");
        }
        if (pointingPattern == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: pp");
        }
        if (!targetParameters.getIsMosaic()) {
            throw new IllegalArgumentException("The target parameters are expected to be a custom mosaic");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: spectralSpec");
        }
        Rectangle rectangle = SchedBlockExpert.getBoundingRectangle(targetParameters);
        Log.logger(SchedBlockExpert.class).fine("Raw 12-m rectangle bounding points: " + rectangle);
        try {
            frequency = spectralSpec.getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.LOWESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        assert (frequency != null);
        Angle angle = Angle.createAngle();
        angle.setContent(frequency.getWavelengthM() / Antenna.ANTENNA_7M.getDiameter());
        angle.setUnit(Angle.UNIT_RAD);
        angle.convertToUnit(Angle.UNIT_ARCSEC);
        UserAngle userAngle = UserAngle.createUserAngle((Angle)angle.divide(Math.sqrt(3.0)));
        userAngle.setAntenna(Antenna.ANTENNA_7M);
        userAngle.setObservingFrequency(frequency);
        Angle angle2 = (Angle)rectangle.getLatitudeLength().plus((ValueUnitPair)Antenna.ANTENNA_12M.getBeamSize(frequency));
        Angle angle3 = (Angle)rectangle.getLongitudeLength().plus((ValueUnitPair)Antenna.ANTENNA_12M.getBeamSize(frequency));
        rectangle.setShort(angle2);
        rectangle.setLong(angle3);
        rectangle.setArray(Array.ARRAY_7M);
        rectangle.setReferenceFrequency(frequency);
        Log.logger(TargetParametersFieldSourceWorker.class).fine(String.format("Nyquist spacing for 7m at %s is %s or %s arcsec", frequency.toString(), userAngle.getContentInUnits(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM), userAngle.getContentInUnits(UserAngle.USERUNIT_ARCSEC)));
        rectangle.setSpacing(UserAngle.createUserAngle((Angle)((Object)userAngle)));
        RectangleMosaic rectangleMosaic = new RectangleMosaic(rectangle, Antenna.ANTENNA_7M);
        PointingPattern pointingPattern2 = rectangleMosaic.getPointingPattern(targetParameters.getFieldCenterCoordinates());
        if (pointingPattern2.getPhaseCenterCoordinatesCount() == 0) {
            pointingPattern2.addPhaseCenterCoordinates(SkyCoordinates.createOffsetCoordinates());
        }
        for (SkyCoordinates skyCoordinates : pointingPattern2.getPhaseCenterCoordinates()) {
            pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
        }
        if (pointingPattern != null) {
            pointingPattern.setIsMosaic(targetParameters.getIsMosaic());
        }
        TargetParametersFieldSourceWorker.eliminateRedundant7mPointingsFromPointingPattern(targetParameters, pointingPattern, frequency);
    }

    private static void eliminateRedundant7mPointingsFromPointingPattern(TargetParameters targetParameters, PointingPattern pointingPattern, Frequency frequency) {
        if (pointingPattern == null) {
            throw new NullPointerException("Illegal argument - the argument pointingPattern cannot be null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("Illegal argument - the argument targetParameters cannot be null");
        }
        if (frequency == null) {
            throw new NullPointerException("Illegal argument - the argument lowestSPWCentralFrequency cannot be null");
        }
        if (!targetParameters.getIsMosaic()) {
            throw new IllegalArgumentException("The target parameters should be a custom mosaic");
        }
        UserAngle userAngle = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle.setAntenna(Antenna.ANTENNA_7M);
        double d = userAngle.getContentInUnits(UserAngle.UNIT_ARCSEC) / 2.0;
        assert (d > 0.0);
        Log.logger(TargetParametersFieldSourceWorker.class).fine(String.format("beamWidth7mRadius=%g maxSeparationFrom12mPointing=%g", d, d));
        ArrayList<SkyCoordinates> arrayList = new ArrayList<SkyCoordinates>(150);
        block0: for (SkyCoordinates skyCoordinates : pointingPattern.getPhaseCenterCoordinates()) {
            if (skyCoordinates.isAbsoluteCoordinates()) {
                skyCoordinates = skyCoordinates.getOffsetCoordinates(targetParameters.getSourceCoordinates());
            }
            double d2 = skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_ARCSEC);
            double d3 = skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_ARCSEC);
            boolean bl = false;
            for (SkyCoordinates skyCoordinates2 : targetParameters.getPointingPattern().getPhaseCenterCoordinates()) {
                if (skyCoordinates2.isAbsoluteCoordinates()) {
                    skyCoordinates2 = skyCoordinates2.getOffsetCoordinates(targetParameters.getSourceCoordinates());
                }
                double d4 = skyCoordinates2.getLatitude().getContentInUnits(Latitude.UNIT_ARCSEC);
                double d5 = skyCoordinates2.getLongitude().getContentInUnits(Longitude.UNIT_ARCSEC);
                double d6 = Math.sqrt(Math.pow(d5 - d3, 2.0) + Math.pow(d4 - d2, 2.0));
                if (!(d6 <= d)) continue;
                bl = true;
                continue block0;
            }
            if (bl) continue;
            arrayList.add(skyCoordinates);
        }
        for (SkyCoordinates skyCoordinates : arrayList) {
            pointingPattern.removePhaseCenterCoordinates(skyCoordinates);
        }
        Log.logger(TargetParametersFieldSourceWorker.class).fine(String.format("%d pointings in the 7m pointing pattern: %d have been removed)", pointingPattern.getNumberOfPointings(), arrayList.size()));
    }

    private static void setupPointingPattern(TargetParameters targetParameters, PointingPattern pointingPattern) {
        if (targetParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: tp");
        }
        if (pointingPattern == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: pp");
        }
        for (SinglePoint singlePoint : targetParameters.getFieldSinglePoint()) {
            SkyCoordinates skyCoordinates = singlePoint.getCentre().deepCopy();
            if (skyCoordinates.isAbsoluteCoordinates()) {
                skyCoordinates = skyCoordinates.getOffsetCoordinates(targetParameters.getSourceCoordinates());
            }
            pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
        }
        if (pointingPattern != null) {
            pointingPattern.setIsMosaic(targetParameters.getIsMosaic());
        }
    }

    private static void setupRectanglePattern(TargetParameters targetParameters, RectanglePattern rectanglePattern, RequestedArray requestedArray, SpectralSpec spectralSpec) {
        Rectangle rectangle = targetParameters.getFieldRectangle()[0];
        rectangle.setTargetParameters(targetParameters);
        TargetParametersFieldSourceWorker.setupRectanglePattern(rectangle, rectanglePattern, requestedArray, spectralSpec, targetParameters);
    }

    private static void setupRectanglePattern(Rectangle rectangle, RectanglePattern rectanglePattern, RequestedArray requestedArray, SpectralSpec spectralSpec, TargetParameters targetParameters) {
        if (RequestedArray.TP.equals((Object)requestedArray)) {
            TargetParametersFieldSourceWorker.setupTPRectanglePattern(rectangle, rectanglePattern, spectralSpec, targetParameters);
        } else {
            TargetParametersFieldSourceWorker.setupStandardRectanglePattern(rectangle, rectanglePattern, spectralSpec, targetParameters);
        }
    }

    private static void setupStandardRectanglePattern(Rectangle rectangle, RectanglePattern rectanglePattern, SpectralSpec spectralSpec, TargetParameters targetParameters) {
        SkyCoordinates skyCoordinates = rectangle.getCentre().deepCopy();
        skyCoordinates.setSystem(targetParameters.getSourceCoordinates().getSystem());
        rectanglePattern.setPatternCenterCoordinates(skyCoordinates);
        rectanglePattern.setScanningCoordinateSystem(RectanglePattern.SCANNINGCOORDINATESYSTEM_ICRS);
        rectanglePattern.setOrientation(rectangle.getPALong().deepCopy());
        Angle angle = Angle.createAngle();
        angle.setContentAndUnit(rectangle.getSpacing().getContentInUnits(UserAngle.UNIT_ARCSEC), Angle.UNIT_ARCSEC);
        rectanglePattern.setOrthogonalStep(angle);
        rectanglePattern.getLongitudeLength().setContent(rectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC));
        rectanglePattern.getLongitudeLength().setUnit(Angle.UNIT_ARCSEC);
        rectanglePattern.getLatitudeLength().setContent(rectangle.getShort().getContentInUnits(Angle.UNIT_ARCSEC));
        rectanglePattern.getLatitudeLength().setUnit(Angle.UNIT_ARCSEC);
        TargetParametersFieldSourceWorker.performGalacticToICRSRectangleRotation(targetParameters, rectanglePattern, SystemRotationConversion.GalacticToICRS);
    }

    private static void setupTPRectanglePattern(Rectangle rectangle, RectanglePattern rectanglePattern, SpectralSpec spectralSpec, TargetParameters targetParameters) {
        Frequency frequency;
        if ((rectangle = rectangle.getTPArrayRectangle(spectralSpec)).getLong().isGreaterThanOrEqualTo((AbstractDoubleWithUnit)rectangle.getShort())) {
            rectanglePattern.setScanDirection(RectanglePattern.SCANDIRECTION_LONGITUDE);
        } else {
            rectanglePattern.setScanDirection(RectanglePattern.SCANDIRECTION_LATITUDE);
        }
        SkyCoordinates skyCoordinates = rectangle.getCentre().deepCopy();
        if (!targetParameters.isPointingPattern()) {
            skyCoordinates.setSystem(targetParameters.getSourceCoordinates().getSystem());
        }
        rectanglePattern.setPatternCenterCoordinates(skyCoordinates);
        rectanglePattern.setScanningCoordinateSystem(RectanglePattern.SCANNINGCOORDINATESYSTEM_ICRS);
        rectanglePattern.setOrientation(rectangle.getPALong().deepCopy());
        try {
            frequency = spectralSpec.getSpectralSpec().getFilteredSpectralWindow(SpectralSpec.FilteringCriteria.HIGHESTFREQUENCY);
        }
        catch (SpectralSpec.IncompleteCorrelatorSetupFoundException incompleteCorrelatorSetupFoundException) {
            throw new WizardSBGenerationException(incompleteCorrelatorSetupFoundException);
        }
        UserAngle userAngle = UserAngle.createUserAngle(0.31, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        userAngle.setAntenna(Antenna.ANTENNA_12M);
        Angle angle = Angle.createAngle();
        angle.setContentAndUnit(((Angle)userAngle.multiply(1.0)).getContentInUnits(UserAngle.UNIT_ARCSEC), Angle.UNIT_ARCSEC);
        rectanglePattern.setOrthogonalStep(angle);
        rectanglePattern.getLongitudeLength().setContent(rectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC));
        rectanglePattern.getLongitudeLength().setUnit(Angle.UNIT_ARCSEC);
        rectanglePattern.getLatitudeLength().setContent(rectangle.getShort().getContentInUnits(Angle.UNIT_ARCSEC));
        rectanglePattern.getLatitudeLength().setUnit(Angle.UNIT_ARCSEC);
        TargetParametersFieldSourceWorker.performGalacticToICRSRectangleRotation(targetParameters, rectanglePattern, SystemRotationConversion.GalacticToICRS);
    }

    private static void performGalacticToICRSRectangleRotation(TargetParameters targetParameters, RectanglePattern rectanglePattern, SystemRotationConversion systemRotationConversion) {
        if (targetParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: targetParameters");
        }
        if (rectanglePattern == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: rectPatt");
        }
        if (!targetParameters.getSourceCoordinates().isGalactic()) {
            return;
        }
        TargetParameters targetParameters2 = TargetParameters.getPointingSourceInICRS(targetParameters);
        SkyCoordinates skyCoordinates = targetParameters2.getSourceCoordinates();
        double d = skyCoordinates.getLongitude().getContentInDeg();
        double d2 = skyCoordinates.getLatitude().getContentInDeg();
        double d3 = rectanglePattern.getOrientation().getContentInUnits(Angle.UNIT_DEG);
        double d4 = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(d3, d, d2, systemRotationConversion);
        Log.logger(TargetParametersFieldSourceWorker.class).fine("Rectangle PA in Galactic " + d3 + " converted to " + d4 + " degrees");
        rectanglePattern.setRotationAngle(Angle.createAngle((double)d4, (String)Angle.UNIT_DEG));
    }

    public static double transformPABetweenCoordinateSystems(double d, double d2, double d3, SystemRotationConversion systemRotationConversion) {
        if (systemRotationConversion.equals((Object)SystemRotationConversion.NoConversionRequired)) {
            return d;
        }
        double d4 = systemRotationConversion.equals((Object)SystemRotationConversion.GalacticToICRS) ? 1.0 : -1.0;
        double d5 = Math.toRadians(192.85948);
        double d6 = Math.toRadians(27.12825);
        double d7 = Math.toRadians(d2);
        double d8 = Math.toRadians(d3);
        double d9 = Math.cos(d6) * Math.sin(d7 - d5);
        double d10 = Math.sin(d6) * Math.cos(d8) - Math.cos(d6) * Math.sin(d8) * Math.cos(d7 - d5);
        double d11 = Math.toDegrees(Math.toRadians(d) + (Math.atan(d10 / d9) - Math.toRadians(90.0)) * d4);
        return d11;
    }

    private static void setupStandardPointingMosaic(TargetParameters targetParameters, FieldSource fieldSource, RequestedArray requestedArray) {
        RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
        MosaicParameters mosaicParameters = rectanglePattern.getMosaicParameters();
        mosaicParameters.getFrequency().setContentAndUnit((ValueUnitPair)targetParameters.getSingleFrequency());
        mosaicParameters.setAntenna(requestedArray.getAntenna());
        Rectangle rectangle = targetParameters.getFieldRectangle()[0];
        UserAngle userAngle = rectangle.getSpacing().deepCopy();
        if (!userAngle.inModelUnit()) {
            userAngle.setAntenna(requestedArray.getAntenna());
        }
        mosaicParameters.setSpacing(userAngle.getContentInUnits(Angle.UNIT_ARCSEC));
        mosaicParameters.updateOverlap();
        RectangleMosaic rectangleMosaic = new RectangleMosaic(rectanglePattern, requestedArray.getAntenna()){

            @Override
            public boolean abortsByTooManyPointings() {
                return false;
            }
        };
        PointingPattern pointingPattern = rectangleMosaic.getPointingPattern();
        pointingPattern.setDerivedFromRectangle(true);
        if (pointingPattern != null) {
            pointingPattern.setIsMosaic(true);
        }
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
    }

    public static void main(String[] stringArray) {
        double d = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(100.0, 269.78767782647594, -23.750156939233786, SystemRotationConversion.GalacticToICRS);
        double d2 = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(d, 269.78767782647594, -23.750156939233786, SystemRotationConversion.ICRSToGalactic);
        System.out.println(d + " " + d2);
    }

    public static enum SystemRotationConversion {
        NoConversionRequired,
        GalacticToICRS,
        ICRSToGalactic;

    }
}

