/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions;

import alma.obsprep.services.losolutions.wrappers.AbstractBasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.DSBbasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SSBbasebandSpecWrapper;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.List;

public class LOToolParameters {
    private Frequency requestedLO1;
    private boolean isDsb = false;
    private List<AbstractBasebandSpecWrapper> basebandParameters = new ArrayList<AbstractBasebandSpecWrapper>();

    public boolean isDsbReceiver() {
        return this.isDsb;
    }

    public void setDsbReceiver(boolean bl) {
        if (this.isDsb != bl) {
            this.clearBasebandParameters();
        }
        this.isDsb = bl;
    }

    public Frequency getRequestedLO1() {
        if (this.requestedLO1 == null) {
            this.requestedLO1 = Frequency.createFrequency();
        }
        return this.requestedLO1;
    }

    public void clearLO1() {
        this.getRequestedLO1().setContentInGHz(0.0);
    }

    public int getBasebandParametersCount() {
        return this.basebandParameters.size();
    }

    public List<AbstractBasebandSpecWrapper> getLOSBasebandSpecList() {
        return this.basebandParameters;
    }

    public AbstractBasebandSpecWrapper getBasebandParameters(int n) {
        return this.basebandParameters.get(n);
    }

    public AbstractBasebandSpecWrapper addNewBasebandParameters() {
        return this.addNewBasebandParameters(this.getBasebandParametersCount());
    }

    public AbstractBasebandSpecWrapper addNewBasebandParameters(int n) {
        AbstractBasebandSpecWrapper abstractBasebandSpecWrapper = this.isDsbReceiver() ? new DSBbasebandSpecWrapper() : new SSBbasebandSpecWrapper();
        this.addBasebandParameters(n, abstractBasebandSpecWrapper);
        return abstractBasebandSpecWrapper;
    }

    public void addBasebandParameters(int n, AbstractBasebandSpecWrapper abstractBasebandSpecWrapper) {
        this.basebandParameters.add(n, abstractBasebandSpecWrapper);
    }

    public void addBasebandParameters(AbstractBasebandSpecWrapper abstractBasebandSpecWrapper) {
        this.addBasebandParameters(this.basebandParameters.size(), abstractBasebandSpecWrapper);
    }

    public void clearBasebandParameters() {
        this.basebandParameters.clear();
    }

    public boolean removeBasebandParameters(AbstractBasebandSpecWrapper abstractBasebandSpecWrapper) {
        return this.basebandParameters.remove(abstractBasebandSpecWrapper);
    }

    public AbstractBasebandSpecWrapper removeBasebandParameters(int n) {
        return this.basebandParameters.remove(n);
    }
}

