/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions;

import alma.Control.LO2Parameters;
import alma.Control.LOSolutions.LOSolutions;
import alma.Control.LOSolutions.LOSolutionsInterface;
import alma.Control.LOSolutions.SidebandSelect;
import alma.Control.SSBbasebandSpec;
import alma.Control.TuningParameters;
import alma.ReceiverBandMod.ReceiverBand;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.services.losolutions.LOSolutionException;
import alma.obsprep.services.losolutions.LOToolParameters;
import alma.obsprep.services.losolutions.wrappers.AbstractBasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.DSBbasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SSBbasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandSelectWrapper;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class OTLOsolutions {
    private Set<alma.obsprep.bo.schedblock.ReceiverBand> band2and3 = new HashSet<alma.obsprep.bo.schedblock.ReceiverBand>(alma.obsprep.bo.schedblock.ReceiverBand.getReceiverBands(3, 2));
    private LOSolutionsInterface loSolutions;
    private LOToolParameters loToolParameters;
    private static final double BasebandBW = 2.0E9;
    private static final double BandOffset = 9.999999999E8;
    private static final double DigitizerFreq = 4.0E9;
    private TuningParameters tuningParameters;

    private OTLOsolutions(Logger logger) {
        this.loSolutions = new LOSolutions(logger);
        this.loToolParameters = new LOToolParameters();
    }

    private OTLOsolutions() {
        this((Logger)Log.logger(OTLOsolutions.class));
    }

    public static OTLOsolutions createOTLOsolutions() {
        return new OTLOsolutions();
    }

    public static OTLOsolutions createOTLOsolutions(Logger logger) {
        return new OTLOsolutions(logger);
    }

    public void setBasebandCenterFrequencies(Frequency[] frequencyArray, Velocity velocity) throws LOSolutionException {
        alma.obsprep.bo.schedblock.ReceiverBand receiverBand;
        if (frequencyArray == null || frequencyArray.length == 0) {
            throw new LOSolutionException("At least one frequency is needed.");
        }
        Frequency[] frequencyArray2 = new Frequency[frequencyArray.length];
        for (int i = 0; i < frequencyArray.length; ++i) {
            frequencyArray2[i] = frequencyArray[i].dopplerShifted(velocity);
        }
        try {
            receiverBand = alma.obsprep.bo.schedblock.ReceiverBand.getReceiverBand(frequencyArray2[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LOSolutionException("Invalid Frequency : " + (Object)((Object)frequencyArray2[0]));
        }
        this.loToolParameters.clearBasebandParameters();
        this.loToolParameters.setDsbReceiver(ReceiverType.getReceiverType(receiverBand.getType()) == ReceiverType.DSB);
        for (Frequency frequency : frequencyArray2) {
            AbstractBasebandSpecWrapper abstractBasebandSpecWrapper = this.loToolParameters.addNewBasebandParameters();
            abstractBasebandSpecWrapper.setOneSkyFrequency(frequency);
        }
    }

    public TuningParameters computeSolutions() throws LOSolutionException {
        List<AbstractBasebandSpecWrapper> list = this.loToolParameters.getLOSBasebandSpecList();
        return this.computeSolutions(list);
    }

    public TuningParameters computeSolutions(List<AbstractBasebandSpecWrapper> list) throws LOSolutionException {
        Set<alma.obsprep.bo.schedblock.ReceiverBand> set;
        AbstractBasebandSpecWrapper abstractBasebandSpecWrapper2;
        for (AbstractBasebandSpecWrapper object2 : list) {
            Frequency frequency;
            Frequency frequency2 = Frequency.createFrequencyGHZ(0.0);
            if (object2 instanceof DSBbasebandSpecWrapper) {
                abstractBasebandSpecWrapper2 = (DSBbasebandSpecWrapper)object2;
                frequency = ((DSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getPrimarySpec().getSkyFrequency();
                if (frequency.isLessThan((AbstractDoubleWithUnit)frequency2) || frequency.isZero(0.1)) {
                    ((DSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getPrimarySpec().setWeight(0.0);
                }
                if (!(frequency = ((DSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getSubSpec().getSkyFrequency()).isLessThan((AbstractDoubleWithUnit)frequency2) && !frequency.isZero(0.1)) continue;
                ((DSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getSubSpec().setWeight(0.0);
                continue;
            }
            if (object2 instanceof SSBbasebandSpecWrapper) {
                abstractBasebandSpecWrapper2 = (SSBbasebandSpecWrapper)object2;
                frequency = ((SSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getSkyFrequency();
                if (!frequency.isLessThan((AbstractDoubleWithUnit)frequency2) && !frequency.isZero(0.1)) continue;
                ((SSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).setWeight(0.0);
                continue;
            }
            throw new RuntimeException("Unknown type of BB wrapper defined : " + object2.getClass().getName());
        }
        this.tuningParameters = null;
        if (list.size() == 0 || list.get(0) instanceof SSBbasebandSpecWrapper) {
            set = alma.obsprep.bo.schedblock.ReceiverBand.getReceiverBands(list.stream().map(abstractBasebandSpecWrapper -> ((SSBbasebandSpecWrapper)abstractBasebandSpecWrapper).getSkyFrequency()).collect(Collectors.toList()));
            boolean bl = set.equals(this.band2and3);
            ArrayList<SSBbasebandSpec> arrayList = new ArrayList<SSBbasebandSpec>();
            for (AbstractBasebandSpecWrapper abstractBasebandSpecWrapper3 : list) {
                abstractBasebandSpecWrapper2 = (SSBbasebandSpecWrapper)abstractBasebandSpecWrapper3;
                arrayList.add(((SSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).exportNativeBasebandSpec());
            }
            try {
                if (bl) {
                    this.tuningParameters = this.loSolutions.computeSSBSolution(arrayList, ReceiverBand.ALMA_RB_03);
                }
                this.tuningParameters = this.loSolutions.computeSSBSolution(arrayList);
            }
            catch (Exception exception) {
                throw new LOSolutionException(exception.getMessage(), exception);
            }
        } else {
            set = new ArrayList();
            for (AbstractBasebandSpecWrapper abstractBasebandSpecWrapper4 : list) {
                DSBbasebandSpecWrapper dSBbasebandSpecWrapper = (DSBbasebandSpecWrapper)abstractBasebandSpecWrapper4;
                set.add((alma.obsprep.bo.schedblock.ReceiverBand)dSBbasebandSpecWrapper.exportNativeBasebandSpec());
            }
            try {
                this.tuningParameters = this.loSolutions.computeDSBSolution(set);
            }
            catch (Exception exception) {
                throw new LOSolutionException(exception.getMessage(), exception);
            }
        }
        return this.tuningParameters;
    }

    public Frequency getPreferredLO1FrequencySky() {
        return this.tuningParameters != null ? Frequency.createFrequencyGHZ(this.LO1Freq(this.tuningParameters) / 1.0E9) : null;
    }

    public double LO1Freq(TuningParameters tuningParameters) {
        return this.loSolutions.LO1Freq(tuningParameters);
    }

    public double getLO2Freq(LO2Parameters lO2Parameters) {
        return LOSolutions.getLO2Freq((LO2Parameters)lO2Parameters);
    }

    public double IFfrequency(LO2Parameters lO2Parameters) {
        double d = this.getLO2Freq(lO2Parameters);
        return d - 4.0E9 + 9.999999999E8;
    }

    public double actualSkyFreq(TuningParameters tuningParameters, int n, SidebandSelectWrapper sidebandSelectWrapper) throws Exception {
        return LOSolutions.actualSkyFreq((TuningParameters)tuningParameters, (int)n, (SidebandSelect)sidebandSelectWrapper.getNativeSidebandSelect());
    }

    public String getHardwareParameters() throws Exception {
        return this.loSolutions.getHardwareParameters();
    }
}

